/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.TileEntityEnderChest;

public class InventoryEnderChest
extends InventorySubcontainer {
    @Nullable
    private TileEntityEnderChest activeChest;

    public InventoryEnderChest() {
        super(27);
    }

    public void setActiveChest(TileEntityEnderChest var0) {
        this.activeChest = var0;
    }

    public boolean isActiveChest(TileEntityEnderChest var0) {
        return this.activeChest == var0;
    }

    @Override
    public void fromTag(NBTTagList var0, HolderLookup.a var1) {
        int var2;
        for (var2 = 0; var2 < this.getContainerSize(); ++var2) {
            this.setItem(var2, ItemStack.EMPTY);
        }
        for (var2 = 0; var2 < var0.size(); ++var2) {
            NBTTagCompound var3 = var0.getCompoundOrEmpty(var2);
            int var4 = var3.getByteOr("Slot", (byte)0) & 0xFF;
            if (var4 < 0 || var4 >= this.getContainerSize()) continue;
            this.setItem(var4, ItemStack.parse(var1, var3).orElse(ItemStack.EMPTY));
        }
    }

    @Override
    public NBTTagList createTag(HolderLookup.a var0) {
        NBTTagList var1 = new NBTTagList();
        for (int var2 = 0; var2 < this.getContainerSize(); ++var2) {
            ItemStack var3 = this.getItem(var2);
            if (var3.isEmpty()) continue;
            NBTTagCompound var4 = new NBTTagCompound();
            var4.putByte("Slot", (byte)var2);
            var1.add(var3.save(var0, var4));
        }
        return var1;
    }

    @Override
    public boolean stillValid(EntityHuman var0) {
        if (this.activeChest != null && !this.activeChest.stillValid(var0)) {
            return false;
        }
        return super.stillValid(var0);
    }

    @Override
    public void startOpen(EntityHuman var0) {
        if (this.activeChest != null) {
            this.activeChest.startOpen(var0);
        }
        super.startOpen(var0);
    }

    @Override
    public void stopOpen(EntityHuman var0) {
        if (this.activeChest != null) {
            this.activeChest.stopOpen(var0);
        }
        super.stopOpen(var0);
        this.activeChest = null;
    }
}

