/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayInBoatMove;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.InterpolationHandler;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityWaterAnimal;
import net.minecraft.world.entity.monster.creaking.Creaking;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.entity.vehicle.VehicleEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockWaterLily;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;

public abstract class AbstractBoat
extends VehicleEntity
implements Leashable {
    private static final DataWatcherObject<Boolean> DATA_ID_PADDLE_LEFT = DataWatcher.defineId(AbstractBoat.class, DataWatcherRegistry.BOOLEAN);
    private static final DataWatcherObject<Boolean> DATA_ID_PADDLE_RIGHT = DataWatcher.defineId(AbstractBoat.class, DataWatcherRegistry.BOOLEAN);
    private static final DataWatcherObject<Integer> DATA_ID_BUBBLE_TIME = DataWatcher.defineId(AbstractBoat.class, DataWatcherRegistry.INT);
    public static final int PADDLE_LEFT = 0;
    public static final int PADDLE_RIGHT = 1;
    private static final int TIME_TO_EJECT = 60;
    private static final float PADDLE_SPEED = 0.3926991f;
    public static final double PADDLE_SOUND_TIME = 0.7853981852531433;
    public static final int BUBBLE_TIME = 60;
    private final float[] paddlePositions = new float[2];
    private float outOfControlTicks;
    private float deltaRotation;
    private final InterpolationHandler interpolation = new InterpolationHandler((Entity)this, 3);
    private boolean inputLeft;
    private boolean inputRight;
    private boolean inputUp;
    private boolean inputDown;
    private double waterLevel;
    private float landFriction;
    public EnumStatus status;
    private EnumStatus oldStatus;
    private double lastYd;
    private boolean isAboveBubbleColumn;
    private boolean bubbleColumnDirectionIsDown;
    private float bubbleMultiplier;
    private float bubbleAngle;
    private float bubbleAngleO;
    @Nullable
    private Leashable.a leashData;
    private final Supplier<Item> dropItem;

    public AbstractBoat(EntityTypes<? extends AbstractBoat> var0, World var1, Supplier<Item> var2) {
        super(var0, var1);
        this.dropItem = var2;
        this.blocksBuilding = true;
    }

    public void setInitialPos(double var0, double var2, double var4) {
        this.setPos(var0, var2, var4);
        this.xo = var0;
        this.yo = var2;
        this.zo = var4;
    }

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.EVENTS;
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        var0.define(DATA_ID_PADDLE_LEFT, false);
        var0.define(DATA_ID_PADDLE_RIGHT, false);
        var0.define(DATA_ID_BUBBLE_TIME, 0);
    }

    @Override
    public boolean canCollideWith(Entity var0) {
        return AbstractBoat.canVehicleCollide(this, var0);
    }

    public static boolean canVehicleCollide(Entity var0, Entity var1) {
        return (var1.canBeCollidedWith() || var1.isPushable()) && !var0.isPassengerOfSameVehicle(var1);
    }

    @Override
    public boolean canBeCollidedWith() {
        return true;
    }

    @Override
    public boolean isPushable() {
        return true;
    }

    @Override
    public Vec3D getRelativePortalPosition(EnumDirection.EnumAxis var0, BlockUtil.Rectangle var1) {
        return EntityLiving.resetForwardDirectionOfRelativePortalPosition(super.getRelativePortalPosition(var0, var1));
    }

    protected abstract double rideHeight(EntitySize var1);

    @Override
    protected Vec3D getPassengerAttachmentPoint(Entity var0, EntitySize var1, float var2) {
        float var3 = this.getSinglePassengerXOffset();
        if (this.getPassengers().size() > 1) {
            int var4 = this.getPassengers().indexOf(var0);
            var3 = var4 == 0 ? 0.2f : -0.6f;
            if (var0 instanceof EntityAnimal) {
                var3 += 0.2f;
            }
        }
        return new Vec3D(0.0, this.rideHeight(var1), var3).yRot(-this.getYRot() * ((float)Math.PI / 180));
    }

    @Override
    public void onAboveBubbleColumn(boolean var0, BlockPosition var1) {
        if (this.level() instanceof WorldServer) {
            this.isAboveBubbleColumn = true;
            this.bubbleColumnDirectionIsDown = var0;
            if (this.getBubbleTime() == 0) {
                this.setBubbleTime(60);
            }
        }
        if (!this.isUnderWater() && this.random.nextInt(100) == 0) {
            this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), this.getSwimSplashSound(), this.getSoundSource(), 1.0f, 0.8f + 0.4f * this.random.nextFloat(), false);
            this.level().addParticle(Particles.SPLASH, this.getX() + (double)this.random.nextFloat(), this.getY() + 0.7, this.getZ() + (double)this.random.nextFloat(), 0.0, 0.0, 0.0);
            this.gameEvent(GameEvent.SPLASH, this.getControllingPassenger());
        }
    }

    @Override
    public void push(Entity var0) {
        if (var0 instanceof AbstractBoat) {
            if (var0.getBoundingBox().minY < this.getBoundingBox().maxY) {
                super.push(var0);
            }
        } else if (var0.getBoundingBox().minY <= this.getBoundingBox().minY) {
            super.push(var0);
        }
    }

    @Override
    public void animateHurt(float var0) {
        this.setHurtDir(-this.getHurtDir());
        this.setHurtTime(10);
        this.setDamage(this.getDamage() * 11.0f);
    }

    @Override
    public boolean isPickable() {
        return !this.isRemoved();
    }

    @Override
    public InterpolationHandler getInterpolation() {
        return this.interpolation;
    }

    @Override
    public EnumDirection getMotionDirection() {
        return this.getDirection().getClockWise();
    }

    @Override
    public void tick() {
        this.oldStatus = this.status;
        this.status = this.getStatus();
        this.outOfControlTicks = this.status == EnumStatus.UNDER_WATER || this.status == EnumStatus.UNDER_FLOWING_WATER ? (this.outOfControlTicks += 1.0f) : 0.0f;
        if (!this.level().isClientSide && this.outOfControlTicks >= 60.0f) {
            this.ejectPassengers();
        }
        if (this.getHurtTime() > 0) {
            this.setHurtTime(this.getHurtTime() - 1);
        }
        if (this.getDamage() > 0.0f) {
            this.setDamage(this.getDamage() - 1.0f);
        }
        super.tick();
        this.interpolation.interpolate();
        if (this.isLocalInstanceAuthoritative()) {
            if (!(this.getFirstPassenger() instanceof EntityHuman)) {
                this.setPaddleState(false, false);
            }
            this.floatBoat();
            if (this.level().isClientSide) {
                this.controlBoat();
                this.level().sendPacketToServer(new PacketPlayInBoatMove(this.getPaddleState(0), this.getPaddleState(1)));
            }
            this.move(EnumMoveType.SELF, this.getDeltaMovement());
        } else {
            this.setDeltaMovement(Vec3D.ZERO);
        }
        this.applyEffectsFromBlocks();
        this.applyEffectsFromBlocks();
        this.tickBubbleColumn();
        for (int var0 = 0; var0 <= 1; ++var0) {
            if (this.getPaddleState(var0)) {
                SoundEffect var1;
                if (!this.isSilent() && (double)(this.paddlePositions[var0] % ((float)Math.PI * 2)) <= 0.7853981852531433 && (double)((this.paddlePositions[var0] + 0.3926991f) % ((float)Math.PI * 2)) >= 0.7853981852531433 && (var1 = this.getPaddleSound()) != null) {
                    Vec3D var2 = this.getViewVector(1.0f);
                    double var3 = var0 == 1 ? -var2.z : var2.z;
                    double var5 = var0 == 1 ? var2.x : -var2.x;
                    this.level().playSound(null, this.getX() + var3, this.getY(), this.getZ() + var5, var1, this.getSoundSource(), 1.0f, 0.8f + 0.4f * this.random.nextFloat());
                }
                int n2 = var0;
                this.paddlePositions[n2] = this.paddlePositions[n2] + 0.3926991f;
                continue;
            }
            this.paddlePositions[var0] = 0.0f;
        }
        List<Entity> var0 = this.level().getEntities(this, this.getBoundingBox().inflate(0.2f, -0.01f, 0.2f), IEntitySelector.pushableBy(this));
        if (!var0.isEmpty()) {
            boolean var1 = !this.level().isClientSide && !(this.getControllingPassenger() instanceof EntityHuman);
            for (Entity var3 : var0) {
                if (var3.hasPassenger(this)) continue;
                if (var1 && this.getPassengers().size() < this.getMaxPassengers() && !var3.isPassenger() && this.hasEnoughSpaceFor(var3) && var3 instanceof EntityLiving && !(var3 instanceof EntityWaterAnimal) && !(var3 instanceof EntityHuman) && !(var3 instanceof Creaking)) {
                    var3.startRiding(this);
                    continue;
                }
                this.push(var3);
            }
        }
    }

    private void tickBubbleColumn() {
        if (this.level().isClientSide) {
            int var02 = this.getBubbleTime();
            this.bubbleMultiplier = var02 > 0 ? (this.bubbleMultiplier += 0.05f) : (this.bubbleMultiplier -= 0.1f);
            this.bubbleMultiplier = MathHelper.clamp(this.bubbleMultiplier, 0.0f, 1.0f);
            this.bubbleAngleO = this.bubbleAngle;
            this.bubbleAngle = 10.0f * (float)Math.sin(0.5 * (double)this.tickCount) * this.bubbleMultiplier;
        } else {
            int var03;
            if (!this.isAboveBubbleColumn) {
                this.setBubbleTime(0);
            }
            if ((var03 = this.getBubbleTime()) > 0) {
                this.setBubbleTime(--var03);
                int var1 = 60 - var03 - 1;
                if (var1 > 0 && var03 == 0) {
                    this.setBubbleTime(0);
                    Vec3D var2 = this.getDeltaMovement();
                    if (this.bubbleColumnDirectionIsDown) {
                        this.setDeltaMovement(var2.add(0.0, -0.7, 0.0));
                        this.ejectPassengers();
                    } else {
                        this.setDeltaMovement(var2.x, this.hasPassenger((Entity var0) -> var0 instanceof EntityHuman) ? 2.7 : 0.6, var2.z);
                    }
                }
                this.isAboveBubbleColumn = false;
            }
        }
    }

    @Nullable
    protected SoundEffect getPaddleSound() {
        return switch (this.getStatus().ordinal()) {
            case 0, 1, 2 -> SoundEffects.BOAT_PADDLE_WATER;
            case 3 -> SoundEffects.BOAT_PADDLE_LAND;
            default -> null;
        };
    }

    public void setPaddleState(boolean var0, boolean var1) {
        this.entityData.set(DATA_ID_PADDLE_LEFT, var0);
        this.entityData.set(DATA_ID_PADDLE_RIGHT, var1);
    }

    public float getRowingTime(int var0, float var1) {
        if (this.getPaddleState(var0)) {
            return MathHelper.clampedLerp(this.paddlePositions[var0] - 0.3926991f, this.paddlePositions[var0], var1);
        }
        return 0.0f;
    }

    @Override
    @Nullable
    public Leashable.a getLeashData() {
        return this.leashData;
    }

    @Override
    public void setLeashData(@Nullable Leashable.a var0) {
        this.leashData = var0;
    }

    @Override
    public Vec3D getLeashOffset() {
        return new Vec3D(0.0, 0.88f * this.getEyeHeight(), this.getBbWidth() * 0.64f);
    }

    @Override
    public void elasticRangeLeashBehaviour(Entity var0, float var1) {
        Vec3D var2 = var0.position().subtract(this.position()).normalize().scale((double)var1 - 6.0);
        Vec3D var3 = this.getDeltaMovement();
        boolean var4 = var3.dot(var2) > 0.0;
        this.setDeltaMovement(var3.add(var2.scale(var4 ? (double)0.15f : (double)0.2f)));
    }

    private EnumStatus getStatus() {
        EnumStatus var0 = this.isUnderwater();
        if (var0 != null) {
            this.waterLevel = this.getBoundingBox().maxY;
            return var0;
        }
        if (this.checkInWater()) {
            return EnumStatus.IN_WATER;
        }
        float var1 = this.getGroundFriction();
        if (var1 > 0.0f) {
            this.landFriction = var1;
            return EnumStatus.ON_LAND;
        }
        return EnumStatus.IN_AIR;
    }

    public float getWaterLevelAbove() {
        AxisAlignedBB var0 = this.getBoundingBox();
        int var1 = MathHelper.floor(var0.minX);
        int var2 = MathHelper.ceil(var0.maxX);
        int var3 = MathHelper.floor(var0.maxY);
        int var4 = MathHelper.ceil(var0.maxY - this.lastYd);
        int var5 = MathHelper.floor(var0.minZ);
        int var6 = MathHelper.ceil(var0.maxZ);
        BlockPosition.MutableBlockPosition var7 = new BlockPosition.MutableBlockPosition();
        block0: for (int var8 = var3; var8 < var4; ++var8) {
            float var9 = 0.0f;
            for (int var10 = var1; var10 < var2; ++var10) {
                for (int var11 = var5; var11 < var6; ++var11) {
                    var7.set(var10, var8, var11);
                    Fluid var12 = this.level().getFluidState(var7);
                    if (var12.is(TagsFluid.WATER)) {
                        var9 = Math.max(var9, var12.getHeight(this.level(), var7));
                    }
                    if (var9 >= 1.0f) continue block0;
                }
            }
            if (!(var9 < 1.0f)) continue;
            return (float)var7.getY() + var9;
        }
        return var4 + 1;
    }

    public float getGroundFriction() {
        AxisAlignedBB var0 = this.getBoundingBox();
        AxisAlignedBB var1 = new AxisAlignedBB(var0.minX, var0.minY - 0.001, var0.minZ, var0.maxX, var0.minY, var0.maxZ);
        int var2 = MathHelper.floor(var1.minX) - 1;
        int var3 = MathHelper.ceil(var1.maxX) + 1;
        int var4 = MathHelper.floor(var1.minY) - 1;
        int var5 = MathHelper.ceil(var1.maxY) + 1;
        int var6 = MathHelper.floor(var1.minZ) - 1;
        int var7 = MathHelper.ceil(var1.maxZ) + 1;
        VoxelShape var8 = VoxelShapes.create(var1);
        float var9 = 0.0f;
        int var10 = 0;
        BlockPosition.MutableBlockPosition var11 = new BlockPosition.MutableBlockPosition();
        for (int var12 = var2; var12 < var3; ++var12) {
            for (int var13 = var6; var13 < var7; ++var13) {
                int var14 = (var12 == var2 || var12 == var3 - 1 ? 1 : 0) + (var13 == var6 || var13 == var7 - 1 ? 1 : 0);
                if (var14 == 2) continue;
                for (int var15 = var4; var15 < var5; ++var15) {
                    if (var14 > 0 && (var15 == var4 || var15 == var5 - 1)) continue;
                    var11.set(var12, var15, var13);
                    IBlockData var16 = this.level().getBlockState(var11);
                    if (var16.getBlock() instanceof BlockWaterLily || !VoxelShapes.joinIsNotEmpty(var16.getCollisionShape(this.level(), var11).move(var11), var8, OperatorBoolean.AND)) continue;
                    var9 += var16.getBlock().getFriction();
                    ++var10;
                }
            }
        }
        return var9 / (float)var10;
    }

    private boolean checkInWater() {
        AxisAlignedBB var0 = this.getBoundingBox();
        int var1 = MathHelper.floor(var0.minX);
        int var2 = MathHelper.ceil(var0.maxX);
        int var3 = MathHelper.floor(var0.minY);
        int var4 = MathHelper.ceil(var0.minY + 0.001);
        int var5 = MathHelper.floor(var0.minZ);
        int var6 = MathHelper.ceil(var0.maxZ);
        boolean var7 = false;
        this.waterLevel = -1.7976931348623157E308;
        BlockPosition.MutableBlockPosition var8 = new BlockPosition.MutableBlockPosition();
        for (int var9 = var1; var9 < var2; ++var9) {
            for (int var10 = var3; var10 < var4; ++var10) {
                for (int var11 = var5; var11 < var6; ++var11) {
                    var8.set(var9, var10, var11);
                    Fluid var12 = this.level().getFluidState(var8);
                    if (!var12.is(TagsFluid.WATER)) continue;
                    float var13 = (float)var10 + var12.getHeight(this.level(), var8);
                    this.waterLevel = Math.max((double)var13, this.waterLevel);
                    var7 |= var0.minY < (double)var13;
                }
            }
        }
        return var7;
    }

    @Nullable
    private EnumStatus isUnderwater() {
        AxisAlignedBB var0 = this.getBoundingBox();
        double var1 = var0.maxY + 0.001;
        int var3 = MathHelper.floor(var0.minX);
        int var4 = MathHelper.ceil(var0.maxX);
        int var5 = MathHelper.floor(var0.maxY);
        int var6 = MathHelper.ceil(var1);
        int var7 = MathHelper.floor(var0.minZ);
        int var8 = MathHelper.ceil(var0.maxZ);
        boolean var9 = false;
        BlockPosition.MutableBlockPosition var10 = new BlockPosition.MutableBlockPosition();
        for (int var11 = var3; var11 < var4; ++var11) {
            for (int var12 = var5; var12 < var6; ++var12) {
                for (int var13 = var7; var13 < var8; ++var13) {
                    var10.set(var11, var12, var13);
                    Fluid var14 = this.level().getFluidState(var10);
                    if (!var14.is(TagsFluid.WATER) || !(var1 < (double)((float)var10.getY() + var14.getHeight(this.level(), var10)))) continue;
                    if (var14.isSource()) {
                        var9 = true;
                        continue;
                    }
                    return EnumStatus.UNDER_FLOWING_WATER;
                }
            }
        }
        return var9 ? EnumStatus.UNDER_WATER : null;
    }

    @Override
    protected double getDefaultGravity() {
        return 0.04;
    }

    private void floatBoat() {
        double var0 = -this.getGravity();
        double var2 = 0.0;
        float var4 = 0.05f;
        if (this.oldStatus == EnumStatus.IN_AIR && this.status != EnumStatus.IN_AIR && this.status != EnumStatus.ON_LAND) {
            this.waterLevel = this.getY(1.0);
            double var5 = (double)(this.getWaterLevelAbove() - this.getBbHeight()) + 0.101;
            if (this.level().noCollision(this, this.getBoundingBox().move(0.0, var5 - this.getY(), 0.0))) {
                this.setPos(this.getX(), var5, this.getZ());
                this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, 0.0, 1.0));
                this.lastYd = 0.0;
            }
            this.status = EnumStatus.IN_WATER;
        } else {
            if (this.status == EnumStatus.IN_WATER) {
                var2 = (this.waterLevel - this.getY()) / (double)this.getBbHeight();
                var4 = 0.9f;
            } else if (this.status == EnumStatus.UNDER_FLOWING_WATER) {
                var0 = -7.0E-4;
                var4 = 0.9f;
            } else if (this.status == EnumStatus.UNDER_WATER) {
                var2 = 0.01f;
                var4 = 0.45f;
            } else if (this.status == EnumStatus.IN_AIR) {
                var4 = 0.9f;
            } else if (this.status == EnumStatus.ON_LAND) {
                var4 = this.landFriction;
                if (this.getControllingPassenger() instanceof EntityHuman) {
                    this.landFriction /= 2.0f;
                }
            }
            Vec3D var5 = this.getDeltaMovement();
            this.setDeltaMovement(var5.x * (double)var4, var5.y + var0, var5.z * (double)var4);
            this.deltaRotation *= var4;
            if (var2 > 0.0) {
                Vec3D var6 = this.getDeltaMovement();
                this.setDeltaMovement(var6.x, (var6.y + var2 * (this.getDefaultGravity() / 0.65)) * 0.75, var6.z);
            }
        }
    }

    private void controlBoat() {
        if (!this.isVehicle()) {
            return;
        }
        float var0 = 0.0f;
        if (this.inputLeft) {
            this.deltaRotation -= 1.0f;
        }
        if (this.inputRight) {
            this.deltaRotation += 1.0f;
        }
        if (this.inputRight != this.inputLeft && !this.inputUp && !this.inputDown) {
            var0 += 0.005f;
        }
        this.setYRot(this.getYRot() + this.deltaRotation);
        if (this.inputUp) {
            var0 += 0.04f;
        }
        if (this.inputDown) {
            var0 -= 0.005f;
        }
        this.setDeltaMovement(this.getDeltaMovement().add(MathHelper.sin(-this.getYRot() * ((float)Math.PI / 180)) * var0, 0.0, MathHelper.cos(this.getYRot() * ((float)Math.PI / 180)) * var0));
        this.setPaddleState(this.inputRight && !this.inputLeft || this.inputUp, this.inputLeft && !this.inputRight || this.inputUp);
    }

    protected float getSinglePassengerXOffset() {
        return 0.0f;
    }

    public boolean hasEnoughSpaceFor(Entity var0) {
        return var0.getBbWidth() < this.getBbWidth();
    }

    @Override
    protected void positionRider(Entity var0, Entity.MoveFunction var1) {
        super.positionRider(var0, var1);
        if (var0.getType().is(TagsEntity.CAN_TURN_IN_BOATS)) {
            return;
        }
        var0.setYRot(var0.getYRot() + this.deltaRotation);
        var0.setYHeadRot(var0.getYHeadRot() + this.deltaRotation);
        this.clampRotation(var0);
        if (var0 instanceof EntityAnimal && this.getPassengers().size() == this.getMaxPassengers()) {
            int var2 = var0.getId() % 2 == 0 ? 90 : 270;
            var0.setYBodyRot(((EntityAnimal)var0).yBodyRot + (float)var2);
            var0.setYHeadRot(var0.getYHeadRot() + (float)var2);
        }
    }

    @Override
    public Vec3D getDismountLocationForPassenger(EntityLiving var0) {
        Vec3D var1 = AbstractBoat.getCollisionHorizontalEscapeVector(this.getBbWidth() * MathHelper.SQRT_OF_TWO, var0.getBbWidth(), var0.getYRot());
        double var2 = this.getX() + var1.x;
        double var4 = this.getZ() + var1.z;
        BlockPosition var6 = BlockPosition.containing(var2, this.getBoundingBox().maxY, var4);
        BlockPosition var7 = var6.below();
        if (!this.level().isWaterAt(var7)) {
            double var11;
            ArrayList var8 = Lists.newArrayList();
            double var9 = this.level().getBlockFloorHeight(var6);
            if (DismountUtil.isBlockFloorValid(var9)) {
                var8.add(new Vec3D(var2, (double)var6.getY() + var9, var4));
            }
            if (DismountUtil.isBlockFloorValid(var11 = this.level().getBlockFloorHeight(var7))) {
                var8.add(new Vec3D(var2, (double)var7.getY() + var11, var4));
            }
            for (EntityPose var14 : var0.getDismountPoses()) {
                for (Vec3D var16 : var8) {
                    if (!DismountUtil.canDismountTo(this.level(), var16, var0, var14)) continue;
                    var0.setPose(var14);
                    return var16;
                }
            }
        }
        return super.getDismountLocationForPassenger(var0);
    }

    protected void clampRotation(Entity var0) {
        var0.setYBodyRot(this.getYRot());
        float var1 = MathHelper.wrapDegrees(var0.getYRot() - this.getYRot());
        float var2 = MathHelper.clamp(var1, -105.0f, 105.0f);
        var0.yRotO += var2 - var1;
        var0.setYRot(var0.getYRot() + var2 - var1);
        var0.setYHeadRot(var0.getYRot());
    }

    @Override
    public void onPassengerTurned(Entity var0) {
        this.clampRotation(var0);
    }

    @Override
    protected void addAdditionalSaveData(NBTTagCompound var0) {
        this.writeLeashData(var0, this.leashData);
    }

    @Override
    protected void readAdditionalSaveData(NBTTagCompound var0) {
        this.readLeashData(var0);
    }

    @Override
    public EnumInteractionResult interact(EntityHuman var0, EnumHand var1) {
        EnumInteractionResult var2 = super.interact(var0, var1);
        if (var2 != EnumInteractionResult.PASS) {
            return var2;
        }
        if (!var0.isSecondaryUseActive() && this.outOfControlTicks < 60.0f && (this.level().isClientSide || var0.startRiding(this))) {
            return EnumInteractionResult.SUCCESS;
        }
        return EnumInteractionResult.PASS;
    }

    @Override
    public void remove(Entity.RemovalReason var0) {
        if (!this.level().isClientSide && var0.shouldDestroy() && this.isLeashed()) {
            this.dropLeash();
        }
        super.remove(var0);
    }

    @Override
    protected void checkFallDamage(double var0, boolean var2, IBlockData var3, BlockPosition var4) {
        this.lastYd = this.getDeltaMovement().y;
        if (this.isPassenger()) {
            return;
        }
        if (var2) {
            this.resetFallDistance();
        } else if (!this.level().getFluidState(this.blockPosition().below()).is(TagsFluid.WATER) && var0 < 0.0) {
            this.fallDistance -= (double)((float)var0);
        }
    }

    public boolean getPaddleState(int var0) {
        return this.entityData.get(var0 == 0 ? DATA_ID_PADDLE_LEFT : DATA_ID_PADDLE_RIGHT) != false && this.getControllingPassenger() != null;
    }

    private void setBubbleTime(int var0) {
        this.entityData.set(DATA_ID_BUBBLE_TIME, var0);
    }

    private int getBubbleTime() {
        return this.entityData.get(DATA_ID_BUBBLE_TIME);
    }

    public float getBubbleAngle(float var0) {
        return MathHelper.lerp(var0, this.bubbleAngleO, this.bubbleAngle);
    }

    @Override
    protected boolean canAddPassenger(Entity var0) {
        return this.getPassengers().size() < this.getMaxPassengers() && !this.isEyeInFluid(TagsFluid.WATER);
    }

    protected int getMaxPassengers() {
        return 2;
    }

    @Override
    @Nullable
    public EntityLiving getControllingPassenger() {
        EntityLiving var0;
        Entity entity = this.getFirstPassenger();
        return entity instanceof EntityLiving ? (var0 = (EntityLiving)entity) : super.getControllingPassenger();
    }

    public void setInput(boolean var0, boolean var1, boolean var2, boolean var3) {
        this.inputLeft = var0;
        this.inputRight = var1;
        this.inputUp = var2;
        this.inputDown = var3;
    }

    @Override
    public boolean isUnderWater() {
        return this.status == EnumStatus.UNDER_WATER || this.status == EnumStatus.UNDER_FLOWING_WATER;
    }

    @Override
    protected final Item getDropItem() {
        return this.dropItem.get();
    }

    @Override
    public final ItemStack getPickResult() {
        return new ItemStack(this.dropItem.get());
    }

    public static final class EnumStatus
    extends Enum<EnumStatus> {
        public static final /* enum */ EnumStatus IN_WATER = new EnumStatus();
        public static final /* enum */ EnumStatus UNDER_WATER = new EnumStatus();
        public static final /* enum */ EnumStatus UNDER_FLOWING_WATER = new EnumStatus();
        public static final /* enum */ EnumStatus ON_LAND = new EnumStatus();
        public static final /* enum */ EnumStatus IN_AIR = new EnumStatus();
        private static final /* synthetic */ EnumStatus[] f;

        public static EnumStatus[] values() {
            return (EnumStatus[])f.clone();
        }

        public static EnumStatus valueOf(String var0) {
            return Enum.valueOf(EnumStatus.class, var0);
        }

        private static /* synthetic */ EnumStatus[] a() {
            return new EnumStatus[]{IN_WATER, UNDER_WATER, UNDER_FLOWING_WATER, ON_LAND, IN_AIR};
        }

        static {
            f = EnumStatus.a();
        }
    }
}

