/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.variant;

import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;

public class VariantUtils {
    public static final String TAG_VARIANT = "variant";

    public static <T> Holder<T> getDefaultOrAny(IRegistryCustom var0, ResourceKey<T> var1) {
        HolderLookup.b var2 = var0.lookupOrThrow(var1.registryKey());
        return (Holder)var2.get(var1).or(((IRegistry)var2)::getAny).orElseThrow();
    }

    public static <T> Holder<T> getAny(IRegistryCustom var0, ResourceKey<? extends IRegistry<T>> var1) {
        return var0.lookupOrThrow(var1).getAny().orElseThrow();
    }

    public static <T> void writeVariant(NBTTagCompound var0, Holder<T> var12) {
        var12.unwrapKey().ifPresent(var1 -> var0.store(TAG_VARIANT, MinecraftKey.CODEC, var1.location()));
    }

    public static <T> Optional<Holder<T>> readVariant(NBTTagCompound var0, IRegistryCustom var12, ResourceKey<? extends IRegistry<T>> var2) {
        return var0.read(TAG_VARIANT, MinecraftKey.CODEC).map(var1 -> ResourceKey.create(var2, var1)).flatMap(var12::get);
    }
}

