/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import it.unimi.dsi.fastutil.doubles.DoubleDoubleImmutablePair;
import java.util.List;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;

public class EntityFireworks
extends IProjectile
implements ItemSupplier {
    public static final DataWatcherObject<ItemStack> DATA_ID_FIREWORKS_ITEM = DataWatcher.defineId(EntityFireworks.class, DataWatcherRegistry.ITEM_STACK);
    private static final DataWatcherObject<OptionalInt> DATA_ATTACHED_TO_TARGET = DataWatcher.defineId(EntityFireworks.class, DataWatcherRegistry.OPTIONAL_UNSIGNED_INT);
    public static final DataWatcherObject<Boolean> DATA_SHOT_AT_ANGLE = DataWatcher.defineId(EntityFireworks.class, DataWatcherRegistry.BOOLEAN);
    private static final int DEFAULT_LIFE = 0;
    private static final int DEFAULT_LIFE_TIME = 0;
    private static final boolean DEFAULT_SHOT_AT_ANGLE = false;
    public int life = 0;
    public int lifetime = 0;
    @Nullable
    public EntityLiving attachedToEntity;

    public EntityFireworks(EntityTypes<? extends EntityFireworks> var0, World var1) {
        super((EntityTypes<? extends IProjectile>)var0, var1);
    }

    public EntityFireworks(World var0, double var1, double var3, double var5, ItemStack var7) {
        super((EntityTypes<? extends IProjectile>)EntityTypes.FIREWORK_ROCKET, var0);
        this.life = 0;
        this.setPos(var1, var3, var5);
        this.entityData.set(DATA_ID_FIREWORKS_ITEM, var7.copy());
        int var8 = 1;
        Fireworks var9 = var7.get(DataComponents.FIREWORKS);
        if (var9 != null) {
            var8 += var9.flightDuration();
        }
        this.setDeltaMovement(this.random.triangle(0.0, 0.002297), 0.05, this.random.triangle(0.0, 0.002297));
        this.lifetime = 10 * var8 + this.random.nextInt(6) + this.random.nextInt(7);
    }

    public EntityFireworks(World var0, @Nullable Entity var1, double var2, double var4, double var6, ItemStack var8) {
        this(var0, var2, var4, var6, var8);
        this.setOwner(var1);
    }

    public EntityFireworks(World var0, ItemStack var1, EntityLiving var2) {
        this(var0, var2, var2.getX(), var2.getY(), var2.getZ(), var1);
        this.entityData.set(DATA_ATTACHED_TO_TARGET, OptionalInt.of(var2.getId()));
        this.attachedToEntity = var2;
    }

    public EntityFireworks(World var0, ItemStack var1, double var2, double var4, double var6, boolean var8) {
        this(var0, var2, var4, var6, var1);
        this.entityData.set(DATA_SHOT_AT_ANGLE, var8);
    }

    public EntityFireworks(World var0, ItemStack var1, Entity var2, double var3, double var5, double var7, boolean var9) {
        this(var0, var1, var3, var5, var7, var9);
        this.setOwner(var2);
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        var0.define(DATA_ID_FIREWORKS_ITEM, EntityFireworks.getDefaultItem());
        var0.define(DATA_ATTACHED_TO_TARGET, OptionalInt.empty());
        var0.define(DATA_SHOT_AT_ANGLE, false);
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double var0) {
        return var0 < 4096.0 && !this.isAttachedToEntity();
    }

    @Override
    public boolean shouldRender(double var0, double var2, double var4) {
        return super.shouldRender(var0, var2, var4) && !this.isAttachedToEntity();
    }

    @Override
    public void tick() {
        World world;
        MovingObjectPosition var02;
        Object var1;
        super.tick();
        if (this.isAttachedToEntity()) {
            if (this.attachedToEntity == null) {
                this.entityData.get(DATA_ATTACHED_TO_TARGET).ifPresent(var0 -> {
                    Entity var1 = this.level().getEntity(var0);
                    if (var1 instanceof EntityLiving) {
                        this.attachedToEntity = (EntityLiving)var1;
                    }
                });
            }
            if (this.attachedToEntity != null) {
                if (this.attachedToEntity.isFallFlying()) {
                    Vec3D var2 = this.attachedToEntity.getLookAngle();
                    double var3 = 1.5;
                    double var5 = 0.1;
                    Vec3D var7 = this.attachedToEntity.getDeltaMovement();
                    this.attachedToEntity.setDeltaMovement(var7.add(var2.x * 0.1 + (var2.x * 1.5 - var7.x) * 0.5, var2.y * 0.1 + (var2.y * 1.5 - var7.y) * 0.5, var2.z * 0.1 + (var2.z * 1.5 - var7.z) * 0.5));
                    var1 = this.attachedToEntity.getHandHoldingItemAngle(Items.FIREWORK_ROCKET);
                } else {
                    var1 = Vec3D.ZERO;
                }
                this.setPos(this.attachedToEntity.getX() + ((Vec3D)var1).x, this.attachedToEntity.getY() + ((Vec3D)var1).y, this.attachedToEntity.getZ() + ((Vec3D)var1).z);
                this.setDeltaMovement(this.attachedToEntity.getDeltaMovement());
            }
            var02 = ProjectileHelper.getHitResultOnMoveVector(this, this::canHitEntity);
        } else {
            if (!this.isShotAtAngle()) {
                double var12 = this.horizontalCollision ? 1.0 : 1.15;
                this.setDeltaMovement(this.getDeltaMovement().multiply(var12, 1.0, var12).add(0.0, 0.04, 0.0));
            }
            var1 = this.getDeltaMovement();
            var02 = ProjectileHelper.getHitResultOnMoveVector(this, this::canHitEntity);
            this.move(EnumMoveType.SELF, (Vec3D)var1);
            this.applyEffectsFromBlocks();
            this.setDeltaMovement((Vec3D)var1);
        }
        if (!this.noPhysics && this.isAlive() && var02.getType() != MovingObjectPosition.EnumMovingObjectType.MISS) {
            this.hitTargetOrDeflectSelf(var02);
            this.hasImpulse = true;
        }
        this.updateRotation();
        if (this.life == 0 && !this.isSilent()) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEffects.FIREWORK_ROCKET_LAUNCH, SoundCategory.AMBIENT, 3.0f, 1.0f);
        }
        ++this.life;
        if (this.level().isClientSide && this.life % 2 < 2) {
            this.level().addParticle(Particles.FIREWORK, this.getX(), this.getY(), this.getZ(), this.random.nextGaussian() * 0.05, -this.getDeltaMovement().y * 0.5, this.random.nextGaussian() * 0.05);
        }
        if (this.life > this.lifetime && (world = this.level()) instanceof WorldServer) {
            var1 = (WorldServer)world;
            this.explode((WorldServer)var1);
        }
    }

    private void explode(WorldServer var0) {
        var0.broadcastEntityEvent(this, (byte)17);
        this.gameEvent(GameEvent.EXPLODE, this.getOwner());
        this.dealExplosionDamage(var0);
        this.discard();
    }

    @Override
    protected void onHitEntity(MovingObjectPositionEntity var0) {
        super.onHitEntity(var0);
        World world = this.level();
        if (world instanceof WorldServer) {
            WorldServer var1 = (WorldServer)world;
            this.explode(var1);
        }
    }

    @Override
    protected void onHitBlock(MovingObjectPositionBlock var0) {
        BlockPosition var1 = new BlockPosition(var0.getBlockPos());
        this.level().getBlockState(var1).entityInside(this.level(), var1, this, InsideBlockEffectApplier.NOOP);
        World world = this.level();
        if (world instanceof WorldServer) {
            WorldServer var2 = (WorldServer)world;
            if (this.hasExplosion()) {
                this.explode(var2);
            }
        }
        super.onHitBlock(var0);
    }

    private boolean hasExplosion() {
        return !this.getExplosions().isEmpty();
    }

    private void dealExplosionDamage(WorldServer var0) {
        float var1 = 0.0f;
        List<FireworkExplosion> var2 = this.getExplosions();
        if (!var2.isEmpty()) {
            var1 = 5.0f + (float)(var2.size() * 2);
        }
        if (var1 > 0.0f) {
            if (this.attachedToEntity != null) {
                this.attachedToEntity.hurtServer(var0, this.damageSources().fireworks(this, this.getOwner()), 5.0f + (float)(var2.size() * 2));
            }
            double var3 = 5.0;
            Vec3D var5 = this.position();
            List<EntityLiving> var6 = this.level().getEntitiesOfClass(EntityLiving.class, this.getBoundingBox().inflate(5.0));
            for (EntityLiving var8 : var6) {
                if (var8 == this.attachedToEntity || this.distanceToSqr(var8) > 25.0) continue;
                boolean var9 = false;
                for (int var10 = 0; var10 < 2; ++var10) {
                    Vec3D var11 = new Vec3D(var8.getX(), var8.getY(0.5 * (double)var10), var8.getZ());
                    MovingObjectPositionBlock var12 = this.level().clip(new RayTrace(var5, var11, RayTrace.BlockCollisionOption.COLLIDER, RayTrace.FluidCollisionOption.NONE, this));
                    if (((MovingObjectPosition)var12).getType() != MovingObjectPosition.EnumMovingObjectType.MISS) continue;
                    var9 = true;
                    break;
                }
                if (!var9) continue;
                float var10 = var1 * (float)Math.sqrt((5.0 - (double)this.distanceTo(var8)) / 5.0);
                var8.hurtServer(var0, this.damageSources().fireworks(this, this.getOwner()), var10);
            }
        }
    }

    private boolean isAttachedToEntity() {
        return this.entityData.get(DATA_ATTACHED_TO_TARGET).isPresent();
    }

    public boolean isShotAtAngle() {
        return this.entityData.get(DATA_SHOT_AT_ANGLE);
    }

    @Override
    public void handleEntityEvent(byte var0) {
        if (var0 == 17 && this.level().isClientSide) {
            Vec3D var1 = this.getDeltaMovement();
            this.level().createFireworks(this.getX(), this.getY(), this.getZ(), var1.x, var1.y, var1.z, this.getExplosions());
        }
        super.handleEntityEvent(var0);
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        var0.putInt("Life", this.life);
        var0.putInt("LifeTime", this.lifetime);
        RegistryOps<NBTBase> var1 = this.registryAccess().createSerializationContext(DynamicOpsNBT.INSTANCE);
        var0.store("FireworksItem", ItemStack.CODEC, var1, this.getItem());
        var0.putBoolean("ShotAtAngle", this.entityData.get(DATA_SHOT_AT_ANGLE));
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        super.readAdditionalSaveData(var0);
        this.life = var0.getIntOr("Life", 0);
        this.lifetime = var0.getIntOr("LifeTime", 0);
        RegistryOps<NBTBase> var1 = this.registryAccess().createSerializationContext(DynamicOpsNBT.INSTANCE);
        this.entityData.set(DATA_ID_FIREWORKS_ITEM, var0.read("FireworksItem", ItemStack.CODEC, var1).orElse(EntityFireworks.getDefaultItem()));
        this.entityData.set(DATA_SHOT_AT_ANGLE, var0.getBooleanOr("ShotAtAngle", false));
    }

    private List<FireworkExplosion> getExplosions() {
        ItemStack var0 = this.entityData.get(DATA_ID_FIREWORKS_ITEM);
        Fireworks var1 = var0.get(DataComponents.FIREWORKS);
        return var1 != null ? var1.explosions() : List.of();
    }

    @Override
    public ItemStack getItem() {
        return this.entityData.get(DATA_ID_FIREWORKS_ITEM);
    }

    @Override
    public boolean isAttackable() {
        return false;
    }

    private static ItemStack getDefaultItem() {
        return new ItemStack(Items.FIREWORK_ROCKET);
    }

    @Override
    public DoubleDoubleImmutablePair calculateHorizontalHurtKnockbackDirection(EntityLiving var0, DamageSource var1) {
        double var2 = var0.position().x - this.position().x;
        double var4 = var0.position().z - this.position().z;
        return DoubleDoubleImmutablePair.of((double)var2, (double)var4);
    }
}

