/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.Vec3D;

public class EntityEnderSignal
extends Entity
implements ItemSupplier {
    private static final float MIN_CAMERA_DISTANCE_SQUARED = 12.25f;
    private static final DataWatcherObject<ItemStack> DATA_ITEM_STACK = DataWatcher.defineId(EntityEnderSignal.class, DataWatcherRegistry.ITEM_STACK);
    public double tx;
    public double ty;
    public double tz;
    public int life;
    public boolean surviveAfterDeath;

    public EntityEnderSignal(EntityTypes<? extends EntityEnderSignal> var0, World var1) {
        super(var0, var1);
    }

    public EntityEnderSignal(World var0, double var1, double var3, double var5) {
        this((EntityTypes<? extends EntityEnderSignal>)EntityTypes.EYE_OF_ENDER, var0);
        this.setPos(var1, var3, var5);
    }

    public void setItem(ItemStack var0) {
        if (var0.isEmpty()) {
            this.getEntityData().set(DATA_ITEM_STACK, this.getDefaultItem());
        } else {
            this.getEntityData().set(DATA_ITEM_STACK, var0.copyWithCount(1));
        }
    }

    @Override
    public ItemStack getItem() {
        return this.getEntityData().get(DATA_ITEM_STACK);
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        var0.define(DATA_ITEM_STACK, this.getDefaultItem());
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double var0) {
        if (this.tickCount < 2 && var0 < 12.25) {
            return false;
        }
        double var2 = this.getBoundingBox().getSize() * 4.0;
        if (Double.isNaN(var2)) {
            var2 = 4.0;
        }
        return var0 < (var2 *= 64.0) * var2;
    }

    public void signalTo(BlockPosition var0) {
        double var8;
        double var1 = var0.getX();
        int var3 = var0.getY();
        double var4 = var0.getZ();
        double var6 = var1 - this.getX();
        double var10 = Math.sqrt(var6 * var6 + (var8 = var4 - this.getZ()) * var8);
        if (var10 > 12.0) {
            this.tx = this.getX() + var6 / var10 * 12.0;
            this.tz = this.getZ() + var8 / var10 * 12.0;
            this.ty = this.getY() + 8.0;
        } else {
            this.tx = var1;
            this.ty = var3;
            this.tz = var4;
        }
        this.life = 0;
        this.surviveAfterDeath = this.random.nextInt(5) > 0;
    }

    @Override
    public void lerpMotion(double var0, double var2, double var4) {
        this.setDeltaMovement(var0, var2, var4);
        if (this.xRotO == 0.0f && this.yRotO == 0.0f) {
            double var6 = Math.sqrt(var0 * var0 + var4 * var4);
            this.setYRot((float)(MathHelper.atan2(var0, var4) * 57.2957763671875));
            this.setXRot((float)(MathHelper.atan2(var2, var6) * 57.2957763671875));
            this.yRotO = this.getYRot();
            this.xRotO = this.getXRot();
        }
    }

    @Override
    public void tick() {
        super.tick();
        Vec3D var0 = this.getDeltaMovement();
        double var1 = this.getX() + var0.x;
        double var3 = this.getY() + var0.y;
        double var5 = this.getZ() + var0.z;
        double var7 = var0.horizontalDistance();
        this.setXRot(IProjectile.lerpRotation(this.xRotO, (float)(MathHelper.atan2(var0.y, var7) * 57.2957763671875)));
        this.setYRot(IProjectile.lerpRotation(this.yRotO, (float)(MathHelper.atan2(var0.x, var0.z) * 57.2957763671875)));
        if (!this.level().isClientSide) {
            double var9 = this.tx - var1;
            double var11 = this.tz - var5;
            float var13 = (float)Math.sqrt(var9 * var9 + var11 * var11);
            float var14 = (float)MathHelper.atan2(var11, var9);
            double var15 = MathHelper.lerp(0.0025, var7, (double)var13);
            double var17 = var0.y;
            if (var13 < 1.0f) {
                var15 *= 0.8;
                var17 *= 0.8;
            }
            int var19 = this.getY() < this.ty ? 1 : -1;
            var0 = new Vec3D(Math.cos(var14) * var15, var17 + ((double)var19 - var17) * (double)0.015f, Math.sin(var14) * var15);
            this.setDeltaMovement(var0);
        }
        float var9 = 0.25f;
        if (this.isInWater()) {
            for (int var10 = 0; var10 < 4; ++var10) {
                this.level().addParticle(Particles.BUBBLE, var1 - var0.x * 0.25, var3 - var0.y * 0.25, var5 - var0.z * 0.25, var0.x, var0.y, var0.z);
            }
        } else {
            this.level().addParticle(Particles.PORTAL, var1 - var0.x * 0.25 + this.random.nextDouble() * 0.6 - 0.3, var3 - var0.y * 0.25 - 0.5, var5 - var0.z * 0.25 + this.random.nextDouble() * 0.6 - 0.3, var0.x, var0.y, var0.z);
        }
        if (!this.level().isClientSide) {
            this.setPos(var1, var3, var5);
            ++this.life;
            if (this.life > 80 && !this.level().isClientSide) {
                this.playSound(SoundEffects.ENDER_EYE_DEATH, 1.0f, 1.0f);
                this.discard();
                if (this.surviveAfterDeath) {
                    this.level().addFreshEntity(new EntityItem(this.level(), this.getX(), this.getY(), this.getZ(), this.getItem()));
                } else {
                    this.level().levelEvent(2003, this.blockPosition(), 0);
                }
            }
        } else {
            this.setPos(var1, var3, var5);
        }
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        RegistryOps<NBTBase> var1 = this.registryAccess().createSerializationContext(DynamicOpsNBT.INSTANCE);
        var0.store("Item", ItemStack.CODEC, var1, this.getItem());
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        RegistryOps<NBTBase> var1 = this.registryAccess().createSerializationContext(DynamicOpsNBT.INSTANCE);
        this.setItem(var0.read("Item", ItemStack.CODEC, var1).orElse(this.getDefaultItem()));
    }

    private ItemStack getDefaultItem() {
        return new ItemStack(Items.ENDER_EYE);
    }

    @Override
    public float getLightLevelDependentMagicValue() {
        return 1.0f;
    }

    @Override
    public boolean isAttackable() {
        return false;
    }

    @Override
    public boolean hurtServer(WorldServer var0, DamageSource var1, float var2) {
        return false;
    }
}

