/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import java.util.List;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAreaEffectCloud;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.projectile.EntityFireball;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;

public class EntityDragonFireball
extends EntityFireball {
    public static final float SPLASH_RANGE = 4.0f;

    public EntityDragonFireball(EntityTypes<? extends EntityDragonFireball> var0, World var1) {
        super((EntityTypes<? extends EntityFireball>)var0, var1);
    }

    public EntityDragonFireball(World var0, EntityLiving var1, Vec3D var2) {
        super(EntityTypes.DRAGON_FIREBALL, var1, var2, var0);
    }

    @Override
    protected void onHit(MovingObjectPosition var0) {
        super.onHit(var0);
        if (var0.getType() == MovingObjectPosition.EnumMovingObjectType.ENTITY && this.ownedBy(((MovingObjectPositionEntity)var0).getEntity())) {
            return;
        }
        if (!this.level().isClientSide) {
            List<EntityLiving> var1 = this.level().getEntitiesOfClass(EntityLiving.class, this.getBoundingBox().inflate(4.0, 2.0, 4.0));
            EntityAreaEffectCloud var2 = new EntityAreaEffectCloud(this.level(), this.getX(), this.getY(), this.getZ());
            Entity var3 = this.getOwner();
            if (var3 instanceof EntityLiving) {
                var2.setOwner((EntityLiving)var3);
            }
            var2.setParticle(Particles.DRAGON_BREATH);
            var2.setRadius(3.0f);
            var2.setDuration(600);
            var2.setRadiusPerTick((7.0f - var2.getRadius()) / (float)var2.getDuration());
            var2.setPotionDurationScale(0.25f);
            var2.addEffect(new MobEffect(MobEffects.INSTANT_DAMAGE, 1, 1));
            if (!var1.isEmpty()) {
                for (EntityLiving var5 : var1) {
                    double var6 = this.distanceToSqr(var5);
                    if (!(var6 < 16.0)) continue;
                    var2.setPos(var5.getX(), var5.getY(), var5.getZ());
                    break;
                }
            }
            this.level().levelEvent(2006, this.blockPosition(), this.isSilent() ? -1 : 1);
            this.level().addFreshEntity(var2);
            this.discard();
        }
    }

    @Override
    protected ParticleParam getTrailParticle() {
        return Particles.DRAGON_BREATH;
    }

    @Override
    protected boolean shouldBurn() {
        return false;
    }
}

