/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.player;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.math.IntMath;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.game.PacketPlayOutEntityVelocity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.Statistic;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Unit;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityEquipment;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.EntityParrot;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.warden.WardenSpawnTracker;
import net.minecraft.world.entity.player.PlayerAbilities;
import net.minecraft.world.entity.player.PlayerEquipment;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.entity.projectile.EntityFishingHook;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.food.FoodMetaData;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerPlayer;
import net.minecraft.world.inventory.InventoryEnderChest;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldown;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.BlocksAttacks;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.CommandBlockListenerAbstract;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TestBlockEntity;
import net.minecraft.world.level.block.entity.TestInstanceBlockEntity;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.entity.TileEntityJigsaw;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;

public abstract class EntityHuman
extends EntityLiving {
    public static final EnumMainHand DEFAULT_MAIN_HAND = EnumMainHand.RIGHT;
    public static final int DEFAULT_MODEL_CUSTOMIZATION = 0;
    public static final int MAX_HEALTH = 20;
    public static final int SLEEP_DURATION = 100;
    public static final int WAKE_UP_DURATION = 10;
    public static final int ENDER_SLOT_OFFSET = 200;
    public static final int HELD_ITEM_SLOT = 499;
    public static final int CRAFTING_SLOT_OFFSET = 500;
    public static final float DEFAULT_BLOCK_INTERACTION_RANGE = 4.5f;
    public static final float DEFAULT_ENTITY_INTERACTION_RANGE = 3.0f;
    public static final float CROUCH_BB_HEIGHT = 1.5f;
    public static final float SWIMMING_BB_WIDTH = 0.6f;
    public static final float SWIMMING_BB_HEIGHT = 0.6f;
    public static final float DEFAULT_EYE_HEIGHT = 1.62f;
    private static final int CURRENT_IMPULSE_CONTEXT_RESET_GRACE_TIME_TICKS = 40;
    public static final Vec3D DEFAULT_VEHICLE_ATTACHMENT = new Vec3D(0.0, 0.6, 0.0);
    public static final EntitySize STANDING_DIMENSIONS = EntitySize.scalable(0.6f, 1.8f).withEyeHeight(1.62f).withAttachments(EntityAttachments.builder().attach(EntityAttachment.VEHICLE, DEFAULT_VEHICLE_ATTACHMENT));
    private static final Map<EntityPose, EntitySize> POSES = ImmutableMap.builder().put((Object)EntityPose.STANDING, (Object)STANDING_DIMENSIONS).put((Object)EntityPose.SLEEPING, (Object)SLEEPING_DIMENSIONS).put((Object)EntityPose.FALL_FLYING, (Object)EntitySize.scalable(0.6f, 0.6f).withEyeHeight(0.4f)).put((Object)EntityPose.SWIMMING, (Object)EntitySize.scalable(0.6f, 0.6f).withEyeHeight(0.4f)).put((Object)EntityPose.SPIN_ATTACK, (Object)EntitySize.scalable(0.6f, 0.6f).withEyeHeight(0.4f)).put((Object)EntityPose.CROUCHING, (Object)EntitySize.scalable(0.6f, 1.5f).withEyeHeight(1.27f).withAttachments(EntityAttachments.builder().attach(EntityAttachment.VEHICLE, DEFAULT_VEHICLE_ATTACHMENT))).put((Object)EntityPose.DYING, (Object)EntitySize.fixed(0.2f, 0.2f).withEyeHeight(1.62f)).build();
    private static final DataWatcherObject<Float> DATA_PLAYER_ABSORPTION_ID = DataWatcher.defineId(EntityHuman.class, DataWatcherRegistry.FLOAT);
    private static final DataWatcherObject<Integer> DATA_SCORE_ID = DataWatcher.defineId(EntityHuman.class, DataWatcherRegistry.INT);
    protected static final DataWatcherObject<Byte> DATA_PLAYER_MODE_CUSTOMISATION = DataWatcher.defineId(EntityHuman.class, DataWatcherRegistry.BYTE);
    protected static final DataWatcherObject<Byte> DATA_PLAYER_MAIN_HAND = DataWatcher.defineId(EntityHuman.class, DataWatcherRegistry.BYTE);
    protected static final DataWatcherObject<NBTTagCompound> DATA_SHOULDER_LEFT = DataWatcher.defineId(EntityHuman.class, DataWatcherRegistry.COMPOUND_TAG);
    protected static final DataWatcherObject<NBTTagCompound> DATA_SHOULDER_RIGHT = DataWatcher.defineId(EntityHuman.class, DataWatcherRegistry.COMPOUND_TAG);
    public static final int CLIENT_LOADED_TIMEOUT_TIME = 60;
    private static final short DEFAULT_SLEEP_TIMER = 0;
    private static final float DEFAULT_EXPERIENCE_PROGRESS = 0.0f;
    private static final int DEFAULT_EXPERIENCE_LEVEL = 0;
    private static final int DEFAULT_TOTAL_EXPERIENCE = 0;
    private static final int NO_ENCHANTMENT_SEED = 0;
    private static final int DEFAULT_SELECTED_SLOT = 0;
    private static final int DEFAULT_SCORE = 0;
    private static final boolean DEFAULT_IGNORE_FALL_DAMAGE_FROM_CURRENT_IMPULSE = false;
    private static final int DEFAULT_CURRENT_IMPULSE_CONTEXT_RESET_GRACE_TIME = 0;
    private long timeEntitySatOnShoulder;
    final PlayerInventory inventory;
    protected InventoryEnderChest enderChestInventory = new InventoryEnderChest();
    public final ContainerPlayer inventoryMenu;
    public Container containerMenu;
    protected FoodMetaData foodData = new FoodMetaData();
    protected int jumpTriggerTime;
    private boolean clientLoaded = false;
    protected int clientLoadedTimeoutTimer = 60;
    public float oBob;
    public float bob;
    public int takeXpDelay;
    public double xCloakO;
    public double yCloakO;
    public double zCloakO;
    public double xCloak;
    public double yCloak;
    public double zCloak;
    public int sleepCounter = 0;
    protected boolean wasUnderwater;
    private final PlayerAbilities abilities = new PlayerAbilities();
    public int experienceLevel = 0;
    public int totalExperience = 0;
    public float experienceProgress = 0.0f;
    public int enchantmentSeed = 0;
    protected final float defaultFlySpeed = 0.02f;
    private int lastLevelUpTime;
    private final GameProfile gameProfile;
    private boolean reducedDebugInfo;
    private ItemStack lastItemInMainHand = ItemStack.EMPTY;
    private final ItemCooldown cooldowns = this.createItemCooldowns();
    private Optional<GlobalPos> lastDeathLocation = Optional.empty();
    @Nullable
    public EntityFishingHook fishing;
    protected float hurtDir;
    @Nullable
    public Vec3D currentImpulseImpactPos;
    @Nullable
    public Entity currentExplosionCause;
    private boolean ignoreFallDamageFromCurrentImpulse = false;
    private int currentImpulseContextResetGraceTime = 0;

    public EntityHuman(World var0, BlockPosition var1, float var2, GameProfile var3) {
        super((EntityTypes<? extends EntityLiving>)EntityTypes.PLAYER, var0);
        this.setUUID(var3.getId());
        this.gameProfile = var3;
        this.inventory = new PlayerInventory(this, this.equipment);
        this.inventoryMenu = new ContainerPlayer(this.inventory, !var0.isClientSide, this);
        this.containerMenu = this.inventoryMenu;
        this.snapTo((double)var1.getX() + 0.5, var1.getY() + 1, (double)var1.getZ() + 0.5, var2, 0.0f);
    }

    @Override
    protected EntityEquipment createEquipment() {
        return new PlayerEquipment(this);
    }

    public boolean blockActionRestricted(World var0, BlockPosition var1, EnumGamemode var2) {
        if (!var2.isBlockPlacingRestricted()) {
            return false;
        }
        if (var2 == EnumGamemode.SPECTATOR) {
            return true;
        }
        if (this.mayBuild()) {
            return false;
        }
        ItemStack var3 = this.getMainHandItem();
        return var3.isEmpty() || !var3.canBreakBlockInAdventureMode(new ShapeDetectorBlock(var0, var1, false));
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityLiving.createLivingAttributes().add(GenericAttributes.ATTACK_DAMAGE, 1.0).add(GenericAttributes.MOVEMENT_SPEED, 0.1f).add(GenericAttributes.ATTACK_SPEED).add(GenericAttributes.LUCK).add(GenericAttributes.BLOCK_INTERACTION_RANGE, 4.5).add(GenericAttributes.ENTITY_INTERACTION_RANGE, 3.0).add(GenericAttributes.BLOCK_BREAK_SPEED).add(GenericAttributes.SUBMERGED_MINING_SPEED).add(GenericAttributes.SNEAKING_SPEED).add(GenericAttributes.MINING_EFFICIENCY).add(GenericAttributes.SWEEPING_DAMAGE_RATIO);
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        var0.define(DATA_PLAYER_ABSORPTION_ID, Float.valueOf(0.0f));
        var0.define(DATA_SCORE_ID, 0);
        var0.define(DATA_PLAYER_MODE_CUSTOMISATION, (byte)0);
        var0.define(DATA_PLAYER_MAIN_HAND, (byte)DEFAULT_MAIN_HAND.getId());
        var0.define(DATA_SHOULDER_LEFT, new NBTTagCompound());
        var0.define(DATA_SHOULDER_RIGHT, new NBTTagCompound());
    }

    @Override
    public void tick() {
        this.noPhysics = this.isSpectator();
        if (this.isSpectator() || this.isPassenger()) {
            this.setOnGround(false);
        }
        if (this.takeXpDelay > 0) {
            --this.takeXpDelay;
        }
        if (this.isSleeping()) {
            ++this.sleepCounter;
            if (this.sleepCounter > 100) {
                this.sleepCounter = 100;
            }
            if (!this.level().isClientSide && this.level().isBrightOutside()) {
                this.stopSleepInBed(false, true);
            }
        } else if (this.sleepCounter > 0) {
            ++this.sleepCounter;
            if (this.sleepCounter >= 110) {
                this.sleepCounter = 0;
            }
        }
        this.updateIsUnderwater();
        super.tick();
        if (!this.level().isClientSide && this.containerMenu != null && !this.containerMenu.stillValid(this)) {
            this.closeContainer();
            this.containerMenu = this.inventoryMenu;
        }
        this.moveCloak();
        EntityHuman entityHuman = this;
        if (entityHuman instanceof EntityPlayer) {
            EntityPlayer var0 = (EntityPlayer)entityHuman;
            this.foodData.tick(var0);
            this.awardStat(StatisticList.PLAY_TIME);
            this.awardStat(StatisticList.TOTAL_WORLD_TIME);
            if (this.isAlive()) {
                this.awardStat(StatisticList.TIME_SINCE_DEATH);
            }
            if (this.isDiscrete()) {
                this.awardStat(StatisticList.CROUCH_TIME);
            }
            if (!this.isSleeping()) {
                this.awardStat(StatisticList.TIME_SINCE_REST);
            }
        }
        int var0 = 29999999;
        double var1 = MathHelper.clamp(this.getX(), -2.9999999E7, 2.9999999E7);
        double var3 = MathHelper.clamp(this.getZ(), -2.9999999E7, 2.9999999E7);
        if (var1 != this.getX() || var3 != this.getZ()) {
            this.setPos(var1, this.getY(), var3);
        }
        ++this.attackStrengthTicker;
        ItemStack var5 = this.getMainHandItem();
        if (!ItemStack.matches(this.lastItemInMainHand, var5)) {
            if (!ItemStack.isSameItem(this.lastItemInMainHand, var5)) {
                this.resetAttackStrengthTicker();
            }
            this.lastItemInMainHand = var5.copy();
        }
        if (!this.isEyeInFluid(TagsFluid.WATER) && this.isEquipped(Items.TURTLE_HELMET)) {
            this.turtleHelmetTick();
        }
        this.cooldowns.tick();
        this.updatePlayerPose();
        if (this.currentImpulseContextResetGraceTime > 0) {
            --this.currentImpulseContextResetGraceTime;
        }
    }

    @Override
    protected float getMaxHeadRotationRelativeToBody() {
        if (this.isBlocking()) {
            return 15.0f;
        }
        return super.getMaxHeadRotationRelativeToBody();
    }

    public boolean isSecondaryUseActive() {
        return this.isShiftKeyDown();
    }

    protected boolean wantsToStopRiding() {
        return this.isShiftKeyDown();
    }

    protected boolean isStayingOnGroundSurface() {
        return this.isShiftKeyDown();
    }

    protected boolean updateIsUnderwater() {
        this.wasUnderwater = this.isEyeInFluid(TagsFluid.WATER);
        return this.wasUnderwater;
    }

    @Override
    public void onAboveBubbleColumn(boolean var0, BlockPosition var1) {
        if (!this.getAbilities().flying) {
            super.onAboveBubbleColumn(var0, var1);
        }
    }

    @Override
    public void onInsideBubbleColumn(boolean var0) {
        if (!this.getAbilities().flying) {
            super.onInsideBubbleColumn(var0);
        }
    }

    private void turtleHelmetTick() {
        this.addEffect(new MobEffect(MobEffects.WATER_BREATHING, 200, 0, false, false, true));
    }

    private boolean isEquipped(Item var0) {
        for (EnumItemSlot var2 : EnumItemSlot.VALUES) {
            ItemStack var3 = this.getItemBySlot(var2);
            Equippable var4 = var3.get(DataComponents.EQUIPPABLE);
            if (!var3.is(var0) || var4 == null || var4.slot() != var2) continue;
            return true;
        }
        return false;
    }

    protected ItemCooldown createItemCooldowns() {
        return new ItemCooldown();
    }

    private void moveCloak() {
        this.xCloakO = this.xCloak;
        this.yCloakO = this.yCloak;
        this.zCloakO = this.zCloak;
        double var0 = this.getX() - this.xCloak;
        double var2 = this.getY() - this.yCloak;
        double var4 = this.getZ() - this.zCloak;
        double var6 = 10.0;
        if (var0 > 10.0) {
            this.xCloakO = this.xCloak = this.getX();
        }
        if (var4 > 10.0) {
            this.zCloakO = this.zCloak = this.getZ();
        }
        if (var2 > 10.0) {
            this.yCloakO = this.yCloak = this.getY();
        }
        if (var0 < -10.0) {
            this.xCloakO = this.xCloak = this.getX();
        }
        if (var4 < -10.0) {
            this.zCloakO = this.zCloak = this.getZ();
        }
        if (var2 < -10.0) {
            this.yCloakO = this.yCloak = this.getY();
        }
        this.xCloak += var0 * 0.25;
        this.zCloak += var4 * 0.25;
        this.yCloak += var2 * 0.25;
    }

    protected void updatePlayerPose() {
        if (!this.canPlayerFitWithinBlocksAndEntitiesWhen(EntityPose.SWIMMING)) {
            return;
        }
        EntityPose var0 = this.getDesiredPose();
        EntityPose var1 = this.isSpectator() || this.isPassenger() || this.canPlayerFitWithinBlocksAndEntitiesWhen(var0) ? var0 : (this.canPlayerFitWithinBlocksAndEntitiesWhen(EntityPose.CROUCHING) ? EntityPose.CROUCHING : EntityPose.SWIMMING);
        this.setPose(var1);
    }

    private EntityPose getDesiredPose() {
        if (this.isSleeping()) {
            return EntityPose.SLEEPING;
        }
        if (this.isSwimming()) {
            return EntityPose.SWIMMING;
        }
        if (this.isFallFlying()) {
            return EntityPose.FALL_FLYING;
        }
        if (this.isAutoSpinAttack()) {
            return EntityPose.SPIN_ATTACK;
        }
        if (this.isShiftKeyDown() && !this.abilities.flying) {
            return EntityPose.CROUCHING;
        }
        return EntityPose.STANDING;
    }

    protected boolean canPlayerFitWithinBlocksAndEntitiesWhen(EntityPose var0) {
        return this.level().noCollision(this, this.getDimensions(var0).makeBoundingBox(this.position()).deflate(1.0E-7));
    }

    @Override
    protected SoundEffect getSwimSound() {
        return SoundEffects.PLAYER_SWIM;
    }

    @Override
    protected SoundEffect getSwimSplashSound() {
        return SoundEffects.PLAYER_SPLASH;
    }

    @Override
    protected SoundEffect getSwimHighSpeedSplashSound() {
        return SoundEffects.PLAYER_SPLASH_HIGH_SPEED;
    }

    @Override
    public int getDimensionChangingDelay() {
        return 10;
    }

    @Override
    public void playSound(SoundEffect var0, float var1, float var2) {
        this.level().playSound((Entity)this, this.getX(), this.getY(), this.getZ(), var0, this.getSoundSource(), var1, var2);
    }

    public void playNotifySound(SoundEffect var0, SoundCategory var1, float var2, float var3) {
    }

    @Override
    public SoundCategory getSoundSource() {
        return SoundCategory.PLAYERS;
    }

    @Override
    public int getFireImmuneTicks() {
        return 20;
    }

    @Override
    public void handleEntityEvent(byte var0) {
        if (var0 == 9) {
            this.completeUsingItem();
        } else if (var0 == 23) {
            this.reducedDebugInfo = false;
        } else if (var0 == 22) {
            this.reducedDebugInfo = true;
        } else {
            super.handleEntityEvent(var0);
        }
    }

    public void closeContainer() {
        this.containerMenu = this.inventoryMenu;
    }

    protected void doCloseContainer() {
    }

    @Override
    public void rideTick() {
        if (!this.level().isClientSide && this.wantsToStopRiding() && this.isPassenger()) {
            this.stopRiding();
            this.setShiftKeyDown(false);
            return;
        }
        super.rideTick();
        this.oBob = this.bob;
        this.bob = 0.0f;
    }

    @Override
    public void aiStep() {
        if (this.jumpTriggerTime > 0) {
            --this.jumpTriggerTime;
        }
        this.tickRegeneration();
        this.inventory.tick();
        this.oBob = this.bob;
        if (this.abilities.flying && !this.isPassenger()) {
            this.resetFallDistance();
        }
        super.aiStep();
        this.updateSwingTime();
        this.yHeadRot = this.getYRot();
        this.setSpeed((float)this.getAttributeValue(GenericAttributes.MOVEMENT_SPEED));
        float var0 = !this.onGround() || this.isDeadOrDying() || this.isSwimming() ? 0.0f : Math.min(0.1f, (float)this.getDeltaMovement().horizontalDistance());
        this.bob += (var0 - this.bob) * 0.4f;
        if (this.getHealth() > 0.0f && !this.isSpectator()) {
            AxisAlignedBB var1 = this.isPassenger() && !this.getVehicle().isRemoved() ? this.getBoundingBox().minmax(this.getVehicle().getBoundingBox()).inflate(1.0, 0.0, 1.0) : this.getBoundingBox().inflate(1.0, 0.5, 1.0);
            List<Entity> var2 = this.level().getEntities(this, var1);
            ArrayList var3 = Lists.newArrayList();
            for (Entity var5 : var2) {
                if (var5.getType() == EntityTypes.EXPERIENCE_ORB) {
                    var3.add(var5);
                    continue;
                }
                if (var5.isRemoved()) continue;
                this.touch(var5);
            }
            if (!var3.isEmpty()) {
                this.touch((Entity)SystemUtils.getRandom(var3, this.random));
            }
        }
        this.playShoulderEntityAmbientSound(this.getShoulderEntityLeft());
        this.playShoulderEntityAmbientSound(this.getShoulderEntityRight());
        if (!this.level().isClientSide && (this.fallDistance > 0.5 || this.isInWater()) || this.abilities.flying || this.isSleeping() || this.isInPowderSnow) {
            this.removeEntitiesOnShoulder();
        }
    }

    protected void tickRegeneration() {
    }

    private void playShoulderEntityAmbientSound(NBTTagCompound var0) {
        EntityTypes var1;
        if (var0.isEmpty() || var0.getBooleanOr("Silent", false)) {
            return;
        }
        if (this.level().random.nextInt(200) == 0 && (var1 = (EntityTypes)var0.read("id", EntityTypes.CODEC).orElse(null)) == EntityTypes.PARROT && !EntityParrot.imitateNearbyMobs(this.level(), this)) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), EntityParrot.getAmbient(this.level(), this.level().random), this.getSoundSource(), 1.0f, EntityParrot.getPitch(this.level().random));
        }
    }

    private void touch(Entity var0) {
        var0.playerTouch(this);
    }

    public int getScore() {
        return this.entityData.get(DATA_SCORE_ID);
    }

    public void setScore(int var0) {
        this.entityData.set(DATA_SCORE_ID, var0);
    }

    public void increaseScore(int var0) {
        int var1 = this.getScore();
        this.entityData.set(DATA_SCORE_ID, var1 + var0);
    }

    public void startAutoSpinAttack(int var0, float var1, ItemStack var2) {
        this.autoSpinAttackTicks = var0;
        this.autoSpinAttackDmg = var1;
        this.autoSpinAttackItemStack = var2;
        if (!this.level().isClientSide) {
            this.removeEntitiesOnShoulder();
            this.setLivingEntityFlag(4, true);
        }
    }

    @Override
    @Nonnull
    public ItemStack getWeaponItem() {
        if (this.isAutoSpinAttack() && this.autoSpinAttackItemStack != null) {
            return this.autoSpinAttackItemStack;
        }
        return super.getWeaponItem();
    }

    @Override
    public void die(DamageSource var0) {
        World world;
        super.die(var0);
        this.reapplyPosition();
        if (!this.isSpectator() && (world = this.level()) instanceof WorldServer) {
            WorldServer var1 = (WorldServer)world;
            this.dropAllDeathLoot(var1, var0);
        }
        if (var0 != null) {
            this.setDeltaMovement(-MathHelper.cos((this.getHurtDir() + this.getYRot()) * ((float)Math.PI / 180)) * 0.1f, 0.1f, -MathHelper.sin((this.getHurtDir() + this.getYRot()) * ((float)Math.PI / 180)) * 0.1f);
        } else {
            this.setDeltaMovement(0.0, 0.1, 0.0);
        }
        this.awardStat(StatisticList.DEATHS);
        this.resetStat(StatisticList.CUSTOM.get(StatisticList.TIME_SINCE_DEATH));
        this.resetStat(StatisticList.CUSTOM.get(StatisticList.TIME_SINCE_REST));
        this.clearFire();
        this.setSharedFlagOnFire(false);
        this.setLastDeathLocation(Optional.of(GlobalPos.of(this.level().dimension(), this.blockPosition())));
    }

    @Override
    protected void dropEquipment(WorldServer var0) {
        super.dropEquipment(var0);
        if (!var0.getGameRules().getBoolean(GameRules.RULE_KEEPINVENTORY)) {
            this.destroyVanishingCursedItems();
            this.inventory.dropAll();
        }
    }

    protected void destroyVanishingCursedItems() {
        for (int var0 = 0; var0 < this.inventory.getContainerSize(); ++var0) {
            ItemStack var1 = this.inventory.getItem(var0);
            if (var1.isEmpty() || !EnchantmentManager.has(var1, EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP)) continue;
            this.inventory.removeItemNoUpdate(var0);
        }
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return var0.type().effects().sound();
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.PLAYER_DEATH;
    }

    public void handleCreativeModeItemDrop(ItemStack var0) {
    }

    @Nullable
    public EntityItem drop(ItemStack var0, boolean var1) {
        return this.drop(var0, false, var1);
    }

    public float getDestroySpeed(IBlockData var0) {
        float var1 = this.inventory.getSelectedItem().getDestroySpeed(var0);
        if (var1 > 1.0f) {
            var1 += (float)this.getAttributeValue(GenericAttributes.MINING_EFFICIENCY);
        }
        if (MobEffectUtil.hasDigSpeed(this)) {
            var1 *= 1.0f + (float)(MobEffectUtil.getDigSpeedAmplification(this) + 1) * 0.2f;
        }
        if (this.hasEffect(MobEffects.MINING_FATIGUE)) {
            float var2 = switch (this.getEffect(MobEffects.MINING_FATIGUE).getAmplifier()) {
                case 0 -> 0.3f;
                case 1 -> 0.09f;
                case 2 -> 0.0027f;
                default -> 8.1E-4f;
            };
            var1 *= var2;
        }
        var1 *= (float)this.getAttributeValue(GenericAttributes.BLOCK_BREAK_SPEED);
        if (this.isEyeInFluid(TagsFluid.WATER)) {
            var1 *= (float)this.getAttribute(GenericAttributes.SUBMERGED_MINING_SPEED).getValue();
        }
        if (!this.onGround()) {
            var1 /= 5.0f;
        }
        return var1;
    }

    public boolean hasCorrectToolForDrops(IBlockData var0) {
        return !var0.requiresCorrectToolForDrops() || this.inventory.getSelectedItem().isCorrectToolForDrops(var0);
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var02) {
        super.readAdditionalSaveData(var02);
        this.setUUID(this.gameProfile.getId());
        NBTTagList var1 = var02.getListOrEmpty("Inventory");
        this.inventory.load(var1);
        this.inventory.setSelectedSlot(var02.getIntOr("SelectedItemSlot", 0));
        this.sleepCounter = var02.getShortOr("SleepTimer", (short)0);
        this.experienceProgress = var02.getFloatOr("XpP", 0.0f);
        this.experienceLevel = var02.getIntOr("XpLevel", 0);
        this.totalExperience = var02.getIntOr("XpTotal", 0);
        this.enchantmentSeed = var02.getIntOr("XpSeed", 0);
        if (this.enchantmentSeed == 0) {
            this.enchantmentSeed = this.random.nextInt();
        }
        this.setScore(var02.getIntOr("Score", 0));
        this.foodData.readAdditionalSaveData(var02);
        this.abilities.loadSaveData(var02);
        this.getAttribute(GenericAttributes.MOVEMENT_SPEED).setBaseValue(this.abilities.getWalkingSpeed());
        var02.getList("EnderItems").ifPresent(var0 -> this.enderChestInventory.fromTag((NBTTagList)var0, this.registryAccess()));
        this.setShoulderEntityLeft(var02.getCompoundOrEmpty("ShoulderEntityLeft"));
        this.setShoulderEntityRight(var02.getCompoundOrEmpty("ShoulderEntityRight"));
        this.setLastDeathLocation(var02.read("LastDeathLocation", GlobalPos.CODEC));
        this.currentImpulseImpactPos = var02.read("current_explosion_impact_pos", Vec3D.CODEC).orElse(null);
        this.ignoreFallDamageFromCurrentImpulse = var02.getBooleanOr("ignore_fall_damage_from_current_explosion", false);
        this.currentImpulseContextResetGraceTime = var02.getIntOr("current_impulse_context_reset_grace_time", 0);
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        GameProfileSerializer.addCurrentDataVersion(var0);
        var0.put("Inventory", this.inventory.save(new NBTTagList()));
        var0.putInt("SelectedItemSlot", this.inventory.getSelectedSlot());
        var0.putShort("SleepTimer", (short)this.sleepCounter);
        var0.putFloat("XpP", this.experienceProgress);
        var0.putInt("XpLevel", this.experienceLevel);
        var0.putInt("XpTotal", this.totalExperience);
        var0.putInt("XpSeed", this.enchantmentSeed);
        var0.putInt("Score", this.getScore());
        this.foodData.addAdditionalSaveData(var0);
        this.abilities.addSaveData(var0);
        var0.put("EnderItems", this.enderChestInventory.createTag(this.registryAccess()));
        if (!this.getShoulderEntityLeft().isEmpty()) {
            var0.put("ShoulderEntityLeft", this.getShoulderEntityLeft());
        }
        if (!this.getShoulderEntityRight().isEmpty()) {
            var0.put("ShoulderEntityRight", this.getShoulderEntityRight());
        }
        this.lastDeathLocation.ifPresent(var1 -> var0.store("LastDeathLocation", GlobalPos.CODEC, var1));
        var0.storeNullable("current_explosion_impact_pos", Vec3D.CODEC, this.currentImpulseImpactPos);
        var0.putBoolean("ignore_fall_damage_from_current_explosion", this.ignoreFallDamageFromCurrentImpulse);
        var0.putInt("current_impulse_context_reset_grace_time", this.currentImpulseContextResetGraceTime);
    }

    @Override
    public boolean isInvulnerableTo(WorldServer var0, DamageSource var1) {
        if (super.isInvulnerableTo(var0, var1)) {
            return true;
        }
        if (var1.is(DamageTypeTags.IS_DROWNING)) {
            return !var0.getGameRules().getBoolean(GameRules.RULE_DROWNING_DAMAGE);
        }
        if (var1.is(DamageTypeTags.IS_FALL)) {
            return !var0.getGameRules().getBoolean(GameRules.RULE_FALL_DAMAGE);
        }
        if (var1.is(DamageTypeTags.IS_FIRE)) {
            return !var0.getGameRules().getBoolean(GameRules.RULE_FIRE_DAMAGE);
        }
        if (var1.is(DamageTypeTags.IS_FREEZING)) {
            return !var0.getGameRules().getBoolean(GameRules.RULE_FREEZE_DAMAGE);
        }
        return false;
    }

    @Override
    public boolean hurtServer(WorldServer var0, DamageSource var1, float var2) {
        if (this.isInvulnerableTo(var0, var1)) {
            return false;
        }
        if (this.abilities.invulnerable && !var1.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return false;
        }
        this.noActionTime = 0;
        if (this.isDeadOrDying()) {
            return false;
        }
        this.removeEntitiesOnShoulder();
        if (var1.scalesWithDifficulty()) {
            if (var0.getDifficulty() == EnumDifficulty.PEACEFUL) {
                var2 = 0.0f;
            }
            if (var0.getDifficulty() == EnumDifficulty.EASY) {
                var2 = Math.min(var2 / 2.0f + 1.0f, var2);
            }
            if (var0.getDifficulty() == EnumDifficulty.HARD) {
                var2 = var2 * 3.0f / 2.0f;
            }
        }
        if (var2 == 0.0f) {
            return false;
        }
        return super.hurtServer(var0, var1, var2);
    }

    @Override
    protected void blockUsingItem(WorldServer var0, EntityLiving var1) {
        super.blockUsingItem(var0, var1);
        ItemStack var2 = this.getItemBlockingWith();
        BlocksAttacks var3 = var2 != null ? var2.get(DataComponents.BLOCKS_ATTACKS) : null;
        float var4 = var1.getSecondsToDisableBlocking();
        if (var4 > 0.0f && var3 != null) {
            var3.disable(var0, this, var4, var2);
        }
    }

    @Override
    public boolean canBeSeenAsEnemy() {
        return !this.getAbilities().invulnerable && super.canBeSeenAsEnemy();
    }

    public boolean canHarmPlayer(EntityHuman var0) {
        ScoreboardTeam var1 = this.getTeam();
        ScoreboardTeam var2 = var0.getTeam();
        if (var1 == null) {
            return true;
        }
        if (!var1.isAlliedTo(var2)) {
            return true;
        }
        return ((ScoreboardTeamBase)var1).isAllowFriendlyFire();
    }

    @Override
    protected void hurtArmor(DamageSource var0, float var1) {
        this.doHurtEquipment(var0, var1, EnumItemSlot.FEET, EnumItemSlot.LEGS, EnumItemSlot.CHEST, EnumItemSlot.HEAD);
    }

    @Override
    protected void hurtHelmet(DamageSource var0, float var1) {
        this.doHurtEquipment(var0, var1, EnumItemSlot.HEAD);
    }

    @Override
    protected void actuallyHurt(WorldServer var0, DamageSource var1, float var2) {
        if (this.isInvulnerableTo(var0, var1)) {
            return;
        }
        var2 = this.getDamageAfterArmorAbsorb(var1, var2);
        float var3 = var2 = this.getDamageAfterMagicAbsorb(var1, var2);
        var2 = Math.max(var2 - this.getAbsorptionAmount(), 0.0f);
        this.setAbsorptionAmount(this.getAbsorptionAmount() - (var3 - var2));
        float var4 = var3 - var2;
        if (var4 > 0.0f && var4 < 3.4028235E37f) {
            this.awardStat(StatisticList.DAMAGE_ABSORBED, Math.round(var4 * 10.0f));
        }
        if (var2 == 0.0f) {
            return;
        }
        this.causeFoodExhaustion(var1.getFoodExhaustion());
        this.getCombatTracker().recordDamage(var1, var2);
        this.setHealth(this.getHealth() - var2);
        if (var2 < 3.4028235E37f) {
            this.awardStat(StatisticList.DAMAGE_TAKEN, Math.round(var2 * 10.0f));
        }
        this.gameEvent(GameEvent.ENTITY_DAMAGE);
    }

    public boolean isTextFilteringEnabled() {
        return false;
    }

    public void openTextEdit(TileEntitySign var0, boolean var1) {
    }

    public void openMinecartCommandBlock(CommandBlockListenerAbstract var0) {
    }

    public void openCommandBlock(TileEntityCommand var0) {
    }

    public void openStructureBlock(TileEntityStructure var0) {
    }

    public void openTestBlock(TestBlockEntity var0) {
    }

    public void openTestInstanceBlock(TestInstanceBlockEntity var0) {
    }

    public void openJigsawBlock(TileEntityJigsaw var0) {
    }

    public void openHorseInventory(EntityHorseAbstract var0, IInventory var1) {
    }

    public OptionalInt openMenu(@Nullable ITileInventory var0) {
        return OptionalInt.empty();
    }

    public void sendMerchantOffers(int var0, MerchantRecipeList var1, int var2, int var3, boolean var4, boolean var5) {
    }

    public void openItemGui(ItemStack var0, EnumHand var1) {
    }

    public EnumInteractionResult interactOn(Entity var0, EnumHand var1) {
        if (this.isSpectator()) {
            if (var0 instanceof ITileInventory) {
                this.openMenu((ITileInventory)((Object)var0));
            }
            return EnumInteractionResult.PASS;
        }
        ItemStack var2 = this.getItemInHand(var1);
        ItemStack var3 = var2.copy();
        EnumInteractionResult var4 = var0.interact(this, var1);
        if (var4.consumesAction()) {
            if (this.hasInfiniteMaterials() && var2 == this.getItemInHand(var1) && var2.getCount() < var3.getCount()) {
                var2.setCount(var3.getCount());
            }
            return var4;
        }
        if (!var2.isEmpty() && var0 instanceof EntityLiving) {
            EnumInteractionResult var5;
            if (this.hasInfiniteMaterials()) {
                var2 = var3;
            }
            if ((var5 = var2.interactLivingEntity(this, (EntityLiving)var0, var1)).consumesAction()) {
                this.level().gameEvent(GameEvent.ENTITY_INTERACT, var0.position(), GameEvent.a.of(this));
                if (var2.isEmpty() && !this.hasInfiniteMaterials()) {
                    this.setItemInHand(var1, ItemStack.EMPTY);
                }
                return var5;
            }
        }
        return EnumInteractionResult.PASS;
    }

    @Override
    public void removeVehicle() {
        super.removeVehicle();
        this.boardingCooldown = 0;
    }

    @Override
    protected boolean isImmobile() {
        return super.isImmobile() || this.isSleeping();
    }

    @Override
    public boolean isAffectedByFluids() {
        return !this.abilities.flying;
    }

    @Override
    protected Vec3D maybeBackOffFromEdge(Vec3D var0, EnumMoveType var1) {
        double var3;
        float var2 = this.maxUpStep();
        if (this.abilities.flying || var0.y > 0.0 || var1 != EnumMoveType.SELF && var1 != EnumMoveType.PLAYER || !this.isStayingOnGroundSurface() || !this.isAboveGround(var2)) {
            return var0;
        }
        double var5 = var0.z;
        double var7 = 0.05;
        double var9 = Math.signum(var3) * 0.05;
        double var11 = Math.signum(var5) * 0.05;
        for (var3 = var0.x; var3 != 0.0 && this.canFallAtLeast(var3, 0.0, var2); var3 -= var9) {
            if (!(Math.abs(var3) <= 0.05)) continue;
            var3 = 0.0;
            break;
        }
        while (var5 != 0.0 && this.canFallAtLeast(0.0, var5, var2)) {
            if (Math.abs(var5) <= 0.05) {
                var5 = 0.0;
                break;
            }
            var5 -= var11;
        }
        while (var3 != 0.0 && var5 != 0.0 && this.canFallAtLeast(var3, var5, var2)) {
            var3 = Math.abs(var3) <= 0.05 ? 0.0 : (var3 -= var9);
            if (Math.abs(var5) <= 0.05) {
                var5 = 0.0;
                continue;
            }
            var5 -= var11;
        }
        return new Vec3D(var3, var0.y, var5);
    }

    private boolean isAboveGround(float var0) {
        return this.onGround() || this.fallDistance < (double)var0 && !this.canFallAtLeast(0.0, 0.0, (double)var0 - this.fallDistance);
    }

    private boolean canFallAtLeast(double var0, double var2, double var4) {
        AxisAlignedBB var6 = this.getBoundingBox();
        return this.level().noCollision(this, new AxisAlignedBB(var6.minX + 1.0E-7 + var0, var6.minY - var4 - 1.0E-7, var6.minZ + 1.0E-7 + var2, var6.maxX - 1.0E-7 + var0, var6.minY, var6.maxZ - 1.0E-7 + var2));
    }

    public void attack(Entity var0) {
        IProjectile var6;
        if (!var0.isAttackable()) {
            return;
        }
        if (var0.skipAttackInteraction(this)) {
            return;
        }
        float var1 = this.isAutoSpinAttack() ? this.autoSpinAttackDmg : (float)this.getAttributeValue(GenericAttributes.ATTACK_DAMAGE);
        ItemStack var2 = this.getWeaponItem();
        DamageSource var3 = Optional.ofNullable(var2.getItem().getDamageSource(this)).orElse(this.damageSources().playerAttack(this));
        float var4 = this.getEnchantedDamage(var0, var1, var3) - var1;
        float var5 = this.getAttackStrengthScale(0.5f);
        var1 *= 0.2f + var5 * var5 * 0.8f;
        var4 *= var5;
        this.resetAttackStrengthTicker();
        if (var0.getType().is(TagsEntity.REDIRECTABLE_PROJECTILE) && var0 instanceof IProjectile && (var6 = (IProjectile)var0).deflect(ProjectileDeflection.AIM_DEFLECT, this, this, true)) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEffects.PLAYER_ATTACK_NODAMAGE, this.getSoundSource());
            return;
        }
        if (var1 > 0.0f || var4 > 0.0f) {
            Object var12;
            double var13;
            double var11;
            boolean var8;
            boolean var7;
            boolean var62;
            boolean bl = var62 = var5 > 0.9f;
            if (this.isSprinting() && var62) {
                this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEffects.PLAYER_ATTACK_KNOCKBACK, this.getSoundSource(), 1.0f, 1.0f);
                var7 = true;
            } else {
                var7 = false;
            }
            var1 += var2.getItem().getAttackDamageBonus(var0, var1, var3);
            boolean bl2 = var8 = var62 && this.fallDistance > 0.0 && !this.onGround() && !this.onClimbable() && !this.isInWater() && !this.hasEffect(MobEffects.BLINDNESS) && !this.isPassenger() && var0 instanceof EntityLiving && !this.isSprinting();
            if (var8) {
                var1 *= 1.5f;
            }
            float var9 = var1 + var4;
            boolean var10 = false;
            if (var62 && !var8 && !var7 && this.onGround() && (var11 = this.getKnownMovement().horizontalDistanceSqr()) < MathHelper.square(var13 = (double)this.getSpeed() * 2.5) && this.getItemInHand(EnumHand.MAIN_HAND).is(TagsItem.SWORDS)) {
                var10 = true;
            }
            float var112 = 0.0f;
            if (var0 instanceof EntityLiving) {
                var12 = (EntityLiving)var0;
                var112 = ((EntityLiving)var12).getHealth();
            }
            var12 = var0.getDeltaMovement();
            boolean var132 = var0.hurtOrSimulate(var3, var9);
            if (var132) {
                Entity var15;
                float var14 = this.getKnockback(var0, var3) + (var7 ? 1.0f : 0.0f);
                if (var14 > 0.0f) {
                    if (var0 instanceof EntityLiving) {
                        var15 = (EntityLiving)var0;
                        var15.knockback(var14 * 0.5f, MathHelper.sin(this.getYRot() * ((float)Math.PI / 180)), -MathHelper.cos(this.getYRot() * ((float)Math.PI / 180)));
                    } else {
                        var0.push(-MathHelper.sin(this.getYRot() * ((float)Math.PI / 180)) * var14 * 0.5f, 0.1, MathHelper.cos(this.getYRot() * ((float)Math.PI / 180)) * var14 * 0.5f);
                    }
                    this.setDeltaMovement(this.getDeltaMovement().multiply(0.6, 1.0, 0.6));
                    this.setSprinting(false);
                }
                if (var10) {
                    float var152 = 1.0f + (float)this.getAttributeValue(GenericAttributes.SWEEPING_DAMAGE_RATIO) * var1;
                    List<EntityLiving> var16 = this.level().getEntitiesOfClass(EntityLiving.class, var0.getBoundingBox().inflate(1.0, 0.25, 1.0));
                    for (EntityLiving entityLiving : var16) {
                        WorldServer var20;
                        EntityArmorStand var19;
                        if (entityLiving == this || entityLiving == var0 || this.isAlliedTo(entityLiving) || entityLiving instanceof EntityArmorStand && (var19 = (EntityArmorStand)entityLiving).isMarker() || !(this.distanceToSqr(entityLiving) < 9.0)) continue;
                        float var192 = this.getEnchantedDamage(entityLiving, var152, var3) * var5;
                        World world = this.level();
                        if (!(world instanceof WorldServer) || !entityLiving.hurtServer(var20 = (WorldServer)world, var3, var192)) continue;
                        entityLiving.knockback(0.4f, MathHelper.sin(this.getYRot() * ((float)Math.PI / 180)), -MathHelper.cos(this.getYRot() * ((float)Math.PI / 180)));
                        EnchantmentManager.doPostAttackEffects(var20, entityLiving, var3);
                    }
                    this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEffects.PLAYER_ATTACK_SWEEP, this.getSoundSource(), 1.0f, 1.0f);
                    this.sweepAttack();
                }
                if (var0 instanceof EntityPlayer && var0.hurtMarked) {
                    ((EntityPlayer)var0).connection.send(new PacketPlayOutEntityVelocity(var0));
                    var0.hurtMarked = false;
                    var0.setDeltaMovement((Vec3D)var12);
                }
                if (var8) {
                    this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEffects.PLAYER_ATTACK_CRIT, this.getSoundSource(), 1.0f, 1.0f);
                    this.crit(var0);
                }
                if (!var8 && !var10) {
                    if (var62) {
                        this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEffects.PLAYER_ATTACK_STRONG, this.getSoundSource(), 1.0f, 1.0f);
                    } else {
                        this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEffects.PLAYER_ATTACK_WEAK, this.getSoundSource(), 1.0f, 1.0f);
                    }
                }
                if (var4 > 0.0f) {
                    this.magicCrit(var0);
                }
                this.setLastHurtMob(var0);
                var15 = var0;
                if (var0 instanceof EntityComplexPart) {
                    var15 = ((EntityComplexPart)var0).parentMob;
                }
                boolean var16 = false;
                World world = this.level();
                if (world instanceof WorldServer) {
                    WorldServer var17 = (WorldServer)world;
                    if (var15 instanceof EntityLiving) {
                        Entity entity = var15;
                        var16 = var2.hurtEnemy((EntityLiving)entity, this);
                    }
                    EnchantmentManager.doPostAttackEffects(var17, var0, var3);
                }
                if (!this.level().isClientSide && !var2.isEmpty() && var15 instanceof EntityLiving) {
                    if (var16) {
                        var2.postHurtEnemy((EntityLiving)var15, this);
                    }
                    if (var2.isEmpty()) {
                        if (var2 == this.getMainHandItem()) {
                            this.setItemInHand(EnumHand.MAIN_HAND, ItemStack.EMPTY);
                        } else {
                            this.setItemInHand(EnumHand.OFF_HAND, ItemStack.EMPTY);
                        }
                    }
                }
                if (var0 instanceof EntityLiving) {
                    float var17 = var112 - ((EntityLiving)var0).getHealth();
                    this.awardStat(StatisticList.DAMAGE_DEALT, Math.round(var17 * 10.0f));
                    if (this.level() instanceof WorldServer && var17 > 2.0f) {
                        int n2 = (int)((double)var17 * 0.5);
                        ((WorldServer)this.level()).sendParticles(Particles.DAMAGE_INDICATOR, var0.getX(), var0.getY(0.5), var0.getZ(), n2, 0.1, 0.0, 0.1, 0.2);
                    }
                }
                this.causeFoodExhaustion(0.1f);
            } else {
                this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEffects.PLAYER_ATTACK_NODAMAGE, this.getSoundSource(), 1.0f, 1.0f);
            }
        }
    }

    protected float getEnchantedDamage(Entity var0, float var1, DamageSource var2) {
        return var1;
    }

    @Override
    protected void doAutoAttackOnTouch(EntityLiving var0) {
        this.attack(var0);
    }

    public void crit(Entity var0) {
    }

    public void magicCrit(Entity var0) {
    }

    public void sweepAttack() {
        double var0 = -MathHelper.sin(this.getYRot() * ((float)Math.PI / 180));
        double var2 = MathHelper.cos(this.getYRot() * ((float)Math.PI / 180));
        if (this.level() instanceof WorldServer) {
            ((WorldServer)this.level()).sendParticles(Particles.SWEEP_ATTACK, this.getX() + var0, this.getY(0.5), this.getZ() + var2, 0, var0, 0.0, var2, 0.0);
        }
    }

    public void respawn() {
    }

    @Override
    public void remove(Entity.RemovalReason var0) {
        super.remove(var0);
        this.inventoryMenu.removed(this);
        if (this.containerMenu != null && this.hasContainerOpen()) {
            this.doCloseContainer();
        }
    }

    @Override
    public boolean isClientAuthoritative() {
        return true;
    }

    @Override
    protected boolean isLocalClientAuthoritative() {
        return this.isLocalPlayer();
    }

    public boolean isLocalPlayer() {
        return false;
    }

    @Override
    public boolean canSimulateMovement() {
        return !this.level().isClientSide || this.isLocalPlayer();
    }

    @Override
    public boolean isEffectiveAi() {
        return !this.level().isClientSide || this.isLocalPlayer();
    }

    public GameProfile getGameProfile() {
        return this.gameProfile;
    }

    public PlayerInventory getInventory() {
        return this.inventory;
    }

    public PlayerAbilities getAbilities() {
        return this.abilities;
    }

    @Override
    public boolean hasInfiniteMaterials() {
        return this.abilities.instabuild;
    }

    public boolean preventsBlockDrops() {
        return this.abilities.instabuild;
    }

    public void updateTutorialInventoryAction(ItemStack var0, ItemStack var1, ClickAction var2) {
    }

    public boolean hasContainerOpen() {
        return this.containerMenu != this.inventoryMenu;
    }

    public boolean canDropItems() {
        return true;
    }

    public Either<EnumBedResult, Unit> startSleepInBed(BlockPosition var0) {
        this.startSleeping(var0);
        this.sleepCounter = 0;
        return Either.right((Object)((Object)Unit.INSTANCE));
    }

    public void stopSleepInBed(boolean var0, boolean var1) {
        super.stopSleeping();
        if (this.level() instanceof WorldServer && var1) {
            ((WorldServer)this.level()).updateSleepingPlayerList();
        }
        this.sleepCounter = var0 ? 0 : 100;
    }

    @Override
    public void stopSleeping() {
        this.stopSleepInBed(true, true);
    }

    public boolean isSleepingLongEnough() {
        return this.isSleeping() && this.sleepCounter >= 100;
    }

    public int getSleepTimer() {
        return this.sleepCounter;
    }

    public void displayClientMessage(IChatBaseComponent var0, boolean var1) {
    }

    public void awardStat(MinecraftKey var0) {
        this.awardStat(StatisticList.CUSTOM.get(var0));
    }

    public void awardStat(MinecraftKey var0, int var1) {
        this.awardStat(StatisticList.CUSTOM.get(var0), var1);
    }

    public void awardStat(Statistic<?> var0) {
        this.awardStat(var0, 1);
    }

    public void awardStat(Statistic<?> var0, int var1) {
    }

    public void resetStat(Statistic<?> var0) {
    }

    public int awardRecipes(Collection<RecipeHolder<?>> var0) {
        return 0;
    }

    public void triggerRecipeCrafted(RecipeHolder<?> var0, List<ItemStack> var1) {
    }

    public void awardRecipesByKey(List<ResourceKey<IRecipe<?>>> var0) {
    }

    public int resetRecipes(Collection<RecipeHolder<?>> var0) {
        return 0;
    }

    @Override
    public void travel(Vec3D var0) {
        double var1;
        if (this.isPassenger()) {
            super.travel(var0);
            return;
        }
        if (this.isSwimming()) {
            double var3;
            var1 = this.getLookAngle().y;
            double d2 = var3 = var1 < -0.2 ? 0.085 : 0.06;
            if (var1 <= 0.0 || this.jumping || !this.level().getFluidState(BlockPosition.containing(this.getX(), this.getY() + 1.0 - 0.1, this.getZ())).isEmpty()) {
                Vec3D var5 = this.getDeltaMovement();
                this.setDeltaMovement(var5.add(0.0, (var1 - var5.y) * var3, 0.0));
            }
        }
        if (this.getAbilities().flying) {
            var1 = this.getDeltaMovement().y;
            super.travel(var0);
            this.setDeltaMovement(this.getDeltaMovement().with(EnumDirection.EnumAxis.Y, var1 * 0.6));
        } else {
            super.travel(var0);
        }
    }

    @Override
    protected boolean canGlide() {
        return !this.abilities.flying && super.canGlide();
    }

    @Override
    public void updateSwimming() {
        if (this.abilities.flying) {
            this.setSwimming(false);
        } else {
            super.updateSwimming();
        }
    }

    protected boolean freeAt(BlockPosition var0) {
        return !this.level().getBlockState(var0).isSuffocating(this.level(), var0);
    }

    @Override
    public float getSpeed() {
        return (float)this.getAttributeValue(GenericAttributes.MOVEMENT_SPEED);
    }

    @Override
    public boolean causeFallDamage(double var0, float var2, DamageSource var3) {
        double var4;
        boolean var6;
        if (this.abilities.mayfly) {
            return false;
        }
        if (var0 >= 2.0) {
            this.awardStat(StatisticList.FALL_ONE_CM, (int)Math.round(var0 * 100.0));
        }
        boolean bl = var6 = this.currentImpulseImpactPos != null && this.ignoreFallDamageFromCurrentImpulse;
        if (var6) {
            boolean var7;
            var4 = Math.min(var0, this.currentImpulseImpactPos.y - this.getY());
            boolean bl2 = var7 = var4 <= 0.0;
            if (var7) {
                this.resetCurrentImpulseContext();
            } else {
                this.tryResetCurrentImpulseContext();
            }
        } else {
            var4 = var0;
        }
        if (var4 > 0.0 && super.causeFallDamage(var4, var2, var3)) {
            this.resetCurrentImpulseContext();
            return true;
        }
        this.propagateFallToPassengers(var0, var2, var3);
        return false;
    }

    public boolean tryToStartFallFlying() {
        if (!this.isFallFlying() && this.canGlide() && !this.isInWater()) {
            this.startFallFlying();
            return true;
        }
        return false;
    }

    public void startFallFlying() {
        this.setSharedFlag(7, true);
    }

    @Override
    protected void doWaterSplashEffect() {
        if (!this.isSpectator()) {
            super.doWaterSplashEffect();
        }
    }

    @Override
    protected void playStepSound(BlockPosition var0, IBlockData var1) {
        if (this.isInWater()) {
            this.waterSwimSound();
            this.playMuffledStepSound(var1);
        } else {
            BlockPosition var2 = this.getPrimaryStepSoundBlockPos(var0);
            if (!var0.equals(var2)) {
                IBlockData var3 = this.level().getBlockState(var2);
                if (var3.is(TagsBlock.COMBINATION_STEP_SOUND_BLOCKS)) {
                    this.playCombinationStepSounds(var3, var1);
                } else {
                    super.playStepSound(var2, var3);
                }
            } else {
                super.playStepSound(var0, var1);
            }
        }
    }

    @Override
    public EntityLiving.a getFallSounds() {
        return new EntityLiving.a(SoundEffects.PLAYER_SMALL_FALL, SoundEffects.PLAYER_BIG_FALL);
    }

    @Override
    public boolean killedEntity(WorldServer var0, EntityLiving var1) {
        this.awardStat(StatisticList.ENTITY_KILLED.get(var1.getType()));
        return true;
    }

    @Override
    public void makeStuckInBlock(IBlockData var0, Vec3D var1) {
        if (!this.abilities.flying) {
            super.makeStuckInBlock(var0, var1);
        }
        this.tryResetCurrentImpulseContext();
    }

    public void giveExperiencePoints(int var0) {
        this.increaseScore(var0);
        this.experienceProgress += (float)var0 / (float)this.getXpNeededForNextLevel();
        this.totalExperience = MathHelper.clamp(this.totalExperience + var0, 0, Integer.MAX_VALUE);
        while (this.experienceProgress < 0.0f) {
            float var1 = this.experienceProgress * (float)this.getXpNeededForNextLevel();
            if (this.experienceLevel > 0) {
                this.giveExperienceLevels(-1);
                this.experienceProgress = 1.0f + var1 / (float)this.getXpNeededForNextLevel();
                continue;
            }
            this.giveExperienceLevels(-1);
            this.experienceProgress = 0.0f;
        }
        while (this.experienceProgress >= 1.0f) {
            this.experienceProgress = (this.experienceProgress - 1.0f) * (float)this.getXpNeededForNextLevel();
            this.giveExperienceLevels(1);
            this.experienceProgress /= (float)this.getXpNeededForNextLevel();
        }
    }

    public int getEnchantmentSeed() {
        return this.enchantmentSeed;
    }

    public void onEnchantmentPerformed(ItemStack var0, int var1) {
        this.experienceLevel -= var1;
        if (this.experienceLevel < 0) {
            this.experienceLevel = 0;
            this.experienceProgress = 0.0f;
            this.totalExperience = 0;
        }
        this.enchantmentSeed = this.random.nextInt();
    }

    public void giveExperienceLevels(int var0) {
        this.experienceLevel = IntMath.saturatedAdd((int)this.experienceLevel, (int)var0);
        if (this.experienceLevel < 0) {
            this.experienceLevel = 0;
            this.experienceProgress = 0.0f;
            this.totalExperience = 0;
        }
        if (var0 > 0 && this.experienceLevel % 5 == 0 && (float)this.lastLevelUpTime < (float)this.tickCount - 100.0f) {
            float var1 = this.experienceLevel > 30 ? 1.0f : (float)this.experienceLevel / 30.0f;
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEffects.PLAYER_LEVELUP, this.getSoundSource(), var1 * 0.75f, 1.0f);
            this.lastLevelUpTime = this.tickCount;
        }
    }

    public int getXpNeededForNextLevel() {
        if (this.experienceLevel >= 30) {
            return 112 + (this.experienceLevel - 30) * 9;
        }
        if (this.experienceLevel >= 15) {
            return 37 + (this.experienceLevel - 15) * 5;
        }
        return 7 + this.experienceLevel * 2;
    }

    public void causeFoodExhaustion(float var0) {
        if (this.abilities.invulnerable) {
            return;
        }
        if (!this.level().isClientSide) {
            this.foodData.addExhaustion(var0);
        }
    }

    public Optional<WardenSpawnTracker> getWardenSpawnTracker() {
        return Optional.empty();
    }

    public FoodMetaData getFoodData() {
        return this.foodData;
    }

    public boolean canEat(boolean var0) {
        return this.abilities.invulnerable || var0 || this.foodData.needsFood();
    }

    public boolean isHurt() {
        return this.getHealth() > 0.0f && this.getHealth() < this.getMaxHealth();
    }

    public boolean mayBuild() {
        return this.abilities.mayBuild;
    }

    public boolean mayUseItemAt(BlockPosition var0, EnumDirection var1, ItemStack var2) {
        if (this.abilities.mayBuild) {
            return true;
        }
        BlockPosition var3 = var0.relative(var1.getOpposite());
        ShapeDetectorBlock var4 = new ShapeDetectorBlock(this.level(), var3, false);
        return var2.canPlaceOnBlockInAdventureMode(var4);
    }

    @Override
    protected int getBaseExperienceReward(WorldServer var0) {
        if (var0.getGameRules().getBoolean(GameRules.RULE_KEEPINVENTORY) || this.isSpectator()) {
            return 0;
        }
        return Math.min(this.experienceLevel * 7, 100);
    }

    @Override
    protected boolean isAlwaysExperienceDropper() {
        return true;
    }

    @Override
    public boolean shouldShowName() {
        return true;
    }

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return !this.abilities.flying && (!this.onGround() || !this.isDiscrete()) ? Entity.MovementEmission.ALL : Entity.MovementEmission.NONE;
    }

    public void onUpdateAbilities() {
    }

    @Override
    public IChatBaseComponent getName() {
        return IChatBaseComponent.literal(this.gameProfile.getName());
    }

    public InventoryEnderChest getEnderChestInventory() {
        return this.enderChestInventory;
    }

    @Override
    protected boolean doesEmitEquipEvent(EnumItemSlot var0) {
        return var0.getType() == EnumItemSlot.Function.HUMANOID_ARMOR;
    }

    public boolean addItem(ItemStack var0) {
        return this.inventory.add(var0);
    }

    public boolean setEntityOnShoulder(NBTTagCompound var0) {
        if (this.isPassenger() || !this.onGround() || this.isInWater() || this.isInPowderSnow) {
            return false;
        }
        if (this.getShoulderEntityLeft().isEmpty()) {
            this.setShoulderEntityLeft(var0);
            this.timeEntitySatOnShoulder = this.level().getGameTime();
            return true;
        }
        if (this.getShoulderEntityRight().isEmpty()) {
            this.setShoulderEntityRight(var0);
            this.timeEntitySatOnShoulder = this.level().getGameTime();
            return true;
        }
        return false;
    }

    protected void removeEntitiesOnShoulder() {
        if (this.timeEntitySatOnShoulder + 20L < this.level().getGameTime()) {
            this.respawnEntityOnShoulder(this.getShoulderEntityLeft());
            this.setShoulderEntityLeft(new NBTTagCompound());
            this.respawnEntityOnShoulder(this.getShoulderEntityRight());
            this.setShoulderEntityRight(new NBTTagCompound());
        }
    }

    private void respawnEntityOnShoulder(NBTTagCompound var02) {
        if (!this.level().isClientSide && !var02.isEmpty()) {
            EntityTypes.create(var02, this.level(), EntitySpawnReason.LOAD).ifPresent(var0 -> {
                if (var0 instanceof EntityTameableAnimal) {
                    EntityTameableAnimal var1 = (EntityTameableAnimal)var0;
                    var1.setOwner(this);
                }
                var0.setPos(this.getX(), this.getY() + (double)0.7f, this.getZ());
                ((WorldServer)this.level()).addWithUUID((Entity)var0);
            });
        }
    }

    @Nullable
    public abstract EnumGamemode gameMode();

    @Override
    public boolean isSpectator() {
        return this.gameMode() == EnumGamemode.SPECTATOR;
    }

    @Override
    public boolean canBeHitByProjectile() {
        return !this.isSpectator() && super.canBeHitByProjectile();
    }

    @Override
    public boolean isSwimming() {
        return !this.abilities.flying && !this.isSpectator() && super.isSwimming();
    }

    public boolean isCreative() {
        return this.gameMode() == EnumGamemode.CREATIVE;
    }

    @Override
    public boolean isPushedByFluid() {
        return !this.abilities.flying;
    }

    public Scoreboard getScoreboard() {
        return this.level().getScoreboard();
    }

    @Override
    public IChatBaseComponent getDisplayName() {
        IChatMutableComponent var0 = ScoreboardTeam.formatNameForTeam(this.getTeam(), this.getName());
        return this.decorateDisplayNameComponent(var0);
    }

    private IChatMutableComponent decorateDisplayNameComponent(IChatMutableComponent var0) {
        String var12 = this.getGameProfile().getName();
        return var0.withStyle(var1 -> var1.withClickEvent(new ChatClickable.SuggestCommand("/tell " + var12 + " ")).withHoverEvent(this.createHoverEvent()).withInsertion(var12));
    }

    @Override
    public String getScoreboardName() {
        return this.getGameProfile().getName();
    }

    @Override
    protected void internalSetAbsorptionAmount(float var0) {
        this.getEntityData().set(DATA_PLAYER_ABSORPTION_ID, Float.valueOf(var0));
    }

    @Override
    public float getAbsorptionAmount() {
        return this.getEntityData().get(DATA_PLAYER_ABSORPTION_ID).floatValue();
    }

    public boolean isModelPartShown(PlayerModelPart var0) {
        return (this.getEntityData().get(DATA_PLAYER_MODE_CUSTOMISATION) & var0.getMask()) == var0.getMask();
    }

    @Override
    public SlotAccess getSlot(int var0) {
        if (var0 == 499) {
            return new SlotAccess(){

                @Override
                public ItemStack get() {
                    return EntityHuman.this.containerMenu.getCarried();
                }

                @Override
                public boolean set(ItemStack var0) {
                    EntityHuman.this.containerMenu.setCarried(var0);
                    return true;
                }
            };
        }
        final int var1 = var0 - 500;
        if (var1 >= 0 && var1 < 4) {
            return new SlotAccess(){

                @Override
                public ItemStack get() {
                    return EntityHuman.this.inventoryMenu.getCraftSlots().getItem(var1);
                }

                @Override
                public boolean set(ItemStack var0) {
                    EntityHuman.this.inventoryMenu.getCraftSlots().setItem(var1, var0);
                    EntityHuman.this.inventoryMenu.slotsChanged(EntityHuman.this.inventory);
                    return true;
                }
            };
        }
        if (var0 >= 0 && var0 < this.inventory.getNonEquipmentItems().size()) {
            return SlotAccess.forContainer(this.inventory, var0);
        }
        int var2 = var0 - 200;
        if (var2 >= 0 && var2 < this.enderChestInventory.getContainerSize()) {
            return SlotAccess.forContainer(this.enderChestInventory, var2);
        }
        return super.getSlot(var0);
    }

    public boolean isReducedDebugInfo() {
        return this.reducedDebugInfo;
    }

    public void setReducedDebugInfo(boolean var0) {
        this.reducedDebugInfo = var0;
    }

    @Override
    public void setRemainingFireTicks(int var0) {
        super.setRemainingFireTicks(this.abilities.invulnerable ? Math.min(var0, 1) : var0);
    }

    @Override
    public EnumMainHand getMainArm() {
        return this.entityData.get(DATA_PLAYER_MAIN_HAND) == 0 ? EnumMainHand.LEFT : EnumMainHand.RIGHT;
    }

    public void setMainArm(EnumMainHand var0) {
        this.entityData.set(DATA_PLAYER_MAIN_HAND, (byte)(var0 != EnumMainHand.LEFT ? 1 : 0));
    }

    public NBTTagCompound getShoulderEntityLeft() {
        return this.entityData.get(DATA_SHOULDER_LEFT);
    }

    public void setShoulderEntityLeft(NBTTagCompound var0) {
        this.entityData.set(DATA_SHOULDER_LEFT, var0);
    }

    public NBTTagCompound getShoulderEntityRight() {
        return this.entityData.get(DATA_SHOULDER_RIGHT);
    }

    public void setShoulderEntityRight(NBTTagCompound var0) {
        this.entityData.set(DATA_SHOULDER_RIGHT, var0);
    }

    public float getCurrentItemAttackStrengthDelay() {
        return (float)(1.0 / this.getAttributeValue(GenericAttributes.ATTACK_SPEED) * 20.0);
    }

    public float getAttackStrengthScale(float var0) {
        return MathHelper.clamp(((float)this.attackStrengthTicker + var0) / this.getCurrentItemAttackStrengthDelay(), 0.0f, 1.0f);
    }

    public void resetAttackStrengthTicker() {
        this.attackStrengthTicker = 0;
    }

    public ItemCooldown getCooldowns() {
        return this.cooldowns;
    }

    @Override
    protected float getBlockSpeedFactor() {
        return this.abilities.flying || this.isFallFlying() ? 1.0f : super.getBlockSpeedFactor();
    }

    @Override
    public float getLuck() {
        return (float)this.getAttributeValue(GenericAttributes.LUCK);
    }

    public boolean canUseGameMasterBlocks() {
        return this.abilities.instabuild && this.getPermissionLevel() >= 2;
    }

    public int getPermissionLevel() {
        return 0;
    }

    public boolean hasPermissions(int var0) {
        return this.getPermissionLevel() >= var0;
    }

    @Override
    public EntitySize getDefaultDimensions(EntityPose var0) {
        return POSES.getOrDefault((Object)var0, STANDING_DIMENSIONS);
    }

    @Override
    public ImmutableList<EntityPose> getDismountPoses() {
        return ImmutableList.of((Object)((Object)EntityPose.STANDING), (Object)((Object)EntityPose.CROUCHING), (Object)((Object)EntityPose.SWIMMING));
    }

    @Override
    public ItemStack getProjectile(ItemStack var0) {
        if (!(var0.getItem() instanceof ItemProjectileWeapon)) {
            return ItemStack.EMPTY;
        }
        Predicate<ItemStack> var1 = ((ItemProjectileWeapon)var0.getItem()).getSupportedHeldProjectiles();
        ItemStack var2 = ItemProjectileWeapon.getHeldProjectile(this, var1);
        if (!var2.isEmpty()) {
            return var2;
        }
        var1 = ((ItemProjectileWeapon)var0.getItem()).getAllSupportedProjectiles();
        for (int var3 = 0; var3 < this.inventory.getContainerSize(); ++var3) {
            ItemStack var4 = this.inventory.getItem(var3);
            if (!var1.test(var4)) continue;
            return var4;
        }
        return this.hasInfiniteMaterials() ? new ItemStack(Items.ARROW) : ItemStack.EMPTY;
    }

    @Override
    public Vec3D getRopeHoldPosition(float var0) {
        double var1 = 0.22 * (this.getMainArm() == EnumMainHand.RIGHT ? -1.0 : 1.0);
        float var3 = MathHelper.lerp(var0 * 0.5f, this.getXRot(), this.xRotO) * ((float)Math.PI / 180);
        float var4 = MathHelper.lerp(var0, this.yBodyRotO, this.yBodyRot) * ((float)Math.PI / 180);
        if (this.isFallFlying() || this.isAutoSpinAttack()) {
            float var11;
            Vec3D var5 = this.getViewVector(var0);
            Vec3D var6 = this.getDeltaMovement();
            double var7 = var6.horizontalDistanceSqr();
            double var9 = var5.horizontalDistanceSqr();
            if (var7 > 0.0 && var9 > 0.0) {
                double var12 = (var6.x * var5.x + var6.z * var5.z) / Math.sqrt(var7 * var9);
                double var14 = var6.x * var5.z - var6.z * var5.x;
                var11 = (float)(Math.signum(var14) * Math.acos(var12));
            } else {
                var11 = 0.0f;
            }
            return this.getPosition(var0).add(new Vec3D(var1, -0.11, 0.85).zRot(-var11).xRot(-var3).yRot(-var4));
        }
        if (this.isVisuallySwimming()) {
            return this.getPosition(var0).add(new Vec3D(var1, 0.2, -0.15).xRot(-var3).yRot(-var4));
        }
        double var5 = this.getBoundingBox().getYsize() - 1.0;
        double var7 = this.isCrouching() ? -0.2 : 0.07;
        return this.getPosition(var0).add(new Vec3D(var1, var5, var7).yRot(-var4));
    }

    @Override
    public boolean isAlwaysTicking() {
        return true;
    }

    public boolean isScoping() {
        return this.isUsingItem() && this.getUseItem().is(Items.SPYGLASS);
    }

    @Override
    public boolean shouldBeSaved() {
        return false;
    }

    public Optional<GlobalPos> getLastDeathLocation() {
        return this.lastDeathLocation;
    }

    public void setLastDeathLocation(Optional<GlobalPos> var0) {
        this.lastDeathLocation = var0;
    }

    @Override
    public float getHurtDir() {
        return this.hurtDir;
    }

    @Override
    public void animateHurt(float var0) {
        super.animateHurt(var0);
        this.hurtDir = var0;
    }

    @Override
    public boolean canSprint() {
        return true;
    }

    @Override
    protected float getFlyingSpeed() {
        if (this.abilities.flying && !this.isPassenger()) {
            return this.isSprinting() ? this.abilities.getFlyingSpeed() * 2.0f : this.abilities.getFlyingSpeed();
        }
        return this.isSprinting() ? 0.025999999f : 0.02f;
    }

    public boolean hasClientLoaded() {
        return this.clientLoaded || this.clientLoadedTimeoutTimer <= 0;
    }

    public void tickClientLoadTimeout() {
        if (!this.clientLoaded) {
            --this.clientLoadedTimeoutTimer;
        }
    }

    public void setClientLoaded(boolean var0) {
        this.clientLoaded = var0;
        if (!this.clientLoaded) {
            this.clientLoadedTimeoutTimer = 60;
        }
    }

    public double blockInteractionRange() {
        return this.getAttributeValue(GenericAttributes.BLOCK_INTERACTION_RANGE);
    }

    public double entityInteractionRange() {
        return this.getAttributeValue(GenericAttributes.ENTITY_INTERACTION_RANGE);
    }

    public boolean canInteractWithEntity(Entity var0, double var1) {
        if (var0.isRemoved()) {
            return false;
        }
        return this.canInteractWithEntity(var0.getBoundingBox(), var1);
    }

    public boolean canInteractWithEntity(AxisAlignedBB var0, double var1) {
        double var3 = this.entityInteractionRange() + var1;
        return var0.distanceToSqr(this.getEyePosition()) < var3 * var3;
    }

    public boolean canInteractWithBlock(BlockPosition var0, double var1) {
        double var3 = this.blockInteractionRange() + var1;
        return new AxisAlignedBB(var0).distanceToSqr(this.getEyePosition()) < var3 * var3;
    }

    public void setIgnoreFallDamageFromCurrentImpulse(boolean var0) {
        this.ignoreFallDamageFromCurrentImpulse = var0;
        this.currentImpulseContextResetGraceTime = var0 ? 40 : 0;
    }

    public boolean isIgnoringFallDamageFromCurrentImpulse() {
        return this.ignoreFallDamageFromCurrentImpulse;
    }

    public void tryResetCurrentImpulseContext() {
        if (this.currentImpulseContextResetGraceTime == 0) {
            this.resetCurrentImpulseContext();
        }
    }

    public void resetCurrentImpulseContext() {
        this.currentImpulseContextResetGraceTime = 0;
        this.currentExplosionCause = null;
        this.currentImpulseImpactPos = null;
        this.ignoreFallDamageFromCurrentImpulse = false;
    }

    public boolean shouldRotateWithMinecart() {
        return false;
    }

    @Override
    public boolean onClimbable() {
        if (this.abilities.flying) {
            return false;
        }
        return super.onClimbable();
    }

    public String debugInfo() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.getName().getString()).add("id", this.getId()).add("pos", (Object)this.position()).add("mode", (Object)this.gameMode()).add("permission", this.getPermissionLevel()).toString();
    }

    public static final class EnumBedResult
    extends Enum<EnumBedResult> {
        public static final /* enum */ EnumBedResult NOT_POSSIBLE_HERE = new EnumBedResult();
        public static final /* enum */ EnumBedResult NOT_POSSIBLE_NOW = new EnumBedResult(IChatBaseComponent.translatable("block.minecraft.bed.no_sleep"));
        public static final /* enum */ EnumBedResult TOO_FAR_AWAY = new EnumBedResult(IChatBaseComponent.translatable("block.minecraft.bed.too_far_away"));
        public static final /* enum */ EnumBedResult OBSTRUCTED = new EnumBedResult(IChatBaseComponent.translatable("block.minecraft.bed.obstructed"));
        public static final /* enum */ EnumBedResult OTHER_PROBLEM = new EnumBedResult();
        public static final /* enum */ EnumBedResult NOT_SAFE = new EnumBedResult(IChatBaseComponent.translatable("block.minecraft.bed.not_safe"));
        @Nullable
        private final IChatBaseComponent message;
        private static final /* synthetic */ EnumBedResult[] h;

        public static EnumBedResult[] values() {
            return (EnumBedResult[])h.clone();
        }

        public static EnumBedResult valueOf(String var0) {
            return Enum.valueOf(EnumBedResult.class, var0);
        }

        private EnumBedResult() {
            this.message = null;
        }

        private EnumBedResult(IChatBaseComponent var2) {
            this.message = var2;
        }

        @Nullable
        public IChatBaseComponent getMessage() {
            return this.message;
        }

        private static /* synthetic */ EnumBedResult[] b() {
            return new EnumBedResult[]{NOT_POSSIBLE_HERE, NOT_POSSIBLE_NOW, TOO_FAR_AWAY, OBSTRUCTED, OTHER_PROBLEM, NOT_SAFE};
        }

        static {
            h = EnumBedResult.b();
        }
    }
}

