/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.item;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.Vec3D;

public class EntityItem
extends Entity
implements TraceableEntity {
    private static final DataWatcherObject<ItemStack> DATA_ITEM = DataWatcher.defineId(EntityItem.class, DataWatcherRegistry.ITEM_STACK);
    private static final float FLOAT_HEIGHT = 0.1f;
    public static final float EYE_HEIGHT = 0.2125f;
    private static final int LIFETIME = 6000;
    private static final int INFINITE_PICKUP_DELAY = Short.MAX_VALUE;
    private static final int INFINITE_LIFETIME = Short.MIN_VALUE;
    private static final int DEFAULT_HEALTH = 5;
    private static final short DEFAULT_AGE = 0;
    private static final short DEFAULT_PICKUP_DELAY = 0;
    public int age = 0;
    public int pickupDelay = 0;
    private int health = 5;
    @Nullable
    public UUID thrower;
    @Nullable
    private Entity cachedThrower;
    @Nullable
    public UUID target;
    public final float bobOffs;

    public EntityItem(EntityTypes<? extends EntityItem> var0, World var1) {
        super(var0, var1);
        this.bobOffs = this.random.nextFloat() * (float)Math.PI * 2.0f;
        this.setYRot(this.random.nextFloat() * 360.0f);
    }

    public EntityItem(World var0, double var1, double var3, double var5, ItemStack var7) {
        this(var0, var1, var3, var5, var7, var0.random.nextDouble() * 0.2 - 0.1, 0.2, var0.random.nextDouble() * 0.2 - 0.1);
    }

    public EntityItem(World var0, double var1, double var3, double var5, ItemStack var7, double var8, double var10, double var12) {
        this((EntityTypes<? extends EntityItem>)EntityTypes.ITEM, var0);
        this.setPos(var1, var3, var5);
        this.setDeltaMovement(var8, var10, var12);
        this.setItem(var7);
    }

    private EntityItem(EntityItem var0) {
        super(var0.getType(), var0.level());
        this.setItem(var0.getItem().copy());
        this.copyPosition(var0);
        this.age = var0.age;
        this.bobOffs = var0.bobOffs;
    }

    @Override
    public boolean dampensVibrations() {
        return this.getItem().is(TagsItem.DAMPENS_VIBRATIONS);
    }

    @Override
    @Nullable
    public Entity getOwner() {
        World world;
        if (this.cachedThrower != null && !this.cachedThrower.isRemoved()) {
            return this.cachedThrower;
        }
        if (this.thrower != null && (world = this.level()) instanceof WorldServer) {
            WorldServer var0 = (WorldServer)world;
            this.cachedThrower = var0.getEntity(this.thrower);
            return this.cachedThrower;
        }
        return null;
    }

    @Override
    public void restoreFrom(Entity var0) {
        super.restoreFrom(var0);
        if (var0 instanceof EntityItem) {
            EntityItem var1 = (EntityItem)var0;
            this.cachedThrower = var1.cachedThrower;
        }
    }

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        var0.define(DATA_ITEM, ItemStack.EMPTY);
    }

    @Override
    protected double getDefaultGravity() {
        return 0.04;
    }

    @Override
    public void tick() {
        double var3;
        int var2;
        if (this.getItem().isEmpty()) {
            this.discard();
            return;
        }
        super.tick();
        if (this.pickupDelay > 0 && this.pickupDelay != Short.MAX_VALUE) {
            --this.pickupDelay;
        }
        this.xo = this.getX();
        this.yo = this.getY();
        this.zo = this.getZ();
        Vec3D var0 = this.getDeltaMovement();
        if (this.isInWater() && this.getFluidHeight(TagsFluid.WATER) > (double)0.1f) {
            this.setUnderwaterMovement();
        } else if (this.isInLava() && this.getFluidHeight(TagsFluid.LAVA) > (double)0.1f) {
            this.setUnderLavaMovement();
        } else {
            this.applyGravity();
        }
        if (this.level().isClientSide) {
            this.noPhysics = false;
        } else {
            boolean bl = this.noPhysics = !this.level().noCollision(this, this.getBoundingBox().deflate(1.0E-7));
            if (this.noPhysics) {
                this.moveTowardsClosestSpace(this.getX(), (this.getBoundingBox().minY + this.getBoundingBox().maxY) / 2.0, this.getZ());
            }
        }
        if (!this.onGround() || this.getDeltaMovement().horizontalDistanceSqr() > (double)1.0E-5f || (this.tickCount + this.getId()) % 4 == 0) {
            this.move(EnumMoveType.SELF, this.getDeltaMovement());
            this.applyEffectsFromBlocks();
            float var1 = 0.98f;
            if (this.onGround()) {
                var1 = this.level().getBlockState(this.getBlockPosBelowThatAffectsMyMovement()).getBlock().getFriction() * 0.98f;
            }
            this.setDeltaMovement(this.getDeltaMovement().multiply(var1, 0.98, var1));
            if (this.onGround()) {
                Vec3D var22 = this.getDeltaMovement();
                if (var22.y < 0.0) {
                    this.setDeltaMovement(var22.multiply(1.0, -0.5, 1.0));
                }
            }
        }
        boolean var1 = MathHelper.floor(this.xo) != MathHelper.floor(this.getX()) || MathHelper.floor(this.yo) != MathHelper.floor(this.getY()) || MathHelper.floor(this.zo) != MathHelper.floor(this.getZ());
        int n2 = var2 = var1 ? 2 : 40;
        if (this.tickCount % var2 == 0 && !this.level().isClientSide && this.isMergable()) {
            this.mergeWithNeighbours();
        }
        if (this.age != Short.MIN_VALUE) {
            ++this.age;
        }
        this.hasImpulse |= this.updateInWaterStateAndDoFluidPushing();
        if (!this.level().isClientSide && (var3 = this.getDeltaMovement().subtract(var0).lengthSqr()) > 0.01) {
            this.hasImpulse = true;
        }
        if (!this.level().isClientSide && this.age >= 6000) {
            this.discard();
        }
    }

    @Override
    public BlockPosition getBlockPosBelowThatAffectsMyMovement() {
        return this.getOnPos(0.999999f);
    }

    private void setUnderwaterMovement() {
        this.setFluidMovement(0.99f);
    }

    private void setUnderLavaMovement() {
        this.setFluidMovement(0.95f);
    }

    private void setFluidMovement(double var0) {
        Vec3D var2 = this.getDeltaMovement();
        this.setDeltaMovement(var2.x * var0, var2.y + (double)(var2.y < (double)0.06f ? 5.0E-4f : 0.0f), var2.z * var0);
    }

    private void mergeWithNeighbours() {
        if (!this.isMergable()) {
            return;
        }
        List<EntityItem> var02 = this.level().getEntitiesOfClass(EntityItem.class, this.getBoundingBox().inflate(0.5, 0.0, 0.5), var0 -> var0 != this && var0.isMergable());
        for (EntityItem var2 : var02) {
            if (!var2.isMergable()) continue;
            this.tryToMerge(var2);
            if (!this.isRemoved()) continue;
            break;
        }
    }

    private boolean isMergable() {
        ItemStack var0 = this.getItem();
        return this.isAlive() && this.pickupDelay != Short.MAX_VALUE && this.age != Short.MIN_VALUE && this.age < 6000 && var0.getCount() < var0.getMaxStackSize();
    }

    private void tryToMerge(EntityItem var0) {
        ItemStack var1 = this.getItem();
        ItemStack var2 = var0.getItem();
        if (!Objects.equals(this.target, var0.target) || !EntityItem.areMergable(var1, var2)) {
            return;
        }
        if (var2.getCount() < var1.getCount()) {
            EntityItem.merge(this, var1, var0, var2);
        } else {
            EntityItem.merge(var0, var2, this, var1);
        }
    }

    public static boolean areMergable(ItemStack var0, ItemStack var1) {
        if (var1.getCount() + var0.getCount() > var1.getMaxStackSize()) {
            return false;
        }
        return ItemStack.isSameItemSameComponents(var0, var1);
    }

    public static ItemStack merge(ItemStack var0, ItemStack var1, int var2) {
        int var3 = Math.min(Math.min(var0.getMaxStackSize(), var2) - var0.getCount(), var1.getCount());
        ItemStack var4 = var0.copyWithCount(var0.getCount() + var3);
        var1.shrink(var3);
        return var4;
    }

    private static void merge(EntityItem var0, ItemStack var1, ItemStack var2) {
        ItemStack var3 = EntityItem.merge(var1, var2, 64);
        var0.setItem(var3);
    }

    private static void merge(EntityItem var0, ItemStack var1, EntityItem var2, ItemStack var3) {
        EntityItem.merge(var0, var1, var3);
        var0.pickupDelay = Math.max(var0.pickupDelay, var2.pickupDelay);
        var0.age = Math.min(var0.age, var2.age);
        if (var3.isEmpty()) {
            var2.discard();
        }
    }

    @Override
    public boolean fireImmune() {
        return !this.getItem().canBeHurtBy(this.damageSources().inFire()) || super.fireImmune();
    }

    @Override
    protected boolean shouldPlayLavaHurtSound() {
        if (this.health <= 0) {
            return true;
        }
        return this.tickCount % 10 == 0;
    }

    @Override
    public final boolean hurtClient(DamageSource var0) {
        if (this.isInvulnerableToBase(var0)) {
            return false;
        }
        return this.getItem().canBeHurtBy(var0);
    }

    @Override
    public final boolean hurtServer(WorldServer var0, DamageSource var1, float var2) {
        if (this.isInvulnerableToBase(var1)) {
            return false;
        }
        if (!var0.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING) && var1.getEntity() instanceof EntityInsentient) {
            return false;
        }
        if (!this.getItem().canBeHurtBy(var1)) {
            return false;
        }
        this.markHurt();
        this.health = (int)((float)this.health - var2);
        this.gameEvent(GameEvent.ENTITY_DAMAGE, var1.getEntity());
        if (this.health <= 0) {
            this.getItem().onDestroyed(this);
            this.discard();
        }
        return true;
    }

    @Override
    public boolean ignoreExplosion(Explosion var0) {
        if (var0.shouldAffectBlocklikeEntities()) {
            return super.ignoreExplosion(var0);
        }
        return true;
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        var0.putShort("Health", (short)this.health);
        var0.putShort("Age", (short)this.age);
        var0.putShort("PickupDelay", (short)this.pickupDelay);
        var0.storeNullable("Thrower", UUIDUtil.CODEC, this.thrower);
        var0.storeNullable("Owner", UUIDUtil.CODEC, this.target);
        if (!this.getItem().isEmpty()) {
            RegistryOps<NBTBase> var1 = this.registryAccess().createSerializationContext(DynamicOpsNBT.INSTANCE);
            var0.store("Item", ItemStack.CODEC, var1, this.getItem());
        }
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        this.health = var0.getShortOr("Health", (short)5);
        this.age = var0.getShortOr("Age", (short)0);
        this.pickupDelay = var0.getShortOr("PickupDelay", (short)0);
        this.target = var0.read("Owner", UUIDUtil.CODEC).orElse(null);
        this.thrower = var0.read("Thrower", UUIDUtil.CODEC).orElse(null);
        this.cachedThrower = null;
        RegistryOps<NBTBase> var1 = this.registryAccess().createSerializationContext(DynamicOpsNBT.INSTANCE);
        this.setItem(var0.read("Item", ItemStack.CODEC, var1).orElse(ItemStack.EMPTY));
        if (this.getItem().isEmpty()) {
            this.discard();
        }
    }

    @Override
    public void playerTouch(EntityHuman var0) {
        if (this.level().isClientSide) {
            return;
        }
        ItemStack var1 = this.getItem();
        Item var2 = var1.getItem();
        int var3 = var1.getCount();
        if (this.pickupDelay == 0 && (this.target == null || this.target.equals(var0.getUUID())) && var0.getInventory().add(var1)) {
            var0.take(this, var3);
            if (var1.isEmpty()) {
                this.discard();
                var1.setCount(var3);
            }
            var0.awardStat(StatisticList.ITEM_PICKED_UP.get(var2), var3);
            var0.onItemPickup(this);
        }
    }

    @Override
    public IChatBaseComponent getName() {
        IChatBaseComponent var0 = this.getCustomName();
        if (var0 != null) {
            return var0;
        }
        return this.getItem().getItemName();
    }

    @Override
    public boolean isAttackable() {
        return false;
    }

    @Override
    @Nullable
    public Entity teleport(TeleportTransition var0) {
        Entity var1 = super.teleport(var0);
        if (!this.level().isClientSide && var1 instanceof EntityItem) {
            EntityItem var2 = (EntityItem)var1;
            var2.mergeWithNeighbours();
        }
        return var1;
    }

    public ItemStack getItem() {
        return this.getEntityData().get(DATA_ITEM);
    }

    public void setItem(ItemStack var0) {
        this.getEntityData().set(DATA_ITEM, var0);
    }

    @Override
    public void onSyncedDataUpdated(DataWatcherObject<?> var0) {
        super.onSyncedDataUpdated(var0);
        if (DATA_ITEM.equals(var0)) {
            this.getItem().setEntityRepresentation(this);
        }
    }

    public void setTarget(@Nullable UUID var0) {
        this.target = var0;
    }

    public void setThrower(Entity var0) {
        this.thrower = var0.getUUID();
        this.cachedThrower = var0;
    }

    public int getAge() {
        return this.age;
    }

    public void setDefaultPickUpDelay() {
        this.pickupDelay = 10;
    }

    public void setNoPickUpDelay() {
        this.pickupDelay = 0;
    }

    public void setNeverPickUp() {
        this.pickupDelay = Short.MAX_VALUE;
    }

    public void setPickUpDelay(int var0) {
        this.pickupDelay = var0;
    }

    public boolean hasPickUpDelay() {
        return this.pickupDelay > 0;
    }

    public void setUnlimitedLifetime() {
        this.age = Short.MIN_VALUE;
    }

    public void setExtendedLifetime() {
        this.age = -6000;
    }

    public void makeFakeItem() {
        this.setNeverPickUp();
        this.age = 5999;
    }

    public static float getSpin(float var0, float var1) {
        return var0 / 20.0f + var1;
    }

    public EntityItem copy() {
        return new EntityItem(this);
    }

    @Override
    public SoundCategory getSoundSource() {
        return SoundCategory.AMBIENT;
    }

    @Override
    public float getVisualRotationYInDegrees() {
        return 180.0f - EntityItem.getSpin((float)this.getAge() + 0.5f, this.bobOffs) / ((float)Math.PI * 2) * 360.0f;
    }

    @Override
    public SlotAccess getSlot(int var0) {
        if (var0 == 0) {
            return SlotAccess.of(this::getItem, this::setItem);
        }
        return super.getSlot(var0);
    }
}

