/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.item;

import com.mojang.logging.LogUtils;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContextDirectional;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockAnvil;
import net.minecraft.world.level.block.BlockConcretePowder;
import net.minecraft.world.level.block.BlockFalling;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.slf4j.Logger;

public class EntityFallingBlock
extends Entity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final IBlockData DEFAULT_BLOCK_STATE = Blocks.SAND.defaultBlockState();
    private static final int DEFAULT_TIME = 0;
    private static final float DEFAULT_FALL_DAMAGE_PER_DISTANCE = 0.0f;
    private static final int DEFAULT_MAX_FALL_DAMAGE = 40;
    private static final boolean DEFAULT_DROP_ITEM = true;
    private static final boolean DEFAULT_CANCEL_DROP = false;
    private IBlockData blockState = DEFAULT_BLOCK_STATE;
    public int time = 0;
    public boolean dropItem = true;
    public boolean cancelDrop = false;
    public boolean hurtEntities;
    public int fallDamageMax = 40;
    public float fallDamagePerDistance = 0.0f;
    @Nullable
    public NBTTagCompound blockData;
    public boolean forceTickAfterTeleportToDuplicate;
    protected static final DataWatcherObject<BlockPosition> DATA_START_POS = DataWatcher.defineId(EntityFallingBlock.class, DataWatcherRegistry.BLOCK_POS);

    public EntityFallingBlock(EntityTypes<? extends EntityFallingBlock> var0, World var1) {
        super(var0, var1);
    }

    private EntityFallingBlock(World var0, double var1, double var3, double var5, IBlockData var7) {
        this((EntityTypes<? extends EntityFallingBlock>)EntityTypes.FALLING_BLOCK, var0);
        this.blockState = var7;
        this.blocksBuilding = true;
        this.setPos(var1, var3, var5);
        this.setDeltaMovement(Vec3D.ZERO);
        this.xo = var1;
        this.yo = var3;
        this.zo = var5;
        this.setStartPos(this.blockPosition());
    }

    public static EntityFallingBlock fall(World var0, BlockPosition var1, IBlockData var2) {
        EntityFallingBlock var3 = new EntityFallingBlock(var0, (double)var1.getX() + 0.5, var1.getY(), (double)var1.getZ() + 0.5, var2.hasProperty(BlockProperties.WATERLOGGED) ? (IBlockData)var2.setValue(BlockProperties.WATERLOGGED, false) : var2);
        var0.setBlock(var1, var2.getFluidState().createLegacyBlock(), 3);
        var0.addFreshEntity(var3);
        return var3;
    }

    @Override
    public boolean isAttackable() {
        return false;
    }

    @Override
    public final boolean hurtServer(WorldServer var0, DamageSource var1, float var2) {
        if (!this.isInvulnerableToBase(var1)) {
            this.markHurt();
        }
        return false;
    }

    public void setStartPos(BlockPosition var0) {
        this.entityData.set(DATA_START_POS, var0);
    }

    public BlockPosition getStartPos() {
        return this.entityData.get(DATA_START_POS);
    }

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        var0.define(DATA_START_POS, BlockPosition.ZERO);
    }

    @Override
    public boolean isPickable() {
        return !this.isRemoved();
    }

    @Override
    protected double getDefaultGravity() {
        return 0.04;
    }

    @Override
    public void tick() {
        if (this.blockState.isAir()) {
            this.discard();
            return;
        }
        Block var0 = this.blockState.getBlock();
        ++this.time;
        this.applyGravity();
        this.move(EnumMoveType.SELF, this.getDeltaMovement());
        this.applyEffectsFromBlocks();
        this.handlePortal();
        World world = this.level();
        if (world instanceof WorldServer) {
            WorldServer var12 = (WorldServer)world;
            if (this.isAlive() || this.forceTickAfterTeleportToDuplicate) {
                Object var7;
                BlockPosition var22 = this.blockPosition();
                boolean var3 = this.blockState.getBlock() instanceof BlockConcretePowder;
                boolean var4 = var3 && this.level().getFluidState(var22).is(TagsFluid.WATER);
                double var5 = this.getDeltaMovement().lengthSqr();
                if (var3 && var5 > 1.0 && ((MovingObjectPositionBlock)(var7 = this.level().clip(new RayTrace(new Vec3D(this.xo, this.yo, this.zo), this.position(), RayTrace.BlockCollisionOption.COLLIDER, RayTrace.FluidCollisionOption.SOURCE_ONLY, this)))).getType() != MovingObjectPosition.EnumMovingObjectType.MISS && this.level().getFluidState(((MovingObjectPositionBlock)var7).getBlockPos()).is(TagsFluid.WATER)) {
                    var22 = ((MovingObjectPositionBlock)var7).getBlockPos();
                    var4 = true;
                }
                if (this.onGround() || var4) {
                    var7 = this.level().getBlockState(var22);
                    this.setDeltaMovement(this.getDeltaMovement().multiply(0.7, -0.5, 0.7));
                    if (!((BlockBase.BlockData)var7).is(Blocks.MOVING_PISTON)) {
                        if (!this.cancelDrop) {
                            boolean var10;
                            boolean var8 = ((BlockBase.BlockData)var7).canBeReplaced(new BlockActionContextDirectional(this.level(), var22, EnumDirection.DOWN, ItemStack.EMPTY, EnumDirection.UP));
                            boolean var9 = BlockFalling.isFree(this.level().getBlockState(var22.below())) && (!var3 || !var4);
                            boolean bl = var10 = this.blockState.canSurvive(this.level(), var22) && !var9;
                            if (var8 && var10) {
                                if (this.blockState.hasProperty(BlockProperties.WATERLOGGED) && this.level().getFluidState(var22).getType() == FluidTypes.WATER) {
                                    this.blockState = (IBlockData)this.blockState.setValue(BlockProperties.WATERLOGGED, true);
                                }
                                if (this.level().setBlock(var22, this.blockState, 3)) {
                                    TileEntity var11;
                                    ((WorldServer)this.level()).getChunkSource().chunkMap.broadcast(this, new PacketPlayOutBlockChange(var22, this.level().getBlockState(var22)));
                                    this.discard();
                                    if (var0 instanceof Fallable) {
                                        ((Fallable)((Object)var0)).onLand(this.level(), var22, this.blockState, (IBlockData)var7, this);
                                    }
                                    if (this.blockData != null && this.blockState.hasBlockEntity() && (var11 = this.level().getBlockEntity(var22)) != null) {
                                        NBTTagCompound var122 = var11.saveWithoutMetadata(this.level().registryAccess());
                                        this.blockData.forEach((var1, var2) -> var122.put((String)var1, var2.copy()));
                                        try {
                                            var11.loadWithComponents(var122, this.level().registryAccess());
                                        }
                                        catch (Exception var13) {
                                            LOGGER.error("Failed to load block entity from falling block", (Throwable)var13);
                                        }
                                        var11.setChanged();
                                    }
                                } else if (this.dropItem && var12.getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                                    this.discard();
                                    this.callOnBrokenAfterFall(var0, var22);
                                    this.spawnAtLocation(var12, var0);
                                }
                            } else {
                                this.discard();
                                if (this.dropItem && var12.getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                                    this.callOnBrokenAfterFall(var0, var22);
                                    this.spawnAtLocation(var12, var0);
                                }
                            }
                        } else {
                            this.discard();
                            this.callOnBrokenAfterFall(var0, var22);
                        }
                    }
                } else if (this.time > 100 && (var22.getY() <= this.level().getMinY() || var22.getY() > this.level().getMaxY()) || this.time > 600) {
                    if (this.dropItem && var12.getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                        this.spawnAtLocation(var12, var0);
                    }
                    this.discard();
                }
            }
        }
        this.setDeltaMovement(this.getDeltaMovement().scale(0.98));
    }

    public void callOnBrokenAfterFall(Block var0, BlockPosition var1) {
        if (var0 instanceof Fallable) {
            ((Fallable)((Object)var0)).onBrokenAfterFall(this.level(), var1, this);
        }
    }

    @Override
    public boolean causeFallDamage(double var0, float var22, DamageSource var3) {
        DamageSource damageSource;
        if (!this.hurtEntities) {
            return false;
        }
        int var4 = MathHelper.ceil(var0 - 1.0);
        if (var4 < 0) {
            return false;
        }
        Predicate<Entity> var5 = IEntitySelector.NO_CREATIVE_OR_SPECTATOR.and(IEntitySelector.LIVING_ENTITY_STILL_ALIVE);
        Block block = this.blockState.getBlock();
        if (block instanceof Fallable) {
            Fallable var7 = (Fallable)((Object)block);
            damageSource = var7.getFallDamageSource(this);
        } else {
            damageSource = this.damageSources().fallingBlock(this);
        }
        DamageSource var6 = damageSource;
        float var7 = Math.min(MathHelper.floor((float)var4 * this.fallDamagePerDistance), this.fallDamageMax);
        this.level().getEntities(this, this.getBoundingBox(), var5).forEach(var2 -> var2.hurt(var6, var7));
        boolean var8 = this.blockState.is(TagsBlock.ANVIL);
        if (var8 && var7 > 0.0f && this.random.nextFloat() < 0.05f + (float)var4 * 0.05f) {
            IBlockData var9 = BlockAnvil.damage(this.blockState);
            if (var9 == null) {
                this.cancelDrop = true;
            } else {
                this.blockState = var9;
            }
        }
        return false;
    }

    @Override
    protected void addAdditionalSaveData(NBTTagCompound var0) {
        RegistryOps<NBTBase> var1 = this.registryAccess().createSerializationContext(DynamicOpsNBT.INSTANCE);
        var0.store("BlockState", IBlockData.CODEC, var1, this.blockState);
        var0.putInt("Time", this.time);
        var0.putBoolean("DropItem", this.dropItem);
        var0.putBoolean("HurtEntities", this.hurtEntities);
        var0.putFloat("FallHurtAmount", this.fallDamagePerDistance);
        var0.putInt("FallHurtMax", this.fallDamageMax);
        if (this.blockData != null) {
            var0.put("TileEntityData", this.blockData);
        }
        var0.putBoolean("CancelDrop", this.cancelDrop);
    }

    @Override
    protected void readAdditionalSaveData(NBTTagCompound var0) {
        RegistryOps<NBTBase> var1 = this.registryAccess().createSerializationContext(DynamicOpsNBT.INSTANCE);
        this.blockState = var0.read("BlockState", IBlockData.CODEC, var1).orElse(DEFAULT_BLOCK_STATE);
        this.time = var0.getIntOr("Time", 0);
        boolean var2 = this.blockState.is(TagsBlock.ANVIL);
        this.hurtEntities = var0.getBooleanOr("HurtEntities", var2);
        this.fallDamagePerDistance = var0.getFloatOr("FallHurtAmount", 0.0f);
        this.fallDamageMax = var0.getIntOr("FallHurtMax", 40);
        this.dropItem = var0.getBooleanOr("DropItem", true);
        this.blockData = var0.getCompound("TileEntityData").map(NBTTagCompound::copy).orElse(null);
        this.cancelDrop = var0.getBooleanOr("CancelDrop", false);
    }

    public void setHurtsEntities(float var0, int var1) {
        this.hurtEntities = true;
        this.fallDamagePerDistance = var0;
        this.fallDamageMax = var1;
    }

    public void disableDrop() {
        this.cancelDrop = true;
    }

    @Override
    public boolean displayFireAnimation() {
        return false;
    }

    @Override
    public void fillCrashReportCategory(CrashReportSystemDetails var0) {
        super.fillCrashReportCategory(var0);
        var0.setDetail("Immitating BlockState", this.blockState.toString());
    }

    public IBlockData getBlockState() {
        return this.blockState;
    }

    @Override
    protected IChatBaseComponent getTypeName() {
        return IChatBaseComponent.translatable("entity.minecraft.falling_block_type", this.blockState.getBlock().getName());
    }

    @Override
    public Packet<PacketListenerPlayOut> getAddEntityPacket(EntityTrackerEntry var0) {
        return new PacketPlayOutSpawnEntity((Entity)this, var0, Block.getId(this.getBlockState()));
    }

    @Override
    public void recreateFromPacket(PacketPlayOutSpawnEntity var0) {
        super.recreateFromPacket(var0);
        this.blockState = Block.stateById(var0.getData());
        this.blocksBuilding = true;
        double var1 = var0.getX();
        double var3 = var0.getY();
        double var5 = var0.getZ();
        this.setPos(var1, var3, var5);
        this.setStartPos(this.blockPosition());
    }

    @Override
    @Nullable
    public Entity teleport(TeleportTransition var0) {
        ResourceKey<World> var1 = var0.newLevel().dimension();
        ResourceKey<World> var2 = this.level().dimension();
        boolean var3 = (var2 == World.END || var1 == World.END) && var2 != var1;
        Entity var4 = super.teleport(var0);
        this.forceTickAfterTeleportToDuplicate = var4 != null && var3;
        return var4;
    }
}

