/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.PaintingVariantTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.decoration.EntityHanging;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.variant.VariantUtils;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;

public class EntityPainting
extends EntityHanging {
    private static final DataWatcherObject<Holder<PaintingVariant>> DATA_PAINTING_VARIANT_ID = DataWatcher.defineId(EntityPainting.class, DataWatcherRegistry.PAINTING_VARIANT);
    public static final float DEPTH = 0.0625f;

    public EntityPainting(EntityTypes<? extends EntityPainting> var0, World var1) {
        super((EntityTypes<? extends EntityHanging>)var0, var1);
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        var0.define(DATA_PAINTING_VARIANT_ID, VariantUtils.getAny(this.registryAccess(), Registries.PAINTING_VARIANT));
    }

    @Override
    public void onSyncedDataUpdated(DataWatcherObject<?> var0) {
        if (DATA_PAINTING_VARIANT_ID.equals(var0)) {
            this.recalculateBoundingBox();
        }
    }

    public void setVariant(Holder<PaintingVariant> var0) {
        this.entityData.set(DATA_PAINTING_VARIANT_ID, var0);
    }

    public Holder<PaintingVariant> getVariant() {
        return this.entityData.get(DATA_PAINTING_VARIANT_ID);
    }

    @Override
    @Nullable
    public <T> T get(DataComponentType<? extends T> var0) {
        if (var0 == DataComponents.PAINTING_VARIANT) {
            return EntityPainting.castComponentValue(var0, this.getVariant());
        }
        return super.get(var0);
    }

    @Override
    protected void applyImplicitComponents(DataComponentGetter var0) {
        this.applyImplicitComponentIfPresent(var0, DataComponents.PAINTING_VARIANT);
        super.applyImplicitComponents(var0);
    }

    @Override
    protected <T> boolean applyImplicitComponent(DataComponentType<T> var0, T var1) {
        if (var0 == DataComponents.PAINTING_VARIANT) {
            this.setVariant(EntityPainting.castComponentValue(DataComponents.PAINTING_VARIANT, var1));
            return true;
        }
        return super.applyImplicitComponent(var0, var1);
    }

    public static Optional<EntityPainting> create(World var0, BlockPosition var12, EnumDirection var2) {
        EntityPainting var3 = new EntityPainting(var0, var12);
        ArrayList<Holder> var4 = new ArrayList<Holder>();
        var0.registryAccess().lookupOrThrow(Registries.PAINTING_VARIANT).getTagOrEmpty(PaintingVariantTags.PLACEABLE).forEach(var4::add);
        if (var4.isEmpty()) {
            return Optional.empty();
        }
        var3.setDirection(var2);
        var4.removeIf(var1 -> {
            var3.setVariant((Holder<PaintingVariant>)var1);
            return !var3.survives();
        });
        if (var4.isEmpty()) {
            return Optional.empty();
        }
        int var5 = var4.stream().mapToInt(EntityPainting::variantArea).max().orElse(0);
        var4.removeIf(var1 -> EntityPainting.variantArea(var1) < var5);
        Optional var6 = SystemUtils.getRandomSafe(var4, var3.random);
        if (var6.isEmpty()) {
            return Optional.empty();
        }
        var3.setVariant((Holder)var6.get());
        var3.setDirection(var2);
        return Optional.of(var3);
    }

    private static int variantArea(Holder<PaintingVariant> var0) {
        return var0.value().area();
    }

    private EntityPainting(World var0, BlockPosition var1) {
        super((EntityTypes<? extends EntityHanging>)EntityTypes.PAINTING, var0, var1);
    }

    public EntityPainting(World var0, BlockPosition var1, EnumDirection var2, Holder<PaintingVariant> var3) {
        this(var0, var1);
        this.setVariant(var3);
        this.setDirection(var2);
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        var0.store("facing", EnumDirection.LEGACY_ID_CODEC_2D, this.direction);
        super.addAdditionalSaveData(var0);
        VariantUtils.writeVariant(var0, this.getVariant());
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        this.direction = var0.read("facing", EnumDirection.LEGACY_ID_CODEC_2D).orElse(EnumDirection.SOUTH);
        super.readAdditionalSaveData(var0);
        this.setDirection(this.direction);
        VariantUtils.readVariant(var0, this.registryAccess(), Registries.PAINTING_VARIANT).ifPresent(this::setVariant);
    }

    @Override
    protected AxisAlignedBB calculateBoundingBox(BlockPosition var0, EnumDirection var1) {
        float var2 = 0.46875f;
        Vec3D var3 = Vec3D.atCenterOf(var0).relative(var1, -0.46875);
        PaintingVariant var4 = this.getVariant().value();
        double var5 = this.offsetForPaintingSize(var4.width());
        double var7 = this.offsetForPaintingSize(var4.height());
        EnumDirection var9 = var1.getCounterClockWise();
        Vec3D var10 = var3.relative(var9, var5).relative(EnumDirection.UP, var7);
        EnumDirection.EnumAxis var11 = var1.getAxis();
        double var12 = var11 == EnumDirection.EnumAxis.X ? 0.0625 : (double)var4.width();
        double var14 = var4.height();
        double var16 = var11 == EnumDirection.EnumAxis.Z ? 0.0625 : (double)var4.width();
        return AxisAlignedBB.ofSize(var10, var12, var14, var16);
    }

    private double offsetForPaintingSize(int var0) {
        return var0 % 2 == 0 ? 0.5 : 0.0;
    }

    @Override
    public void dropItem(WorldServer var0, @Nullable Entity var1) {
        EntityHuman var2;
        if (!var0.getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
            return;
        }
        this.playSound(SoundEffects.PAINTING_BREAK, 1.0f, 1.0f);
        if (var1 instanceof EntityHuman && (var2 = (EntityHuman)var1).hasInfiniteMaterials()) {
            return;
        }
        this.spawnAtLocation(var0, Items.PAINTING);
    }

    @Override
    public void playPlacementSound() {
        this.playSound(SoundEffects.PAINTING_PLACE, 1.0f, 1.0f);
    }

    @Override
    public void snapTo(double var0, double var2, double var4, float var6, float var7) {
        this.setPos(var0, var2, var4);
    }

    @Override
    public Vec3D trackingPosition() {
        return Vec3D.atLowerCornerOf(this.pos);
    }

    @Override
    public Packet<PacketListenerPlayOut> getAddEntityPacket(EntityTrackerEntry var0) {
        return new PacketPlayOutSpawnEntity((Entity)this, this.direction.get3DDataValue(), this.getPos());
    }

    @Override
    public void recreateFromPacket(PacketPlayOutSpawnEntity var0) {
        super.recreateFromPacket(var0);
        this.setDirection(EnumDirection.from3DDataValue(var0.getData()));
    }

    @Override
    public ItemStack getPickResult() {
        return new ItemStack(Items.PAINTING);
    }
}

