/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.wolf;

import java.util.Optional;
import net.minecraft.core.ClientAsset;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.animal.wolf.WolfVariant;
import net.minecraft.world.entity.variant.BiomeCheck;
import net.minecraft.world.entity.variant.PriorityProvider;
import net.minecraft.world.entity.variant.SpawnContext;
import net.minecraft.world.entity.variant.SpawnPrioritySelectors;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.Biomes;

public class WolfVariants {
    public static final ResourceKey<WolfVariant> PALE = WolfVariants.createKey("pale");
    public static final ResourceKey<WolfVariant> SPOTTED = WolfVariants.createKey("spotted");
    public static final ResourceKey<WolfVariant> SNOWY = WolfVariants.createKey("snowy");
    public static final ResourceKey<WolfVariant> BLACK = WolfVariants.createKey("black");
    public static final ResourceKey<WolfVariant> ASHEN = WolfVariants.createKey("ashen");
    public static final ResourceKey<WolfVariant> RUSTY = WolfVariants.createKey("rusty");
    public static final ResourceKey<WolfVariant> WOODS = WolfVariants.createKey("woods");
    public static final ResourceKey<WolfVariant> CHESTNUT = WolfVariants.createKey("chestnut");
    public static final ResourceKey<WolfVariant> STRIPED = WolfVariants.createKey("striped");
    public static final ResourceKey<WolfVariant> DEFAULT = PALE;

    private static ResourceKey<WolfVariant> createKey(String var0) {
        return ResourceKey.create(Registries.WOLF_VARIANT, MinecraftKey.withDefaultNamespace(var0));
    }

    private static void register(BootstrapContext<WolfVariant> var0, ResourceKey<WolfVariant> var1, String var2, ResourceKey<BiomeBase> var3) {
        WolfVariants.register(var0, var1, var2, WolfVariants.highPrioBiome(HolderSet.direct(var0.lookup(Registries.BIOME).getOrThrow(var3))));
    }

    private static void register(BootstrapContext<WolfVariant> var0, ResourceKey<WolfVariant> var1, String var2, TagKey<BiomeBase> var3) {
        WolfVariants.register(var0, var1, var2, WolfVariants.highPrioBiome(var0.lookup(Registries.BIOME).getOrThrow(var3)));
    }

    private static SpawnPrioritySelectors highPrioBiome(HolderSet<BiomeBase> var0) {
        return SpawnPrioritySelectors.single(new BiomeCheck(var0), 1);
    }

    private static void register(BootstrapContext<WolfVariant> var0, ResourceKey<WolfVariant> var1, String var2, SpawnPrioritySelectors var3) {
        MinecraftKey var4 = MinecraftKey.withDefaultNamespace("entity/wolf/" + var2);
        MinecraftKey var5 = MinecraftKey.withDefaultNamespace("entity/wolf/" + var2 + "_tame");
        MinecraftKey var6 = MinecraftKey.withDefaultNamespace("entity/wolf/" + var2 + "_angry");
        var0.register(var1, new WolfVariant(new WolfVariant.a(new ClientAsset(var4), new ClientAsset(var5), new ClientAsset(var6)), var3));
    }

    public static Optional<? extends Holder<WolfVariant>> selectVariantToSpawn(RandomSource var0, IRegistryCustom var1, SpawnContext var2) {
        return PriorityProvider.pick(var1.lookupOrThrow(Registries.WOLF_VARIANT).listElements(), Holder::value, var0, var2);
    }

    public static void bootstrap(BootstrapContext<WolfVariant> var0) {
        WolfVariants.register(var0, PALE, "wolf", SpawnPrioritySelectors.fallback(0));
        WolfVariants.register(var0, SPOTTED, "wolf_spotted", BiomeTags.IS_SAVANNA);
        WolfVariants.register(var0, SNOWY, "wolf_snowy", Biomes.GROVE);
        WolfVariants.register(var0, BLACK, "wolf_black", Biomes.OLD_GROWTH_PINE_TAIGA);
        WolfVariants.register(var0, ASHEN, "wolf_ashen", Biomes.SNOWY_TAIGA);
        WolfVariants.register(var0, RUSTY, "wolf_rusty", BiomeTags.IS_JUNGLE);
        WolfVariants.register(var0, WOODS, "wolf_woods", Biomes.FOREST);
        WolfVariants.register(var0, CHESTNUT, "wolf_chestnut", Biomes.OLD_GROWTH_SPRUCE_TAIGA);
        WolfVariants.register(var0, STRIPED, "wolf_striped", BiomeTags.IS_BADLANDS);
    }
}

