/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.horse;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalTarget;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.horse.EntityLlama;
import net.minecraft.world.entity.monster.EntityIllagerAbstract;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.entity.npc.EntityVillagerTrader;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;

public class EntityLlamaTrader
extends EntityLlama {
    private static final int DEFAULT_DESPAWN_DELAY = 47999;
    private int despawnDelay = 47999;

    public EntityLlamaTrader(EntityTypes<? extends EntityLlamaTrader> var0, World var1) {
        super((EntityTypes<? extends EntityLlama>)var0, var1);
    }

    @Override
    public boolean isTraderLlama() {
        return true;
    }

    @Override
    @Nullable
    protected EntityLlama makeNewLlama() {
        return EntityTypes.TRADER_LLAMA.create(this.level(), EntitySpawnReason.BREEDING);
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        var0.putInt("DespawnDelay", this.despawnDelay);
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        super.readAdditionalSaveData(var0);
        this.despawnDelay = var0.getIntOr("DespawnDelay", 47999);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, new PathfinderGoalPanic(this, 2.0));
        this.targetSelector.addGoal(1, new a(this));
        this.targetSelector.addGoal(2, new PathfinderGoalNearestAttackableTarget<EntityZombie>((EntityInsentient)this, EntityZombie.class, true, (var0, var1) -> var0.getType() != EntityTypes.ZOMBIFIED_PIGLIN));
        this.targetSelector.addGoal(2, new PathfinderGoalNearestAttackableTarget<EntityIllagerAbstract>((EntityInsentient)this, EntityIllagerAbstract.class, true));
    }

    public void setDespawnDelay(int var0) {
        this.despawnDelay = var0;
    }

    @Override
    protected void doPlayerRide(EntityHuman var0) {
        Entity var1 = this.getLeashHolder();
        if (var1 instanceof EntityVillagerTrader) {
            return;
        }
        super.doPlayerRide(var0);
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide) {
            this.maybeDespawn();
        }
    }

    private void maybeDespawn() {
        if (!this.canDespawn()) {
            return;
        }
        int n2 = this.despawnDelay = this.isLeashedToWanderingTrader() ? ((EntityVillagerTrader)this.getLeashHolder()).getDespawnDelay() - 1 : this.despawnDelay - 1;
        if (this.despawnDelay <= 0) {
            this.removeLeash();
            this.discard();
        }
    }

    private boolean canDespawn() {
        return !this.isTamed() && !this.isLeashedToSomethingOtherThanTheWanderingTrader() && !this.hasExactlyOnePlayerPassenger();
    }

    private boolean isLeashedToWanderingTrader() {
        return this.getLeashHolder() instanceof EntityVillagerTrader;
    }

    private boolean isLeashedToSomethingOtherThanTheWanderingTrader() {
        return this.isLeashed() && !this.isLeashedToWanderingTrader();
    }

    @Override
    @Nullable
    public GroupDataEntity finalizeSpawn(WorldAccess var0, DifficultyDamageScaler var1, EntitySpawnReason var2, @Nullable GroupDataEntity var3) {
        if (var2 == EntitySpawnReason.EVENT) {
            this.setAge(0);
        }
        if (var3 == null) {
            var3 = new EntityAgeable.a(false);
        }
        return super.finalizeSpawn(var0, var1, var2, var3);
    }

    protected static class a
    extends PathfinderGoalTarget {
        private final EntityLlama llama;
        private EntityLiving ownerLastHurtBy;
        private int timestamp;

        public a(EntityLlama var0) {
            super(var0, false);
            this.llama = var0;
            this.setFlags(EnumSet.of(PathfinderGoal.Type.TARGET));
        }

        @Override
        public boolean canUse() {
            if (!this.llama.isLeashed()) {
                return false;
            }
            Entity var0 = this.llama.getLeashHolder();
            if (!(var0 instanceof EntityVillagerTrader)) {
                return false;
            }
            EntityVillagerTrader var1 = (EntityVillagerTrader)var0;
            this.ownerLastHurtBy = var1.getLastHurtByMob();
            int var2 = var1.getLastHurtByMobTimestamp();
            return var2 != this.timestamp && this.canAttack(this.ownerLastHurtBy, PathfinderTargetCondition.DEFAULT);
        }

        @Override
        public void start() {
            this.mob.setTarget(this.ownerLastHurtBy);
            Entity var0 = this.llama.getLeashHolder();
            if (var0 instanceof EntityVillagerTrader) {
                this.timestamp = ((EntityVillagerTrader)var0).getLastHurtByMobTimestamp();
            }
            super.start();
        }
    }
}

