/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.frog;

import java.util.Optional;
import net.minecraft.core.ClientAsset;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.animal.TemperatureVariants;
import net.minecraft.world.entity.animal.frog.FrogVariant;
import net.minecraft.world.entity.variant.BiomeCheck;
import net.minecraft.world.entity.variant.PriorityProvider;
import net.minecraft.world.entity.variant.SpawnContext;
import net.minecraft.world.entity.variant.SpawnPrioritySelectors;
import net.minecraft.world.level.biome.BiomeBase;

public interface FrogVariants {
    public static final ResourceKey<FrogVariant> TEMPERATE = FrogVariants.createKey(TemperatureVariants.TEMPERATE);
    public static final ResourceKey<FrogVariant> WARM = FrogVariants.createKey(TemperatureVariants.WARM);
    public static final ResourceKey<FrogVariant> COLD = FrogVariants.createKey(TemperatureVariants.COLD);

    private static ResourceKey<FrogVariant> createKey(MinecraftKey var0) {
        return ResourceKey.create(Registries.FROG_VARIANT, var0);
    }

    public static void bootstrap(BootstrapContext<FrogVariant> var0) {
        FrogVariants.register(var0, TEMPERATE, "entity/frog/temperate_frog", SpawnPrioritySelectors.fallback(0));
        FrogVariants.register(var0, WARM, "entity/frog/warm_frog", BiomeTags.SPAWNS_WARM_VARIANT_FROGS);
        FrogVariants.register(var0, COLD, "entity/frog/cold_frog", BiomeTags.SPAWNS_COLD_VARIANT_FROGS);
    }

    private static void register(BootstrapContext<FrogVariant> var0, ResourceKey<FrogVariant> var1, String var2, TagKey<BiomeBase> var3) {
        HolderSet.Named<BiomeBase> var4 = var0.lookup(Registries.BIOME).getOrThrow(var3);
        FrogVariants.register(var0, var1, var2, SpawnPrioritySelectors.single(new BiomeCheck(var4), 1));
    }

    private static void register(BootstrapContext<FrogVariant> var0, ResourceKey<FrogVariant> var1, String var2, SpawnPrioritySelectors var3) {
        var0.register(var1, new FrogVariant(new ClientAsset(MinecraftKey.withDefaultNamespace(var2)), var3));
    }

    public static Optional<Holder.c<FrogVariant>> selectVariantToSpawn(RandomSource var0, IRegistryCustom var1, SpawnContext var2) {
        return PriorityProvider.pick(var1.lookupOrThrow(Registries.FROG_VARIANT).listElements(), Holder::value, var0, var2);
    }
}

