/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsEntity;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityFish;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;

public class EntityPufferFish
extends EntityFish {
    private static final DataWatcherObject<Integer> PUFF_STATE = DataWatcher.defineId(EntityPufferFish.class, DataWatcherRegistry.INT);
    int inflateCounter;
    int deflateTimer;
    private static final PathfinderTargetCondition.a SCARY_MOB = (var0, var1) -> {
        EntityHuman var2;
        if (var0 instanceof EntityHuman && (var2 = (EntityHuman)var0).isCreative()) {
            return false;
        }
        return !var0.getType().is(TagsEntity.NOT_SCARY_FOR_PUFFERFISH);
    };
    static final PathfinderTargetCondition TARGETING_CONDITIONS = PathfinderTargetCondition.forNonCombat().ignoreInvisibilityTesting().ignoreLineOfSight().selector(SCARY_MOB);
    public static final int STATE_SMALL = 0;
    public static final int STATE_MID = 1;
    public static final int STATE_FULL = 2;
    private static final int DEFAULT_PUFF_STATE = 0;

    public EntityPufferFish(EntityTypes<? extends EntityPufferFish> var0, World var1) {
        super((EntityTypes<? extends EntityFish>)var0, var1);
        this.refreshDimensions();
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        var0.define(PUFF_STATE, 0);
    }

    public int getPuffState() {
        return this.entityData.get(PUFF_STATE);
    }

    public void setPuffState(int var0) {
        this.entityData.set(PUFF_STATE, var0);
    }

    @Override
    public void onSyncedDataUpdated(DataWatcherObject<?> var0) {
        if (PUFF_STATE.equals(var0)) {
            this.refreshDimensions();
        }
        super.onSyncedDataUpdated(var0);
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        var0.putInt("PuffState", this.getPuffState());
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        super.readAdditionalSaveData(var0);
        this.setPuffState(Math.min(var0.getIntOr("PuffState", 0), 2));
    }

    @Override
    public ItemStack getBucketItemStack() {
        return new ItemStack(Items.PUFFERFISH_BUCKET);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, new a(this));
    }

    @Override
    public void tick() {
        if (!this.level().isClientSide && this.isAlive() && this.isEffectiveAi()) {
            if (this.inflateCounter > 0) {
                if (this.getPuffState() == 0) {
                    this.makeSound(SoundEffects.PUFFER_FISH_BLOW_UP);
                    this.setPuffState(1);
                } else if (this.inflateCounter > 40 && this.getPuffState() == 1) {
                    this.makeSound(SoundEffects.PUFFER_FISH_BLOW_UP);
                    this.setPuffState(2);
                }
                ++this.inflateCounter;
            } else if (this.getPuffState() != 0) {
                if (this.deflateTimer > 60 && this.getPuffState() == 2) {
                    this.makeSound(SoundEffects.PUFFER_FISH_BLOW_OUT);
                    this.setPuffState(1);
                } else if (this.deflateTimer > 100 && this.getPuffState() == 1) {
                    this.makeSound(SoundEffects.PUFFER_FISH_BLOW_OUT);
                    this.setPuffState(0);
                }
                ++this.deflateTimer;
            }
        }
        super.tick();
    }

    @Override
    public void aiStep() {
        super.aiStep();
        World world = this.level();
        if (world instanceof WorldServer) {
            WorldServer var0 = (WorldServer)world;
            if (this.isAlive() && this.getPuffState() > 0) {
                List<EntityInsentient> var12 = this.level().getEntitiesOfClass(EntityInsentient.class, this.getBoundingBox().inflate(0.3), var1 -> TARGETING_CONDITIONS.test(var0, this, (EntityLiving)var1));
                for (EntityInsentient var3 : var12) {
                    if (!var3.isAlive()) continue;
                    this.touch(var0, var3);
                }
            }
        }
    }

    private void touch(WorldServer var0, EntityInsentient var1) {
        int var2 = this.getPuffState();
        if (var1.hurtServer(var0, this.damageSources().mobAttack(this), 1 + var2)) {
            var1.addEffect(new MobEffect(MobEffects.POISON, 60 * var2, 0), this);
            this.playSound(SoundEffects.PUFFER_FISH_STING, 1.0f, 1.0f);
        }
    }

    @Override
    public void playerTouch(EntityHuman var0) {
        int var1 = this.getPuffState();
        if (var0 instanceof EntityPlayer) {
            EntityPlayer var2 = (EntityPlayer)var0;
            if (var1 > 0 && var0.hurtServer(var2.serverLevel(), this.damageSources().mobAttack(this), 1 + var1)) {
                if (!this.isSilent()) {
                    var2.connection.send(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.PUFFER_FISH_STING, 0.0f));
                }
                var0.addEffect(new MobEffect(MobEffects.POISON, 60 * var1, 0), this);
            }
        }
    }

    @Override
    protected SoundEffect getAmbientSound() {
        return SoundEffects.PUFFER_FISH_AMBIENT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.PUFFER_FISH_DEATH;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.PUFFER_FISH_HURT;
    }

    @Override
    protected SoundEffect getFlopSound() {
        return SoundEffects.PUFFER_FISH_FLOP;
    }

    @Override
    public EntitySize getDefaultDimensions(EntityPose var0) {
        return super.getDefaultDimensions(var0).scale(EntityPufferFish.getScale(this.getPuffState()));
    }

    private static float getScale(int var0) {
        switch (var0) {
            case 1: {
                return 0.7f;
            }
            case 0: {
                return 0.5f;
            }
        }
        return 1.0f;
    }

    static class a
    extends PathfinderGoal {
        private final EntityPufferFish fish;

        public a(EntityPufferFish var0) {
            this.fish = var0;
        }

        @Override
        public boolean canUse() {
            List<EntityLiving> var02 = this.fish.level().getEntitiesOfClass(EntityLiving.class, this.fish.getBoundingBox().inflate(2.0), var0 -> TARGETING_CONDITIONS.test(a.getServerLevel(this.fish), this.fish, (EntityLiving)var0));
            return !var02.isEmpty();
        }

        @Override
        public void start() {
            this.fish.inflateCounter = 1;
            this.fish.deflateTimer = 0;
        }

        @Override
        public void stop() {
            this.fish.inflateCounter = 0;
        }
    }
}

