/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.animal.AbstractCow;
import net.minecraft.world.entity.animal.CowVariant;
import net.minecraft.world.entity.animal.CowVariants;
import net.minecraft.world.entity.variant.SpawnContext;
import net.minecraft.world.entity.variant.VariantUtils;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;

public class EntityCow
extends AbstractCow {
    private static final DataWatcherObject<Holder<CowVariant>> DATA_VARIANT_ID = DataWatcher.defineId(EntityCow.class, DataWatcherRegistry.COW_VARIANT);

    public EntityCow(EntityTypes<? extends EntityCow> var0, World var1) {
        super((EntityTypes<? extends AbstractCow>)var0, var1);
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        var0.define(DATA_VARIANT_ID, VariantUtils.getDefaultOrAny(this.registryAccess(), CowVariants.TEMPERATE));
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        VariantUtils.writeVariant(var0, this.getVariant());
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        super.readAdditionalSaveData(var0);
        VariantUtils.readVariant(var0, this.registryAccess(), Registries.COW_VARIANT).ifPresent(this::setVariant);
    }

    @Override
    @Nullable
    public EntityCow getBreedOffspring(WorldServer var0, EntityAgeable var1) {
        EntityCow var2 = EntityTypes.COW.create(var0, EntitySpawnReason.BREEDING);
        if (var2 != null && var1 instanceof EntityCow) {
            EntityCow var3 = (EntityCow)var1;
            var2.setVariant(this.random.nextBoolean() ? this.getVariant() : var3.getVariant());
        }
        return var2;
    }

    @Override
    public GroupDataEntity finalizeSpawn(WorldAccess var0, DifficultyDamageScaler var1, EntitySpawnReason var2, @Nullable GroupDataEntity var3) {
        CowVariants.selectVariantToSpawn(this.random, this.registryAccess(), SpawnContext.create(var0, this.blockPosition())).ifPresent(this::setVariant);
        return super.finalizeSpawn(var0, var1, var2, var3);
    }

    public void setVariant(Holder<CowVariant> var0) {
        this.entityData.set(DATA_VARIANT_ID, var0);
    }

    public Holder<CowVariant> getVariant() {
        return this.entityData.get(DATA_VARIANT_ID);
    }

    @Override
    @Nullable
    public <T> T get(DataComponentType<? extends T> var0) {
        if (var0 == DataComponents.COW_VARIANT) {
            return EntityCow.castComponentValue(var0, this.getVariant());
        }
        return super.get(var0);
    }

    @Override
    protected void applyImplicitComponents(DataComponentGetter var0) {
        this.applyImplicitComponentIfPresent(var0, DataComponents.COW_VARIANT);
        super.applyImplicitComponents(var0);
    }

    @Override
    protected <T> boolean applyImplicitComponent(DataComponentType<T> var0, T var1) {
        if (var0 == DataComponents.COW_VARIANT) {
            this.setVariant(EntityCow.castComponentValue(DataComponents.COW_VARIANT, var1));
            return true;
        }
        return super.applyImplicitComponent(var0, var1);
    }

    @Override
    @Nullable
    public /* synthetic */ EntityAgeable getBreedOffspring(WorldServer worldServer, EntityAgeable entityAgeable) {
        return this.getBreedOffspring(worldServer, entityAgeable);
    }
}

