/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.navigation;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.SectionPosition;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.Pathfinder;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.phys.Vec3D;

public class Navigation
extends NavigationAbstract {
    private boolean avoidSun;

    public Navigation(EntityInsentient var0, World var1) {
        super(var0, var1);
    }

    @Override
    protected Pathfinder createPathFinder(int var0) {
        this.nodeEvaluator = new PathfinderNormal();
        return new Pathfinder(this.nodeEvaluator, var0);
    }

    @Override
    protected boolean canUpdatePath() {
        return this.mob.onGround() || this.mob.isInLiquid() || this.mob.isPassenger();
    }

    @Override
    protected Vec3D getTempMobPos() {
        return new Vec3D(this.mob.getX(), this.getSurfaceY(), this.mob.getZ());
    }

    @Override
    public PathEntity createPath(BlockPosition var0, int var1) {
        BlockPosition.MutableBlockPosition var3;
        Chunk var2 = this.level.getChunkSource().getChunkNow(SectionPosition.blockToSectionCoord(var0.getX()), SectionPosition.blockToSectionCoord(var0.getZ()));
        if (var2 == null) {
            return null;
        }
        if (var2.getBlockState(var0).isAir()) {
            var3 = var0.mutable().move(EnumDirection.DOWN);
            while (var3.getY() > this.level.getMinY() && var2.getBlockState(var3).isAir()) {
                var3.move(EnumDirection.DOWN);
            }
            if (var3.getY() > this.level.getMinY()) {
                return super.createPath((BlockPosition)var3.above(), var1);
            }
            var3.setY(var0.getY() + 1);
            while (var3.getY() <= this.level.getMaxY() && var2.getBlockState(var3).isAir()) {
                var3.move(EnumDirection.UP);
            }
            var0 = var3;
        }
        if (var2.getBlockState(var0).isSolid()) {
            var3 = var0.mutable().move(EnumDirection.UP);
            while (var3.getY() <= this.level.getMaxY() && var2.getBlockState(var3).isSolid()) {
                var3.move(EnumDirection.UP);
            }
            return super.createPath(var3.immutable(), var1);
        }
        return super.createPath(var0, var1);
    }

    @Override
    public PathEntity createPath(Entity var0, int var1) {
        return this.createPath(var0.blockPosition(), var1);
    }

    private int getSurfaceY() {
        if (!this.mob.isInWater() || !this.canFloat()) {
            return MathHelper.floor(this.mob.getY() + 0.5);
        }
        int var0 = this.mob.getBlockY();
        IBlockData var1 = this.level.getBlockState(BlockPosition.containing(this.mob.getX(), var0, this.mob.getZ()));
        int var2 = 0;
        while (var1.is(Blocks.WATER)) {
            var1 = this.level.getBlockState(BlockPosition.containing(this.mob.getX(), ++var0, this.mob.getZ()));
            if (++var2 <= 16) continue;
            return this.mob.getBlockY();
        }
        return var0;
    }

    @Override
    protected void trimPath() {
        super.trimPath();
        if (this.avoidSun) {
            if (this.level.canSeeSky(BlockPosition.containing(this.mob.getX(), this.mob.getY() + 0.5, this.mob.getZ()))) {
                return;
            }
            for (int var0 = 0; var0 < this.path.getNodeCount(); ++var0) {
                PathPoint var1 = this.path.getNode(var0);
                if (!this.level.canSeeSky(new BlockPosition(var1.x, var1.y, var1.z))) continue;
                this.path.truncateNodes(var0);
                return;
            }
        }
    }

    protected boolean hasValidPathType(PathType var0) {
        if (var0 == PathType.WATER) {
            return false;
        }
        if (var0 == PathType.LAVA) {
            return false;
        }
        return var0 != PathType.OPEN;
    }

    public void setCanOpenDoors(boolean var0) {
        this.nodeEvaluator.setCanOpenDoors(var0);
    }

    public void setAvoidSun(boolean var0) {
        this.avoidSun = var0;
    }

    public void setCanWalkOverFences(boolean var0) {
        this.nodeEvaluator.setCanWalkOverFences(var0);
    }
}

