/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.navigation;

import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.level.World;
import net.minecraft.world.level.pathfinder.AmphibiousNodeEvaluator;
import net.minecraft.world.level.pathfinder.Pathfinder;
import net.minecraft.world.phys.Vec3D;

public class AmphibiousPathNavigation
extends NavigationAbstract {
    public AmphibiousPathNavigation(EntityInsentient var0, World var1) {
        super(var0, var1);
    }

    @Override
    protected Pathfinder createPathFinder(int var0) {
        this.nodeEvaluator = new AmphibiousNodeEvaluator(false);
        return new Pathfinder(this.nodeEvaluator, var0);
    }

    @Override
    protected boolean canUpdatePath() {
        return true;
    }

    @Override
    protected Vec3D getTempMobPos() {
        return new Vec3D(this.mob.getX(), this.mob.getY(0.5), this.mob.getZ());
    }

    @Override
    protected double getGroundY(Vec3D var0) {
        return var0.y;
    }

    @Override
    protected boolean canMoveDirectly(Vec3D var0, Vec3D var1) {
        if (this.mob.isInLiquid()) {
            return AmphibiousPathNavigation.isClearForMovementBetween(this.mob, var0, var1, false);
        }
        return false;
    }

    @Override
    public boolean isStableDestination(BlockPosition var0) {
        return !this.level.getBlockState(var0.below()).isAir();
    }

    @Override
    public void setCanFloat(boolean var0) {
    }
}

