/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.entity.ai.behavior.BehaviorBedJump;
import net.minecraft.world.entity.ai.behavior.BehaviorBell;
import net.minecraft.world.entity.ai.behavior.BehaviorBellAlert;
import net.minecraft.world.entity.ai.behavior.BehaviorBellRing;
import net.minecraft.world.entity.ai.behavior.BehaviorBetterJob;
import net.minecraft.world.entity.ai.behavior.BehaviorBonemeal;
import net.minecraft.world.entity.ai.behavior.BehaviorCareer;
import net.minecraft.world.entity.ai.behavior.BehaviorCelebrate;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.BehaviorCooldown;
import net.minecraft.world.entity.ai.behavior.BehaviorFarm;
import net.minecraft.world.entity.ai.behavior.BehaviorFindAdmirableItem;
import net.minecraft.world.entity.ai.behavior.BehaviorFindPosition;
import net.minecraft.world.entity.ai.behavior.BehaviorGate;
import net.minecraft.world.entity.ai.behavior.BehaviorGateSingle;
import net.minecraft.world.entity.ai.behavior.BehaviorHide;
import net.minecraft.world.entity.ai.behavior.BehaviorHome;
import net.minecraft.world.entity.ai.behavior.BehaviorInteract;
import net.minecraft.world.entity.ai.behavior.BehaviorInteractDoor;
import net.minecraft.world.entity.ai.behavior.BehaviorInteractPlayer;
import net.minecraft.world.entity.ai.behavior.BehaviorLeaveJob;
import net.minecraft.world.entity.ai.behavior.BehaviorLook;
import net.minecraft.world.entity.ai.behavior.BehaviorLookInteract;
import net.minecraft.world.entity.ai.behavior.BehaviorLookTarget;
import net.minecraft.world.entity.ai.behavior.BehaviorLookWalk;
import net.minecraft.world.entity.ai.behavior.BehaviorMakeLove;
import net.minecraft.world.entity.ai.behavior.BehaviorNearestVillage;
import net.minecraft.world.entity.ai.behavior.BehaviorNop;
import net.minecraft.world.entity.ai.behavior.BehaviorOutside;
import net.minecraft.world.entity.ai.behavior.BehaviorPanic;
import net.minecraft.world.entity.ai.behavior.BehaviorPlay;
import net.minecraft.world.entity.ai.behavior.BehaviorPositionValidate;
import net.minecraft.world.entity.ai.behavior.BehaviorPotentialJobSite;
import net.minecraft.world.entity.ai.behavior.BehaviorProfession;
import net.minecraft.world.entity.ai.behavior.BehaviorRaid;
import net.minecraft.world.entity.ai.behavior.BehaviorRaidReset;
import net.minecraft.world.entity.ai.behavior.BehaviorSchedule;
import net.minecraft.world.entity.ai.behavior.BehaviorSleep;
import net.minecraft.world.entity.ai.behavior.BehaviorStrollInside;
import net.minecraft.world.entity.ai.behavior.BehaviorStrollPlace;
import net.minecraft.world.entity.ai.behavior.BehaviorStrollPlaceList;
import net.minecraft.world.entity.ai.behavior.BehaviorStrollPosition;
import net.minecraft.world.entity.ai.behavior.BehaviorStrollRandom;
import net.minecraft.world.entity.ai.behavior.BehaviorSwim;
import net.minecraft.world.entity.ai.behavior.BehaviorTradePlayer;
import net.minecraft.world.entity.ai.behavior.BehaviorTradeVillager;
import net.minecraft.world.entity.ai.behavior.BehaviorVillageHeroGift;
import net.minecraft.world.entity.ai.behavior.BehaviorWake;
import net.minecraft.world.entity.ai.behavior.BehaviorWalkAway;
import net.minecraft.world.entity.ai.behavior.BehaviorWalkAwayBlock;
import net.minecraft.world.entity.ai.behavior.BehaviorWalkHome;
import net.minecraft.world.entity.ai.behavior.BehaviorWork;
import net.minecraft.world.entity.ai.behavior.BehaviorWorkComposter;
import net.minecraft.world.entity.ai.behavior.BehavorMove;
import net.minecraft.world.entity.ai.behavior.TriggerGate;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.state.IBlockData;

public class Behaviors {
    private static final float STROLL_SPEED_MODIFIER = 0.4f;
    public static final int INTERACT_DIST_SQR = 5;
    public static final int INTERACT_WALKUP_DIST = 2;
    public static final float INTERACT_SPEED_MODIFIER = 0.5f;

    public static ImmutableList<Pair<Integer, ? extends BehaviorControl<? super EntityVillager>>> getCorePackage(Holder<VillagerProfession> var02, float var12) {
        return ImmutableList.of((Object)Pair.of((Object)0, new BehaviorSwim(0.8f)), (Object)Pair.of((Object)0, BehaviorInteractDoor.create()), (Object)Pair.of((Object)0, (Object)new BehaviorLook(45, 90)), (Object)Pair.of((Object)0, (Object)new BehaviorPanic()), (Object)Pair.of((Object)0, BehaviorWake.create()), (Object)Pair.of((Object)0, BehaviorBellAlert.create()), (Object)Pair.of((Object)0, BehaviorRaid.create()), (Object)Pair.of((Object)0, BehaviorPositionValidate.create(var02.value().heldJobSite(), MemoryModuleType.JOB_SITE)), (Object)Pair.of((Object)0, BehaviorPositionValidate.create(var02.value().acquirableJobSite(), MemoryModuleType.POTENTIAL_JOB_SITE)), (Object)Pair.of((Object)1, (Object)new BehavorMove()), (Object)Pair.of((Object)2, BehaviorBetterJob.create()), (Object)Pair.of((Object)3, (Object)new BehaviorInteractPlayer(var12)), (Object[])new Pair[]{Pair.of((Object)5, BehaviorFindAdmirableItem.create(var12, false, 4)), Pair.of((Object)6, BehaviorFindPosition.create(var02.value().acquirableJobSite(), MemoryModuleType.JOB_SITE, MemoryModuleType.POTENTIAL_JOB_SITE, true, Optional.empty(), (var0, var1) -> true)), Pair.of((Object)7, (Object)new BehaviorPotentialJobSite(var12)), Pair.of((Object)8, BehaviorLeaveJob.create(var12)), Pair.of((Object)10, BehaviorFindPosition.create(var0 -> var0.is(PoiTypes.HOME), MemoryModuleType.HOME, false, Optional.of((byte)14), Behaviors::validateBedPoi)), Pair.of((Object)10, BehaviorFindPosition.create(var0 -> var0.is(PoiTypes.MEETING), MemoryModuleType.MEETING_POINT, true, Optional.of((byte)14))), Pair.of((Object)10, BehaviorCareer.create()), Pair.of((Object)10, BehaviorProfession.create())});
    }

    private static boolean validateBedPoi(WorldServer var0, BlockPosition var1) {
        IBlockData var2 = var0.getBlockState(var1);
        return var2.is(TagsBlock.BEDS) && var2.getValue(BlockBed.OCCUPIED) == false;
    }

    public static ImmutableList<Pair<Integer, ? extends BehaviorControl<? super EntityVillager>>> getWorkPackage(Holder<VillagerProfession> var0, float var1) {
        BehaviorWork var2 = var0.is(VillagerProfession.FARMER) ? new BehaviorWorkComposter() : new BehaviorWork();
        return ImmutableList.of(Behaviors.getMinimalLookBehavior(), (Object)Pair.of((Object)5, new BehaviorGateSingle(ImmutableList.of((Object)Pair.of((Object)var2, (Object)7), (Object)Pair.of(BehaviorStrollPosition.create(MemoryModuleType.JOB_SITE, 0.4f, 4), (Object)2), (Object)Pair.of(BehaviorStrollPlace.create(MemoryModuleType.JOB_SITE, 0.4f, 1, 10), (Object)5), (Object)Pair.of(BehaviorStrollPlaceList.create(MemoryModuleType.SECONDARY_JOB_SITE, var1, 1, 6, MemoryModuleType.JOB_SITE), (Object)5), (Object)Pair.of((Object)new BehaviorFarm(), (Object)(var0.is(VillagerProfession.FARMER) ? 2 : 5)), (Object)Pair.of((Object)new BehaviorBonemeal(), (Object)(var0.is(VillagerProfession.FARMER) ? 4 : 7))))), (Object)Pair.of((Object)10, (Object)new BehaviorTradePlayer(400, 1600)), (Object)Pair.of((Object)10, BehaviorLookInteract.create(EntityTypes.PLAYER, 4)), (Object)Pair.of((Object)2, BehaviorWalkAwayBlock.create(MemoryModuleType.JOB_SITE, var1, 9, 100, 1200)), (Object)Pair.of((Object)3, (Object)new BehaviorVillageHeroGift(100)), (Object)Pair.of((Object)99, BehaviorSchedule.create()));
    }

    public static ImmutableList<Pair<Integer, ? extends BehaviorControl<? super EntityVillager>>> getPlayPackage(float var0) {
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)new BehavorMove(80, 120)), Behaviors.getFullLookBehavior(), (Object)Pair.of((Object)5, BehaviorPlay.create()), (Object)Pair.of((Object)5, new BehaviorGateSingle((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.VISIBLE_VILLAGER_BABIES, (Object)((Object)MemoryStatus.VALUE_ABSENT)), ImmutableList.of((Object)Pair.of(BehaviorInteract.of(EntityTypes.VILLAGER, 8, MemoryModuleType.INTERACTION_TARGET, var0, 2), (Object)2), (Object)Pair.of(BehaviorInteract.of(EntityTypes.CAT, 8, MemoryModuleType.INTERACTION_TARGET, var0, 2), (Object)1), (Object)Pair.of(BehaviorStrollRandom.create(var0), (Object)1), (Object)Pair.of(BehaviorLookWalk.create(var0, 2), (Object)1), (Object)Pair.of((Object)new BehaviorBedJump(var0), (Object)2), (Object)Pair.of((Object)new BehaviorNop(20, 40), (Object)2)))), (Object)Pair.of((Object)99, BehaviorSchedule.create()));
    }

    public static ImmutableList<Pair<Integer, ? extends BehaviorControl<? super EntityVillager>>> getRestPackage(Holder<VillagerProfession> var02, float var1) {
        return ImmutableList.of((Object)Pair.of((Object)2, BehaviorWalkAwayBlock.create(MemoryModuleType.HOME, var1, 1, 150, 1200)), (Object)Pair.of((Object)3, BehaviorPositionValidate.create(var0 -> var0.is(PoiTypes.HOME), MemoryModuleType.HOME)), (Object)Pair.of((Object)3, (Object)new BehaviorSleep()), (Object)Pair.of((Object)5, new BehaviorGateSingle((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.HOME, (Object)((Object)MemoryStatus.VALUE_ABSENT)), ImmutableList.of((Object)Pair.of(BehaviorWalkHome.create(var1), (Object)1), (Object)Pair.of(BehaviorStrollInside.create(var1), (Object)4), (Object)Pair.of(BehaviorNearestVillage.create(var1, 4), (Object)2), (Object)Pair.of((Object)new BehaviorNop(20, 40), (Object)2)))), Behaviors.getMinimalLookBehavior(), (Object)Pair.of((Object)99, BehaviorSchedule.create()));
    }

    public static ImmutableList<Pair<Integer, ? extends BehaviorControl<? super EntityVillager>>> getMeetPackage(Holder<VillagerProfession> var02, float var1) {
        return ImmutableList.of((Object)Pair.of((Object)2, TriggerGate.triggerOneShuffled(ImmutableList.of((Object)Pair.of(BehaviorStrollPosition.create(MemoryModuleType.MEETING_POINT, 0.4f, 40), (Object)2), (Object)Pair.of(BehaviorBell.create(), (Object)2)))), (Object)Pair.of((Object)10, (Object)new BehaviorTradePlayer(400, 1600)), (Object)Pair.of((Object)10, BehaviorLookInteract.create(EntityTypes.PLAYER, 4)), (Object)Pair.of((Object)2, BehaviorWalkAwayBlock.create(MemoryModuleType.MEETING_POINT, var1, 6, 100, 200)), (Object)Pair.of((Object)3, (Object)new BehaviorVillageHeroGift(100)), (Object)Pair.of((Object)3, BehaviorPositionValidate.create(var0 -> var0.is(PoiTypes.MEETING), MemoryModuleType.MEETING_POINT)), (Object)Pair.of((Object)3, new BehaviorGate((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(), (Set<MemoryModuleType<?>>)ImmutableSet.of(MemoryModuleType.INTERACTION_TARGET), BehaviorGate.Order.ORDERED, BehaviorGate.Execution.RUN_ONE, ImmutableList.of((Object)Pair.of((Object)new BehaviorTradeVillager(), (Object)1)))), Behaviors.getFullLookBehavior(), (Object)Pair.of((Object)99, BehaviorSchedule.create()));
    }

    public static ImmutableList<Pair<Integer, ? extends BehaviorControl<? super EntityVillager>>> getIdlePackage(Holder<VillagerProfession> var0, float var1) {
        return ImmutableList.of((Object)Pair.of((Object)2, new BehaviorGateSingle(ImmutableList.of((Object)Pair.of(BehaviorInteract.of(EntityTypes.VILLAGER, 8, MemoryModuleType.INTERACTION_TARGET, var1, 2), (Object)2), (Object)Pair.of(BehaviorInteract.of(EntityTypes.VILLAGER, 8, EntityAgeable::canBreed, EntityAgeable::canBreed, MemoryModuleType.BREED_TARGET, var1, 2), (Object)1), (Object)Pair.of(BehaviorInteract.of(EntityTypes.CAT, 8, MemoryModuleType.INTERACTION_TARGET, var1, 2), (Object)1), (Object)Pair.of(BehaviorStrollRandom.create(var1), (Object)1), (Object)Pair.of(BehaviorLookWalk.create(var1, 2), (Object)1), (Object)Pair.of((Object)new BehaviorBedJump(var1), (Object)1), (Object)Pair.of((Object)new BehaviorNop(30, 60), (Object)1)))), (Object)Pair.of((Object)3, (Object)new BehaviorVillageHeroGift(100)), (Object)Pair.of((Object)3, BehaviorLookInteract.create(EntityTypes.PLAYER, 4)), (Object)Pair.of((Object)3, (Object)new BehaviorTradePlayer(400, 1600)), (Object)Pair.of((Object)3, new BehaviorGate((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(), (Set<MemoryModuleType<?>>)ImmutableSet.of(MemoryModuleType.INTERACTION_TARGET), BehaviorGate.Order.ORDERED, BehaviorGate.Execution.RUN_ONE, ImmutableList.of((Object)Pair.of((Object)new BehaviorTradeVillager(), (Object)1)))), (Object)Pair.of((Object)3, new BehaviorGate((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(), (Set<MemoryModuleType<?>>)ImmutableSet.of(MemoryModuleType.BREED_TARGET), BehaviorGate.Order.ORDERED, BehaviorGate.Execution.RUN_ONE, ImmutableList.of((Object)Pair.of((Object)new BehaviorMakeLove(), (Object)1)))), Behaviors.getFullLookBehavior(), (Object)Pair.of((Object)99, BehaviorSchedule.create()));
    }

    public static ImmutableList<Pair<Integer, ? extends BehaviorControl<? super EntityVillager>>> getPanicPackage(Holder<VillagerProfession> var0, float var1) {
        float var2 = var1 * 1.5f;
        return ImmutableList.of((Object)Pair.of((Object)0, BehaviorCooldown.create()), (Object)Pair.of((Object)1, BehaviorWalkAway.entity(MemoryModuleType.NEAREST_HOSTILE, var2, 6, false)), (Object)Pair.of((Object)1, BehaviorWalkAway.entity(MemoryModuleType.HURT_BY_ENTITY, var2, 6, false)), (Object)Pair.of((Object)3, BehaviorStrollRandom.create(var2, 2, 2)), Behaviors.getMinimalLookBehavior());
    }

    public static ImmutableList<Pair<Integer, ? extends BehaviorControl<? super EntityVillager>>> getPreRaidPackage(Holder<VillagerProfession> var0, float var1) {
        return ImmutableList.of((Object)Pair.of((Object)0, BehaviorBellRing.create()), (Object)Pair.of((Object)0, TriggerGate.triggerOneShuffled(ImmutableList.of((Object)Pair.of(BehaviorWalkAwayBlock.create(MemoryModuleType.MEETING_POINT, var1 * 1.5f, 2, 150, 200), (Object)6), (Object)Pair.of(BehaviorStrollRandom.create(var1 * 1.5f), (Object)2)))), Behaviors.getMinimalLookBehavior(), (Object)Pair.of((Object)99, BehaviorRaidReset.create()));
    }

    public static ImmutableList<Pair<Integer, ? extends BehaviorControl<? super EntityVillager>>> getRaidPackage(Holder<VillagerProfession> var0, float var1) {
        return ImmutableList.of((Object)Pair.of((Object)0, BehaviorBuilder.sequence(BehaviorBuilder.triggerIf(Behaviors::raidExistsAndNotVictory), TriggerGate.triggerOneShuffled(ImmutableList.of((Object)Pair.of(BehaviorOutside.create(var1), (Object)5), (Object)Pair.of(BehaviorStrollRandom.create(var1 * 1.1f), (Object)2))))), (Object)Pair.of((Object)0, (Object)new BehaviorCelebrate(600, 600)), (Object)Pair.of((Object)2, BehaviorBuilder.sequence(BehaviorBuilder.triggerIf(Behaviors::raidExistsAndActive), BehaviorHome.create(24, var1 * 1.4f, 1))), Behaviors.getMinimalLookBehavior(), (Object)Pair.of((Object)99, BehaviorRaidReset.create()));
    }

    public static ImmutableList<Pair<Integer, ? extends BehaviorControl<? super EntityVillager>>> getHidePackage(Holder<VillagerProfession> var0, float var1) {
        int var2 = 2;
        return ImmutableList.of((Object)Pair.of((Object)0, BehaviorHide.create(15, 3)), (Object)Pair.of((Object)1, BehaviorHome.create(32, var1 * 1.25f, 2)), Behaviors.getMinimalLookBehavior());
    }

    private static Pair<Integer, BehaviorControl<EntityLiving>> getFullLookBehavior() {
        return Pair.of((Object)5, new BehaviorGateSingle(ImmutableList.of((Object)Pair.of(BehaviorLookTarget.create(EntityTypes.CAT, 8.0f), (Object)8), (Object)Pair.of(BehaviorLookTarget.create(EntityTypes.VILLAGER, 8.0f), (Object)2), (Object)Pair.of(BehaviorLookTarget.create(EntityTypes.PLAYER, 8.0f), (Object)2), (Object)Pair.of(BehaviorLookTarget.create(EnumCreatureType.CREATURE, 8.0f), (Object)1), (Object)Pair.of(BehaviorLookTarget.create(EnumCreatureType.WATER_CREATURE, 8.0f), (Object)1), (Object)Pair.of(BehaviorLookTarget.create(EnumCreatureType.AXOLOTLS, 8.0f), (Object)1), (Object)Pair.of(BehaviorLookTarget.create(EnumCreatureType.UNDERGROUND_WATER_CREATURE, 8.0f), (Object)1), (Object)Pair.of(BehaviorLookTarget.create(EnumCreatureType.WATER_AMBIENT, 8.0f), (Object)1), (Object)Pair.of(BehaviorLookTarget.create(EnumCreatureType.MONSTER, 8.0f), (Object)1), (Object)Pair.of((Object)new BehaviorNop(30, 60), (Object)2))));
    }

    private static Pair<Integer, BehaviorControl<EntityLiving>> getMinimalLookBehavior() {
        return Pair.of((Object)5, new BehaviorGateSingle(ImmutableList.of((Object)Pair.of(BehaviorLookTarget.create(EntityTypes.VILLAGER, 8.0f), (Object)2), (Object)Pair.of(BehaviorLookTarget.create(EntityTypes.PLAYER, 8.0f), (Object)2), (Object)Pair.of((Object)new BehaviorNop(30, 60), (Object)8))));
    }

    private static boolean raidExistsAndActive(WorldServer var0, EntityLiving var1) {
        Raid var2 = var0.getRaidAt(var1.blockPosition());
        return var2 != null && var2.isActive() && !var2.isVictory() && !var2.isLoss();
    }

    private static boolean raidExistsAndNotVictory(WorldServer var0, EntityLiving var1) {
        Raid var2 = var0.getRaidAt(var1.blockPosition());
        return var2 != null && var2.isVictory();
    }
}

