/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.Applicative;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryTarget;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.phys.Vec3D;

public class BehaviorOutside {
    public static OneShot<EntityLiving> create(float var0) {
        return BehaviorBuilder.create(var12 -> var12.group(var12.absent(MemoryModuleType.WALK_TARGET)).apply((Applicative)var12, var1 -> (var22, var3, var4) -> {
            if (var22.canSeeSky(var3.blockPosition())) {
                return false;
            }
            Optional<Vec3D> var6 = Optional.ofNullable(BehaviorOutside.getOutdoorPosition(var22, var3));
            var6.ifPresent(var2 -> var1.set(new MemoryTarget((Vec3D)var2, var0, 0)));
            return true;
        }));
    }

    @Nullable
    private static Vec3D getOutdoorPosition(WorldServer var0, EntityLiving var1) {
        RandomSource var2 = var1.getRandom();
        BlockPosition var3 = var1.blockPosition();
        for (int var4 = 0; var4 < 10; ++var4) {
            BlockPosition var5 = var3.offset(var2.nextInt(20) - 10, var2.nextInt(6) - 3, var2.nextInt(20) - 10);
            if (!BehaviorOutside.hasNoBlocksAbove(var0, var1, var5)) continue;
            return Vec3D.atBottomCenterOf(var5);
        }
        return null;
    }

    public static boolean hasNoBlocksAbove(WorldServer var0, EntityLiving var1, BlockPosition var2) {
        return var0.canSeeSky(var2) && (double)var0.getHeightmapPos(HeightMap.Type.MOTION_BLOCKING, var2).getY() <= var1.getY();
    }
}

