/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.attributes;

import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;

public class AttributeMapBase {
    private final Map<Holder<AttributeBase>, AttributeModifiable> attributes = new Object2ObjectOpenHashMap();
    private final Set<AttributeModifiable> attributesToSync = new ObjectOpenHashSet();
    private final Set<AttributeModifiable> attributesToUpdate = new ObjectOpenHashSet();
    private final AttributeProvider supplier;

    public AttributeMapBase(AttributeProvider var0) {
        this.supplier = var0;
    }

    private void onAttributeModified(AttributeModifiable var0) {
        this.attributesToUpdate.add(var0);
        if (var0.getAttribute().value().isClientSyncable()) {
            this.attributesToSync.add(var0);
        }
    }

    public Set<AttributeModifiable> getAttributesToSync() {
        return this.attributesToSync;
    }

    public Set<AttributeModifiable> getAttributesToUpdate() {
        return this.attributesToUpdate;
    }

    public Collection<AttributeModifiable> getSyncableAttributes() {
        return this.attributes.values().stream().filter(var0 -> var0.getAttribute().value().isClientSyncable()).collect(Collectors.toList());
    }

    @Nullable
    public AttributeModifiable getInstance(Holder<AttributeBase> var02) {
        return this.attributes.computeIfAbsent(var02, var0 -> this.supplier.createInstance(this::onAttributeModified, (Holder<AttributeBase>)var0));
    }

    public boolean hasAttribute(Holder<AttributeBase> var0) {
        return this.attributes.get(var0) != null || this.supplier.hasAttribute(var0);
    }

    public boolean hasModifier(Holder<AttributeBase> var0, MinecraftKey var1) {
        AttributeModifiable var2 = this.attributes.get(var0);
        return var2 != null ? var2.getModifier(var1) != null : this.supplier.hasModifier(var0, var1);
    }

    public double getValue(Holder<AttributeBase> var0) {
        AttributeModifiable var1 = this.attributes.get(var0);
        return var1 != null ? var1.getValue() : this.supplier.getValue(var0);
    }

    public double getBaseValue(Holder<AttributeBase> var0) {
        AttributeModifiable var1 = this.attributes.get(var0);
        return var1 != null ? var1.getBaseValue() : this.supplier.getBaseValue(var0);
    }

    public double getModifierValue(Holder<AttributeBase> var0, MinecraftKey var1) {
        AttributeModifiable var2 = this.attributes.get(var0);
        return var2 != null ? var2.getModifier(var1).amount() : this.supplier.getModifierValue(var0, var1);
    }

    public void addTransientAttributeModifiers(Multimap<Holder<AttributeBase>, AttributeModifier> var02) {
        var02.forEach((var0, var1) -> {
            AttributeModifiable var2 = this.getInstance((Holder<AttributeBase>)var0);
            if (var2 != null) {
                var2.removeModifier(var1.id());
                var2.addTransientModifier((AttributeModifier)var1);
            }
        });
    }

    public void removeAttributeModifiers(Multimap<Holder<AttributeBase>, AttributeModifier> var02) {
        var02.asMap().forEach((var0, var12) -> {
            AttributeModifiable var2 = this.attributes.get(var0);
            if (var2 != null) {
                var12.forEach(var1 -> var2.removeModifier(var1.id()));
            }
        });
    }

    public void assignAllValues(AttributeMapBase var02) {
        var02.attributes.values().forEach(var0 -> {
            AttributeModifiable var1 = this.getInstance(var0.getAttribute());
            if (var1 != null) {
                var1.replaceFrom((AttributeModifiable)var0);
            }
        });
    }

    public void assignBaseValues(AttributeMapBase var02) {
        var02.attributes.values().forEach(var0 -> {
            AttributeModifiable var1 = this.getInstance(var0.getAttribute());
            if (var1 != null) {
                var1.setBaseValue(var0.getBaseValue());
            }
        });
    }

    public void assignPermanentModifiers(AttributeMapBase var02) {
        var02.attributes.values().forEach(var0 -> {
            AttributeModifiable var1 = this.getInstance(var0.getAttribute());
            if (var1 != null) {
                var1.addPermanentModifiers(var0.getPermanentModifiers());
            }
        });
    }

    public boolean resetBaseValue(Holder<AttributeBase> var0) {
        if (!this.supplier.hasAttribute(var0)) {
            return false;
        }
        AttributeModifiable var1 = this.attributes.get(var0);
        if (var1 != null) {
            var1.setBaseValue(this.supplier.getBaseValue(var0));
        }
        return true;
    }

    public NBTTagList save() {
        NBTTagList var0 = new NBTTagList();
        for (AttributeModifiable var2 : this.attributes.values()) {
            var0.add(var2.save());
        }
        return var0;
    }

    public void load(NBTTagList var0) {
        for (int var12 = 0; var12 < var0.size(); ++var12) {
            NBTTagCompound var2 = var0.getCompoundOrEmpty(var12);
            var2.read("id", AttributeModifiable.TYPE_CODEC).map(this::getInstance).ifPresent(var1 -> var1.load(var2));
        }
    }
}

