/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.players.NameReferencingFileConverter;
import net.minecraft.world.level.World;
import net.minecraft.world.level.entity.UUIDLookup;
import net.minecraft.world.level.entity.UniquelyIdentifyable;

public class EntityReference<StoredEntityType extends UniquelyIdentifyable> {
    private static final Codec<? extends EntityReference<?>> CODEC = UUIDUtil.CODEC.xmap(EntityReference::new, EntityReference::getUUID);
    private static final StreamCodec<ByteBuf, ? extends EntityReference<?>> STREAM_CODEC = UUIDUtil.STREAM_CODEC.map(EntityReference::new, EntityReference::getUUID);
    private Either<UUID, StoredEntityType> entity;

    public static <Type extends UniquelyIdentifyable> Codec<EntityReference<Type>> codec() {
        return CODEC;
    }

    public static <Type extends UniquelyIdentifyable> StreamCodec<ByteBuf, EntityReference<Type>> streamCodec() {
        return STREAM_CODEC;
    }

    public EntityReference(StoredEntityType var0) {
        this.entity = Either.right(var0);
    }

    public EntityReference(UUID var0) {
        this.entity = Either.left((Object)var0);
    }

    public UUID getUUID() {
        return (UUID)this.entity.map(var0 -> var0, UniquelyIdentifyable::getUUID);
    }

    @Nullable
    public StoredEntityType getEntity(UUIDLookup<? super StoredEntityType> var0, Class<StoredEntityType> var1) {
        StoredEntityType var4;
        Object var3;
        Optional var2 = this.entity.right();
        if (var2.isPresent()) {
            var3 = (UniquelyIdentifyable)var2.get();
            if (var3.isRemoved()) {
                this.entity = Either.left((Object)var3.getUUID());
            } else {
                return (StoredEntityType)var3;
            }
        }
        if (((Optional)(var3 = this.entity.left())).isPresent() && (var4 = this.resolve((UniquelyIdentifyable)var0.getEntity((UUID)((Optional)var3).get()), var1)) != null && !var4.isRemoved()) {
            this.entity = Either.right(var4);
            return var4;
        }
        return null;
    }

    @Nullable
    private StoredEntityType resolve(@Nullable UniquelyIdentifyable var0, Class<StoredEntityType> var1) {
        if (var0 != null && var1.isAssignableFrom(var0.getClass())) {
            return (StoredEntityType)((UniquelyIdentifyable)var1.cast(var0));
        }
        return null;
    }

    public boolean matches(StoredEntityType var0) {
        return this.getUUID().equals(var0.getUUID());
    }

    public void store(NBTTagCompound var0, String var1) {
        var0.store(var1, UUIDUtil.CODEC, this.getUUID());
    }

    @Nullable
    public static <StoredEntityType extends UniquelyIdentifyable> StoredEntityType get(@Nullable EntityReference<StoredEntityType> var0, UUIDLookup<? super StoredEntityType> var1, Class<StoredEntityType> var2) {
        return var0 != null ? (StoredEntityType)var0.getEntity(var1, var2) : null;
    }

    @Nullable
    public static <StoredEntityType extends UniquelyIdentifyable> EntityReference<StoredEntityType> read(NBTTagCompound var0, String var1) {
        return var0.read(var1, EntityReference.codec()).orElse(null);
    }

    @Nullable
    public static <StoredEntityType extends UniquelyIdentifyable> EntityReference<StoredEntityType> readWithOldOwnerConversion(NBTTagCompound var0, String var12, World var2) {
        Optional<UUID> var3 = var0.read(var12, UUIDUtil.CODEC);
        if (var3.isPresent()) {
            return new EntityReference<StoredEntityType>(var3.get());
        }
        return var0.getString(var12).map(var1 -> NameReferencingFileConverter.convertMobOwnerIfNecessary(var2.getServer(), var1)).map(EntityReference::new).orElse(null);
    }
}

