/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.collect.Maps;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GlowSquid;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ambient.EntityBat;
import net.minecraft.world.entity.animal.AgeableWaterCreature;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityFox;
import net.minecraft.world.entity.animal.EntityMushroomCow;
import net.minecraft.world.entity.animal.EntityOcelot;
import net.minecraft.world.entity.animal.EntityParrot;
import net.minecraft.world.entity.animal.EntityPolarBear;
import net.minecraft.world.entity.animal.EntityRabbit;
import net.minecraft.world.entity.animal.EntityTropicalFish;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.animal.EntityWaterAnimal;
import net.minecraft.world.entity.animal.armadillo.Armadillo;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.animal.camel.Camel;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.animal.horse.EntityHorseSkeleton;
import net.minecraft.world.entity.animal.horse.EntityHorseZombie;
import net.minecraft.world.entity.animal.wolf.EntityWolf;
import net.minecraft.world.entity.monster.EntityDrowned;
import net.minecraft.world.entity.monster.EntityEndermite;
import net.minecraft.world.entity.monster.EntityGhast;
import net.minecraft.world.entity.monster.EntityGuardian;
import net.minecraft.world.entity.monster.EntityMagmaCube;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntityMonsterPatrolling;
import net.minecraft.world.entity.monster.EntityPigZombie;
import net.minecraft.world.entity.monster.EntitySilverfish;
import net.minecraft.world.entity.monster.EntitySkeletonStray;
import net.minecraft.world.entity.monster.EntitySlime;
import net.minecraft.world.entity.monster.EntityStrider;
import net.minecraft.world.entity.monster.EntityZombieHusk;
import net.minecraft.world.entity.monster.hoglin.EntityHoglin;
import net.minecraft.world.entity.monster.piglin.EntityPiglin;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.levelgen.HeightMap;

public class EntityPositionTypes {
    private static final Map<EntityTypes<?>, a> DATA_BY_TYPE = Maps.newHashMap();

    private static <T extends EntityInsentient> void register(EntityTypes<T> var0, SpawnPlacementType var1, HeightMap.Type var2, b<T> var3) {
        a var4 = DATA_BY_TYPE.put(var0, new a(var2, var1, var3));
        if (var4 != null) {
            throw new IllegalStateException("Duplicate registration for type " + String.valueOf(BuiltInRegistries.ENTITY_TYPE.getKey(var0)));
        }
    }

    public static SpawnPlacementType getPlacementType(EntityTypes<?> var0) {
        a var1 = DATA_BY_TYPE.get(var0);
        return var1 == null ? SpawnPlacementTypes.NO_RESTRICTIONS : var1.placement;
    }

    public static boolean isSpawnPositionOk(EntityTypes<?> var0, IWorldReader var1, BlockPosition var2) {
        return EntityPositionTypes.getPlacementType(var0).isSpawnPositionOk(var1, var2, var0);
    }

    public static HeightMap.Type getHeightmapType(@Nullable EntityTypes<?> var0) {
        a var1 = DATA_BY_TYPE.get(var0);
        return var1 == null ? HeightMap.Type.MOTION_BLOCKING_NO_LEAVES : var1.heightMap;
    }

    public static <T extends Entity> boolean checkSpawnRules(EntityTypes<T> var0, WorldAccess var1, EntitySpawnReason var2, BlockPosition var3, RandomSource var4) {
        a var5 = DATA_BY_TYPE.get(var0);
        return var5 == null || var5.predicate.test(var0, var1, var2, var3, var4);
    }

    static {
        EntityPositionTypes.register(EntityTypes.AXOLOTL, SpawnPlacementTypes.IN_WATER, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, Axolotl::checkAxolotlSpawnRules);
        EntityPositionTypes.register(EntityTypes.COD, SpawnPlacementTypes.IN_WATER, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityWaterAnimal::checkSurfaceWaterAnimalSpawnRules);
        EntityPositionTypes.register(EntityTypes.DOLPHIN, SpawnPlacementTypes.IN_WATER, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, AgeableWaterCreature::checkSurfaceAgeableWaterCreatureSpawnRules);
        EntityPositionTypes.register(EntityTypes.DROWNED, SpawnPlacementTypes.IN_WATER, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityDrowned::checkDrownedSpawnRules);
        EntityPositionTypes.register(EntityTypes.GUARDIAN, SpawnPlacementTypes.IN_WATER, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityGuardian::checkGuardianSpawnRules);
        EntityPositionTypes.register(EntityTypes.PUFFERFISH, SpawnPlacementTypes.IN_WATER, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityWaterAnimal::checkSurfaceWaterAnimalSpawnRules);
        EntityPositionTypes.register(EntityTypes.SALMON, SpawnPlacementTypes.IN_WATER, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityWaterAnimal::checkSurfaceWaterAnimalSpawnRules);
        EntityPositionTypes.register(EntityTypes.SQUID, SpawnPlacementTypes.IN_WATER, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, AgeableWaterCreature::checkSurfaceAgeableWaterCreatureSpawnRules);
        EntityPositionTypes.register(EntityTypes.TROPICAL_FISH, SpawnPlacementTypes.IN_WATER, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityTropicalFish::checkTropicalFishSpawnRules);
        EntityPositionTypes.register(EntityTypes.ARMADILLO, SpawnPlacementTypes.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, Armadillo::checkArmadilloSpawnRules);
        EntityPositionTypes.register(EntityTypes.BAT, SpawnPlacementTypes.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityBat::checkBatSpawnRules);
        EntityPositionTypes.register(EntityTypes.BLAZE, SpawnPlacementTypes.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityMonster::checkAnyLightMonsterSpawnRules);
        EntityPositionTypes.register(EntityTypes.BOGGED, SpawnPlacementTypes.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityMonster::checkMonsterSpawnRules);
        EntityPositionTypes.register(EntityTypes.BREEZE, SpawnPlacementTypes.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityMonster::checkAnyLightMonsterSpawnRules);
        EntityPositionTypes.register(EntityTypes.CAMEL, SpawnPlacementTypes.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, Camel::checkCamelSpawnRules);
        EntityPositionTypes.register(EntityTypes.CAVE_SPIDER, SpawnPlacementTypes.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityMonster::checkMonsterSpawnRules);
        EntityPositionTypes.register(EntityTypes.CHICKEN, SpawnPlacementTypes.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityAnimal::checkAnimalSpawnRules);
        EntityPositionTypes.register(EntityTypes.COW, SpawnPlacementTypes.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityAnimal::checkAnimalSpawnRules);
        EntityPositionTypes.register(EntityTypes.CREEPER, SpawnPlacementTypes.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityMonster::checkMonsterSpawnRules);
        EntityPositionTypes.register(EntityTypes.DONKEY, SpawnPlacementTypes.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityAnimal::checkAnimalSpawnRules);
        EntityPositionTypes.register(EntityTypes.ENDERMAN, SpawnPlacementTypes.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityMonster::checkMonsterSpawnRules);
        EntityPositionTypes.register(EntityTypes.ENDERMITE, SpawnPlacementTypes.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityEndermite::checkEndermiteSpawnRules);
        EntityPositionTypes.register(EntityTypes.ENDER_DRAGON, SpawnPlacementTypes.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityInsentient::checkMobSpawnRules);
        EntityPositionTypes.register(EntityTypes.FROG, SpawnPlacementTypes.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, Frog::checkFrogSpawnRules);
        EntityPositionTypes.register(EntityTypes.GHAST, SpawnPlacementTypes.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityGhast::checkGhastSpawnRules);
        EntityPositionTypes.register(EntityTypes.GIANT, SpawnPlacementTypes.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityMonster::checkMonsterSpawnRules);
        EntityPositionTypes.register(EntityTypes.GLOW_SQUID, SpawnPlacementTypes.IN_WATER, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, GlowSquid::checkGlowSquidSpawnRules);
        EntityPositionTypes.register(EntityTypes.GOAT, SpawnPlacementTypes.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, Goat::checkGoatSpawnRules);
        EntityPositionTypes.register(EntityTypes.HORSE, SpawnPlacementTypes.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityAnimal::checkAnimalSpawnRules);
        EntityPositionTypes.register(EntityTypes.HUSK, SpawnPlacementTypes.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityZombieHusk::checkHuskSpawnRules);
        EntityPositionTypes.register(EntityTypes.IRON_GOLEM, SpawnPlacementTypes.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityInsentient::checkMobSpawnRules);
        EntityPositionTypes.register(EntityTypes.LLAMA, SpawnPlacementTypes.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityAnimal::checkAnimalSpawnRules);
        EntityPositionTypes.register(EntityTypes.MAGMA_CUBE, SpawnPlacementTypes.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityMagmaCube::checkMagmaCubeSpawnRules);
        EntityPositionTypes.register(EntityTypes.MOOSHROOM, SpawnPlacementTypes.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityMushroomCow::checkMushroomSpawnRules);
        EntityPositionTypes.register(EntityTypes.MULE, SpawnPlacementTypes.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityAnimal::checkAnimalSpawnRules);
        EntityPositionTypes.register(EntityTypes.OCELOT, SpawnPlacementTypes.ON_GROUND, HeightMap.Type.MOTION_BLOCKING, EntityOcelot::checkOcelotSpawnRules);
        EntityPositionTypes.register(EntityTypes.PARROT, SpawnPlacementTypes.ON_GROUND, HeightMap.Type.MOTION_BLOCKING, EntityParrot::checkParrotSpawnRules);
        EntityPositionTypes.register(EntityTypes.PIG, SpawnPlacementTypes.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityAnimal::checkAnimalSpawnRules);
        EntityPositionTypes.register(EntityTypes.HOGLIN, SpawnPlacementTypes.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityHoglin::checkHoglinSpawnRules);
        EntityPositionTypes.register(EntityTypes.PIGLIN, SpawnPlacementTypes.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityPiglin::checkPiglinSpawnRules);
        EntityPositionTypes.register(EntityTypes.PILLAGER, SpawnPlacementTypes.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityMonsterPatrolling::checkPatrollingMonsterSpawnRules);
        EntityPositionTypes.register(EntityTypes.POLAR_BEAR, SpawnPlacementTypes.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityPolarBear::checkPolarBearSpawnRules);
        EntityPositionTypes.register(EntityTypes.RABBIT, SpawnPlacementTypes.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityRabbit::checkRabbitSpawnRules);
        EntityPositionTypes.register(EntityTypes.SHEEP, SpawnPlacementTypes.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityAnimal::checkAnimalSpawnRules);
        EntityPositionTypes.register(EntityTypes.SILVERFISH, SpawnPlacementTypes.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntitySilverfish::checkSilverfishSpawnRules);
        EntityPositionTypes.register(EntityTypes.SKELETON, SpawnPlacementTypes.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityMonster::checkMonsterSpawnRules);
        EntityPositionTypes.register(EntityTypes.SKELETON_HORSE, SpawnPlacementTypes.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityHorseSkeleton::checkSkeletonHorseSpawnRules);
        EntityPositionTypes.register(EntityTypes.SLIME, SpawnPlacementTypes.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntitySlime::checkSlimeSpawnRules);
        EntityPositionTypes.register(EntityTypes.SNOW_GOLEM, SpawnPlacementTypes.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityInsentient::checkMobSpawnRules);
        EntityPositionTypes.register(EntityTypes.SPIDER, SpawnPlacementTypes.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityMonster::checkMonsterSpawnRules);
        EntityPositionTypes.register(EntityTypes.STRAY, SpawnPlacementTypes.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntitySkeletonStray::checkStraySpawnRules);
        EntityPositionTypes.register(EntityTypes.STRIDER, SpawnPlacementTypes.IN_LAVA, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityStrider::checkStriderSpawnRules);
        EntityPositionTypes.register(EntityTypes.TURTLE, SpawnPlacementTypes.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityTurtle::checkTurtleSpawnRules);
        EntityPositionTypes.register(EntityTypes.VILLAGER, SpawnPlacementTypes.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityInsentient::checkMobSpawnRules);
        EntityPositionTypes.register(EntityTypes.WITCH, SpawnPlacementTypes.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityMonster::checkMonsterSpawnRules);
        EntityPositionTypes.register(EntityTypes.WITHER, SpawnPlacementTypes.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityMonster::checkMonsterSpawnRules);
        EntityPositionTypes.register(EntityTypes.WITHER_SKELETON, SpawnPlacementTypes.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityMonster::checkMonsterSpawnRules);
        EntityPositionTypes.register(EntityTypes.WOLF, SpawnPlacementTypes.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityWolf::checkWolfSpawnRules);
        EntityPositionTypes.register(EntityTypes.ZOGLIN, SpawnPlacementTypes.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityMonster::checkAnyLightMonsterSpawnRules);
        EntityPositionTypes.register(EntityTypes.CREAKING, SpawnPlacementTypes.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityMonster::checkMonsterSpawnRules);
        EntityPositionTypes.register(EntityTypes.ZOMBIE, SpawnPlacementTypes.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityMonster::checkMonsterSpawnRules);
        EntityPositionTypes.register(EntityTypes.ZOMBIE_HORSE, SpawnPlacementTypes.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityHorseZombie::checkZombieHorseSpawnRules);
        EntityPositionTypes.register(EntityTypes.ZOMBIFIED_PIGLIN, SpawnPlacementTypes.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityPigZombie::checkZombifiedPiglinSpawnRules);
        EntityPositionTypes.register(EntityTypes.ZOMBIE_VILLAGER, SpawnPlacementTypes.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityMonster::checkMonsterSpawnRules);
        EntityPositionTypes.register(EntityTypes.CAT, SpawnPlacementTypes.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityAnimal::checkAnimalSpawnRules);
        EntityPositionTypes.register(EntityTypes.ELDER_GUARDIAN, SpawnPlacementTypes.IN_WATER, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityGuardian::checkGuardianSpawnRules);
        EntityPositionTypes.register(EntityTypes.EVOKER, SpawnPlacementTypes.NO_RESTRICTIONS, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityMonster::checkMonsterSpawnRules);
        EntityPositionTypes.register(EntityTypes.FOX, SpawnPlacementTypes.NO_RESTRICTIONS, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityFox::checkFoxSpawnRules);
        EntityPositionTypes.register(EntityTypes.ILLUSIONER, SpawnPlacementTypes.NO_RESTRICTIONS, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityMonster::checkMonsterSpawnRules);
        EntityPositionTypes.register(EntityTypes.PANDA, SpawnPlacementTypes.NO_RESTRICTIONS, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityAnimal::checkAnimalSpawnRules);
        EntityPositionTypes.register(EntityTypes.PHANTOM, SpawnPlacementTypes.NO_RESTRICTIONS, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityInsentient::checkMobSpawnRules);
        EntityPositionTypes.register(EntityTypes.RAVAGER, SpawnPlacementTypes.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityMonster::checkMonsterSpawnRules);
        EntityPositionTypes.register(EntityTypes.SHULKER, SpawnPlacementTypes.NO_RESTRICTIONS, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityInsentient::checkMobSpawnRules);
        EntityPositionTypes.register(EntityTypes.TRADER_LLAMA, SpawnPlacementTypes.NO_RESTRICTIONS, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityAnimal::checkAnimalSpawnRules);
        EntityPositionTypes.register(EntityTypes.VEX, SpawnPlacementTypes.NO_RESTRICTIONS, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityMonster::checkMonsterSpawnRules);
        EntityPositionTypes.register(EntityTypes.VINDICATOR, SpawnPlacementTypes.NO_RESTRICTIONS, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityMonster::checkMonsterSpawnRules);
        EntityPositionTypes.register(EntityTypes.WANDERING_TRADER, SpawnPlacementTypes.ON_GROUND, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityInsentient::checkMobSpawnRules);
        EntityPositionTypes.register(EntityTypes.WARDEN, SpawnPlacementTypes.NO_RESTRICTIONS, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, EntityMonster::checkMonsterSpawnRules);
    }

    static final class a
    extends Record {
        final HeightMap.Type heightMap;
        final SpawnPlacementType placement;
        final b<?> predicate;

        a(HeightMap.Type var0, SpawnPlacementType var1, b<?> var2) {
            this.heightMap = var0;
            this.placement = var1;
            this.predicate = var2;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "heightMap;placement;predicate", "heightMap", "placement", "predicate"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "heightMap;placement;predicate", "heightMap", "placement", "predicate"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "heightMap;placement;predicate", "heightMap", "placement", "predicate"}, this, var0);
        }

        public HeightMap.Type heightMap() {
            return this.heightMap;
        }

        public SpawnPlacementType placement() {
            return this.placement;
        }

        public b<?> predicate() {
            return this.predicate;
        }
    }

    @FunctionalInterface
    public static interface b<T extends Entity> {
        public boolean test(EntityTypes<T> var1, WorldAccess var2, EntitySpawnReason var3, BlockPosition var4, RandomSource var5);
    }
}

