/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ARGB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.World;
import net.minecraft.world.level.material.EnumPistonReaction;

public class EntityAreaEffectCloud
extends Entity
implements TraceableEntity {
    private static final int TIME_BETWEEN_APPLICATIONS = 5;
    private static final DataWatcherObject<Float> DATA_RADIUS = DataWatcher.defineId(EntityAreaEffectCloud.class, DataWatcherRegistry.FLOAT);
    private static final DataWatcherObject<Boolean> DATA_WAITING = DataWatcher.defineId(EntityAreaEffectCloud.class, DataWatcherRegistry.BOOLEAN);
    private static final DataWatcherObject<ParticleParam> DATA_PARTICLE = DataWatcher.defineId(EntityAreaEffectCloud.class, DataWatcherRegistry.PARTICLE);
    private static final float MAX_RADIUS = 32.0f;
    private static final int DEFAULT_AGE = 0;
    private static final int DEFAULT_DURATION_ON_USE = 0;
    private static final float DEFAULT_RADIUS_ON_USE = 0.0f;
    private static final float DEFAULT_RADIUS_PER_TICK = 0.0f;
    private static final float DEFAULT_POTION_DURATION_SCALE = 1.0f;
    private static final float MINIMAL_RADIUS = 0.5f;
    private static final float DEFAULT_RADIUS = 3.0f;
    public static final float DEFAULT_WIDTH = 6.0f;
    public static final float HEIGHT = 0.5f;
    public static final int INFINITE_DURATION = -1;
    public static final int DEFAULT_LINGERING_DURATION = 600;
    private static final int DEFAULT_WAIT_TIME = 20;
    private static final int DEFAULT_REAPPLICATION_DELAY = 20;
    private static final ColorParticleOption DEFAULT_PARTICLE = ColorParticleOption.create(Particles.ENTITY_EFFECT, -1);
    public PotionContents potionContents = PotionContents.EMPTY;
    private float potionDurationScale = 1.0f;
    private final Map<Entity, Integer> victims = Maps.newHashMap();
    private int duration = -1;
    public int waitTime = 20;
    public int reapplicationDelay = 20;
    public int durationOnUse = 0;
    public float radiusOnUse = 0.0f;
    public float radiusPerTick = 0.0f;
    @Nullable
    private EntityLiving owner;
    @Nullable
    private UUID ownerUUID;

    public EntityAreaEffectCloud(EntityTypes<? extends EntityAreaEffectCloud> var0, World var1) {
        super(var0, var1);
        this.noPhysics = true;
    }

    public EntityAreaEffectCloud(World var0, double var1, double var3, double var5) {
        this((EntityTypes<? extends EntityAreaEffectCloud>)EntityTypes.AREA_EFFECT_CLOUD, var0);
        this.setPos(var1, var3, var5);
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        var0.define(DATA_RADIUS, Float.valueOf(3.0f));
        var0.define(DATA_WAITING, false);
        var0.define(DATA_PARTICLE, DEFAULT_PARTICLE);
    }

    public void setRadius(float var0) {
        if (!this.level().isClientSide) {
            this.getEntityData().set(DATA_RADIUS, Float.valueOf(MathHelper.clamp(var0, 0.0f, 32.0f)));
        }
    }

    @Override
    public void refreshDimensions() {
        double var0 = this.getX();
        double var2 = this.getY();
        double var4 = this.getZ();
        super.refreshDimensions();
        this.setPos(var0, var2, var4);
    }

    public float getRadius() {
        return this.getEntityData().get(DATA_RADIUS).floatValue();
    }

    public void setPotionContents(PotionContents var0) {
        this.potionContents = var0;
        this.updateColor();
    }

    public void setPotionDurationScale(float var0) {
        this.potionDurationScale = var0;
    }

    public void updateColor() {
        ParticleParam var0 = this.entityData.get(DATA_PARTICLE);
        if (var0 instanceof ColorParticleOption) {
            ColorParticleOption var1 = (ColorParticleOption)var0;
            int var2 = this.potionContents.equals(PotionContents.EMPTY) ? 0 : this.potionContents.getColor();
            this.entityData.set(DATA_PARTICLE, ColorParticleOption.create(var1.getType(), ARGB.opaque(var2)));
        }
    }

    public void addEffect(MobEffect var0) {
        this.setPotionContents(this.potionContents.withEffectAdded(var0));
    }

    public ParticleParam getParticle() {
        return this.getEntityData().get(DATA_PARTICLE);
    }

    public void setParticle(ParticleParam var0) {
        this.getEntityData().set(DATA_PARTICLE, var0);
    }

    protected void setWaiting(boolean var0) {
        this.getEntityData().set(DATA_WAITING, var0);
    }

    public boolean isWaiting() {
        return this.getEntityData().get(DATA_WAITING);
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int var0) {
        this.duration = var0;
    }

    @Override
    public void tick() {
        super.tick();
        World world = this.level();
        if (world instanceof WorldServer) {
            WorldServer var0 = (WorldServer)world;
            this.serverTick(var0);
        } else {
            this.clientTick();
        }
    }

    private void clientTick() {
        float var4;
        int var3;
        boolean var0 = this.isWaiting();
        float var1 = this.getRadius();
        if (var0 && this.random.nextBoolean()) {
            return;
        }
        ParticleParam var2 = this.getParticle();
        if (var0) {
            var3 = 2;
            var4 = 0.2f;
        } else {
            var3 = MathHelper.ceil((float)Math.PI * var1 * var1);
            var4 = var1;
        }
        for (int var5 = 0; var5 < var3; ++var5) {
            float var6 = this.random.nextFloat() * ((float)Math.PI * 2);
            float var7 = MathHelper.sqrt(this.random.nextFloat()) * var4;
            double var8 = this.getX() + (double)(MathHelper.cos(var6) * var7);
            double var10 = this.getY();
            double var12 = this.getZ() + (double)(MathHelper.sin(var6) * var7);
            if (var2.getType() == Particles.ENTITY_EFFECT) {
                if (var0 && this.random.nextBoolean()) {
                    this.level().addAlwaysVisibleParticle(ColorParticleOption.create(Particles.ENTITY_EFFECT, -1), var8, var10, var12, 0.0, 0.0, 0.0);
                    continue;
                }
                this.level().addAlwaysVisibleParticle(var2, var8, var10, var12, 0.0, 0.0, 0.0);
                continue;
            }
            if (var0) {
                this.level().addAlwaysVisibleParticle(var2, var8, var10, var12, 0.0, 0.0, 0.0);
                continue;
            }
            this.level().addAlwaysVisibleParticle(var2, var8, var10, var12, (0.5 - this.random.nextDouble()) * 0.15, 0.01f, (0.5 - this.random.nextDouble()) * 0.15);
        }
    }

    private void serverTick(WorldServer var02) {
        boolean var2;
        if (this.duration != -1 && this.tickCount >= this.waitTime + this.duration) {
            this.discard();
            return;
        }
        boolean var1 = this.isWaiting();
        boolean bl = var2 = this.tickCount < this.waitTime;
        if (var1 != var2) {
            this.setWaiting(var2);
        }
        if (var2) {
            return;
        }
        float var3 = this.getRadius();
        if (this.radiusPerTick != 0.0f) {
            if ((var3 += this.radiusPerTick) < 0.5f) {
                this.discard();
                return;
            }
            this.setRadius(var3);
        }
        if (this.tickCount % 5 == 0) {
            this.victims.entrySet().removeIf(var0 -> this.tickCount >= (Integer)var0.getValue());
            if (!this.potionContents.hasEffects()) {
                this.victims.clear();
            } else {
                ArrayList var4 = new ArrayList();
                this.potionContents.forEachEffect(var4::add, this.potionDurationScale);
                List<EntityLiving> var5 = this.level().getEntitiesOfClass(EntityLiving.class, this.getBoundingBox());
                if (!var5.isEmpty()) {
                    for (EntityLiving var7 : var5) {
                        double var10;
                        double var8;
                        double var12;
                        if (this.victims.containsKey(var7) || !var7.isAffectedByPotions()) continue;
                        if (var4.stream().noneMatch(var7::canBeAffected) || !((var12 = (var8 = var7.getX() - this.getX()) * var8 + (var10 = var7.getZ() - this.getZ()) * var10) <= (double)(var3 * var3))) continue;
                        this.victims.put(var7, this.tickCount + this.reapplicationDelay);
                        for (MobEffect var15 : var4) {
                            if (var15.getEffect().value().isInstantenous()) {
                                var15.getEffect().value().applyInstantenousEffect(var02, this, this.getOwner(), var7, var15.getAmplifier(), 0.5);
                                continue;
                            }
                            var7.addEffect(new MobEffect(var15), this);
                        }
                        if (this.radiusOnUse != 0.0f) {
                            if ((var3 += this.radiusOnUse) < 0.5f) {
                                this.discard();
                                return;
                            }
                            this.setRadius(var3);
                        }
                        if (this.durationOnUse == 0 || this.duration == -1) continue;
                        this.duration += this.durationOnUse;
                        if (this.duration > 0) continue;
                        this.discard();
                        return;
                    }
                }
            }
        }
    }

    public float getRadiusOnUse() {
        return this.radiusOnUse;
    }

    public void setRadiusOnUse(float var0) {
        this.radiusOnUse = var0;
    }

    public float getRadiusPerTick() {
        return this.radiusPerTick;
    }

    public void setRadiusPerTick(float var0) {
        this.radiusPerTick = var0;
    }

    public int getDurationOnUse() {
        return this.durationOnUse;
    }

    public void setDurationOnUse(int var0) {
        this.durationOnUse = var0;
    }

    public int getWaitTime() {
        return this.waitTime;
    }

    public void setWaitTime(int var0) {
        this.waitTime = var0;
    }

    public void setOwner(@Nullable EntityLiving var0) {
        this.owner = var0;
        this.ownerUUID = var0 == null ? null : var0.getUUID();
    }

    @Override
    @Nullable
    public EntityLiving getOwner() {
        World world;
        if (this.owner != null && !this.owner.isRemoved()) {
            return this.owner;
        }
        if (this.ownerUUID != null && (world = this.level()) instanceof WorldServer) {
            EntityLiving var1;
            WorldServer var0 = (WorldServer)world;
            Entity entity = var0.getEntity(this.ownerUUID);
            this.owner = entity instanceof EntityLiving ? (var1 = (EntityLiving)entity) : null;
        }
        return this.owner;
    }

    @Override
    protected void readAdditionalSaveData(NBTTagCompound var0) {
        this.tickCount = var0.getIntOr("Age", 0);
        this.duration = var0.getIntOr("Duration", -1);
        this.waitTime = var0.getIntOr("WaitTime", 20);
        this.reapplicationDelay = var0.getIntOr("ReapplicationDelay", 20);
        this.durationOnUse = var0.getIntOr("DurationOnUse", 0);
        this.radiusOnUse = var0.getFloatOr("RadiusOnUse", 0.0f);
        this.radiusPerTick = var0.getFloatOr("RadiusPerTick", 0.0f);
        this.setRadius(var0.getFloatOr("Radius", 3.0f));
        this.ownerUUID = var0.read("Owner", UUIDUtil.CODEC).orElse(null);
        RegistryOps<NBTBase> var1 = this.registryAccess().createSerializationContext(DynamicOpsNBT.INSTANCE);
        this.setParticle(var0.read("Particle", Particles.CODEC, var1).orElse(DEFAULT_PARTICLE));
        this.setPotionContents(var0.read("potion_contents", PotionContents.CODEC, var1).orElse(PotionContents.EMPTY));
        this.potionDurationScale = var0.getFloatOr("potion_duration_scale", 1.0f);
    }

    @Override
    protected void addAdditionalSaveData(NBTTagCompound var0) {
        var0.putInt("Age", this.tickCount);
        var0.putInt("Duration", this.duration);
        var0.putInt("WaitTime", this.waitTime);
        var0.putInt("ReapplicationDelay", this.reapplicationDelay);
        var0.putInt("DurationOnUse", this.durationOnUse);
        var0.putFloat("RadiusOnUse", this.radiusOnUse);
        var0.putFloat("RadiusPerTick", this.radiusPerTick);
        var0.putFloat("Radius", this.getRadius());
        RegistryOps<NBTBase> var1 = this.registryAccess().createSerializationContext(DynamicOpsNBT.INSTANCE);
        var0.store("Particle", Particles.CODEC, var1, this.getParticle());
        var0.storeNullable("Owner", UUIDUtil.CODEC, this.ownerUUID);
        if (!this.potionContents.equals(PotionContents.EMPTY)) {
            var0.store("potion_contents", PotionContents.CODEC, var1, this.potionContents);
        }
        if (this.potionDurationScale != 1.0f) {
            var0.putFloat("potion_duration_scale", this.potionDurationScale);
        }
    }

    @Override
    public void onSyncedDataUpdated(DataWatcherObject<?> var0) {
        if (DATA_RADIUS.equals(var0)) {
            this.refreshDimensions();
        }
        super.onSyncedDataUpdated(var0);
    }

    @Override
    public EnumPistonReaction getPistonPushReaction() {
        return EnumPistonReaction.IGNORE;
    }

    @Override
    public EntitySize getDimensions(EntityPose var0) {
        return EntitySize.scalable(this.getRadius() * 2.0f, 0.5f);
    }

    @Override
    public final boolean hurtServer(WorldServer var0, DamageSource var1, float var2) {
        return false;
    }

    @Override
    @Nullable
    public <T> T get(DataComponentType<? extends T> var0) {
        if (var0 == DataComponents.POTION_CONTENTS) {
            return EntityAreaEffectCloud.castComponentValue(var0, this.potionContents);
        }
        if (var0 == DataComponents.POTION_DURATION_SCALE) {
            return EntityAreaEffectCloud.castComponentValue(var0, Float.valueOf(this.potionDurationScale));
        }
        return super.get(var0);
    }

    @Override
    protected void applyImplicitComponents(DataComponentGetter var0) {
        this.applyImplicitComponentIfPresent(var0, DataComponents.POTION_CONTENTS);
        this.applyImplicitComponentIfPresent(var0, DataComponents.POTION_DURATION_SCALE);
        super.applyImplicitComponents(var0);
    }

    @Override
    protected <T> boolean applyImplicitComponent(DataComponentType<T> var0, T var1) {
        if (var0 == DataComponents.POTION_CONTENTS) {
            this.setPotionContents(EntityAreaEffectCloud.castComponentValue(DataComponents.POTION_CONTENTS, var1));
            return true;
        }
        if (var0 == DataComponents.POTION_DURATION_SCALE) {
            this.setPotionDurationScale(EntityAreaEffectCloud.castComponentValue(DataComponents.POTION_DURATION_SCALE, var1).floatValue());
            return true;
        }
        return super.applyImplicitComponent(var0, var1);
    }

    @Override
    @Nullable
    public /* synthetic */ Entity getOwner() {
        return this.getOwner();
    }
}

