/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.effect;

import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.effect.AbsorptionMobEffect;
import net.minecraft.world.effect.BadOmenMobEffect;
import net.minecraft.world.effect.HealOrHarmMobEffect;
import net.minecraft.world.effect.HungerMobEffect;
import net.minecraft.world.effect.InfestedMobEffect;
import net.minecraft.world.effect.MobEffectInfo;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.OozingMobEffect;
import net.minecraft.world.effect.PoisonMobEffect;
import net.minecraft.world.effect.RaidOmenMobEffect;
import net.minecraft.world.effect.RegenerationMobEffect;
import net.minecraft.world.effect.SaturationMobEffect;
import net.minecraft.world.effect.WeavingMobEffect;
import net.minecraft.world.effect.WindChargedMobEffect;
import net.minecraft.world.effect.WitherMobEffect;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;

public class MobEffects {
    private static final int DARKNESS_EFFECT_FACTOR_PADDING_DURATION_TICKS = 22;
    public static final Holder<MobEffectList> SPEED = MobEffects.register("speed", new MobEffectList(MobEffectInfo.BENEFICIAL, 3402751).addAttributeModifier(GenericAttributes.MOVEMENT_SPEED, MinecraftKey.withDefaultNamespace("effect.speed"), 0.2f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
    public static final Holder<MobEffectList> SLOWNESS = MobEffects.register("slowness", new MobEffectList(MobEffectInfo.HARMFUL, 9154528).addAttributeModifier(GenericAttributes.MOVEMENT_SPEED, MinecraftKey.withDefaultNamespace("effect.slowness"), -0.15f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
    public static final Holder<MobEffectList> HASTE = MobEffects.register("haste", new MobEffectList(MobEffectInfo.BENEFICIAL, 14270531).addAttributeModifier(GenericAttributes.ATTACK_SPEED, MinecraftKey.withDefaultNamespace("effect.haste"), 0.1f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
    public static final Holder<MobEffectList> MINING_FATIGUE = MobEffects.register("mining_fatigue", new MobEffectList(MobEffectInfo.HARMFUL, 4866583).addAttributeModifier(GenericAttributes.ATTACK_SPEED, MinecraftKey.withDefaultNamespace("effect.mining_fatigue"), -0.1f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
    public static final Holder<MobEffectList> STRENGTH = MobEffects.register("strength", new MobEffectList(MobEffectInfo.BENEFICIAL, 16762624).addAttributeModifier(GenericAttributes.ATTACK_DAMAGE, MinecraftKey.withDefaultNamespace("effect.strength"), 3.0, AttributeModifier.Operation.ADD_VALUE));
    public static final Holder<MobEffectList> INSTANT_HEALTH = MobEffects.register("instant_health", new HealOrHarmMobEffect(MobEffectInfo.BENEFICIAL, 16262179, false));
    public static final Holder<MobEffectList> INSTANT_DAMAGE = MobEffects.register("instant_damage", new HealOrHarmMobEffect(MobEffectInfo.HARMFUL, 11101546, true));
    public static final Holder<MobEffectList> JUMP_BOOST = MobEffects.register("jump_boost", new MobEffectList(MobEffectInfo.BENEFICIAL, 16646020).addAttributeModifier(GenericAttributes.SAFE_FALL_DISTANCE, MinecraftKey.withDefaultNamespace("effect.jump_boost"), 1.0, AttributeModifier.Operation.ADD_VALUE));
    public static final Holder<MobEffectList> NAUSEA = MobEffects.register("nausea", new MobEffectList(MobEffectInfo.HARMFUL, 5578058).setBlendDuration(150, 20, 60));
    public static final Holder<MobEffectList> REGENERATION = MobEffects.register("regeneration", new RegenerationMobEffect(MobEffectInfo.BENEFICIAL, 13458603));
    public static final Holder<MobEffectList> RESISTANCE = MobEffects.register("resistance", new MobEffectList(MobEffectInfo.BENEFICIAL, 9520880));
    public static final Holder<MobEffectList> FIRE_RESISTANCE = MobEffects.register("fire_resistance", new MobEffectList(MobEffectInfo.BENEFICIAL, 0xFF9900));
    public static final Holder<MobEffectList> WATER_BREATHING = MobEffects.register("water_breathing", new MobEffectList(MobEffectInfo.BENEFICIAL, 10017472));
    public static final Holder<MobEffectList> INVISIBILITY = MobEffects.register("invisibility", new MobEffectList(MobEffectInfo.BENEFICIAL, 0xF6F6F6));
    public static final Holder<MobEffectList> BLINDNESS = MobEffects.register("blindness", new MobEffectList(MobEffectInfo.HARMFUL, 2039587));
    public static final Holder<MobEffectList> NIGHT_VISION = MobEffects.register("night_vision", new MobEffectList(MobEffectInfo.BENEFICIAL, 12779366));
    public static final Holder<MobEffectList> HUNGER = MobEffects.register("hunger", new HungerMobEffect(MobEffectInfo.HARMFUL, 5797459));
    public static final Holder<MobEffectList> WEAKNESS = MobEffects.register("weakness", new MobEffectList(MobEffectInfo.HARMFUL, 0x484D48).addAttributeModifier(GenericAttributes.ATTACK_DAMAGE, MinecraftKey.withDefaultNamespace("effect.weakness"), -4.0, AttributeModifier.Operation.ADD_VALUE));
    public static final Holder<MobEffectList> POISON = MobEffects.register("poison", new PoisonMobEffect(MobEffectInfo.HARMFUL, 8889187));
    public static final Holder<MobEffectList> WITHER = MobEffects.register("wither", new WitherMobEffect(MobEffectInfo.HARMFUL, 7561558));
    public static final Holder<MobEffectList> HEALTH_BOOST = MobEffects.register("health_boost", new MobEffectList(MobEffectInfo.BENEFICIAL, 16284963).addAttributeModifier(GenericAttributes.MAX_HEALTH, MinecraftKey.withDefaultNamespace("effect.health_boost"), 4.0, AttributeModifier.Operation.ADD_VALUE));
    public static final Holder<MobEffectList> ABSORPTION = MobEffects.register("absorption", new AbsorptionMobEffect(MobEffectInfo.BENEFICIAL, 0x2552A5).addAttributeModifier(GenericAttributes.MAX_ABSORPTION, MinecraftKey.withDefaultNamespace("effect.absorption"), 4.0, AttributeModifier.Operation.ADD_VALUE));
    public static final Holder<MobEffectList> SATURATION = MobEffects.register("saturation", new SaturationMobEffect(MobEffectInfo.BENEFICIAL, 16262179));
    public static final Holder<MobEffectList> GLOWING = MobEffects.register("glowing", new MobEffectList(MobEffectInfo.NEUTRAL, 9740385));
    public static final Holder<MobEffectList> LEVITATION = MobEffects.register("levitation", new MobEffectList(MobEffectInfo.HARMFUL, 0xCEFFFF));
    public static final Holder<MobEffectList> LUCK = MobEffects.register("luck", new MobEffectList(MobEffectInfo.BENEFICIAL, 5882118).addAttributeModifier(GenericAttributes.LUCK, MinecraftKey.withDefaultNamespace("effect.luck"), 1.0, AttributeModifier.Operation.ADD_VALUE));
    public static final Holder<MobEffectList> UNLUCK = MobEffects.register("unluck", new MobEffectList(MobEffectInfo.HARMFUL, 12624973).addAttributeModifier(GenericAttributes.LUCK, MinecraftKey.withDefaultNamespace("effect.unluck"), -1.0, AttributeModifier.Operation.ADD_VALUE));
    public static final Holder<MobEffectList> SLOW_FALLING = MobEffects.register("slow_falling", new MobEffectList(MobEffectInfo.BENEFICIAL, 15978425));
    public static final Holder<MobEffectList> CONDUIT_POWER = MobEffects.register("conduit_power", new MobEffectList(MobEffectInfo.BENEFICIAL, 1950417));
    public static final Holder<MobEffectList> DOLPHINS_GRACE = MobEffects.register("dolphins_grace", new MobEffectList(MobEffectInfo.BENEFICIAL, 8954814));
    public static final Holder<MobEffectList> BAD_OMEN = MobEffects.register("bad_omen", new BadOmenMobEffect(MobEffectInfo.NEUTRAL, 745784).withSoundOnAdded(SoundEffects.APPLY_EFFECT_BAD_OMEN));
    public static final Holder<MobEffectList> HERO_OF_THE_VILLAGE = MobEffects.register("hero_of_the_village", new MobEffectList(MobEffectInfo.BENEFICIAL, 0x44FF44));
    public static final Holder<MobEffectList> DARKNESS = MobEffects.register("darkness", new MobEffectList(MobEffectInfo.HARMFUL, 2696993).setBlendDuration(22));
    public static final Holder<MobEffectList> TRIAL_OMEN = MobEffects.register("trial_omen", new MobEffectList(MobEffectInfo.NEUTRAL, 0x16A6A6, Particles.TRIAL_OMEN).withSoundOnAdded(SoundEffects.APPLY_EFFECT_TRIAL_OMEN));
    public static final Holder<MobEffectList> RAID_OMEN = MobEffects.register("raid_omen", new RaidOmenMobEffect(MobEffectInfo.NEUTRAL, 14565464, Particles.RAID_OMEN).withSoundOnAdded(SoundEffects.APPLY_EFFECT_RAID_OMEN));
    public static final Holder<MobEffectList> WIND_CHARGED = MobEffects.register("wind_charged", new WindChargedMobEffect(MobEffectInfo.HARMFUL, 12438015));
    public static final Holder<MobEffectList> WEAVING = MobEffects.register("weaving", new WeavingMobEffect(MobEffectInfo.HARMFUL, 7891290, var0 -> MathHelper.randomBetweenInclusive(var0, 2, 3)));
    public static final Holder<MobEffectList> OOZING = MobEffects.register("oozing", new OozingMobEffect(MobEffectInfo.HARMFUL, 10092451, var0 -> 2));
    public static final Holder<MobEffectList> INFESTED = MobEffects.register("infested", new InfestedMobEffect(MobEffectInfo.HARMFUL, 9214860, 0.1f, var0 -> MathHelper.randomBetweenInclusive(var0, 1, 2)));

    private static Holder<MobEffectList> register(String var0, MobEffectList var1) {
        return IRegistry.registerForHolder(BuiltInRegistries.MOB_EFFECT, MinecraftKey.withDefaultNamespace(var0), var1);
    }

    public static Holder<MobEffectList> bootstrap(IRegistry<MobEffectList> var0) {
        return SPEED;
    }
}

