/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.UnaryOperator;
import net.minecraft.SystemUtils;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class TooltipDisplayComponentFix
extends DataFix {
    private static final List<String> CONVERTED_ADDITIONAL_TOOLTIP_TYPES = List.of("minecraft:banner_patterns", "minecraft:bees", "minecraft:block_entity_data", "minecraft:block_state", "minecraft:bundle_contents", "minecraft:charged_projectiles", "minecraft:container", "minecraft:container_loot", "minecraft:firework_explosion", "minecraft:fireworks", "minecraft:instrument", "minecraft:map_id", "minecraft:painting/variant", "minecraft:pot_decorations", "minecraft:potion_contents", "minecraft:tropical_fish/pattern", "minecraft:written_book_content");

    public TooltipDisplayComponentFix(Schema var0) {
        super(var0, true);
    }

    protected TypeRewriteRule makeRule() {
        Type var0 = this.getInputSchema().getType(DataConverterTypes.DATA_COMPONENTS);
        Type var1 = this.getOutputSchema().getType(DataConverterTypes.DATA_COMPONENTS);
        OpticFinder var2 = var0.findField("minecraft:can_place_on");
        OpticFinder var3 = var0.findField("minecraft:can_break");
        Type var42 = var1.findFieldType("minecraft:can_place_on");
        Type var5 = var1.findFieldType("minecraft:can_break");
        return this.fixTypeEverywhereTyped("TooltipDisplayComponentFix", var0, var1, var4 -> TooltipDisplayComponentFix.fix(var4, var2, var3, var42, var5));
    }

    private static Typed<?> fix(Typed<?> var0, OpticFinder<?> var12, OpticFinder<?> var2, Type<?> var3, Type<?> var4) {
        HashSet<String> var5 = new HashSet<String>();
        var0 = TooltipDisplayComponentFix.fixAdventureModePredicate(var0, var12, var3, "minecraft:can_place_on", var5);
        var0 = TooltipDisplayComponentFix.fixAdventureModePredicate(var0, var2, var4, "minecraft:can_break", var5);
        return var0.update(DSL.remainderFinder(), var1 -> {
            var1 = TooltipDisplayComponentFix.fixSimpleComponent(var1, "minecraft:trim", var5);
            var1 = TooltipDisplayComponentFix.fixSimpleComponent(var1, "minecraft:unbreakable", var5);
            var1 = TooltipDisplayComponentFix.fixComponentAndUnwrap(var1, "minecraft:dyed_color", "rgb", var5);
            var1 = TooltipDisplayComponentFix.fixComponentAndUnwrap(var1, "minecraft:attribute_modifiers", "modifiers", var5);
            var1 = TooltipDisplayComponentFix.fixComponentAndUnwrap(var1, "minecraft:enchantments", "levels", var5);
            var1 = TooltipDisplayComponentFix.fixComponentAndUnwrap(var1, "minecraft:stored_enchantments", "levels", var5);
            boolean var2 = var1.get("minecraft:hide_tooltip").result().isPresent();
            var1 = var1.remove("minecraft:hide_tooltip");
            boolean var3 = var1.get("minecraft:hide_additional_tooltip").result().isPresent();
            var1 = var1.remove("minecraft:hide_additional_tooltip");
            if (var3) {
                for (String var5 : CONVERTED_ADDITIONAL_TOOLTIP_TYPES) {
                    if (!var1.get(var5).result().isPresent()) continue;
                    var5.add(var5);
                }
            }
            if (var5.isEmpty() && !var2) {
                return var1;
            }
            return var1.set("minecraft:tooltip_display", var1.createMap(Map.of(var1.createString("hide_tooltip"), var1.createBoolean(var2), var1.createString("hidden_components"), var1.createList(var5.stream().map(arg_0 -> ((Dynamic)var1).createString(arg_0))))));
        });
    }

    private static Dynamic<?> fixSimpleComponent(Dynamic<?> var0, String var1, Set<String> var2) {
        return TooltipDisplayComponentFix.fixRemainderComponent(var0, var1, var2, UnaryOperator.identity());
    }

    private static Dynamic<?> fixComponentAndUnwrap(Dynamic<?> var0, String var12, String var2, Set<String> var3) {
        return TooltipDisplayComponentFix.fixRemainderComponent(var0, var12, var3, var1 -> (Dynamic)DataFixUtils.orElse((Optional)var1.get(var2).result(), (Object)var1));
    }

    private static Dynamic<?> fixRemainderComponent(Dynamic<?> var0, String var1, Set<String> var2, UnaryOperator<Dynamic<?>> var32) {
        return var0.update(var1, var3 -> {
            boolean var4 = var3.get("show_in_tooltip").asBoolean(true);
            if (!var4) {
                var2.add(var1);
            }
            return (Dynamic)var32.apply(var3.remove("show_in_tooltip"));
        });
    }

    private static Typed<?> fixAdventureModePredicate(Typed<?> var0, OpticFinder<?> var1, Type<?> var2, String var32, Set<String> var4) {
        return var0.updateTyped(var1, var2, var3 -> SystemUtils.writeAndReadTypedOrThrow(var3, var2, var2 -> {
            Object var3 = var2.get("predicates");
            if (var3.result().isEmpty()) {
                return var2;
            }
            boolean var4 = var2.get("show_in_tooltip").asBoolean(true);
            if (!var4) {
                var4.add(var32);
            }
            return (Dynamic)var3.result().get();
        }));
    }
}

