/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.Maps;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Dynamic;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.util.datafix.fixes.DataConverterNamedEntity;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.util.datafix.schemas.DataConverterSchemaNamed;

public class DataConverterPainting
extends DataConverterNamedEntity {
    private static final Map<String, String> MAP = (Map)DataFixUtils.make((Object)Maps.newHashMap(), var0 -> {
        var0.put("donkeykong", "donkey_kong");
        var0.put("burningskull", "burning_skull");
        var0.put("skullandroses", "skull_and_roses");
    });

    public DataConverterPainting(Schema var0, boolean var1) {
        super(var0, var1, "EntityPaintingMotiveFix", DataConverterTypes.ENTITY, "minecraft:painting");
    }

    public Dynamic<?> fixTag(Dynamic<?> var0) {
        Optional var1 = var0.get("Motive").asString().result();
        if (var1.isPresent()) {
            String var2 = ((String)var1.get()).toLowerCase(Locale.ROOT);
            return var0.set("Motive", var0.createString(DataConverterSchemaNamed.ensureNamespaced(MAP.getOrDefault(var2, var2))));
        }
        return var0;
    }

    @Override
    protected Typed<?> fix(Typed<?> var0) {
        return var0.update(DSL.remainderFinder(), this::fixTag);
    }
}

