/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import net.minecraft.SystemUtils;
import net.minecraft.util.datafix.LegacyComponentDataFixUtils;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.util.datafix.schemas.DataConverterSchemaNamed;

public class DataConverterCustomNameEntity
extends DataFix {
    public DataConverterCustomNameEntity(Schema var0) {
        super(var0, true);
    }

    public TypeRewriteRule makeRule() {
        Type var0 = this.getInputSchema().getType(DataConverterTypes.ENTITY);
        Type var1 = this.getOutputSchema().getType(DataConverterTypes.ENTITY);
        OpticFinder var2 = DSL.fieldFinder((String)"id", DataConverterSchemaNamed.namespacedString());
        OpticFinder var32 = var0.findField("CustomName");
        Type var4 = var1.findFieldType("CustomName");
        return this.fixTypeEverywhereTyped("EntityCustomNameToComponentFix", var0, var1, var3 -> DataConverterCustomNameEntity.fixEntity(var3, (OpticFinder<String>)var2, (OpticFinder<String>)var32, var4));
    }

    private static <T> Typed<?> fixEntity(Typed<?> var0, OpticFinder<String> var1, OpticFinder<String> var2, Type<T> var32) {
        return var0.update(var2, var32, var3 -> {
            String var4 = var0.getOptional(var1).orElse("");
            Dynamic var5 = DataConverterCustomNameEntity.fixCustomName(var0.getOps(), var3, var4);
            return SystemUtils.readTypedOrThrow(var32, var5).getValue();
        });
    }

    private static <T> Dynamic<T> fixCustomName(DynamicOps<T> var0, String var1, String var2) {
        if ("minecraft:commandblock_minecart".equals(var2)) {
            return new Dynamic(var0, var0.createString(var1));
        }
        return LegacyComponentDataFixUtils.createPlainTextComponent(var0, var1);
    }
}

