/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tags;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.Reader;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.resources.IResource;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagFile;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagNetworkSerialization;
import net.minecraft.util.DependencySorter;
import org.slf4j.Logger;

public class TagDataPack<T> {
    private static final Logger LOGGER = LogUtils.getLogger();
    final a<T> elementLookup;
    private final String directory;

    public TagDataPack(a<T> var0, String var1) {
        this.elementLookup = var0;
        this.directory = var1;
    }

    public Map<MinecraftKey, List<b>> load(IResourceManager var02) {
        HashMap<MinecraftKey, List<b>> var1 = new HashMap<MinecraftKey, List<b>>();
        FileToIdConverter var22 = FileToIdConverter.json(this.directory);
        for (Map.Entry<MinecraftKey, List<IResource>> var4 : var22.listMatchingResourceStacks(var02).entrySet()) {
            MinecraftKey var5 = var4.getKey();
            MinecraftKey var6 = var22.fileToId(var5);
            for (IResource var8 : var4.getValue()) {
                try {
                    BufferedReader var9 = var8.openAsReader();
                    try {
                        JsonElement var10 = JsonParser.parseReader((Reader)var9);
                        List var11 = var1.computeIfAbsent(var6, var0 -> new ArrayList());
                        TagFile var12 = (TagFile)TagFile.CODEC.parse(new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)var10)).getOrThrow();
                        if (var12.replace()) {
                            var11.clear();
                        }
                        String var13 = var8.sourcePackId();
                        var12.entries().forEach(var2 -> var11.add(new b((TagEntry)var2, var13)));
                    }
                    finally {
                        if (var9 == null) continue;
                        ((Reader)var9).close();
                    }
                }
                catch (Exception var9) {
                    LOGGER.error("Couldn't read tag list {} from {} in data pack {}", new Object[]{var6, var5, var8.sourcePackId(), var9});
                }
            }
        }
        return var1;
    }

    private Either<List<b>, List<T>> tryBuildTag(TagEntry.a<T> var0, List<b> var1) {
        LinkedHashSet var2 = new LinkedHashSet();
        ArrayList<b> var3 = new ArrayList<b>();
        for (b var5 : var1) {
            if (var5.entry().build(var0, var2::add)) continue;
            var3.add(var5);
        }
        return var3.isEmpty() ? Either.right(List.copyOf(var2)) : Either.left(var3);
    }

    public Map<MinecraftKey, List<T>> build(Map<MinecraftKey, List<b>> var0) {
        final HashMap var12 = new HashMap();
        TagEntry.a var23 = new TagEntry.a<T>(){

            @Override
            @Nullable
            public T element(MinecraftKey var0, boolean var1) {
                return TagDataPack.this.elementLookup.get(var0, var1).orElse(null);
            }

            @Override
            @Nullable
            public Collection<T> tag(MinecraftKey var0) {
                return (Collection)var12.get(var0);
            }
        };
        DependencySorter<MinecraftKey, d> var32 = new DependencySorter<MinecraftKey, d>();
        var0.forEach((var1, var2) -> var32.addEntry((MinecraftKey)var1, new d((List<b>)var2)));
        var32.orderByDependencies((var22, var3) -> this.tryBuildTag(var23, var3.entries).ifLeft(var1 -> LOGGER.error("Couldn't load tag {} as it is missing following references: {}", var22, (Object)var1.stream().map(Objects::toString).collect(Collectors.joining(", ")))).ifRight(var2 -> var12.put((MinecraftKey)var22, (List)var2)));
        return var12;
    }

    public static <T> void loadTagsFromNetwork(TagNetworkSerialization.a var0, IRegistryWritable<T> var1) {
        var0.resolve(var1).tags.forEach(var1::bindTag);
    }

    public static List<IRegistry.a<?>> loadTagsForExistingRegistries(IResourceManager var0, IRegistryCustom var12) {
        return var12.registries().map(var1 -> TagDataPack.loadPendingTags(var0, var1.value())).flatMap(Optional::stream).collect(Collectors.toUnmodifiableList());
    }

    public static <T> void loadTagsForRegistry(IResourceManager var0, IRegistryWritable<T> var1) {
        ResourceKey var22 = var1.key();
        TagDataPack<Holder<T>> var32 = new TagDataPack<Holder<T>>(a.fromWritableRegistry(var1), Registries.tagsDirPath(var22));
        var32.build(var32.load(var0)).forEach((var2, var3) -> var1.bindTag(TagKey.create(var22, var2), (List)var3));
    }

    private static <T> Map<TagKey<T>, List<Holder<T>>> wrapTags(ResourceKey<? extends IRegistry<T>> var0, Map<MinecraftKey, List<Holder<T>>> var12) {
        return var12.entrySet().stream().collect(Collectors.toUnmodifiableMap(var1 -> TagKey.create(var0, (MinecraftKey)var1.getKey()), Map.Entry::getValue));
    }

    private static <T> Optional<IRegistry.a<T>> loadPendingTags(IResourceManager var0, IRegistry<T> var1) {
        ResourceKey<IRegistry<T>> var2 = var1.key();
        TagDataPack<Holder<T>> var3 = new TagDataPack<Holder<T>>(a.fromFrozenRegistry(var1), Registries.tagsDirPath(var2));
        c<T> var4 = new c<T>(var2, TagDataPack.wrapTags(var1.key(), var3.build(var3.load(var0))));
        return var4.tags().isEmpty() ? Optional.empty() : Optional.of(var1.prepareTagReload(var4));
    }

    public static List<HolderLookup.b<?>> buildUpdatedLookups(IRegistryCustom.Dimension var0, List<IRegistry.a<?>> var1) {
        ArrayList var22 = new ArrayList();
        var0.registries().forEach(var2 -> {
            IRegistry.a var3 = TagDataPack.findTagsForRegistry(var1, var2.key());
            var22.add(var3 != null ? var3.lookup() : var2.value());
        });
        return var22;
    }

    @Nullable
    private static IRegistry.a<?> findTagsForRegistry(List<IRegistry.a<?>> var0, ResourceKey<? extends IRegistry<?>> var1) {
        for (IRegistry.a<?> var3 : var0) {
            if (var3.key() != var1) continue;
            return var3;
        }
        return null;
    }

    public static interface a<T> {
        public Optional<? extends T> get(MinecraftKey var1, boolean var2);

        public static <T> a<? extends Holder<T>> fromFrozenRegistry(IRegistry<T> var0) {
            return (var1, var2) -> var0.get(var1);
        }

        public static <T> a<Holder<T>> fromWritableRegistry(IRegistryWritable<T> var0) {
            HolderGetter var1 = var0.createRegistrationLookup();
            return (var2, var3) -> (var3 ? var1 : var0).get(ResourceKey.create(var0.key(), var2));
        }
    }

    public static final class b
    extends Record {
        final TagEntry entry;
        private final String source;

        public b(TagEntry var0, String var1) {
            this.entry = var0;
            this.source = var1;
        }

        @Override
        public String toString() {
            return String.valueOf(this.entry) + " (from " + this.source + ")";
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "entry;source", "entry", "source"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "entry;source", "entry", "source"}, this, var0);
        }

        public TagEntry entry() {
            return this.entry;
        }

        public String source() {
            return this.source;
        }
    }

    public static final class c<T>
    extends Record {
        private final ResourceKey<? extends IRegistry<T>> key;
        final Map<TagKey<T>, List<Holder<T>>> tags;

        public c(ResourceKey<? extends IRegistry<T>> var0, Map<TagKey<T>, List<Holder<T>>> var1) {
            this.key = var0;
            this.tags = var1;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "key;tags", "key", "tags"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "key;tags", "key", "tags"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "key;tags", "key", "tags"}, this, var0);
        }

        public ResourceKey<? extends IRegistry<T>> key() {
            return this.key;
        }

        public Map<TagKey<T>, List<Holder<T>>> tags() {
            return this.tags;
        }
    }

    static final class d
    extends Record
    implements DependencySorter.a<MinecraftKey> {
        final List<b> entries;

        d(List<b> var0) {
            this.entries = var0;
        }

        @Override
        public void visitRequiredDependencies(Consumer<MinecraftKey> var0) {
            this.entries.forEach(var1 -> var1.entry.visitRequiredDependencies(var0));
        }

        @Override
        public void visitOptionalDependencies(Consumer<MinecraftKey> var0) {
            this.entries.forEach(var1 -> var1.entry.visitOptionalDependencies(var0));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{d.class, "entries", "entries"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{d.class, "entries", "entries"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{d.class, "entries", "entries"}, this, var0);
        }

        public List<b> entries() {
            return this.entries;
        }
    }
}

