/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.FileUtils;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkMapDistance;
import net.minecraft.server.level.ChunkResult;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.GenerationChunkHolder;
import net.minecraft.server.level.LightEngineThreaded;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.level.progress.WorldLoadListener;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.thread.IAsyncTaskHandler;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.LocalMobCapCalculator;
import net.minecraft.world.level.SpawnerCreature;
import net.minecraft.world.level.TicketStorage;
import net.minecraft.world.level.World;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.IChunkProvider;
import net.minecraft.world.level.chunk.LightChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.entity.ChunkStatusUpdateListener;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.saveddata.PersistentBase;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.WorldPersistentData;
import org.slf4j.Logger;

public class ChunkProviderServer
extends IChunkProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final ChunkMapDistance distanceManager;
    private final WorldServer level;
    final Thread mainThread;
    final LightEngineThreaded lightEngine;
    private final a mainThreadProcessor;
    public final PlayerChunkMap chunkMap;
    private final WorldPersistentData dataStorage;
    public final TicketStorage ticketStorage;
    private long lastInhabitedUpdate;
    public boolean spawnEnemies = true;
    public boolean spawnFriendlies = true;
    private static final int CACHE_SIZE = 4;
    private final long[] lastChunkPos = new long[4];
    private final ChunkStatus[] lastChunkStatus = new ChunkStatus[4];
    private final IChunkAccess[] lastChunk = new IChunkAccess[4];
    private final List<Chunk> spawningChunks = new ObjectArrayList();
    private final Set<PlayerChunk> chunkHoldersToBroadcast = new ReferenceOpenHashSet();
    @Nullable
    @VisibleForDebug
    private SpawnerCreature.d lastSpawnState;

    public ChunkProviderServer(WorldServer var0, Convertable.ConversionSession var1, DataFixer var2, StructureTemplateManager var3, Executor var4, ChunkGenerator var5, int var6, int var7, boolean var8, WorldLoadListener var9, ChunkStatusUpdateListener var10, Supplier<WorldPersistentData> var11) {
        this.level = var0;
        this.mainThreadProcessor = new a(var0);
        this.mainThread = Thread.currentThread();
        Path var12 = var1.getDimensionPath(var0.dimension()).resolve("data");
        try {
            FileUtils.createDirectoriesSafe(var12);
        }
        catch (IOException var13) {
            LOGGER.error("Failed to create dimension data storage directory", (Throwable)var13);
        }
        this.dataStorage = new WorldPersistentData(new PersistentBase.a(var0), var12, var2, var0.registryAccess());
        this.ticketStorage = this.dataStorage.computeIfAbsent(TicketStorage.TYPE);
        this.chunkMap = new PlayerChunkMap(var0, var1, var2, var3, var4, this.mainThreadProcessor, this, var5, var9, var10, var11, this.ticketStorage, var6, var8);
        this.lightEngine = this.chunkMap.getLightEngine();
        this.distanceManager = this.chunkMap.getDistanceManager();
        this.distanceManager.updateSimulationDistance(var7);
        this.clearCache();
    }

    @Override
    public LightEngineThreaded getLightEngine() {
        return this.lightEngine;
    }

    @Nullable
    private PlayerChunk getVisibleChunkIfPresent(long var0) {
        return this.chunkMap.getVisibleChunkIfPresent(var0);
    }

    public int getTickingGenerated() {
        return this.chunkMap.getTickingGenerated();
    }

    private void storeInCache(long var0, @Nullable IChunkAccess var2, ChunkStatus var3) {
        for (int var4 = 3; var4 > 0; --var4) {
            this.lastChunkPos[var4] = this.lastChunkPos[var4 - 1];
            this.lastChunkStatus[var4] = this.lastChunkStatus[var4 - 1];
            this.lastChunk[var4] = this.lastChunk[var4 - 1];
        }
        this.lastChunkPos[0] = var0;
        this.lastChunkStatus[0] = var3;
        this.lastChunk[0] = var2;
    }

    @Override
    @Nullable
    public IChunkAccess getChunk(int var0, int var1, ChunkStatus var2, boolean var3) {
        Object var8;
        if (Thread.currentThread() != this.mainThread) {
            return CompletableFuture.supplyAsync(() -> this.getChunk(var0, var1, var2, var3), this.mainThreadProcessor).join();
        }
        GameProfilerFiller var4 = Profiler.get();
        var4.incrementCounter("getChunk");
        long var5 = ChunkCoordIntPair.asLong(var0, var1);
        for (int var7 = 0; var7 < 4; ++var7) {
            if (var5 != this.lastChunkPos[var7] || var2 != this.lastChunkStatus[var7] || (var8 = this.lastChunk[var7]) == null && var3) continue;
            return var8;
        }
        var4.incrementCounter("getChunkCacheMiss");
        CompletableFuture<ChunkResult<IChunkAccess>> var7 = this.getChunkFutureMainThread(var0, var1, var2, var3);
        this.mainThreadProcessor.managedBlock(var7::isDone);
        var8 = var7.join();
        IChunkAccess var9 = var8.orElse(null);
        if (var9 == null && var3) {
            throw SystemUtils.pauseInIde(new IllegalStateException("Chunk not there when requested: " + var8.getError()));
        }
        this.storeInCache(var5, var9, var2);
        return var9;
    }

    @Override
    @Nullable
    public Chunk getChunkNow(int var0, int var1) {
        if (Thread.currentThread() != this.mainThread) {
            return null;
        }
        Profiler.get().incrementCounter("getChunkNow");
        long var2 = ChunkCoordIntPair.asLong(var0, var1);
        for (int var4 = 0; var4 < 4; ++var4) {
            if (var2 != this.lastChunkPos[var4] || this.lastChunkStatus[var4] != ChunkStatus.FULL) continue;
            IChunkAccess var5 = this.lastChunk[var4];
            return var5 instanceof Chunk ? (Chunk)var5 : null;
        }
        PlayerChunk var4 = this.getVisibleChunkIfPresent(var2);
        if (var4 == null) {
            return null;
        }
        IChunkAccess var5 = var4.getChunkIfPresent(ChunkStatus.FULL);
        if (var5 != null) {
            this.storeInCache(var2, var5, ChunkStatus.FULL);
            if (var5 instanceof Chunk) {
                return (Chunk)var5;
            }
        }
        return null;
    }

    private void clearCache() {
        Arrays.fill(this.lastChunkPos, ChunkCoordIntPair.INVALID_CHUNK_POS);
        Arrays.fill(this.lastChunkStatus, null);
        Arrays.fill(this.lastChunk, null);
    }

    public CompletableFuture<ChunkResult<IChunkAccess>> getChunkFuture(int var02, int var1, ChunkStatus var2, boolean var3) {
        CompletionStage<ChunkResult<IChunkAccess>> var5;
        boolean var4;
        boolean bl = var4 = Thread.currentThread() == this.mainThread;
        if (var4) {
            var5 = this.getChunkFutureMainThread(var02, var1, var2, var3);
            this.mainThreadProcessor.managedBlock(() -> var5.isDone());
        } else {
            var5 = CompletableFuture.supplyAsync(() -> this.getChunkFutureMainThread(var02, var1, var2, var3), this.mainThreadProcessor).thenCompose(var0 -> var0);
        }
        return var5;
    }

    private CompletableFuture<ChunkResult<IChunkAccess>> getChunkFutureMainThread(int var0, int var1, ChunkStatus var2, boolean var3) {
        ChunkCoordIntPair var4 = new ChunkCoordIntPair(var0, var1);
        long var5 = var4.toLong();
        int var7 = ChunkLevel.byStatus(var2);
        PlayerChunk var8 = this.getVisibleChunkIfPresent(var5);
        if (var3) {
            this.addTicket(new Ticket(TicketType.UNKNOWN, var7), var4);
            if (this.chunkAbsent(var8, var7)) {
                GameProfilerFiller var9 = Profiler.get();
                var9.push("chunkLoad");
                this.runDistanceManagerUpdates();
                var8 = this.getVisibleChunkIfPresent(var5);
                var9.pop();
                if (this.chunkAbsent(var8, var7)) {
                    throw SystemUtils.pauseInIde(new IllegalStateException("No chunk holder after ticket has been added"));
                }
            }
        }
        if (this.chunkAbsent(var8, var7)) {
            return GenerationChunkHolder.UNLOADED_CHUNK_FUTURE;
        }
        return var8.scheduleChunkGenerationTask(var2, this.chunkMap);
    }

    private boolean chunkAbsent(@Nullable PlayerChunk var0, int var1) {
        return var0 == null || var0.getTicketLevel() > var1;
    }

    @Override
    public boolean hasChunk(int var0, int var1) {
        int var3;
        PlayerChunk var2 = this.getVisibleChunkIfPresent(new ChunkCoordIntPair(var0, var1).toLong());
        return !this.chunkAbsent(var2, var3 = ChunkLevel.byStatus(ChunkStatus.FULL));
    }

    @Override
    @Nullable
    public LightChunk getChunkForLighting(int var0, int var1) {
        long var2 = ChunkCoordIntPair.asLong(var0, var1);
        PlayerChunk var4 = this.getVisibleChunkIfPresent(var2);
        if (var4 == null) {
            return null;
        }
        return var4.getChunkIfPresentUnchecked(ChunkStatus.INITIALIZE_LIGHT.getParent());
    }

    @Override
    public World getLevel() {
        return this.level;
    }

    public boolean pollTask() {
        return this.mainThreadProcessor.pollTask();
    }

    boolean runDistanceManagerUpdates() {
        boolean var0 = this.distanceManager.runAllUpdates(this.chunkMap);
        boolean var1 = this.chunkMap.promoteChunkMap();
        this.chunkMap.runGenerationTasks();
        if (var0 || var1) {
            this.clearCache();
            return true;
        }
        return false;
    }

    public boolean isPositionTicking(long var0) {
        if (!this.level.shouldTickBlocksAt(var0)) {
            return false;
        }
        PlayerChunk var2 = this.getVisibleChunkIfPresent(var0);
        if (var2 == null) {
            return false;
        }
        return var2.getTickingChunkFuture().getNow(PlayerChunk.UNLOADED_LEVEL_CHUNK).isSuccess();
    }

    public void save(boolean var0) {
        this.runDistanceManagerUpdates();
        this.chunkMap.saveAllChunks(var0);
    }

    @Override
    public void close() throws IOException {
        this.save(true);
        this.dataStorage.close();
        this.lightEngine.close();
        this.chunkMap.close();
    }

    @Override
    public void tick(BooleanSupplier var0, boolean var1) {
        GameProfilerFiller var2 = Profiler.get();
        var2.push("purge");
        if (this.level.tickRateManager().runsNormally() || !var1) {
            this.ticketStorage.purgeStaleTickets();
        }
        this.runDistanceManagerUpdates();
        var2.popPush("chunks");
        if (var1) {
            this.tickChunks();
            this.chunkMap.tick();
        }
        var2.popPush("unload");
        this.chunkMap.tick(var0);
        var2.pop();
        this.clearCache();
    }

    private void tickChunks() {
        long var0 = this.level.getGameTime();
        long var2 = var0 - this.lastInhabitedUpdate;
        this.lastInhabitedUpdate = var0;
        if (this.level.isDebug()) {
            return;
        }
        GameProfilerFiller var4 = Profiler.get();
        var4.push("pollingChunks");
        if (this.level.tickRateManager().runsNormally()) {
            var4.push("tickingChunks");
            this.tickChunks(var4, var2);
            var4.pop();
        }
        this.broadcastChangedChunks(var4);
        var4.pop();
    }

    private void broadcastChangedChunks(GameProfilerFiller var0) {
        var0.push("broadcast");
        for (PlayerChunk var2 : this.chunkHoldersToBroadcast) {
            Chunk var3 = var2.getTickingChunk();
            if (var3 == null) continue;
            var2.broadcastChanges(var3);
        }
        this.chunkHoldersToBroadcast.clear();
        var0.pop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tickChunks(GameProfilerFiller var0, long var12) {
        List<EnumCreatureType> var7;
        SpawnerCreature.d var4;
        var0.popPush("naturalSpawnCount");
        int var3 = this.distanceManager.getNaturalSpawnChunkCount();
        this.lastSpawnState = var4 = SpawnerCreature.createState(var3, this.level.getAllEntities(), this::getFullChunk, new LocalMobCapCalculator(this.chunkMap));
        var0.popPush("spawnAndTick");
        boolean var5 = this.level.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING);
        int var6 = this.level.getGameRules().getInt(GameRules.RULE_RANDOMTICKING);
        if (var5 && (this.spawnEnemies || this.spawnFriendlies)) {
            boolean var8 = this.level.getLevelData().getGameTime() % 400L == 0L;
            var7 = SpawnerCreature.getFilteredSpawningCategories(var4, this.spawnFriendlies, this.spawnEnemies, var8);
        } else {
            var7 = List.of();
        }
        List<Chunk> var8 = this.spawningChunks;
        try {
            var0.push("filteringSpawningChunks");
            this.chunkMap.collectSpawningChunks(var8);
            var0.popPush("shuffleSpawningChunks");
            SystemUtils.shuffle(var8, this.level.random);
            var0.popPush("tickSpawningChunks");
            for (Chunk var10 : var8) {
                this.tickSpawningChunk(var10, var12, var7, var4);
            }
        }
        finally {
            var8.clear();
        }
        var0.popPush("tickTickingChunks");
        this.chunkMap.forEachBlockTickingChunk(var1 -> this.level.tickChunk((Chunk)var1, var6));
        var0.pop();
        var0.popPush("customSpawners");
        if (var5) {
            this.level.tickCustomSpawners(this.spawnEnemies, this.spawnFriendlies);
        }
    }

    private void tickSpawningChunk(Chunk var0, long var1, List<EnumCreatureType> var3, SpawnerCreature.d var4) {
        ChunkCoordIntPair var5 = var0.getPos();
        var0.incrementInhabitedTime(var1);
        if (this.distanceManager.inEntityTickingRange(var5.toLong())) {
            this.level.tickThunder(var0);
        }
        if (var3.isEmpty()) {
            return;
        }
        if (this.level.canSpawnEntitiesInChunk(var5)) {
            SpawnerCreature.spawnForChunk(this.level, var0, var4, var3);
        }
    }

    private void getFullChunk(long var0, Consumer<Chunk> var2) {
        PlayerChunk var3 = this.getVisibleChunkIfPresent(var0);
        if (var3 != null) {
            var3.getFullChunkFuture().getNow(PlayerChunk.UNLOADED_LEVEL_CHUNK).ifSuccess(var2);
        }
    }

    @Override
    public String gatherStats() {
        return Integer.toString(this.getLoadedChunksCount());
    }

    @VisibleForTesting
    public int getPendingTasksCount() {
        return this.mainThreadProcessor.getPendingTasksCount();
    }

    public ChunkGenerator getGenerator() {
        return this.chunkMap.generator();
    }

    public ChunkGeneratorStructureState getGeneratorState() {
        return this.chunkMap.generatorState();
    }

    public RandomState randomState() {
        return this.chunkMap.randomState();
    }

    @Override
    public int getLoadedChunksCount() {
        return this.chunkMap.size();
    }

    public void blockChanged(BlockPosition var0) {
        int var2;
        int var1 = SectionPosition.blockToSectionCoord(var0.getX());
        PlayerChunk var3 = this.getVisibleChunkIfPresent(ChunkCoordIntPair.asLong(var1, var2 = SectionPosition.blockToSectionCoord(var0.getZ())));
        if (var3 != null && var3.blockChanged(var0)) {
            this.chunkHoldersToBroadcast.add(var3);
        }
    }

    @Override
    public void onLightUpdate(EnumSkyBlock var0, SectionPosition var1) {
        this.mainThreadProcessor.execute(() -> {
            PlayerChunk var2 = this.getVisibleChunkIfPresent(var1.chunk().toLong());
            if (var2 != null && var2.sectionLightChanged(var0, var1.y())) {
                this.chunkHoldersToBroadcast.add(var2);
            }
        });
    }

    public void addTicket(Ticket var0, ChunkCoordIntPair var1) {
        this.ticketStorage.addTicket(var0, var1);
    }

    public void addTicketWithRadius(TicketType var0, ChunkCoordIntPair var1, int var2) {
        this.ticketStorage.addTicketWithRadius(var0, var1, var2);
    }

    public void removeTicketWithRadius(TicketType var0, ChunkCoordIntPair var1, int var2) {
        this.ticketStorage.removeTicketWithRadius(var0, var1, var2);
    }

    @Override
    public boolean updateChunkForced(ChunkCoordIntPair var0, boolean var1) {
        return this.ticketStorage.updateChunkForced(var0, var1);
    }

    @Override
    public LongSet getForceLoadedChunks() {
        return this.ticketStorage.getForceLoadedChunks();
    }

    public void move(EntityPlayer var0) {
        if (!var0.isRemoved()) {
            this.chunkMap.move(var0);
        }
    }

    public void removeEntity(Entity var0) {
        this.chunkMap.removeEntity(var0);
    }

    public void addEntity(Entity var0) {
        this.chunkMap.addEntity(var0);
    }

    public void broadcastAndSend(Entity var0, Packet<?> var1) {
        this.chunkMap.broadcastAndSend(var0, var1);
    }

    public void broadcast(Entity var0, Packet<?> var1) {
        this.chunkMap.broadcast(var0, var1);
    }

    public void setViewDistance(int var0) {
        this.chunkMap.setServerViewDistance(var0);
    }

    public void setSimulationDistance(int var0) {
        this.distanceManager.updateSimulationDistance(var0);
    }

    @Override
    public void setSpawnSettings(boolean var0) {
        this.spawnEnemies = var0;
        this.spawnFriendlies = this.spawnFriendlies;
    }

    public String getChunkDebugData(ChunkCoordIntPair var0) {
        return this.chunkMap.getChunkDebugData(var0);
    }

    public WorldPersistentData getDataStorage() {
        return this.dataStorage;
    }

    public VillagePlace getPoiManager() {
        return this.chunkMap.getPoiManager();
    }

    public ChunkScanAccess chunkScanner() {
        return this.chunkMap.chunkScanner();
    }

    @Nullable
    @VisibleForDebug
    public SpawnerCreature.d getLastSpawnState() {
        return this.lastSpawnState;
    }

    public void deactivateTicketsOnClosing() {
        this.ticketStorage.deactivateTicketsOnClosing();
    }

    public void onChunkReadyToSend(PlayerChunk var0) {
        if (var0.hasChangesToBroadcast()) {
            this.chunkHoldersToBroadcast.add(var0);
        }
    }

    @Override
    public /* synthetic */ LevelLightEngine getLightEngine() {
        return this.getLightEngine();
    }

    @Override
    public /* synthetic */ IBlockAccess getLevel() {
        return this.getLevel();
    }

    final class a
    extends IAsyncTaskHandler<Runnable> {
        a(World var1) {
            super("Chunk source main thread executor for " + String.valueOf(var1.dimension().location()));
        }

        @Override
        public void managedBlock(BooleanSupplier var0) {
            super.managedBlock(() -> MinecraftServer.throwIfFatalException() && var0.getAsBoolean());
        }

        @Override
        public Runnable wrapRunnable(Runnable var0) {
            return var0;
        }

        @Override
        protected boolean shouldRun(Runnable var0) {
            return true;
        }

        @Override
        protected boolean scheduleExecutables() {
            return true;
        }

        @Override
        protected Thread getRunningThread() {
            return ChunkProviderServer.this.mainThread;
        }

        @Override
        protected void doRunTask(Runnable var0) {
            Profiler.get().incrementCounter("runTask");
            super.doRunTask(var0);
        }

        @Override
        protected boolean pollTask() {
            if (ChunkProviderServer.this.runDistanceManagerUpdates()) {
                return true;
            }
            ChunkProviderServer.this.lightEngine.tryScheduleUpdate();
            return super.pollTask();
        }
    }
}

