/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.minecraft.EnumChatFormat;
import net.minecraft.SharedConstants;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.util.profiling.jfr.Environment;
import net.minecraft.util.profiling.jfr.JvmProfiler;

public class JfrCommand {
    private static final SimpleCommandExceptionType START_FAILED = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.jfr.start.failed"));
    private static final DynamicCommandExceptionType DUMP_FAILED = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatableEscape("commands.jfr.dump.failed", var0));

    private JfrCommand() {
    }

    public static void register(CommandDispatcher<CommandListenerWrapper> var02) {
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("jfr").requires(var0 -> var0.hasPermission(4))).then(net.minecraft.commands.CommandDispatcher.literal("start").executes(var0 -> JfrCommand.startJfr((CommandListenerWrapper)var0.getSource())))).then(net.minecraft.commands.CommandDispatcher.literal("stop").executes(var0 -> JfrCommand.stopJfr((CommandListenerWrapper)var0.getSource()))));
    }

    private static int startJfr(CommandListenerWrapper var0) throws CommandSyntaxException {
        Environment var1 = Environment.from(var0.getServer());
        if (!JvmProfiler.INSTANCE.start(var1)) {
            throw START_FAILED.create();
        }
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.jfr.started"), false);
        return 1;
    }

    private static int stopJfr(CommandListenerWrapper var0) throws CommandSyntaxException {
        try {
            Path var12 = Paths.get(".", new String[0]).relativize(JvmProfiler.INSTANCE.stop().normalize());
            Path var2 = !var0.getServer().isPublished() || SharedConstants.IS_RUNNING_IN_IDE ? var12.toAbsolutePath() : var12;
            IChatMutableComponent var3 = IChatBaseComponent.literal(var12.toString()).withStyle(EnumChatFormat.UNDERLINE).withStyle(var1 -> var1.withClickEvent(new ChatClickable.CopyToClipboard(var2.toString())).withHoverEvent(new ChatHoverable.e(IChatBaseComponent.translatable("chat.copy.click"))));
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.jfr.stopped", var3), false);
            return 1;
        }
        catch (Throwable var13) {
            throw DUMP_FAILED.create((Object)var13.getMessage());
        }
    }
}

