/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentNBTTag;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.arguments.coordinates.ArgumentVec3;
import net.minecraft.commands.synchronization.CompletionProviders;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.Vec3D;

public class CommandSummon {
    private static final SimpleCommandExceptionType ERROR_FAILED = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.summon.failed"));
    private static final SimpleCommandExceptionType ERROR_DUPLICATE_UUID = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.summon.failed.uuid"));
    private static final SimpleCommandExceptionType INVALID_POSITION = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.summon.invalidPosition"));

    public static void register(CommandDispatcher<CommandListenerWrapper> var02, CommandBuildContext var1) {
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("summon").requires(var0 -> var0.hasPermission(2))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("entity", ResourceArgument.resource(var1, Registries.ENTITY_TYPE)).suggests(CompletionProviders.SUMMONABLE_ENTITIES).executes(var0 -> CommandSummon.spawnEntity((CommandListenerWrapper)var0.getSource(), ResourceArgument.getSummonableEntityType((CommandContext<CommandListenerWrapper>)var0, "entity"), ((CommandListenerWrapper)var0.getSource()).getPosition(), new NBTTagCompound(), true))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("pos", ArgumentVec3.vec3()).executes(var0 -> CommandSummon.spawnEntity((CommandListenerWrapper)var0.getSource(), ResourceArgument.getSummonableEntityType((CommandContext<CommandListenerWrapper>)var0, "entity"), ArgumentVec3.getVec3((CommandContext<CommandListenerWrapper>)var0, "pos"), new NBTTagCompound(), true))).then(net.minecraft.commands.CommandDispatcher.argument("nbt", ArgumentNBTTag.compoundTag()).executes(var0 -> CommandSummon.spawnEntity((CommandListenerWrapper)var0.getSource(), ResourceArgument.getSummonableEntityType((CommandContext<CommandListenerWrapper>)var0, "entity"), ArgumentVec3.getVec3((CommandContext<CommandListenerWrapper>)var0, "pos"), ArgumentNBTTag.getCompoundTag(var0, "nbt"), false))))));
    }

    public static Entity createEntity(CommandListenerWrapper var0, Holder.c<EntityTypes<?>> var12, Vec3D var2, NBTTagCompound var3, boolean var4) throws CommandSyntaxException {
        BlockPosition var5 = BlockPosition.containing(var2);
        if (!World.isInSpawnableBounds(var5)) {
            throw INVALID_POSITION.create();
        }
        NBTTagCompound var6 = var3.copy();
        var6.putString("id", var12.key().location().toString());
        WorldServer var7 = var0.getLevel();
        Entity var8 = EntityTypes.loadEntityRecursive(var6, var7, EntitySpawnReason.COMMAND, var1 -> {
            var1.snapTo(var0.x, var0.y, var0.z, var1.getYRot(), var1.getXRot());
            return var1;
        });
        if (var8 == null) {
            throw ERROR_FAILED.create();
        }
        if (var4 && var8 instanceof EntityInsentient) {
            ((EntityInsentient)var8).finalizeSpawn(var0.getLevel(), var0.getLevel().getCurrentDifficultyAt(var8.blockPosition()), EntitySpawnReason.COMMAND, null);
        }
        if (!var7.tryAddFreshEntityWithPassengers(var8)) {
            throw ERROR_DUPLICATE_UUID.create();
        }
        return var8;
    }

    private static int spawnEntity(CommandListenerWrapper var0, Holder.c<EntityTypes<?>> var1, Vec3D var2, NBTTagCompound var3, boolean var4) throws CommandSyntaxException {
        Entity var5 = CommandSummon.createEntity(var0, var1, var2, var3, var4);
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.summon.success", var5.getDisplayName()), true);
        return 1;
    }
}

