/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentAngle;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.level.World;

public class CommandSpawnpoint {
    public static void register(CommandDispatcher<CommandListenerWrapper> var02) {
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("spawnpoint").requires(var0 -> var0.hasPermission(2))).executes(var0 -> CommandSpawnpoint.setSpawn((CommandListenerWrapper)var0.getSource(), Collections.singleton(((CommandListenerWrapper)var0.getSource()).getPlayerOrException()), BlockPosition.containing(((CommandListenerWrapper)var0.getSource()).getPosition()), 0.0f))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("targets", ArgumentEntity.players()).executes(var0 -> CommandSpawnpoint.setSpawn((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var0, "targets"), BlockPosition.containing(((CommandListenerWrapper)var0.getSource()).getPosition()), 0.0f))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("pos", ArgumentPosition.blockPos()).executes(var0 -> CommandSpawnpoint.setSpawn((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var0, "targets"), ArgumentPosition.getSpawnablePos((CommandContext<CommandListenerWrapper>)var0, "pos"), 0.0f))).then(net.minecraft.commands.CommandDispatcher.argument("angle", ArgumentAngle.angle()).executes(var0 -> CommandSpawnpoint.setSpawn((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var0, "targets"), ArgumentPosition.getSpawnablePos((CommandContext<CommandListenerWrapper>)var0, "pos"), ArgumentAngle.getAngle((CommandContext<CommandListenerWrapper>)var0, "angle")))))));
    }

    private static int setSpawn(CommandListenerWrapper var0, Collection<EntityPlayer> var1, BlockPosition var2, float var3) {
        ResourceKey<World> var4 = var0.getLevel().dimension();
        for (EntityPlayer var6 : var1) {
            var6.setRespawnPosition(new EntityPlayer.RespawnConfig(var4, var2, var3, true), false);
        }
        String var5 = var4.location().toString();
        if (var1.size() == 1) {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.spawnpoint.success.single", var2.getX(), var2.getY(), var2.getZ(), Float.valueOf(var3), var5, ((EntityPlayer)var1.iterator().next()).getDisplayName()), true);
        } else {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.spawnpoint.success.multiple", var2.getX(), var2.getY(), var2.getZ(), Float.valueOf(var3), var5, var1.size()), true);
        }
        return var1.size();
    }
}

