/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentProfile;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.players.PlayerList;

public class CommandOp {
    private static final SimpleCommandExceptionType ERROR_ALREADY_OP = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.op.failed"));

    public static void register(CommandDispatcher<CommandListenerWrapper> var03) {
        var03.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("op").requires(var0 -> var0.hasPermission(3))).then(net.minecraft.commands.CommandDispatcher.argument("targets", ArgumentProfile.gameProfile()).suggests((var02, var12) -> {
            PlayerList var2 = ((CommandListenerWrapper)var02.getSource()).getServer().getPlayerList();
            return ICompletionProvider.suggest(var2.getPlayers().stream().filter(var1 -> !var2.isOp(var1.getGameProfile())).map(var0 -> var0.getGameProfile().getName()), var12);
        }).executes(var0 -> CommandOp.opPlayers((CommandListenerWrapper)var0.getSource(), ArgumentProfile.getGameProfiles((CommandContext<CommandListenerWrapper>)var0, "targets")))));
    }

    private static int opPlayers(CommandListenerWrapper var0, Collection<GameProfile> var1) throws CommandSyntaxException {
        PlayerList var2 = var0.getServer().getPlayerList();
        int var3 = 0;
        for (GameProfile var5 : var1) {
            if (var2.isOp(var5)) continue;
            var2.op(var5);
            ++var3;
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.op.success", var5.getName()), true);
        }
        if (var3 == 0) {
            throw ERROR_ALREADY_OP.create();
        }
        return var3;
    }
}

