/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.RedirectModifier;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ContextChain;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.CommandResultCallback;
import net.minecraft.commands.ExecutionCommandSource;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.commands.arguments.ArgumentCriterionValue;
import net.minecraft.commands.arguments.ArgumentDimension;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ArgumentMinecraftKeyRegistered;
import net.minecraft.commands.arguments.ArgumentNBTKey;
import net.minecraft.commands.arguments.ArgumentScoreboardObjective;
import net.minecraft.commands.arguments.ArgumentScoreholder;
import net.minecraft.commands.arguments.HeightmapTypeArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.arguments.ResourceOrIdArgument;
import net.minecraft.commands.arguments.ResourceOrTagArgument;
import net.minecraft.commands.arguments.SlotsArgument;
import net.minecraft.commands.arguments.blocks.ArgumentBlockPredicate;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.commands.arguments.coordinates.ArgumentRotation;
import net.minecraft.commands.arguments.coordinates.ArgumentRotationAxis;
import net.minecraft.commands.arguments.coordinates.ArgumentVec3;
import net.minecraft.commands.arguments.item.ArgumentItemPredicate;
import net.minecraft.commands.arguments.item.ArgumentTag;
import net.minecraft.commands.execution.ChainModifiers;
import net.minecraft.commands.execution.CustomModifierExecutor;
import net.minecraft.commands.execution.ExecutionControl;
import net.minecraft.commands.execution.tasks.CallFunction;
import net.minecraft.commands.execution.tasks.FallthroughTask;
import net.minecraft.commands.functions.InstantiatedFunction;
import net.minecraft.commands.synchronization.CompletionProviders;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.ReloadableServerRegistries;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.server.bossevents.BossBattleCustom;
import net.minecraft.server.commands.CommandBossBar;
import net.minecraft.server.commands.CommandFunction;
import net.minecraft.server.commands.CommandSummon;
import net.minecraft.server.commands.InCommandFunction;
import net.minecraft.server.commands.ItemCommands;
import net.minecraft.server.commands.data.CommandData;
import net.minecraft.server.commands.data.CommandDataAccessor;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.Attackable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.Targeting;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.inventory.SlotRange;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.ReadOnlyScoreInfo;
import net.minecraft.world.scores.ScoreAccess;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.ScoreboardObjective;

public class CommandExecute {
    private static final int MAX_TEST_AREA = 32768;
    private static final Dynamic2CommandExceptionType ERROR_AREA_TOO_LARGE = new Dynamic2CommandExceptionType((var0, var1) -> IChatBaseComponent.translatableEscape("commands.execute.blocks.toobig", var0, var1));
    private static final SimpleCommandExceptionType ERROR_CONDITIONAL_FAILED = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.execute.conditional.fail"));
    private static final DynamicCommandExceptionType ERROR_CONDITIONAL_FAILED_COUNT = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatableEscape("commands.execute.conditional.fail_count", var0));
    @VisibleForTesting
    public static final Dynamic2CommandExceptionType ERROR_FUNCTION_CONDITION_INSTANTATION_FAILURE = new Dynamic2CommandExceptionType((var0, var1) -> IChatBaseComponent.translatableEscape("commands.execute.function.instantiationFailure", var0, var1));
    private static final SuggestionProvider<CommandListenerWrapper> SUGGEST_PREDICATE = (var0, var1) -> {
        ReloadableServerRegistries.a var2 = ((CommandListenerWrapper)var0.getSource()).getServer().reloadableRegistries();
        return ICompletionProvider.suggestResource(var2.getKeys(Registries.PREDICATE), var1);
    };

    public static void register(CommandDispatcher<CommandListenerWrapper> var02, CommandBuildContext var1) {
        LiteralCommandNode var2 = var02.register((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("execute").requires(var0 -> var0.hasPermission(2)));
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("execute").requires(var0 -> var0.hasPermission(2))).then(net.minecraft.commands.CommandDispatcher.literal("run").redirect((CommandNode)var02.getRoot()))).then(CommandExecute.addConditionals((CommandNode<CommandListenerWrapper>)var2, net.minecraft.commands.CommandDispatcher.literal("if"), true, var1))).then(CommandExecute.addConditionals((CommandNode<CommandListenerWrapper>)var2, net.minecraft.commands.CommandDispatcher.literal("unless"), false, var1))).then(net.minecraft.commands.CommandDispatcher.literal("as").then(net.minecraft.commands.CommandDispatcher.argument("targets", ArgumentEntity.entities()).fork((CommandNode)var2, var0 -> {
            ArrayList var1 = Lists.newArrayList();
            for (Entity entity : ArgumentEntity.getOptionalEntities((CommandContext<CommandListenerWrapper>)var0, "targets")) {
                var1.add(((CommandListenerWrapper)var0.getSource()).withEntity(entity));
            }
            return var1;
        })))).then(net.minecraft.commands.CommandDispatcher.literal("at").then(net.minecraft.commands.CommandDispatcher.argument("targets", ArgumentEntity.entities()).fork((CommandNode)var2, var0 -> {
            ArrayList var1 = Lists.newArrayList();
            for (Entity entity : ArgumentEntity.getOptionalEntities((CommandContext<CommandListenerWrapper>)var0, "targets")) {
                var1.add(((CommandListenerWrapper)var0.getSource()).withLevel((WorldServer)entity.level()).withPosition(entity.position()).withRotation(entity.getRotationVector()));
            }
            return var1;
        })))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("store").then(CommandExecute.wrapStores((LiteralCommandNode<CommandListenerWrapper>)var2, net.minecraft.commands.CommandDispatcher.literal("result"), true))).then(CommandExecute.wrapStores((LiteralCommandNode<CommandListenerWrapper>)var2, net.minecraft.commands.CommandDispatcher.literal("success"), false)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("positioned").then(net.minecraft.commands.CommandDispatcher.argument("pos", ArgumentVec3.vec3()).redirect((CommandNode)var2, var0 -> ((CommandListenerWrapper)var0.getSource()).withPosition(ArgumentVec3.getVec3((CommandContext<CommandListenerWrapper>)var0, "pos")).withAnchor(ArgumentAnchor.Anchor.FEET)))).then(net.minecraft.commands.CommandDispatcher.literal("as").then(net.minecraft.commands.CommandDispatcher.argument("targets", ArgumentEntity.entities()).fork((CommandNode)var2, var0 -> {
            ArrayList var1 = Lists.newArrayList();
            for (Entity entity : ArgumentEntity.getOptionalEntities((CommandContext<CommandListenerWrapper>)var0, "targets")) {
                var1.add(((CommandListenerWrapper)var0.getSource()).withPosition(entity.position()));
            }
            return var1;
        })))).then(net.minecraft.commands.CommandDispatcher.literal("over").then(net.minecraft.commands.CommandDispatcher.argument("heightmap", HeightmapTypeArgument.heightmap()).redirect((CommandNode)var2, var0 -> {
            Vec3D var1 = ((CommandListenerWrapper)var0.getSource()).getPosition();
            WorldServer var2 = ((CommandListenerWrapper)var0.getSource()).getLevel();
            double var3 = var1.x();
            double var5 = var1.z();
            if (!var2.hasChunk(SectionPosition.blockToSectionCoord(var3), SectionPosition.blockToSectionCoord(var5))) {
                throw ArgumentPosition.ERROR_NOT_LOADED.create();
            }
            int var7 = var2.getHeight(HeightmapTypeArgument.getHeightmap((CommandContext<CommandListenerWrapper>)var0, "heightmap"), MathHelper.floor(var3), MathHelper.floor(var5));
            return ((CommandListenerWrapper)var0.getSource()).withPosition(new Vec3D(var3, var7, var5));
        }))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("rotated").then(net.minecraft.commands.CommandDispatcher.argument("rot", ArgumentRotation.rotation()).redirect((CommandNode)var2, var0 -> ((CommandListenerWrapper)var0.getSource()).withRotation(ArgumentRotation.getRotation((CommandContext<CommandListenerWrapper>)var0, "rot").getRotation((CommandListenerWrapper)var0.getSource()))))).then(net.minecraft.commands.CommandDispatcher.literal("as").then(net.minecraft.commands.CommandDispatcher.argument("targets", ArgumentEntity.entities()).fork((CommandNode)var2, var0 -> {
            ArrayList var1 = Lists.newArrayList();
            for (Entity entity : ArgumentEntity.getOptionalEntities((CommandContext<CommandListenerWrapper>)var0, "targets")) {
                var1.add(((CommandListenerWrapper)var0.getSource()).withRotation(entity.getRotationVector()));
            }
            return var1;
        }))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("facing").then(net.minecraft.commands.CommandDispatcher.literal("entity").then(net.minecraft.commands.CommandDispatcher.argument("targets", ArgumentEntity.entities()).then(net.minecraft.commands.CommandDispatcher.argument("anchor", ArgumentAnchor.anchor()).fork((CommandNode)var2, var0 -> {
            ArrayList var1 = Lists.newArrayList();
            ArgumentAnchor.Anchor var2 = ArgumentAnchor.getAnchor((CommandContext<CommandListenerWrapper>)var0, "anchor");
            for (Entity entity : ArgumentEntity.getOptionalEntities((CommandContext<CommandListenerWrapper>)var0, "targets")) {
                var1.add(((CommandListenerWrapper)var0.getSource()).facing(entity, var2));
            }
            return var1;
        }))))).then(net.minecraft.commands.CommandDispatcher.argument("pos", ArgumentVec3.vec3()).redirect((CommandNode)var2, var0 -> ((CommandListenerWrapper)var0.getSource()).facing(ArgumentVec3.getVec3((CommandContext<CommandListenerWrapper>)var0, "pos")))))).then(net.minecraft.commands.CommandDispatcher.literal("align").then(net.minecraft.commands.CommandDispatcher.argument("axes", ArgumentRotationAxis.swizzle()).redirect((CommandNode)var2, var0 -> ((CommandListenerWrapper)var0.getSource()).withPosition(((CommandListenerWrapper)var0.getSource()).getPosition().align(ArgumentRotationAxis.getSwizzle((CommandContext<CommandListenerWrapper>)var0, "axes"))))))).then(net.minecraft.commands.CommandDispatcher.literal("anchored").then(net.minecraft.commands.CommandDispatcher.argument("anchor", ArgumentAnchor.anchor()).redirect((CommandNode)var2, var0 -> ((CommandListenerWrapper)var0.getSource()).withAnchor(ArgumentAnchor.getAnchor((CommandContext<CommandListenerWrapper>)var0, "anchor")))))).then(net.minecraft.commands.CommandDispatcher.literal("in").then(net.minecraft.commands.CommandDispatcher.argument("dimension", ArgumentDimension.dimension()).redirect((CommandNode)var2, var0 -> ((CommandListenerWrapper)var0.getSource()).withLevel(ArgumentDimension.getDimension((CommandContext<CommandListenerWrapper>)var0, "dimension")))))).then(net.minecraft.commands.CommandDispatcher.literal("summon").then(net.minecraft.commands.CommandDispatcher.argument("entity", ResourceArgument.resource(var1, Registries.ENTITY_TYPE)).suggests(CompletionProviders.SUMMONABLE_ENTITIES).redirect((CommandNode)var2, var0 -> CommandExecute.spawnEntityAndRedirect((CommandListenerWrapper)var0.getSource(), ResourceArgument.getSummonableEntityType((CommandContext<CommandListenerWrapper>)var0, "entity")))))).then(CommandExecute.createRelationOperations((CommandNode<CommandListenerWrapper>)var2, net.minecraft.commands.CommandDispatcher.literal("on"))));
    }

    private static ArgumentBuilder<CommandListenerWrapper, ?> wrapStores(LiteralCommandNode<CommandListenerWrapper> var0, LiteralArgumentBuilder<CommandListenerWrapper> var12, boolean var2) {
        var12.then(net.minecraft.commands.CommandDispatcher.literal("score").then(net.minecraft.commands.CommandDispatcher.argument("targets", ArgumentScoreholder.scoreHolders()).suggests(ArgumentScoreholder.SUGGEST_SCORE_HOLDERS).then(net.minecraft.commands.CommandDispatcher.argument("objective", ArgumentScoreboardObjective.objective()).redirect(var0, var1 -> CommandExecute.storeValue((CommandListenerWrapper)var1.getSource(), ArgumentScoreholder.getNamesWithDefaultWildcard((CommandContext<CommandListenerWrapper>)var1, "targets"), ArgumentScoreboardObjective.getObjective((CommandContext<CommandListenerWrapper>)var1, "objective"), var2)))));
        var12.then(net.minecraft.commands.CommandDispatcher.literal("bossbar").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("id", ArgumentMinecraftKeyRegistered.id()).suggests(CommandBossBar.SUGGEST_BOSS_BAR).then(net.minecraft.commands.CommandDispatcher.literal("value").redirect(var0, var1 -> CommandExecute.storeValue((CommandListenerWrapper)var1.getSource(), CommandBossBar.getBossBar((CommandContext<CommandListenerWrapper>)var1), true, var2)))).then(net.minecraft.commands.CommandDispatcher.literal("max").redirect(var0, var1 -> CommandExecute.storeValue((CommandListenerWrapper)var1.getSource(), CommandBossBar.getBossBar((CommandContext<CommandListenerWrapper>)var1), false, var2)))));
        for (CommandData.c var4 : CommandData.TARGET_PROVIDERS) {
            var4.wrap((ArgumentBuilder<CommandListenerWrapper, ?>)var12, var3 -> var3.then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("path", ArgumentNBTKey.nbtPath()).then(net.minecraft.commands.CommandDispatcher.literal("int").then(net.minecraft.commands.CommandDispatcher.argument("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)var0, var2 -> CommandExecute.storeData((CommandListenerWrapper)var2.getSource(), var4.access((CommandContext<CommandListenerWrapper>)var2), ArgumentNBTKey.getPath((CommandContext<CommandListenerWrapper>)var2, "path"), var1 -> NBTTagInt.valueOf((int)((double)var1 * DoubleArgumentType.getDouble((CommandContext)var2, (String)"scale"))), var2))))).then(net.minecraft.commands.CommandDispatcher.literal("float").then(net.minecraft.commands.CommandDispatcher.argument("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)var0, var2 -> CommandExecute.storeData((CommandListenerWrapper)var2.getSource(), var4.access((CommandContext<CommandListenerWrapper>)var2), ArgumentNBTKey.getPath((CommandContext<CommandListenerWrapper>)var2, "path"), var1 -> NBTTagFloat.valueOf((float)((double)var1 * DoubleArgumentType.getDouble((CommandContext)var2, (String)"scale"))), var2))))).then(net.minecraft.commands.CommandDispatcher.literal("short").then(net.minecraft.commands.CommandDispatcher.argument("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)var0, var2 -> CommandExecute.storeData((CommandListenerWrapper)var2.getSource(), var4.access((CommandContext<CommandListenerWrapper>)var2), ArgumentNBTKey.getPath((CommandContext<CommandListenerWrapper>)var2, "path"), var1 -> NBTTagShort.valueOf((short)((double)var1 * DoubleArgumentType.getDouble((CommandContext)var2, (String)"scale"))), var2))))).then(net.minecraft.commands.CommandDispatcher.literal("long").then(net.minecraft.commands.CommandDispatcher.argument("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)var0, var2 -> CommandExecute.storeData((CommandListenerWrapper)var2.getSource(), var4.access((CommandContext<CommandListenerWrapper>)var2), ArgumentNBTKey.getPath((CommandContext<CommandListenerWrapper>)var2, "path"), var1 -> NBTTagLong.valueOf((long)((double)var1 * DoubleArgumentType.getDouble((CommandContext)var2, (String)"scale"))), var2))))).then(net.minecraft.commands.CommandDispatcher.literal("double").then(net.minecraft.commands.CommandDispatcher.argument("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)var0, var2 -> CommandExecute.storeData((CommandListenerWrapper)var2.getSource(), var4.access((CommandContext<CommandListenerWrapper>)var2), ArgumentNBTKey.getPath((CommandContext<CommandListenerWrapper>)var2, "path"), var1 -> NBTTagDouble.valueOf((double)var1 * DoubleArgumentType.getDouble((CommandContext)var2, (String)"scale")), var2))))).then(net.minecraft.commands.CommandDispatcher.literal("byte").then(net.minecraft.commands.CommandDispatcher.argument("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)var0, var2 -> CommandExecute.storeData((CommandListenerWrapper)var2.getSource(), var4.access((CommandContext<CommandListenerWrapper>)var2), ArgumentNBTKey.getPath((CommandContext<CommandListenerWrapper>)var2, "path"), var1 -> NBTTagByte.valueOf((byte)((double)var1 * DoubleArgumentType.getDouble((CommandContext)var2, (String)"scale"))), var2))))));
        }
        return var12;
    }

    private static CommandListenerWrapper storeValue(CommandListenerWrapper var0, Collection<ScoreHolder> var1, ScoreboardObjective var2, boolean var3) {
        ScoreboardServer var42 = var0.getServer().getScoreboard();
        return var0.withCallback((var4, var5) -> {
            for (ScoreHolder var7 : var1) {
                ScoreAccess var8 = var42.getOrCreatePlayerScore(var7, var2);
                int var9 = var3 ? var5 : (var4 ? 1 : 0);
                var8.set(var9);
            }
        }, CommandResultCallback::chain);
    }

    private static CommandListenerWrapper storeValue(CommandListenerWrapper var0, BossBattleCustom var1, boolean var2, boolean var32) {
        return var0.withCallback((var3, var4) -> {
            int var5;
            int n2 = var32 ? var4 : (var5 = var3 ? 1 : 0);
            if (var2) {
                var1.setValue(var5);
            } else {
                var1.setMax(var5);
            }
        }, CommandResultCallback::chain);
    }

    private static CommandListenerWrapper storeData(CommandListenerWrapper var0, CommandDataAccessor var1, ArgumentNBTKey.g var2, IntFunction<NBTBase> var3, boolean var42) {
        return var0.withCallback((var4, var5) -> {
            try {
                NBTTagCompound var6 = var1.getData();
                int var7 = var42 ? var5 : (var4 ? 1 : 0);
                var2.set(var6, (NBTBase)var3.apply(var7));
                var1.setData(var6);
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }, CommandResultCallback::chain);
    }

    private static boolean isChunkLoaded(WorldServer var0, BlockPosition var1) {
        ChunkCoordIntPair var2 = new ChunkCoordIntPair(var1);
        Chunk var3 = var0.getChunkSource().getChunkNow(var2.x, var2.z);
        if (var3 != null) {
            return var3.getFullStatus() == FullChunkStatus.ENTITY_TICKING && var0.areEntitiesLoaded(var2.toLong());
        }
        return false;
    }

    private static ArgumentBuilder<CommandListenerWrapper, ?> addConditionals(CommandNode<CommandListenerWrapper> var03, LiteralArgumentBuilder<CommandListenerWrapper> var12, boolean var2, CommandBuildContext var32) {
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)var12.then(net.minecraft.commands.CommandDispatcher.literal("block").then(net.minecraft.commands.CommandDispatcher.argument("pos", ArgumentPosition.blockPos()).then(CommandExecute.addConditional(var03, net.minecraft.commands.CommandDispatcher.argument("block", ArgumentBlockPredicate.blockPredicate(var32)), var2, var0 -> ArgumentBlockPredicate.getBlockPredicate((CommandContext<CommandListenerWrapper>)var0, "block").test(new ShapeDetectorBlock(((CommandListenerWrapper)var0.getSource()).getLevel(), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "pos"), true))))))).then(net.minecraft.commands.CommandDispatcher.literal("biome").then(net.minecraft.commands.CommandDispatcher.argument("pos", ArgumentPosition.blockPos()).then(CommandExecute.addConditional(var03, net.minecraft.commands.CommandDispatcher.argument("biome", ResourceOrTagArgument.resourceOrTag(var32, Registries.BIOME)), var2, var0 -> ResourceOrTagArgument.getResourceOrTag((CommandContext<CommandListenerWrapper>)var0, "biome", Registries.BIOME).test(((CommandListenerWrapper)var0.getSource()).getLevel().getBiome(ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "pos")))))))).then(net.minecraft.commands.CommandDispatcher.literal("loaded").then(CommandExecute.addConditional(var03, net.minecraft.commands.CommandDispatcher.argument("pos", ArgumentPosition.blockPos()), var2, var0 -> CommandExecute.isChunkLoaded(((CommandListenerWrapper)var0.getSource()).getLevel(), ArgumentPosition.getBlockPos((CommandContext<CommandListenerWrapper>)var0, "pos")))))).then(net.minecraft.commands.CommandDispatcher.literal("dimension").then(CommandExecute.addConditional(var03, net.minecraft.commands.CommandDispatcher.argument("dimension", ArgumentDimension.dimension()), var2, var0 -> ArgumentDimension.getDimension((CommandContext<CommandListenerWrapper>)var0, "dimension") == ((CommandListenerWrapper)var0.getSource()).getLevel())))).then(net.minecraft.commands.CommandDispatcher.literal("score").then(net.minecraft.commands.CommandDispatcher.argument("target", ArgumentScoreholder.scoreHolder()).suggests(ArgumentScoreholder.SUGGEST_SCORE_HOLDERS).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("targetObjective", ArgumentScoreboardObjective.objective()).then(net.minecraft.commands.CommandDispatcher.literal("=").then(net.minecraft.commands.CommandDispatcher.argument("source", ArgumentScoreholder.scoreHolder()).suggests(ArgumentScoreholder.SUGGEST_SCORE_HOLDERS).then(CommandExecute.addConditional(var03, net.minecraft.commands.CommandDispatcher.argument("sourceObjective", ArgumentScoreboardObjective.objective()), var2, var02 -> CommandExecute.checkScore((CommandContext<CommandListenerWrapper>)var02, (int var0, int var1) -> var0 == var1)))))).then(net.minecraft.commands.CommandDispatcher.literal("<").then(net.minecraft.commands.CommandDispatcher.argument("source", ArgumentScoreholder.scoreHolder()).suggests(ArgumentScoreholder.SUGGEST_SCORE_HOLDERS).then(CommandExecute.addConditional(var03, net.minecraft.commands.CommandDispatcher.argument("sourceObjective", ArgumentScoreboardObjective.objective()), var2, var02 -> CommandExecute.checkScore((CommandContext<CommandListenerWrapper>)var02, (int var0, int var1) -> var0 < var1)))))).then(net.minecraft.commands.CommandDispatcher.literal("<=").then(net.minecraft.commands.CommandDispatcher.argument("source", ArgumentScoreholder.scoreHolder()).suggests(ArgumentScoreholder.SUGGEST_SCORE_HOLDERS).then(CommandExecute.addConditional(var03, net.minecraft.commands.CommandDispatcher.argument("sourceObjective", ArgumentScoreboardObjective.objective()), var2, var02 -> CommandExecute.checkScore((CommandContext<CommandListenerWrapper>)var02, (int var0, int var1) -> var0 <= var1)))))).then(net.minecraft.commands.CommandDispatcher.literal(">").then(net.minecraft.commands.CommandDispatcher.argument("source", ArgumentScoreholder.scoreHolder()).suggests(ArgumentScoreholder.SUGGEST_SCORE_HOLDERS).then(CommandExecute.addConditional(var03, net.minecraft.commands.CommandDispatcher.argument("sourceObjective", ArgumentScoreboardObjective.objective()), var2, var02 -> CommandExecute.checkScore((CommandContext<CommandListenerWrapper>)var02, (int var0, int var1) -> var0 > var1)))))).then(net.minecraft.commands.CommandDispatcher.literal(">=").then(net.minecraft.commands.CommandDispatcher.argument("source", ArgumentScoreholder.scoreHolder()).suggests(ArgumentScoreholder.SUGGEST_SCORE_HOLDERS).then(CommandExecute.addConditional(var03, net.minecraft.commands.CommandDispatcher.argument("sourceObjective", ArgumentScoreboardObjective.objective()), var2, var02 -> CommandExecute.checkScore((CommandContext<CommandListenerWrapper>)var02, (int var0, int var1) -> var0 >= var1)))))).then(net.minecraft.commands.CommandDispatcher.literal("matches").then(CommandExecute.addConditional(var03, net.minecraft.commands.CommandDispatcher.argument("range", ArgumentCriterionValue.intRange()), var2, var0 -> CommandExecute.checkScore((CommandContext<CommandListenerWrapper>)var0, ArgumentCriterionValue.b.getRange((CommandContext<CommandListenerWrapper>)var0, "range"))))))))).then(net.minecraft.commands.CommandDispatcher.literal("blocks").then(net.minecraft.commands.CommandDispatcher.argument("start", ArgumentPosition.blockPos()).then(net.minecraft.commands.CommandDispatcher.argument("end", ArgumentPosition.blockPos()).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("destination", ArgumentPosition.blockPos()).then(CommandExecute.addIfBlocksConditional(var03, net.minecraft.commands.CommandDispatcher.literal("all"), var2, false))).then(CommandExecute.addIfBlocksConditional(var03, net.minecraft.commands.CommandDispatcher.literal("masked"), var2, true))))))).then(net.minecraft.commands.CommandDispatcher.literal("entity").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("entities", ArgumentEntity.entities()).fork(var03, var1 -> CommandExecute.expect((CommandContext<CommandListenerWrapper>)var1, var2, !ArgumentEntity.getOptionalEntities((CommandContext<CommandListenerWrapper>)var1, "entities").isEmpty()))).executes(CommandExecute.createNumericConditionalHandler(var2, var0 -> ArgumentEntity.getOptionalEntities((CommandContext<CommandListenerWrapper>)var0, "entities").size()))))).then(net.minecraft.commands.CommandDispatcher.literal("predicate").then(CommandExecute.addConditional(var03, net.minecraft.commands.CommandDispatcher.argument("predicate", ResourceOrIdArgument.lootPredicate(var32)).suggests(SUGGEST_PREDICATE), var2, var0 -> CommandExecute.checkCustomPredicate((CommandListenerWrapper)var0.getSource(), ResourceOrIdArgument.getLootPredicate((CommandContext<CommandListenerWrapper>)var0, "predicate")))))).then(net.minecraft.commands.CommandDispatcher.literal("function").then(net.minecraft.commands.CommandDispatcher.argument("name", ArgumentTag.functions()).suggests(CommandFunction.SUGGEST_FUNCTION).fork(var03, (RedirectModifier)new c(var2))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("items").then(net.minecraft.commands.CommandDispatcher.literal("entity").then(net.minecraft.commands.CommandDispatcher.argument("entities", ArgumentEntity.entities()).then(net.minecraft.commands.CommandDispatcher.argument("slots", SlotsArgument.slots()).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("item_predicate", ArgumentItemPredicate.itemPredicate(var32)).fork(var03, var1 -> CommandExecute.expect((CommandContext<CommandListenerWrapper>)var1, var2, CommandExecute.countItems(ArgumentEntity.getEntities((CommandContext<CommandListenerWrapper>)var1, "entities"), SlotsArgument.getSlots((CommandContext<CommandListenerWrapper>)var1, "slots"), ArgumentItemPredicate.getItemPredicate((CommandContext<CommandListenerWrapper>)var1, "item_predicate")) > 0))).executes(CommandExecute.createNumericConditionalHandler(var2, var0 -> CommandExecute.countItems(ArgumentEntity.getEntities((CommandContext<CommandListenerWrapper>)var0, "entities"), SlotsArgument.getSlots((CommandContext<CommandListenerWrapper>)var0, "slots"), ArgumentItemPredicate.getItemPredicate((CommandContext<CommandListenerWrapper>)var0, "item_predicate"))))))))).then(net.minecraft.commands.CommandDispatcher.literal("block").then(net.minecraft.commands.CommandDispatcher.argument("pos", ArgumentPosition.blockPos()).then(net.minecraft.commands.CommandDispatcher.argument("slots", SlotsArgument.slots()).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("item_predicate", ArgumentItemPredicate.itemPredicate(var32)).fork(var03, var1 -> CommandExecute.expect((CommandContext<CommandListenerWrapper>)var1, var2, CommandExecute.countItems((CommandListenerWrapper)var1.getSource(), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var1, "pos"), SlotsArgument.getSlots((CommandContext<CommandListenerWrapper>)var1, "slots"), ArgumentItemPredicate.getItemPredicate((CommandContext<CommandListenerWrapper>)var1, "item_predicate")) > 0))).executes(CommandExecute.createNumericConditionalHandler(var2, var0 -> CommandExecute.countItems((CommandListenerWrapper)var0.getSource(), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "pos"), SlotsArgument.getSlots((CommandContext<CommandListenerWrapper>)var0, "slots"), ArgumentItemPredicate.getItemPredicate((CommandContext<CommandListenerWrapper>)var0, "item_predicate")))))))));
        for (CommandData.c var5 : CommandData.SOURCE_PROVIDERS) {
            var12.then(var5.wrap((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.literal("data"), var3 -> var3.then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("path", ArgumentNBTKey.nbtPath()).fork(var03, var2 -> CommandExecute.expect((CommandContext<CommandListenerWrapper>)var2, var2, CommandExecute.checkMatchingData(var5.access((CommandContext<CommandListenerWrapper>)var2), ArgumentNBTKey.getPath((CommandContext<CommandListenerWrapper>)var2, "path")) > 0))).executes(CommandExecute.createNumericConditionalHandler(var2, var1 -> CommandExecute.checkMatchingData(var5.access((CommandContext<CommandListenerWrapper>)var1), ArgumentNBTKey.getPath((CommandContext<CommandListenerWrapper>)var1, "path")))))));
        }
        return var12;
    }

    private static int countItems(Iterable<? extends Entity> var0, SlotRange var1, Predicate<ItemStack> var2) {
        int var3 = 0;
        for (Entity entity : var0) {
            IntList var6 = var1.slots();
            for (int var7 = 0; var7 < var6.size(); ++var7) {
                int var8 = var6.getInt(var7);
                SlotAccess var9 = entity.getSlot(var8);
                ItemStack var10 = var9.get();
                if (!var2.test(var10)) continue;
                var3 += var10.getCount();
            }
        }
        return var3;
    }

    private static int countItems(CommandListenerWrapper var0, BlockPosition var1, SlotRange var2, Predicate<ItemStack> var3) throws CommandSyntaxException {
        int var4 = 0;
        IInventory var5 = ItemCommands.getContainer(var0, var1, ItemCommands.ERROR_SOURCE_NOT_A_CONTAINER);
        int var6 = var5.getContainerSize();
        IntList var7 = var2.slots();
        for (int var8 = 0; var8 < var7.size(); ++var8) {
            ItemStack var10;
            int var9 = var7.getInt(var8);
            if (var9 < 0 || var9 >= var6 || !var3.test(var10 = var5.getItem(var9))) continue;
            var4 += var10.getCount();
        }
        return var4;
    }

    private static Command<CommandListenerWrapper> createNumericConditionalHandler(boolean var0, a var12) {
        if (var0) {
            return var1 -> {
                int var2 = var12.test((CommandContext<CommandListenerWrapper>)var1);
                if (var2 > 0) {
                    ((CommandListenerWrapper)var1.getSource()).sendSuccess(() -> IChatBaseComponent.translatable("commands.execute.conditional.pass_count", var2), false);
                    return var2;
                }
                throw ERROR_CONDITIONAL_FAILED.create();
            };
        }
        return var1 -> {
            int var2 = var12.test((CommandContext<CommandListenerWrapper>)var1);
            if (var2 == 0) {
                ((CommandListenerWrapper)var1.getSource()).sendSuccess(() -> IChatBaseComponent.translatable("commands.execute.conditional.pass"), false);
                return 1;
            }
            throw ERROR_CONDITIONAL_FAILED_COUNT.create((Object)var2);
        };
    }

    private static int checkMatchingData(CommandDataAccessor var0, ArgumentNBTKey.g var1) throws CommandSyntaxException {
        return var1.countMatching(var0.getData());
    }

    private static boolean checkScore(CommandContext<CommandListenerWrapper> var0, d var1) throws CommandSyntaxException {
        ScoreHolder var2 = ArgumentScoreholder.getName(var0, "target");
        ScoreboardObjective var3 = ArgumentScoreboardObjective.getObjective(var0, "targetObjective");
        ScoreHolder var4 = ArgumentScoreholder.getName(var0, "source");
        ScoreboardObjective var5 = ArgumentScoreboardObjective.getObjective(var0, "sourceObjective");
        ScoreboardServer var6 = ((CommandListenerWrapper)var0.getSource()).getServer().getScoreboard();
        ReadOnlyScoreInfo var7 = var6.getPlayerScoreInfo(var2, var3);
        ReadOnlyScoreInfo var8 = var6.getPlayerScoreInfo(var4, var5);
        if (var7 == null || var8 == null) {
            return false;
        }
        return var1.test(var7.value(), var8.value());
    }

    private static boolean checkScore(CommandContext<CommandListenerWrapper> var0, CriterionConditionValue.IntegerRange var1) throws CommandSyntaxException {
        ScoreHolder var2 = ArgumentScoreholder.getName(var0, "target");
        ScoreboardObjective var3 = ArgumentScoreboardObjective.getObjective(var0, "targetObjective");
        ScoreboardServer var4 = ((CommandListenerWrapper)var0.getSource()).getServer().getScoreboard();
        ReadOnlyScoreInfo var5 = var4.getPlayerScoreInfo(var2, var3);
        if (var5 == null) {
            return false;
        }
        return var1.matches(var5.value());
    }

    private static boolean checkCustomPredicate(CommandListenerWrapper var0, Holder<LootItemCondition> var1) {
        WorldServer var2 = var0.getLevel();
        LootParams var3 = new LootParams.a(var2).withParameter(LootContextParameters.ORIGIN, var0.getPosition()).withOptionalParameter(LootContextParameters.THIS_ENTITY, var0.getEntity()).create(LootContextParameterSets.COMMAND);
        LootTableInfo var4 = new LootTableInfo.Builder(var3).create(Optional.empty());
        var4.pushVisitedElement(LootTableInfo.createVisitedEntry(var1.value()));
        return var1.value().test(var4);
    }

    private static Collection<CommandListenerWrapper> expect(CommandContext<CommandListenerWrapper> var0, boolean var1, boolean var2) {
        if (var2 == var1) {
            return Collections.singleton((CommandListenerWrapper)var0.getSource());
        }
        return Collections.emptyList();
    }

    private static ArgumentBuilder<CommandListenerWrapper, ?> addConditional(CommandNode<CommandListenerWrapper> var0, ArgumentBuilder<CommandListenerWrapper, ?> var1, boolean var22, b var3) {
        return var1.fork(var0, var2 -> CommandExecute.expect((CommandContext<CommandListenerWrapper>)var2, var22, var3.test((CommandContext<CommandListenerWrapper>)var2))).executes(var2 -> {
            if (var22 == var3.test((CommandContext<CommandListenerWrapper>)var2)) {
                ((CommandListenerWrapper)var2.getSource()).sendSuccess(() -> IChatBaseComponent.translatable("commands.execute.conditional.pass"), false);
                return 1;
            }
            throw ERROR_CONDITIONAL_FAILED.create();
        });
    }

    private static ArgumentBuilder<CommandListenerWrapper, ?> addIfBlocksConditional(CommandNode<CommandListenerWrapper> var0, ArgumentBuilder<CommandListenerWrapper, ?> var12, boolean var22, boolean var3) {
        return var12.fork(var0, var2 -> CommandExecute.expect((CommandContext<CommandListenerWrapper>)var2, var22, CommandExecute.checkRegions((CommandContext<CommandListenerWrapper>)var2, var3).isPresent())).executes(var22 ? var1 -> CommandExecute.checkIfRegions((CommandContext<CommandListenerWrapper>)var1, var3) : var1 -> CommandExecute.checkUnlessRegions((CommandContext<CommandListenerWrapper>)var1, var3));
    }

    private static int checkIfRegions(CommandContext<CommandListenerWrapper> var0, boolean var1) throws CommandSyntaxException {
        OptionalInt var2 = CommandExecute.checkRegions(var0, var1);
        if (var2.isPresent()) {
            ((CommandListenerWrapper)var0.getSource()).sendSuccess(() -> IChatBaseComponent.translatable("commands.execute.conditional.pass_count", var2.getAsInt()), false);
            return var2.getAsInt();
        }
        throw ERROR_CONDITIONAL_FAILED.create();
    }

    private static int checkUnlessRegions(CommandContext<CommandListenerWrapper> var0, boolean var1) throws CommandSyntaxException {
        OptionalInt var2 = CommandExecute.checkRegions(var0, var1);
        if (var2.isPresent()) {
            throw ERROR_CONDITIONAL_FAILED_COUNT.create((Object)var2.getAsInt());
        }
        ((CommandListenerWrapper)var0.getSource()).sendSuccess(() -> IChatBaseComponent.translatable("commands.execute.conditional.pass"), false);
        return 1;
    }

    private static OptionalInt checkRegions(CommandContext<CommandListenerWrapper> var0, boolean var1) throws CommandSyntaxException {
        return CommandExecute.checkRegions(((CommandListenerWrapper)var0.getSource()).getLevel(), ArgumentPosition.getLoadedBlockPos(var0, "start"), ArgumentPosition.getLoadedBlockPos(var0, "end"), ArgumentPosition.getLoadedBlockPos(var0, "destination"), var1);
    }

    private static OptionalInt checkRegions(WorldServer var0, BlockPosition var1, BlockPosition var2, BlockPosition var3, boolean var4) throws CommandSyntaxException {
        StructureBoundingBox var5 = StructureBoundingBox.fromCorners(var1, var2);
        StructureBoundingBox var6 = StructureBoundingBox.fromCorners(var3, var3.offset(var5.getLength()));
        BlockPosition var7 = new BlockPosition(var6.minX() - var5.minX(), var6.minY() - var5.minY(), var6.minZ() - var5.minZ());
        int var8 = var5.getXSpan() * var5.getYSpan() * var5.getZSpan();
        if (var8 > 32768) {
            throw ERROR_AREA_TOO_LARGE.create((Object)32768, (Object)var8);
        }
        IRegistryCustom var9 = var0.registryAccess();
        int var10 = 0;
        for (int var11 = var5.minZ(); var11 <= var5.maxZ(); ++var11) {
            for (int var12 = var5.minY(); var12 <= var5.maxY(); ++var12) {
                for (int var13 = var5.minX(); var13 <= var5.maxX(); ++var13) {
                    BlockPosition var14 = new BlockPosition(var13, var12, var11);
                    BlockPosition var15 = var14.offset(var7);
                    IBlockData var16 = var0.getBlockState(var14);
                    if (var4 && var16.is(Blocks.AIR)) continue;
                    if (var16 != var0.getBlockState(var15)) {
                        return OptionalInt.empty();
                    }
                    TileEntity var17 = var0.getBlockEntity(var14);
                    TileEntity var18 = var0.getBlockEntity(var15);
                    if (var17 != null) {
                        NBTTagCompound var20;
                        if (var18 == null) {
                            return OptionalInt.empty();
                        }
                        if (var18.getType() != var17.getType()) {
                            return OptionalInt.empty();
                        }
                        if (!var17.components().equals(var18.components())) {
                            return OptionalInt.empty();
                        }
                        NBTTagCompound var19 = var17.saveCustomOnly(var9);
                        if (!var19.equals(var20 = var18.saveCustomOnly(var9))) {
                            return OptionalInt.empty();
                        }
                    }
                    ++var10;
                }
            }
        }
        return OptionalInt.of(var10);
    }

    private static RedirectModifier<CommandListenerWrapper> expandOneToOneEntityRelation(Function<Entity, Optional<Entity>> var0) {
        return var12 -> {
            CommandListenerWrapper var2 = (CommandListenerWrapper)var12.getSource();
            Entity var3 = var2.getEntity();
            if (var3 == null) {
                return List.of();
            }
            return ((Optional)var0.apply(var3)).filter(var0 -> !var0.isRemoved()).map(var1 -> List.of(var2.withEntity((Entity)var1))).orElse(List.of());
        };
    }

    private static RedirectModifier<CommandListenerWrapper> expandOneToManyEntityRelation(Function<Entity, Stream<Entity>> var0) {
        return var1 -> {
            CommandListenerWrapper var2 = (CommandListenerWrapper)var1.getSource();
            Entity var3 = var2.getEntity();
            if (var3 == null) {
                return List.of();
            }
            return ((Stream)var0.apply(var3)).filter(var0 -> !var0.isRemoved()).map(var2::withEntity).toList();
        };
    }

    private static LiteralArgumentBuilder<CommandListenerWrapper> createRelationOperations(CommandNode<CommandListenerWrapper> var02, LiteralArgumentBuilder<CommandListenerWrapper> var1) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)var1.then(net.minecraft.commands.CommandDispatcher.literal("owner").fork(var02, CommandExecute.expandOneToOneEntityRelation(var0 -> {
            Optional<Object> optional;
            if (var0 instanceof OwnableEntity) {
                OwnableEntity var1 = (OwnableEntity)((Object)var0);
                optional = Optional.ofNullable(var1.getOwner());
            } else {
                optional = Optional.empty();
            }
            return optional;
        })))).then(net.minecraft.commands.CommandDispatcher.literal("leasher").fork(var02, CommandExecute.expandOneToOneEntityRelation(var0 -> {
            Optional<Object> optional;
            if (var0 instanceof Leashable) {
                Leashable var1 = (Leashable)((Object)var0);
                optional = Optional.ofNullable(var1.getLeashHolder());
            } else {
                optional = Optional.empty();
            }
            return optional;
        })))).then(net.minecraft.commands.CommandDispatcher.literal("target").fork(var02, CommandExecute.expandOneToOneEntityRelation(var0 -> {
            Optional<Object> optional;
            if (var0 instanceof Targeting) {
                Targeting var1 = (Targeting)((Object)var0);
                optional = Optional.ofNullable(var1.getTarget());
            } else {
                optional = Optional.empty();
            }
            return optional;
        })))).then(net.minecraft.commands.CommandDispatcher.literal("attacker").fork(var02, CommandExecute.expandOneToOneEntityRelation(var0 -> {
            Optional<Object> optional;
            if (var0 instanceof Attackable) {
                Attackable var1 = (Attackable)((Object)var0);
                optional = Optional.ofNullable(var1.getLastAttacker());
            } else {
                optional = Optional.empty();
            }
            return optional;
        })))).then(net.minecraft.commands.CommandDispatcher.literal("vehicle").fork(var02, CommandExecute.expandOneToOneEntityRelation(var0 -> Optional.ofNullable(var0.getVehicle()))))).then(net.minecraft.commands.CommandDispatcher.literal("controller").fork(var02, CommandExecute.expandOneToOneEntityRelation(var0 -> Optional.ofNullable(var0.getControllingPassenger()))))).then(net.minecraft.commands.CommandDispatcher.literal("origin").fork(var02, CommandExecute.expandOneToOneEntityRelation(var0 -> {
            Optional<Object> optional;
            if (var0 instanceof TraceableEntity) {
                TraceableEntity var1 = (TraceableEntity)((Object)var0);
                optional = Optional.ofNullable(var1.getOwner());
            } else {
                optional = Optional.empty();
            }
            return optional;
        })))).then(net.minecraft.commands.CommandDispatcher.literal("passengers").fork(var02, CommandExecute.expandOneToManyEntityRelation(var0 -> var0.getPassengers().stream())));
    }

    private static CommandListenerWrapper spawnEntityAndRedirect(CommandListenerWrapper var0, Holder.c<EntityTypes<?>> var1) throws CommandSyntaxException {
        Entity var2 = CommandSummon.createEntity(var0, var1, var0.getPosition(), new NBTTagCompound(), true);
        return var0.withEntity(var2);
    }

    /*
     * Exception decompiling
     */
    public static <T extends ExecutionCommandSource<T>> void scheduleFunctionConditionsAndTest(T var0, List<T> var1, Function<T, T> var2, IntPredicate var3, ContextChain<T> var4, @Nullable NBTTagCompound var5, ExecutionControl<T> var6, InCommandFunction<CommandContext<T>, Collection<net.minecraft.commands.functions.CommandFunction<T>>> var7, ChainModifiers var8) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static /* synthetic */ void a(List var0, ExecutionCommandSource var1, ExecutionControl var2) {
        for (InstantiatedFunction var4 : var0) {
            var2.queueNext(new CallFunction<ExecutionCommandSource>(var4, var2.currentFrame().returnValueConsumer(), true).bind(var1));
        }
        var2.queueNext(FallthroughTask.instance());
    }

    private static /* synthetic */ void a(IntPredicate var0, List var1, ExecutionCommandSource var2, boolean var3, int var4) {
        if (var0.test(var4)) {
            var1.add(var2);
        }
    }

    @FunctionalInterface
    static interface b {
        public boolean test(CommandContext<CommandListenerWrapper> var1) throws CommandSyntaxException;
    }

    @FunctionalInterface
    static interface a {
        public int test(CommandContext<CommandListenerWrapper> var1) throws CommandSyntaxException;
    }

    static class c
    implements CustomModifierExecutor.a<CommandListenerWrapper> {
        private final IntPredicate check;

        c(boolean var02) {
            this.check = var02 ? var0 -> var0 != 0 : var0 -> var0 == 0;
        }

        @Override
        public void apply(CommandListenerWrapper var02, List<CommandListenerWrapper> var1, ContextChain<CommandListenerWrapper> var2, ChainModifiers var3, ExecutionControl<CommandListenerWrapper> var4) {
            CommandExecute.scheduleFunctionConditionsAndTest(var02, var1, CommandFunction::modifySenderForExecution, this.check, var2, null, var4, var0 -> ArgumentTag.getFunctions((CommandContext<CommandListenerWrapper>)var0, "name"), var3);
        }
    }

    @FunctionalInterface
    static interface d {
        public boolean test(int var1, int var2);
    }
}

