/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentDimension;
import net.minecraft.commands.arguments.blocks.ArgumentBlockPredicate;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.commands.InCommandFunction;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.ticks.TickListServer;

public class CommandClone {
    private static final SimpleCommandExceptionType ERROR_OVERLAP = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.clone.overlap"));
    private static final Dynamic2CommandExceptionType ERROR_AREA_TOO_LARGE = new Dynamic2CommandExceptionType((var0, var1) -> IChatBaseComponent.translatableEscape("commands.clone.toobig", var0, var1));
    private static final SimpleCommandExceptionType ERROR_FAILED = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.clone.failed"));
    public static final Predicate<ShapeDetectorBlock> FILTER_AIR = var0 -> !var0.getState().isAir();

    public static void register(CommandDispatcher<CommandListenerWrapper> var02, CommandBuildContext var1) {
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("clone").requires(var0 -> var0.hasPermission(2))).then(CommandClone.beginEndDestinationAndModeSuffix(var1, var0 -> ((CommandListenerWrapper)var0.getSource()).getLevel()))).then(net.minecraft.commands.CommandDispatcher.literal("from").then(net.minecraft.commands.CommandDispatcher.argument("sourceDimension", ArgumentDimension.dimension()).then(CommandClone.beginEndDestinationAndModeSuffix(var1, var0 -> ArgumentDimension.getDimension((CommandContext<CommandListenerWrapper>)var0, "sourceDimension"))))));
    }

    private static ArgumentBuilder<CommandListenerWrapper, ?> beginEndDestinationAndModeSuffix(CommandBuildContext var02, InCommandFunction<CommandContext<CommandListenerWrapper>, WorldServer> var1) {
        return net.minecraft.commands.CommandDispatcher.argument("begin", ArgumentPosition.blockPos()).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("end", ArgumentPosition.blockPos()).then(CommandClone.destinationAndStrictSuffix(var02, var1, var0 -> ((CommandListenerWrapper)var0.getSource()).getLevel()))).then(net.minecraft.commands.CommandDispatcher.literal("to").then(net.minecraft.commands.CommandDispatcher.argument("targetDimension", ArgumentDimension.dimension()).then(CommandClone.destinationAndStrictSuffix(var02, var1, var0 -> ArgumentDimension.getDimension((CommandContext<CommandListenerWrapper>)var0, "targetDimension"))))));
    }

    private static c getLoadedDimensionAndPosition(CommandContext<CommandListenerWrapper> var0, WorldServer var1, String var2) throws CommandSyntaxException {
        BlockPosition var3 = ArgumentPosition.getLoadedBlockPos(var0, var1, var2);
        return new c(var1, var3);
    }

    private static ArgumentBuilder<CommandListenerWrapper, ?> destinationAndStrictSuffix(CommandBuildContext var0, InCommandFunction<CommandContext<CommandListenerWrapper>, WorldServer> var12, InCommandFunction<CommandContext<CommandListenerWrapper>, WorldServer> var2) {
        InCommandFunction<CommandContext<CommandListenerWrapper>, c> var3 = var1 -> CommandClone.getLoadedDimensionAndPosition((CommandContext<CommandListenerWrapper>)var1, (WorldServer)var12.apply((CommandContext<CommandListenerWrapper>)var1), "begin");
        InCommandFunction<CommandContext<CommandListenerWrapper>, c> var4 = var1 -> CommandClone.getLoadedDimensionAndPosition((CommandContext<CommandListenerWrapper>)var1, (WorldServer)var12.apply((CommandContext<CommandListenerWrapper>)var1), "end");
        InCommandFunction<CommandContext<CommandListenerWrapper>, c> var5 = var1 -> CommandClone.getLoadedDimensionAndPosition((CommandContext<CommandListenerWrapper>)var1, (WorldServer)var2.apply((CommandContext<CommandListenerWrapper>)var1), "destination");
        return CommandClone.modeSuffix(var0, var3, var4, var5, false, net.minecraft.commands.CommandDispatcher.argument("destination", ArgumentPosition.blockPos())).then(CommandClone.modeSuffix(var0, var3, var4, var5, true, net.minecraft.commands.CommandDispatcher.literal("strict")));
    }

    private static ArgumentBuilder<CommandListenerWrapper, ?> modeSuffix(CommandBuildContext var03, InCommandFunction<CommandContext<CommandListenerWrapper>, c> var1, InCommandFunction<CommandContext<CommandListenerWrapper>, c> var2, InCommandFunction<CommandContext<CommandListenerWrapper>, c> var3, boolean var42, ArgumentBuilder<CommandListenerWrapper, ?> var5) {
        return var5.executes(var4 -> CommandClone.clone((CommandListenerWrapper)var4.getSource(), (c)var1.apply(var4), (c)var2.apply(var4), (c)var3.apply(var4), var0 -> true, Mode.NORMAL, var42)).then(CommandClone.wrapWithCloneMode(var1, var2, var3, var02 -> var0 -> true, var42, net.minecraft.commands.CommandDispatcher.literal("replace"))).then(CommandClone.wrapWithCloneMode(var1, var2, var3, var0 -> FILTER_AIR, var42, net.minecraft.commands.CommandDispatcher.literal("masked"))).then(net.minecraft.commands.CommandDispatcher.literal("filtered").then(CommandClone.wrapWithCloneMode(var1, var2, var3, var0 -> ArgumentBlockPredicate.getBlockPredicate((CommandContext<CommandListenerWrapper>)var0, "filter"), var42, net.minecraft.commands.CommandDispatcher.argument("filter", ArgumentBlockPredicate.blockPredicate(var03)))));
    }

    private static ArgumentBuilder<CommandListenerWrapper, ?> wrapWithCloneMode(InCommandFunction<CommandContext<CommandListenerWrapper>, c> var0, InCommandFunction<CommandContext<CommandListenerWrapper>, c> var1, InCommandFunction<CommandContext<CommandListenerWrapper>, c> var2, InCommandFunction<CommandContext<CommandListenerWrapper>, Predicate<ShapeDetectorBlock>> var3, boolean var4, ArgumentBuilder<CommandListenerWrapper, ?> var52) {
        return var52.executes(var5 -> CommandClone.clone((CommandListenerWrapper)var5.getSource(), (c)var0.apply(var5), (c)var1.apply(var5), (c)var2.apply(var5), (Predicate)var3.apply(var5), Mode.NORMAL, var4)).then(net.minecraft.commands.CommandDispatcher.literal("force").executes(var5 -> CommandClone.clone((CommandListenerWrapper)var5.getSource(), (c)var0.apply(var5), (c)var1.apply(var5), (c)var2.apply(var5), (Predicate)var3.apply(var5), Mode.FORCE, var4))).then(net.minecraft.commands.CommandDispatcher.literal("move").executes(var5 -> CommandClone.clone((CommandListenerWrapper)var5.getSource(), (c)var0.apply(var5), (c)var1.apply(var5), (c)var2.apply(var5), (Predicate)var3.apply(var5), Mode.MOVE, var4))).then(net.minecraft.commands.CommandDispatcher.literal("normal").executes(var5 -> CommandClone.clone((CommandListenerWrapper)var5.getSource(), (c)var0.apply(var5), (c)var1.apply(var5), (c)var2.apply(var5), (Predicate)var3.apply(var5), Mode.NORMAL, var4)));
    }

    private static int clone(CommandListenerWrapper var0, c var1, c var2, c var3, Predicate<ShapeDetectorBlock> var4, Mode var5, boolean var6) throws CommandSyntaxException {
        Object var28;
        int var23;
        int var22;
        int var16;
        BlockPosition var7 = var1.position();
        BlockPosition var8 = var2.position();
        StructureBoundingBox var9 = StructureBoundingBox.fromCorners(var7, var8);
        BlockPosition var10 = var3.position();
        BlockPosition var11 = var10.offset(var9.getLength());
        StructureBoundingBox var12 = StructureBoundingBox.fromCorners(var10, var11);
        WorldServer var13 = var1.dimension();
        WorldServer var14 = var3.dimension();
        if (!var5.canOverlap() && var13 == var14 && var12.intersects(var9)) {
            throw ERROR_OVERLAP.create();
        }
        int var15 = var9.getXSpan() * var9.getYSpan() * var9.getZSpan();
        if (var15 > (var16 = var0.getLevel().getGameRules().getInt(GameRules.RULE_COMMAND_MODIFICATION_BLOCK_LIMIT))) {
            throw ERROR_AREA_TOO_LARGE.create((Object)var16, (Object)var15);
        }
        if (!var13.hasChunksAt(var7, var8) || !var14.hasChunksAt(var10, var11)) {
            throw ArgumentPosition.ERROR_NOT_LOADED.create();
        }
        if (var14.isDebug()) {
            throw ERROR_FAILED.create();
        }
        ArrayList var17 = Lists.newArrayList();
        ArrayList var18 = Lists.newArrayList();
        ArrayList var19 = Lists.newArrayList();
        LinkedList var20 = Lists.newLinkedList();
        BlockPosition var21 = new BlockPosition(var12.minX() - var9.minX(), var12.minY() - var9.minY(), var12.minZ() - var9.minZ());
        for (var22 = var9.minZ(); var22 <= var9.maxZ(); ++var22) {
            for (var23 = var9.minY(); var23 <= var9.maxY(); ++var23) {
                for (int var24 = var9.minX(); var24 <= var9.maxX(); ++var24) {
                    Object var25 = new BlockPosition(var24, var23, var22);
                    Iterator var26 = ((BlockPosition)var25).offset(var21);
                    Object var27 = new ShapeDetectorBlock(var13, (BlockPosition)var25, false);
                    var28 = ((ShapeDetectorBlock)var27).getState();
                    if (!var4.test((ShapeDetectorBlock)var27)) continue;
                    TileEntity var29 = var13.getBlockEntity((BlockPosition)var25);
                    if (var29 != null) {
                        a var30 = new a(var29.saveCustomOnly(var0.registryAccess()), var29.components());
                        var18.add(new CommandCloneStoredTileEntity((BlockPosition)((Object)var26), (IBlockData)var28, var30));
                        var20.addLast(var25);
                        continue;
                    }
                    if (((BlockBase.BlockData)var28).isSolidRender() || ((BlockBase.BlockData)var28).isCollisionShapeFullBlock(var13, (BlockPosition)var25)) {
                        var17.add(new CommandCloneStoredTileEntity((BlockPosition)((Object)var26), (IBlockData)var28, null));
                        var20.addLast(var25);
                        continue;
                    }
                    var19.add(new CommandCloneStoredTileEntity((BlockPosition)((Object)var26), (IBlockData)var28, null));
                    var20.addFirst(var25);
                }
            }
        }
        var22 = 2 | (var6 ? 816 : 0);
        if (var5 == Mode.MOVE) {
            for (BlockPosition var24 : var20) {
                var13.setBlock(var24, Blocks.BARRIER.defaultBlockState(), var22 | 0x330);
            }
            var23 = var6 ? var22 : 3;
            for (Object var25 : var20) {
                var13.setBlock((BlockPosition)var25, Blocks.AIR.defaultBlockState(), var23);
            }
        }
        ArrayList var232 = Lists.newArrayList();
        var232.addAll(var17);
        var232.addAll(var18);
        var232.addAll(var19);
        List var24 = Lists.reverse((List)var232);
        for (Iterator var26 : var24) {
            var14.setBlock(((CommandCloneStoredTileEntity)((Object)var26)).pos, Blocks.BARRIER.defaultBlockState(), var22 | 0x330);
        }
        int var25 = 0;
        for (Object var27 : var232) {
            if (!var14.setBlock(((CommandCloneStoredTileEntity)var27).pos, ((CommandCloneStoredTileEntity)var27).state, var22)) continue;
            ++var25;
        }
        for (Object var27 : var18) {
            var28 = var14.getBlockEntity(((CommandCloneStoredTileEntity)var27).pos);
            if (((CommandCloneStoredTileEntity)var27).blockEntityInfo != null && var28 != null) {
                ((TileEntity)var28).loadCustomOnly(((CommandCloneStoredTileEntity)var27).blockEntityInfo.tag, var14.registryAccess());
                ((TileEntity)var28).setComponents(((CommandCloneStoredTileEntity)var27).blockEntityInfo.components);
                ((TileEntity)var28).setChanged();
            }
            var14.setBlock(((CommandCloneStoredTileEntity)var27).pos, ((CommandCloneStoredTileEntity)var27).state, var22);
        }
        if (!var6) {
            for (Object var27 : var24) {
                var14.updateNeighborsAt(((CommandCloneStoredTileEntity)var27).pos, ((CommandCloneStoredTileEntity)var27).state.getBlock());
            }
        }
        ((TickListServer)var14.getBlockTicks()).copyAreaFrom(var13.getBlockTicks(), var9, var21);
        if (var25 == 0) {
            throw ERROR_FAILED.create();
        }
        int var26 = var25;
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.clone.success", var26), true);
        return var25;
    }

    record c(WorldServer dimension, BlockPosition position) {
    }

    static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode FORCE = new Mode(true);
        public static final /* enum */ Mode MOVE = new Mode(true);
        public static final /* enum */ Mode NORMAL = new Mode(false);
        private final boolean canOverlap;
        private static final /* synthetic */ Mode[] e;

        public static Mode[] values() {
            return (Mode[])e.clone();
        }

        public static Mode valueOf(String var0) {
            return Enum.valueOf(Mode.class, var0);
        }

        private Mode(boolean var2) {
            this.canOverlap = var2;
        }

        public boolean canOverlap() {
            return this.canOverlap;
        }

        private static /* synthetic */ Mode[] b() {
            return new Mode[]{FORCE, MOVE, NORMAL};
        }

        static {
            e = Mode.b();
        }
    }

    static final class a
    extends Record {
        final NBTTagCompound tag;
        final DataComponentMap components;

        a(NBTTagCompound var0, DataComponentMap var1) {
            this.tag = var0;
            this.components = var1;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "tag;components", "tag", "components"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "tag;components", "tag", "components"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "tag;components", "tag", "components"}, this, var0);
        }

        public NBTTagCompound tag() {
            return this.tag;
        }

        public DataComponentMap components() {
            return this.components;
        }
    }

    static final class CommandCloneStoredTileEntity
    extends Record {
        final BlockPosition pos;
        final IBlockData state;
        @Nullable
        final a blockEntityInfo;

        CommandCloneStoredTileEntity(BlockPosition var0, IBlockData var1, @Nullable a var2) {
            this.pos = var0;
            this.state = var1;
            this.blockEntityInfo = var2;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{CommandCloneStoredTileEntity.class, "pos;state;blockEntityInfo", "pos", "state", "blockEntityInfo"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{CommandCloneStoredTileEntity.class, "pos;state;blockEntityInfo", "pos", "state", "blockEntityInfo"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{CommandCloneStoredTileEntity.class, "pos;state;blockEntityInfo", "pos", "state", "blockEntityInfo"}, this, var0);
        }

        public BlockPosition pos() {
            return this.pos;
        }

        public IBlockData state() {
            return this.state;
        }

        @Nullable
        public a blockEntityInfo() {
            return this.blockEntityInfo;
        }
    }
}

