/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SystemUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.core.RegistrySynchronization;
import net.minecraft.core.registries.Registries;
import net.minecraft.gametest.framework.GameTestInstance;
import net.minecraft.gametest.framework.TestEnvironmentDefinition;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.repository.KnownPack;
import net.minecraft.server.packs.resources.IResource;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.tags.TagDataPack;
import net.minecraft.tags.TagNetworkSerialization;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.animal.ChickenVariant;
import net.minecraft.world.entity.animal.CowVariant;
import net.minecraft.world.entity.animal.PigVariant;
import net.minecraft.world.entity.animal.frog.FrogVariant;
import net.minecraft.world.entity.animal.wolf.WolfSoundVariant;
import net.minecraft.world.entity.animal.wolf.WolfVariant;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.JukeboxSong;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.providers.EnchantmentProvider;
import net.minecraft.world.item.equipment.trim.TrimMaterial;
import net.minecraft.world.item.equipment.trim.TrimPattern;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList;
import net.minecraft.world.level.block.entity.EnumBannerPatternType;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerConfig;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverWrapper;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorPreset;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureStructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorList;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorNormal;
import org.slf4j.Logger;

public class RegistryDataLoader {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Comparator<ResourceKey<?>> ERROR_KEY_COMPARATOR = Comparator.comparing(ResourceKey::registry).thenComparing(ResourceKey::location);
    private static final RegistrationInfo NETWORK_REGISTRATION_INFO = new RegistrationInfo(Optional.empty(), Lifecycle.experimental());
    private static final Function<Optional<KnownPack>, RegistrationInfo> REGISTRATION_INFO_CACHE = SystemUtils.memoize(var02 -> {
        Lifecycle var1 = var02.map(KnownPack::isVanilla).map(var0 -> Lifecycle.stable()).orElse(Lifecycle.experimental());
        return new RegistrationInfo((Optional<KnownPack>)var02, var1);
    });
    public static final List<d<?>> WORLDGEN_REGISTRIES = List.of(new d<DimensionManager>(Registries.DIMENSION_TYPE, DimensionManager.DIRECT_CODEC), new d<BiomeBase>(Registries.BIOME, BiomeBase.DIRECT_CODEC), new d<ChatMessageType>(Registries.CHAT_TYPE, ChatMessageType.DIRECT_CODEC), new d(Registries.CONFIGURED_CARVER, WorldGenCarverWrapper.DIRECT_CODEC), new d(Registries.CONFIGURED_FEATURE, WorldGenFeatureConfigured.DIRECT_CODEC), new d<PlacedFeature>(Registries.PLACED_FEATURE, PlacedFeature.DIRECT_CODEC), new d<Structure>(Registries.STRUCTURE, Structure.DIRECT_CODEC), new d<StructureSet>(Registries.STRUCTURE_SET, StructureSet.DIRECT_CODEC), new d<ProcessorList>(Registries.PROCESSOR_LIST, DefinedStructureStructureProcessorType.DIRECT_CODEC), new d<WorldGenFeatureDefinedStructurePoolTemplate>(Registries.TEMPLATE_POOL, WorldGenFeatureDefinedStructurePoolTemplate.DIRECT_CODEC), new d<GeneratorSettingBase>(Registries.NOISE_SETTINGS, GeneratorSettingBase.DIRECT_CODEC), new d<NoiseGeneratorNormal.a>(Registries.NOISE, NoiseGeneratorNormal.a.DIRECT_CODEC), new d<DensityFunction>(Registries.DENSITY_FUNCTION, DensityFunction.DIRECT_CODEC), new d<WorldPreset>(Registries.WORLD_PRESET, WorldPreset.DIRECT_CODEC), new d<FlatLevelGeneratorPreset>(Registries.FLAT_LEVEL_GENERATOR_PRESET, FlatLevelGeneratorPreset.DIRECT_CODEC), new d<TrimPattern>(Registries.TRIM_PATTERN, TrimPattern.DIRECT_CODEC), new d<TrimMaterial>(Registries.TRIM_MATERIAL, TrimMaterial.DIRECT_CODEC), new d<TrialSpawnerConfig>(Registries.TRIAL_SPAWNER_CONFIG, TrialSpawnerConfig.DIRECT_CODEC), new d<WolfVariant>(Registries.WOLF_VARIANT, WolfVariant.DIRECT_CODEC, true), new d<WolfSoundVariant>(Registries.WOLF_SOUND_VARIANT, WolfSoundVariant.DIRECT_CODEC, true), new d<PigVariant>(Registries.PIG_VARIANT, PigVariant.DIRECT_CODEC, true), new d<FrogVariant>(Registries.FROG_VARIANT, FrogVariant.DIRECT_CODEC, true), new d<CatVariant>(Registries.CAT_VARIANT, CatVariant.DIRECT_CODEC, true), new d<CowVariant>(Registries.COW_VARIANT, CowVariant.DIRECT_CODEC, true), new d<ChickenVariant>(Registries.CHICKEN_VARIANT, ChickenVariant.DIRECT_CODEC, true), new d<PaintingVariant>(Registries.PAINTING_VARIANT, PaintingVariant.DIRECT_CODEC, true), new d<DamageType>(Registries.DAMAGE_TYPE, DamageType.DIRECT_CODEC), new d<MultiNoiseBiomeSourceParameterList>(Registries.MULTI_NOISE_BIOME_SOURCE_PARAMETER_LIST, MultiNoiseBiomeSourceParameterList.DIRECT_CODEC), new d<EnumBannerPatternType>(Registries.BANNER_PATTERN, EnumBannerPatternType.DIRECT_CODEC), new d<Enchantment>(Registries.ENCHANTMENT, Enchantment.DIRECT_CODEC), new d<EnchantmentProvider>(Registries.ENCHANTMENT_PROVIDER, EnchantmentProvider.DIRECT_CODEC), new d<JukeboxSong>(Registries.JUKEBOX_SONG, JukeboxSong.DIRECT_CODEC), new d<Instrument>(Registries.INSTRUMENT, Instrument.DIRECT_CODEC), new d<TestEnvironmentDefinition>(Registries.TEST_ENVIRONMENT, TestEnvironmentDefinition.DIRECT_CODEC), new d<GameTestInstance>(Registries.TEST_INSTANCE, GameTestInstance.DIRECT_CODEC));
    public static final List<d<?>> DIMENSION_REGISTRIES = List.of(new d<WorldDimension>(Registries.LEVEL_STEM, WorldDimension.CODEC));
    public static final List<d<?>> SYNCHRONIZED_REGISTRIES = List.of(new d<BiomeBase>(Registries.BIOME, BiomeBase.NETWORK_CODEC), new d<ChatMessageType>(Registries.CHAT_TYPE, ChatMessageType.DIRECT_CODEC), new d<TrimPattern>(Registries.TRIM_PATTERN, TrimPattern.DIRECT_CODEC), new d<TrimMaterial>(Registries.TRIM_MATERIAL, TrimMaterial.DIRECT_CODEC), new d<WolfVariant>(Registries.WOLF_VARIANT, WolfVariant.NETWORK_CODEC, true), new d<WolfSoundVariant>(Registries.WOLF_SOUND_VARIANT, WolfSoundVariant.NETWORK_CODEC, true), new d<PigVariant>(Registries.PIG_VARIANT, PigVariant.NETWORK_CODEC, true), new d<FrogVariant>(Registries.FROG_VARIANT, FrogVariant.NETWORK_CODEC, true), new d<CatVariant>(Registries.CAT_VARIANT, CatVariant.NETWORK_CODEC, true), new d<CowVariant>(Registries.COW_VARIANT, CowVariant.NETWORK_CODEC, true), new d<ChickenVariant>(Registries.CHICKEN_VARIANT, ChickenVariant.NETWORK_CODEC, true), new d<PaintingVariant>(Registries.PAINTING_VARIANT, PaintingVariant.DIRECT_CODEC, true), new d<DimensionManager>(Registries.DIMENSION_TYPE, DimensionManager.DIRECT_CODEC), new d<DamageType>(Registries.DAMAGE_TYPE, DamageType.DIRECT_CODEC), new d<EnumBannerPatternType>(Registries.BANNER_PATTERN, EnumBannerPatternType.DIRECT_CODEC), new d<Enchantment>(Registries.ENCHANTMENT, Enchantment.DIRECT_CODEC), new d<JukeboxSong>(Registries.JUKEBOX_SONG, JukeboxSong.DIRECT_CODEC), new d<Instrument>(Registries.INSTRUMENT, Instrument.DIRECT_CODEC), new d<TestEnvironmentDefinition>(Registries.TEST_ENVIRONMENT, TestEnvironmentDefinition.DIRECT_CODEC), new d<GameTestInstance>(Registries.TEST_INSTANCE, GameTestInstance.DIRECT_CODEC));

    public static IRegistryCustom.Dimension load(IResourceManager var0, List<HolderLookup.b<?>> var12, List<d<?>> var22) {
        return RegistryDataLoader.load((a<?> var1, RegistryOps.c var2) -> var1.loadFromResources(var0, var2), var12, var22);
    }

    public static IRegistryCustom.Dimension load(Map<ResourceKey<? extends IRegistry<?>>, c> var0, ResourceProvider var1, List<HolderLookup.b<?>> var22, List<d<?>> var32) {
        return RegistryDataLoader.load((a<?> var2, RegistryOps.c var3) -> var2.loadFromNetwork(var0, var1, var3), var22, var32);
    }

    private static IRegistryCustom.Dimension load(b var0, List<HolderLookup.b<?>> var12, List<d<?>> var22) {
        HashMap var3 = new HashMap();
        List<a<?>> var4 = var22.stream().map(var1 -> var1.create(Lifecycle.stable(), var3)).collect(Collectors.toUnmodifiableList());
        RegistryOps.c var5 = RegistryDataLoader.createContext(var12, var4);
        var4.forEach(var2 -> var0.apply((a<?>)var2, var5));
        var4.forEach(var1 -> {
            IRegistryWritable var2 = var1.registry();
            try {
                var2.freeze();
            }
            catch (Exception var3) {
                var3.put(var2.key(), var3);
            }
            if (var1.data.requiredNonEmpty && var2.size() == 0) {
                var3.put(var2.key(), new IllegalStateException("Registry must be non-empty: " + String.valueOf(var2.key().location())));
            }
        });
        if (!var3.isEmpty()) {
            throw RegistryDataLoader.logErrors(var3);
        }
        return new IRegistryCustom.c(var4.stream().map(a::registry).toList()).freeze();
    }

    private static RegistryOps.c createContext(List<HolderLookup.b<?>> var0, List<a<?>> var12) {
        final HashMap var2 = new HashMap();
        var0.forEach(var1 -> var2.put(var1.key(), RegistryDataLoader.createInfoForContextRegistry(var1)));
        var12.forEach(var1 -> var2.put(var1.registry.key(), RegistryDataLoader.createInfoForNewRegistry(var1.registry)));
        return new RegistryOps.c(){

            @Override
            public <T> Optional<RegistryOps.b<T>> lookup(ResourceKey<? extends IRegistry<? extends T>> var0) {
                return Optional.ofNullable((RegistryOps.b)var2.get(var0));
            }
        };
    }

    private static <T> RegistryOps.b<T> createInfoForNewRegistry(IRegistryWritable<T> var0) {
        return new RegistryOps.b<T>(var0, var0.createRegistrationLookup(), var0.registryLifecycle());
    }

    private static <T> RegistryOps.b<T> createInfoForContextRegistry(HolderLookup.b<T> var0) {
        return new RegistryOps.b<T>(var0, var0, var0.registryLifecycle());
    }

    private static ReportedException logErrors(Map<ResourceKey<?>, Exception> var0) {
        RegistryDataLoader.printFullDetailsToLog(var0);
        return RegistryDataLoader.createReportWithBriefInfo(var0);
    }

    private static void printFullDetailsToLog(Map<ResourceKey<?>, Exception> var02) {
        StringWriter var1 = new StringWriter();
        PrintWriter var2 = new PrintWriter(var1);
        Map<MinecraftKey, Map<MinecraftKey, Exception>> var3 = var02.entrySet().stream().collect(Collectors.groupingBy(var0 -> ((ResourceKey)var0.getKey()).registry(), Collectors.toMap(var0 -> ((ResourceKey)var0.getKey()).location(), Map.Entry::getValue)));
        var3.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(var12 -> {
            var2.printf("> Errors in registry %s:%n", var12.getKey());
            ((Map)var12.getValue()).entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(var1 -> {
                var2.printf(">> Errors in element %s:%n", var1.getKey());
                ((Exception)var1.getValue()).printStackTrace(var2);
            });
        });
        var2.flush();
        LOGGER.error("Registry loading errors:\n{}", (Object)var1);
    }

    private static ReportedException createReportWithBriefInfo(Map<ResourceKey<?>, Exception> var0) {
        CrashReport var1 = CrashReport.forThrowable(new IllegalStateException("Failed to load registries due to errors"), "Registry Loading");
        CrashReportSystemDetails var2 = var1.addCategory("Loading info");
        var2.setDetail("Errors", () -> {
            StringBuilder var12 = new StringBuilder();
            var0.entrySet().stream().sorted(Map.Entry.comparingByKey(ERROR_KEY_COMPARATOR)).forEach(var1 -> var12.append("\n\t\t").append(((ResourceKey)var1.getKey()).registry()).append("/").append(((ResourceKey)var1.getKey()).location()).append(": ").append(((Exception)var1.getValue()).getMessage()));
            return var12.toString();
        });
        return new ReportedException(var1);
    }

    private static <E> void loadElementFromResource(IRegistryWritable<E> var0, Decoder<E> var1, RegistryOps<JsonElement> var2, ResourceKey<E> var3, IResource var4, RegistrationInfo var5) throws IOException {
        try (BufferedReader var6 = var4.openAsReader();){
            JsonElement var7 = JsonParser.parseReader((Reader)var6);
            DataResult var8 = var1.parse(var2, (Object)var7);
            Object var9 = var8.getOrThrow();
            var0.register(var3, var9, var5);
        }
    }

    static <E> void loadContentsFromManager(IResourceManager var0, RegistryOps.c var1, IRegistryWritable<E> var2, Decoder<E> var3, Map<ResourceKey<?>, Exception> var4) {
        FileToIdConverter var5 = FileToIdConverter.registry(var2.key());
        RegistryOps<JsonElement> var6 = RegistryOps.create(JsonOps.INSTANCE, var1);
        for (Map.Entry<MinecraftKey, IResource> var8 : var5.listMatchingResources(var0).entrySet()) {
            MinecraftKey var9 = var8.getKey();
            ResourceKey var10 = ResourceKey.create(var2.key(), var5.fileToId(var9));
            IResource var11 = var8.getValue();
            RegistrationInfo var12 = REGISTRATION_INFO_CACHE.apply(var11.knownPackInfo());
            try {
                RegistryDataLoader.loadElementFromResource(var2, var3, var6, var10, var11, var12);
            }
            catch (Exception var13) {
                var4.put(var10, new IllegalStateException(String.format(Locale.ROOT, "Failed to parse %s from pack %s", var9, var11.sourcePackId()), var13));
            }
        }
        TagDataPack.loadTagsForRegistry(var0, var2);
    }

    static <E> void loadContentsFromNetwork(Map<ResourceKey<? extends IRegistry<?>>, c> var0, ResourceProvider var1, RegistryOps.c var2, IRegistryWritable<E> var3, Decoder<E> var4, Map<ResourceKey<?>, Exception> var5) {
        c var6 = var0.get(var3.key());
        if (var6 == null) {
            return;
        }
        RegistryOps<NBTBase> var7 = RegistryOps.create(DynamicOpsNBT.INSTANCE, var2);
        RegistryOps<JsonElement> var8 = RegistryOps.create(JsonOps.INSTANCE, var2);
        FileToIdConverter var9 = FileToIdConverter.registry(var3.key());
        for (RegistrySynchronization.a var11 : var6.elements) {
            Object var15;
            MinecraftKey var14;
            ResourceKey var12 = ResourceKey.create(var3.key(), var11.id());
            Optional<NBTBase> var13 = var11.data();
            if (var13.isPresent()) {
                try {
                    var14 = var4.parse(var7, (Object)var13.get());
                    var15 = var14.getOrThrow();
                    var3.register(var12, var15, NETWORK_REGISTRATION_INFO);
                }
                catch (Exception var142) {
                    var5.put(var12, new IllegalStateException(String.format(Locale.ROOT, "Failed to parse value %s from server", var13.get()), var142));
                }
                continue;
            }
            var14 = var9.idToFile(var11.id());
            try {
                var15 = var1.getResourceOrThrow(var14);
                RegistryDataLoader.loadElementFromResource(var3, var4, var8, var12, (IResource)var15, NETWORK_REGISTRATION_INFO);
            }
            catch (Exception var152) {
                var5.put(var12, new IllegalStateException("Failed to parse local data", var152));
            }
        }
        TagDataPack.loadTagsFromNetwork(var6.tags, var3);
    }

    @FunctionalInterface
    static interface b {
        public void apply(a<?> var1, RegistryOps.c var2);
    }

    public static final class c
    extends Record {
        final List<RegistrySynchronization.a> elements;
        final TagNetworkSerialization.a tags;

        public c(List<RegistrySynchronization.a> var0, TagNetworkSerialization.a var1) {
            this.elements = var0;
            this.tags = var1;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "elements;tags", "elements", "tags"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "elements;tags", "elements", "tags"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "elements;tags", "elements", "tags"}, this, var0);
        }

        public List<RegistrySynchronization.a> elements() {
            return this.elements;
        }

        public TagNetworkSerialization.a tags() {
            return this.tags;
        }
    }

    static final class a<T>
    extends Record {
        final d<T> data;
        final IRegistryWritable<T> registry;
        private final Map<ResourceKey<?>, Exception> loadingErrors;

        a(d<T> var0, IRegistryWritable<T> var1, Map<ResourceKey<?>, Exception> var2) {
            this.data = var0;
            this.registry = var1;
            this.loadingErrors = var2;
        }

        public void loadFromResources(IResourceManager var0, RegistryOps.c var1) {
            RegistryDataLoader.loadContentsFromManager(var0, var1, this.registry, this.data.elementCodec, this.loadingErrors);
        }

        public void loadFromNetwork(Map<ResourceKey<? extends IRegistry<?>>, c> var0, ResourceProvider var1, RegistryOps.c var2) {
            RegistryDataLoader.loadContentsFromNetwork(var0, var1, var2, this.registry, this.data.elementCodec, this.loadingErrors);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "data;registry;loadingErrors", "data", "registry", "loadingErrors"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "data;registry;loadingErrors", "data", "registry", "loadingErrors"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "data;registry;loadingErrors", "data", "registry", "loadingErrors"}, this, var0);
        }

        public d<T> data() {
            return this.data;
        }

        public IRegistryWritable<T> registry() {
            return this.registry;
        }

        public Map<ResourceKey<?>, Exception> loadingErrors() {
            return this.loadingErrors;
        }
    }

    public static final class d<T>
    extends Record {
        private final ResourceKey<? extends IRegistry<T>> key;
        final Codec<T> elementCodec;
        final boolean requiredNonEmpty;

        d(ResourceKey<? extends IRegistry<T>> var0, Codec<T> var1) {
            this(var0, var1, false);
        }

        public d(ResourceKey<? extends IRegistry<T>> var0, Codec<T> var1, boolean var2) {
            this.key = var0;
            this.elementCodec = var1;
            this.requiredNonEmpty = var2;
        }

        a<T> create(Lifecycle var0, Map<ResourceKey<?>, Exception> var1) {
            RegistryMaterials var2 = new RegistryMaterials(this.key, var0);
            return new a(this, var2, var1);
        }

        public void runWithArguments(BiConsumer<ResourceKey<? extends IRegistry<T>>, Codec<T>> var0) {
            var0.accept(this.key, this.elementCodec);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{d.class, "key;elementCodec;requiredNonEmpty", "key", "elementCodec", "requiredNonEmpty"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{d.class, "key;elementCodec;requiredNonEmpty", "key", "elementCodec", "requiredNonEmpty"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{d.class, "key;elementCodec;requiredNonEmpty", "key", "elementCodec", "requiredNonEmpty"}, this, var0);
        }

        public ResourceKey<? extends IRegistry<T>> key() {
            return this.key;
        }

        public Codec<T> elementCodec() {
            return this.elementCodec;
        }

        public boolean requiredNonEmpty() {
            return this.requiredNonEmpty;
        }
    }
}

