/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import io.netty.buffer.ByteBuf;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.ResourceKeyInvalidException;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public final class MinecraftKey
implements Comparable<MinecraftKey> {
    public static final Codec<MinecraftKey> CODEC = Codec.STRING.comapFlatMap(MinecraftKey::read, MinecraftKey::toString).stable();
    public static final StreamCodec<ByteBuf, MinecraftKey> STREAM_CODEC = ByteBufCodecs.STRING_UTF8.map(MinecraftKey::parse, MinecraftKey::toString);
    public static final SimpleCommandExceptionType ERROR_INVALID = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("argument.id.invalid"));
    public static final char NAMESPACE_SEPARATOR = ':';
    public static final String DEFAULT_NAMESPACE = "minecraft";
    public static final String REALMS_NAMESPACE = "realms";
    private final String namespace;
    private final String path;

    private MinecraftKey(String var0, String var1) {
        assert (MinecraftKey.isValidNamespace(var0));
        assert (MinecraftKey.isValidPath(var1));
        this.namespace = var0;
        this.path = var1;
    }

    private static MinecraftKey createUntrusted(String var0, String var1) {
        return new MinecraftKey(MinecraftKey.assertValidNamespace(var0, var1), MinecraftKey.assertValidPath(var0, var1));
    }

    public static MinecraftKey fromNamespaceAndPath(String var0, String var1) {
        return MinecraftKey.createUntrusted(var0, var1);
    }

    public static MinecraftKey parse(String var0) {
        return MinecraftKey.bySeparator(var0, ':');
    }

    public static MinecraftKey withDefaultNamespace(String var0) {
        return new MinecraftKey(DEFAULT_NAMESPACE, MinecraftKey.assertValidPath(DEFAULT_NAMESPACE, var0));
    }

    @Nullable
    public static MinecraftKey tryParse(String var0) {
        return MinecraftKey.tryBySeparator(var0, ':');
    }

    @Nullable
    public static MinecraftKey tryBuild(String var0, String var1) {
        if (MinecraftKey.isValidNamespace(var0) && MinecraftKey.isValidPath(var1)) {
            return new MinecraftKey(var0, var1);
        }
        return null;
    }

    public static MinecraftKey bySeparator(String var0, char var1) {
        int var2 = var0.indexOf(var1);
        if (var2 >= 0) {
            String var3 = var0.substring(var2 + 1);
            if (var2 != 0) {
                String var4 = var0.substring(0, var2);
                return MinecraftKey.createUntrusted(var4, var3);
            }
            return MinecraftKey.withDefaultNamespace(var3);
        }
        return MinecraftKey.withDefaultNamespace(var0);
    }

    @Nullable
    public static MinecraftKey tryBySeparator(String var0, char var1) {
        int var2 = var0.indexOf(var1);
        if (var2 >= 0) {
            String var3 = var0.substring(var2 + 1);
            if (!MinecraftKey.isValidPath(var3)) {
                return null;
            }
            if (var2 != 0) {
                String var4 = var0.substring(0, var2);
                return MinecraftKey.isValidNamespace(var4) ? new MinecraftKey(var4, var3) : null;
            }
            return new MinecraftKey(DEFAULT_NAMESPACE, var3);
        }
        return MinecraftKey.isValidPath(var0) ? new MinecraftKey(DEFAULT_NAMESPACE, var0) : null;
    }

    public static DataResult<MinecraftKey> read(String var0) {
        try {
            return DataResult.success((Object)MinecraftKey.parse(var0));
        }
        catch (ResourceKeyInvalidException var1) {
            return DataResult.error(() -> "Not a valid resource location: " + var0 + " " + var1.getMessage());
        }
    }

    public String getPath() {
        return this.path;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public MinecraftKey withPath(String var0) {
        return new MinecraftKey(this.namespace, MinecraftKey.assertValidPath(this.namespace, var0));
    }

    public MinecraftKey withPath(UnaryOperator<String> var0) {
        return this.withPath((String)var0.apply(this.path));
    }

    public MinecraftKey withPrefix(String var0) {
        return this.withPath(var0 + this.path);
    }

    public MinecraftKey withSuffix(String var0) {
        return this.withPath(this.path + var0);
    }

    public String toString() {
        return this.namespace + ":" + this.path;
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (var0 instanceof MinecraftKey) {
            MinecraftKey var1 = (MinecraftKey)var0;
            return this.namespace.equals(var1.namespace) && this.path.equals(var1.path);
        }
        return false;
    }

    public int hashCode() {
        return 31 * this.namespace.hashCode() + this.path.hashCode();
    }

    @Override
    public int compareTo(MinecraftKey var0) {
        int var1 = this.path.compareTo(var0.path);
        if (var1 == 0) {
            var1 = this.namespace.compareTo(var0.namespace);
        }
        return var1;
    }

    public String toDebugFileName() {
        return this.toString().replace('/', '_').replace(':', '_');
    }

    public String toLanguageKey() {
        return this.namespace + "." + this.path;
    }

    public String toShortLanguageKey() {
        return this.namespace.equals(DEFAULT_NAMESPACE) ? this.path : this.toLanguageKey();
    }

    public String toLanguageKey(String var0) {
        return var0 + "." + this.toLanguageKey();
    }

    public String toLanguageKey(String var0, String var1) {
        return var0 + "." + this.toLanguageKey() + "." + var1;
    }

    private static String readGreedy(StringReader var0) {
        int var1 = var0.getCursor();
        while (var0.canRead() && MinecraftKey.isAllowedInResourceLocation(var0.peek())) {
            var0.skip();
        }
        return var0.getString().substring(var1, var0.getCursor());
    }

    public static MinecraftKey read(StringReader var0) throws CommandSyntaxException {
        int var1 = var0.getCursor();
        String var2 = MinecraftKey.readGreedy(var0);
        try {
            return MinecraftKey.parse(var2);
        }
        catch (ResourceKeyInvalidException var3) {
            var0.setCursor(var1);
            throw ERROR_INVALID.createWithContext((ImmutableStringReader)var0);
        }
    }

    public static MinecraftKey readNonEmpty(StringReader var0) throws CommandSyntaxException {
        int var1 = var0.getCursor();
        String var2 = MinecraftKey.readGreedy(var0);
        if (var2.isEmpty()) {
            throw ERROR_INVALID.createWithContext((ImmutableStringReader)var0);
        }
        try {
            return MinecraftKey.parse(var2);
        }
        catch (ResourceKeyInvalidException var3) {
            var0.setCursor(var1);
            throw ERROR_INVALID.createWithContext((ImmutableStringReader)var0);
        }
    }

    public static boolean isAllowedInResourceLocation(char var0) {
        return var0 >= '0' && var0 <= '9' || var0 >= 'a' && var0 <= 'z' || var0 == '_' || var0 == ':' || var0 == '/' || var0 == '.' || var0 == '-';
    }

    public static boolean isValidPath(String var0) {
        for (int var1 = 0; var1 < var0.length(); ++var1) {
            if (MinecraftKey.validPathChar(var0.charAt(var1))) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidNamespace(String var0) {
        for (int var1 = 0; var1 < var0.length(); ++var1) {
            if (MinecraftKey.validNamespaceChar(var0.charAt(var1))) continue;
            return false;
        }
        return true;
    }

    private static String assertValidNamespace(String var0, String var1) {
        if (!MinecraftKey.isValidNamespace(var0)) {
            throw new ResourceKeyInvalidException("Non [a-z0-9_.-] character in namespace of location: " + var0 + ":" + var1);
        }
        return var0;
    }

    public static boolean validPathChar(char var0) {
        return var0 == '_' || var0 == '-' || var0 >= 'a' && var0 <= 'z' || var0 >= '0' && var0 <= '9' || var0 == '/' || var0 == '.';
    }

    private static boolean validNamespaceChar(char var0) {
        return var0 == '_' || var0 == '-' || var0 >= 'a' && var0 <= 'z' || var0 >= '0' && var0 <= '9' || var0 == '.';
    }

    private static String assertValidPath(String var0, String var1) {
        if (!MinecraftKey.isValidPath(var1)) {
            throw new ResourceKeyInvalidException("Non [a-z0-9/._-] character in path of location: " + var0 + ":" + var1);
        }
        return var1;
    }

    @Override
    public /* synthetic */ int compareTo(Object object) {
        return this.compareTo((MinecraftKey)object);
    }
}

