/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Comparators;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagEnd;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.nbt.PrimitiveTag;
import net.minecraft.nbt.SnbtPrinterTagVisitor;
import net.minecraft.nbt.TextComponentTagVisitor;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.IBlockDataHolder;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.material.Fluid;
import org.slf4j.Logger;

public final class GameProfileSerializer {
    private static final Comparator<NBTTagList> YXZ_LISTTAG_INT_COMPARATOR = Comparator.comparingInt(var0 -> var0.getIntOr(1, 0)).thenComparingInt(var0 -> var0.getIntOr(0, 0)).thenComparingInt(var0 -> var0.getIntOr(2, 0));
    private static final Comparator<NBTTagList> YXZ_LISTTAG_DOUBLE_COMPARATOR = Comparator.comparingDouble(var0 -> var0.getDoubleOr(1, 0.0)).thenComparingDouble(var0 -> var0.getDoubleOr(0, 0.0)).thenComparingDouble(var0 -> var0.getDoubleOr(2, 0.0));
    private static final Codec<ResourceKey<Block>> BLOCK_NAME_CODEC = ResourceKey.codec(Registries.BLOCK);
    public static final String SNBT_DATA_TAG = "data";
    private static final char PROPERTIES_START = '{';
    private static final char PROPERTIES_END = '}';
    private static final String ELEMENT_SEPARATOR = ",";
    private static final char KEY_VALUE_SEPARATOR = ':';
    private static final Splitter COMMA_SPLITTER = Splitter.on((String)",");
    private static final Splitter COLON_SPLITTER = Splitter.on((char)':').limit(2);
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int INDENT = 2;
    private static final int NOT_FOUND = -1;

    private GameProfileSerializer() {
    }

    @VisibleForTesting
    public static boolean compareNbt(@Nullable NBTBase var0, @Nullable NBTBase var1, boolean var2) {
        if (var0 == var1) {
            return true;
        }
        if (var0 == null) {
            return true;
        }
        if (var1 == null) {
            return false;
        }
        if (!var0.getClass().equals(var1.getClass())) {
            return false;
        }
        if (var0 instanceof NBTTagCompound) {
            NBTTagCompound var3 = (NBTTagCompound)var0;
            NBTTagCompound var5 = (NBTTagCompound)var1;
            if (var5.size() < var3.size()) {
                return false;
            }
            for (Map.Entry<String, NBTBase> var7 : var3.entrySet()) {
                NBTBase var8 = var7.getValue();
                if (GameProfileSerializer.compareNbt(var8, var5.get(var7.getKey()), var2)) continue;
                return false;
            }
            return true;
        }
        if (var0 instanceof NBTTagList) {
            NBTTagList var4 = (NBTTagList)var0;
            if (var2) {
                NBTTagList var5 = (NBTTagList)var1;
                if (var4.isEmpty()) {
                    return var5.isEmpty();
                }
                if (var5.size() < var4.size()) {
                    return false;
                }
                for (NBTBase var7 : var4) {
                    boolean var8 = false;
                    for (NBTBase var10 : var5) {
                        if (!GameProfileSerializer.compareNbt(var7, var10, var2)) continue;
                        var8 = true;
                        break;
                    }
                    if (var8) continue;
                    return false;
                }
                return true;
            }
        }
        return var0.equals(var1);
    }

    public static IBlockData readBlockState(HolderGetter<Block> var0, NBTTagCompound var1) {
        Optional var2 = var1.read("Name", BLOCK_NAME_CODEC).flatMap(var0::get);
        if (var2.isEmpty()) {
            return Blocks.AIR.defaultBlockState();
        }
        Block var3 = (Block)((Holder)var2.get()).value();
        IBlockData var4 = var3.defaultBlockState();
        Optional<NBTTagCompound> var5 = var1.getCompound("Properties");
        if (var5.isPresent()) {
            BlockStateList<Block, IBlockData> var6 = var3.getStateDefinition();
            for (String var8 : var5.get().keySet()) {
                IBlockState<?> var9 = var6.getProperty(var8);
                if (var9 == null) continue;
                var4 = GameProfileSerializer.setValueHelper(var4, var9, var8, var5.get(), var1);
            }
        }
        return var4;
    }

    private static <S extends IBlockDataHolder<?, S>, T extends Comparable<T>> S setValueHelper(S var0, IBlockState<T> var1, String var2, NBTTagCompound var3, NBTTagCompound var4) {
        Optional var5 = var3.getString(var2).flatMap(var1::getValue);
        if (var5.isPresent()) {
            return (S)((IBlockDataHolder)var0.setValue(var1, (Comparable)((Comparable)var5.get())));
        }
        LOGGER.warn("Unable to read property: {} with value: {} for blockstate: {}", new Object[]{var2, var3.get(var2), var4});
        return var0;
    }

    public static NBTTagCompound writeBlockState(IBlockData var0) {
        NBTTagCompound var1 = new NBTTagCompound();
        var1.putString("Name", BuiltInRegistries.BLOCK.getKey(var0.getBlock()).toString());
        Map<IBlockState<?>, Comparable<?>> var2 = var0.getValues();
        if (!var2.isEmpty()) {
            NBTTagCompound var3 = new NBTTagCompound();
            for (Map.Entry<IBlockState<?>, Comparable<?>> var5 : var2.entrySet()) {
                IBlockState<?> var6 = var5.getKey();
                var3.putString(var6.getName(), GameProfileSerializer.getName(var6, var5.getValue()));
            }
            var1.put("Properties", var3);
        }
        return var1;
    }

    public static NBTTagCompound writeFluidState(Fluid var0) {
        NBTTagCompound var1 = new NBTTagCompound();
        var1.putString("Name", BuiltInRegistries.FLUID.getKey(var0.getType()).toString());
        Map<IBlockState<?>, Comparable<?>> var2 = var0.getValues();
        if (!var2.isEmpty()) {
            NBTTagCompound var3 = new NBTTagCompound();
            for (Map.Entry<IBlockState<?>, Comparable<?>> var5 : var2.entrySet()) {
                IBlockState<?> var6 = var5.getKey();
                var3.putString(var6.getName(), GameProfileSerializer.getName(var6, var5.getValue()));
            }
            var1.put("Properties", var3);
        }
        return var1;
    }

    private static <T extends Comparable<T>> String getName(IBlockState<T> var0, Comparable<?> var1) {
        return var0.getName(var1);
    }

    public static String prettyPrint(NBTBase var0) {
        return GameProfileSerializer.prettyPrint(var0, false);
    }

    public static String prettyPrint(NBTBase var0, boolean var1) {
        return GameProfileSerializer.prettyPrint(new StringBuilder(), var0, 0, var1).toString();
    }

    public static StringBuilder prettyPrint(StringBuilder var0, NBTBase var1, int var2, boolean var3) {
        NBTBase nBTBase = var1;
        Objects.requireNonNull(nBTBase);
        NBTBase nBTBase2 = nBTBase;
        int n2 = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PrimitiveTag.class, NBTTagEnd.class, NBTTagByteArray.class, NBTTagList.class, NBTTagIntArray.class, NBTTagCompound.class, NBTTagLongArray.class}, (Object)nBTBase2, n2)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                PrimitiveTag var6 = (PrimitiveTag)nBTBase2;
                yield var0.append(var6);
            }
            case 1 -> {
                NBTTagEnd var7 = (NBTTagEnd)nBTBase2;
                yield var0;
            }
            case 2 -> {
                NBTTagByteArray var8 = (NBTTagByteArray)nBTBase2;
                byte[] var9 = var8.getAsByteArray();
                int var10 = var9.length;
                GameProfileSerializer.indent(var2, var0).append("byte[").append(var10).append("] {\n");
                if (var3) {
                    GameProfileSerializer.indent(var2 + 1, var0);
                    for (int var11 = 0; var11 < var9.length; ++var11) {
                        if (var11 != 0) {
                            var0.append(',');
                        }
                        if (var11 % 16 == 0 && var11 / 16 > 0) {
                            var0.append('\n');
                            if (var11 < var9.length) {
                                GameProfileSerializer.indent(var2 + 1, var0);
                            }
                        } else if (var11 != 0) {
                            var0.append(' ');
                        }
                        var0.append(String.format(Locale.ROOT, "0x%02X", var9[var11] & 0xFF));
                    }
                } else {
                    GameProfileSerializer.indent(var2 + 1, var0).append(" // Skipped, supply withBinaryBlobs true");
                }
                var0.append('\n');
                GameProfileSerializer.indent(var2, var0).append('}');
                yield var0;
            }
            case 3 -> {
                NBTTagList var9 = (NBTTagList)nBTBase2;
                int var10 = var9.size();
                GameProfileSerializer.indent(var2, var0).append("list").append("[").append(var10).append("] [");
                if (var10 != 0) {
                    var0.append('\n');
                }
                for (int var11 = 0; var11 < var10; ++var11) {
                    if (var11 != 0) {
                        var0.append(",\n");
                    }
                    GameProfileSerializer.indent(var2 + 1, var0);
                    GameProfileSerializer.prettyPrint(var0, var9.get(var11), var2 + 1, var3);
                }
                if (var10 != 0) {
                    var0.append('\n');
                }
                GameProfileSerializer.indent(var2, var0).append(']');
                yield var0;
            }
            case 4 -> {
                NBTTagIntArray var10 = (NBTTagIntArray)nBTBase2;
                int[] var11 = var10.getAsIntArray();
                int var12 = 0;
                for (int var16 : var11) {
                    var12 = Math.max(var12, String.format(Locale.ROOT, "%X", var16).length());
                }
                int var13 = var11.length;
                GameProfileSerializer.indent(var2, var0).append("int[").append(var13).append("] {\n");
                if (var3) {
                    GameProfileSerializer.indent(var2 + 1, var0);
                    for (int var14 = 0; var14 < var11.length; ++var14) {
                        if (var14 != 0) {
                            var0.append(',');
                        }
                        if (var14 % 16 == 0 && var14 / 16 > 0) {
                            var0.append('\n');
                            if (var14 < var11.length) {
                                GameProfileSerializer.indent(var2 + 1, var0);
                            }
                        } else if (var14 != 0) {
                            var0.append(' ');
                        }
                        var0.append(String.format(Locale.ROOT, "0x%0" + var12 + "X", var11[var14]));
                    }
                } else {
                    GameProfileSerializer.indent(var2 + 1, var0).append(" // Skipped, supply withBinaryBlobs true");
                }
                var0.append('\n');
                GameProfileSerializer.indent(var2, var0).append('}');
                yield var0;
            }
            case 5 -> {
                NBTTagCompound var11 = (NBTTagCompound)nBTBase2;
                ArrayList var12 = Lists.newArrayList(var11.keySet());
                Collections.sort(var12);
                GameProfileSerializer.indent(var2, var0).append('{');
                if (var0.length() - var0.lastIndexOf("\n") > 2 * (var2 + 1)) {
                    var0.append('\n');
                    GameProfileSerializer.indent(var2 + 1, var0);
                }
                int var13 = var12.stream().mapToInt(String::length).max().orElse(0);
                String var14 = Strings.repeat((String)" ", (int)var13);
                for (int var15 = 0; var15 < var12.size(); ++var15) {
                    if (var15 != 0) {
                        var0.append(",\n");
                    }
                    String var16 = (String)var12.get(var15);
                    GameProfileSerializer.indent(var2 + 1, var0).append('\"').append(var16).append('\"').append(var14, 0, var14.length() - var16.length()).append(": ");
                    GameProfileSerializer.prettyPrint(var0, var11.get(var16), var2 + 1, var3);
                }
                if (!var12.isEmpty()) {
                    var0.append('\n');
                }
                GameProfileSerializer.indent(var2, var0).append('}');
                yield var0;
            }
            case 6 -> {
                NBTTagLongArray var12 = (NBTTagLongArray)nBTBase2;
                long[] var13 = var12.getAsLongArray();
                long var14 = 0L;
                for (long var19 : var13) {
                    var14 = Math.max(var14, (long)String.format(Locale.ROOT, "%X", var19).length());
                }
                long var16 = var13.length;
                GameProfileSerializer.indent(var2, var0).append("long[").append(var16).append("] {\n");
                if (var3) {
                    GameProfileSerializer.indent(var2 + 1, var0);
                    for (int var18 = 0; var18 < var13.length; ++var18) {
                        if (var18 != 0) {
                            var0.append(',');
                        }
                        if (var18 % 16 == 0 && var18 / 16 > 0) {
                            var0.append('\n');
                            if (var18 < var13.length) {
                                GameProfileSerializer.indent(var2 + 1, var0);
                            }
                        } else if (var18 != 0) {
                            var0.append(' ');
                        }
                        var0.append(String.format(Locale.ROOT, "0x%0" + var14 + "X", var13[var18]));
                    }
                } else {
                    GameProfileSerializer.indent(var2 + 1, var0).append(" // Skipped, supply withBinaryBlobs true");
                }
                var0.append('\n');
                GameProfileSerializer.indent(var2, var0).append('}');
                yield var0;
            }
        };
    }

    private static StringBuilder indent(int var0, StringBuilder var1) {
        int var2 = var1.lastIndexOf("\n") + 1;
        int var3 = var1.length() - var2;
        for (int var4 = 0; var4 < 2 * var0 - var3; ++var4) {
            var1.append(' ');
        }
        return var1;
    }

    public static IChatBaseComponent toPrettyComponent(NBTBase var0) {
        return new TextComponentTagVisitor("").visit(var0);
    }

    public static String structureToSnbt(NBTTagCompound var0) {
        return new SnbtPrinterTagVisitor().visit(GameProfileSerializer.packStructureTemplate(var0));
    }

    public static NBTTagCompound snbtToStructure(String var0) throws CommandSyntaxException {
        return GameProfileSerializer.unpackStructureTemplate(MojangsonParser.parseCompoundFully(var0));
    }

    @VisibleForTesting
    static NBTTagCompound packStructureTemplate(NBTTagCompound var02) {
        NBTTagList var5;
        Object var4;
        Optional<NBTTagList> var2 = var02.getList("palettes");
        NBTTagList var12 = var2.isPresent() ? var2.get().getListOrEmpty(0) : var02.getListOrEmpty("palette");
        NBTTagList var3 = var12.compoundStream().map(GameProfileSerializer::packBlockState).map(NBTTagString::valueOf).collect(Collectors.toCollection(NBTTagList::new));
        var02.put("palette", var3);
        if (var2.isPresent()) {
            var4 = new NBTTagList();
            var2.get().stream().flatMap(var0 -> var0.asList().stream()).forEach(arg_0 -> GameProfileSerializer.a(var3, (NBTTagList)var4, arg_0));
            var02.put("palettes", (NBTBase)var4);
        }
        if (((Optional)(var4 = var02.getList("entities"))).isPresent()) {
            var5 = ((NBTTagList)((Optional)var4).get()).compoundStream().sorted(Comparator.comparing(var0 -> var0.getList("pos"), Comparators.emptiesLast(YXZ_LISTTAG_DOUBLE_COMPARATOR))).collect(Collectors.toCollection(NBTTagList::new));
            var02.put("entities", var5);
        }
        var5 = var02.getList("blocks").stream().flatMap(NBTTagList::compoundStream).sorted(Comparator.comparing(var0 -> var0.getList("pos"), Comparators.emptiesLast(YXZ_LISTTAG_INT_COMPARATOR))).peek(var1 -> var1.putString("state", var3.getString(var1.getIntOr("state", 0)).orElseThrow())).collect(Collectors.toCollection(NBTTagList::new));
        var02.put(SNBT_DATA_TAG, var5);
        var02.remove("blocks");
        return var02;
    }

    @VisibleForTesting
    static NBTTagCompound unpackStructureTemplate(NBTTagCompound var02) {
        NBTTagList var1 = var02.getListOrEmpty("palette");
        Map var2 = (Map)var1.stream().flatMap(var0 -> var0.asString().stream()).collect(ImmutableMap.toImmutableMap(Function.identity(), GameProfileSerializer::unpackBlockState));
        Optional<NBTTagList> var3 = var02.getList("palettes");
        if (var3.isPresent()) {
            var02.put("palettes", var3.get().compoundStream().map(var12 -> var2.keySet().stream().map(var1 -> var12.getString((String)var1).orElseThrow()).map(GameProfileSerializer::unpackBlockState).collect(Collectors.toCollection(NBTTagList::new))).collect(Collectors.toCollection(NBTTagList::new)));
            var02.remove("palette");
        } else {
            var02.put("palette", var2.values().stream().collect(Collectors.toCollection(NBTTagList::new)));
        }
        Optional<NBTTagList> var4 = var02.getList(SNBT_DATA_TAG);
        if (var4.isPresent()) {
            Object2IntOpenHashMap var5 = new Object2IntOpenHashMap();
            var5.defaultReturnValue(-1);
            for (int var6 = 0; var6 < var1.size(); ++var6) {
                var5.put((Object)var1.getString(var6).orElseThrow(), var6);
            }
            NBTTagList var6 = var4.get();
            for (int var7 = 0; var7 < var6.size(); ++var7) {
                NBTTagCompound var8 = var6.getCompound(var7).orElseThrow();
                String var9 = var8.getString("state").orElseThrow();
                int var10 = var5.getInt((Object)var9);
                if (var10 == -1) {
                    throw new IllegalStateException("Entry " + var9 + " missing from palette");
                }
                var8.putInt("state", var10);
            }
            var02.put("blocks", var6);
            var02.remove(SNBT_DATA_TAG);
        }
        return var02;
    }

    @VisibleForTesting
    static String packBlockState(NBTTagCompound var0) {
        StringBuilder var12 = new StringBuilder(var0.getString("Name").orElseThrow());
        var0.getCompound("Properties").ifPresent(var1 -> {
            String var2 = var1.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(var0 -> (String)var0.getKey() + ":" + ((NBTBase)var0.getValue()).asString().orElseThrow()).collect(Collectors.joining(ELEMENT_SEPARATOR));
            var12.append('{').append(var2).append('}');
        });
        return var12.toString();
    }

    @VisibleForTesting
    static NBTTagCompound unpackBlockState(String var0) {
        String var3;
        NBTTagCompound var1 = new NBTTagCompound();
        int var22 = var0.indexOf(123);
        if (var22 >= 0) {
            var3 = var0.substring(0, var22);
            NBTTagCompound var4 = new NBTTagCompound();
            if (var22 + 2 <= var0.length()) {
                String var5 = var0.substring(var22 + 1, var0.indexOf(125, var22));
                COMMA_SPLITTER.split((CharSequence)var5).forEach(var2 -> {
                    List var3 = COLON_SPLITTER.splitToList((CharSequence)var2);
                    if (var3.size() == 2) {
                        var4.putString((String)var3.get(0), (String)var3.get(1));
                    } else {
                        LOGGER.error("Something went wrong parsing: '{}' -- incorrect gamedata!", (Object)var0);
                    }
                });
                var1.put("Properties", var4);
            }
        } else {
            var3 = var0;
        }
        var1.putString("Name", var3);
        return var1;
    }

    public static NBTTagCompound addCurrentDataVersion(NBTTagCompound var0) {
        int var1 = SharedConstants.getCurrentVersion().getDataVersion().getVersion();
        return GameProfileSerializer.addDataVersion(var0, var1);
    }

    public static NBTTagCompound addDataVersion(NBTTagCompound var0, int var1) {
        var0.putInt("DataVersion", var1);
        return var0;
    }

    public static int getDataVersion(NBTTagCompound var0, int var1) {
        return var0.getIntOr("DataVersion", var1);
    }

    public static int getDataVersion(Dynamic<?> var0, int var1) {
        return var0.get("DataVersion").asInt(var1);
    }

    private static /* synthetic */ void a(NBTTagList var0, NBTTagList var1, NBTTagList var2) {
        NBTTagCompound var3 = new NBTTagCompound();
        for (int var4 = 0; var4 < var2.size(); ++var4) {
            var3.putString(var0.getString(var4).orElseThrow(), GameProfileSerializer.packBlockState(var2.getCompound(var4).orElseThrow()));
        }
        var1.add(var3);
    }
}

