/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.commands.arguments.blocks.ArgumentTileLocation;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.gametest.framework.GameTestInstance;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.TestInstanceBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.ticks.TickListServer;

public class GameTestHarnessStructures {
    public static final int DEFAULT_Y_SEARCH_RADIUS = 10;
    public static final String DEFAULT_TEST_STRUCTURES_DIR = "Minecraft.Server/src/test/convertables/data";
    public static Path testStructuresDir = Paths.get("Minecraft.Server/src/test/convertables/data", new String[0]);

    public static EnumBlockRotation getRotationForRotationSteps(int var0) {
        switch (var0) {
            case 0: {
                return EnumBlockRotation.NONE;
            }
            case 1: {
                return EnumBlockRotation.CLOCKWISE_90;
            }
            case 2: {
                return EnumBlockRotation.CLOCKWISE_180;
            }
            case 3: {
                return EnumBlockRotation.COUNTERCLOCKWISE_90;
            }
        }
        throw new IllegalArgumentException("rotationSteps must be a value from 0-3. Got value " + var0);
    }

    public static int getRotationStepsForRotation(EnumBlockRotation var0) {
        switch (var0) {
            case NONE: {
                return 0;
            }
            case CLOCKWISE_90: {
                return 1;
            }
            case CLOCKWISE_180: {
                return 2;
            }
            case COUNTERCLOCKWISE_90: {
                return 3;
            }
        }
        throw new IllegalArgumentException("Unknown rotation value, don't know how many steps it represents: " + String.valueOf(var0));
    }

    public static TestInstanceBlockEntity createNewEmptyTest(MinecraftKey var0, BlockPosition var1, BaseBlockPosition var2, EnumBlockRotation var3, WorldServer var4) {
        StructureBoundingBox var5 = GameTestHarnessStructures.getStructureBoundingBox(TestInstanceBlockEntity.getStructurePos(var1), var2, var3);
        GameTestHarnessStructures.clearSpaceForStructure(var5, var4);
        var4.setBlockAndUpdate(var1, Blocks.TEST_INSTANCE_BLOCK.defaultBlockState());
        TestInstanceBlockEntity var6 = (TestInstanceBlockEntity)var4.getBlockEntity(var1);
        ResourceKey<GameTestInstance> var7 = ResourceKey.create(Registries.TEST_INSTANCE, var0);
        var6.set(new TestInstanceBlockEntity.a(Optional.of(var7), var2, var3, false, TestInstanceBlockEntity.b.CLEARED, Optional.empty()));
        return var6;
    }

    public static void clearSpaceForStructure(StructureBoundingBox var02, WorldServer var1) {
        int var22 = var02.minY() - 1;
        StructureBoundingBox var3 = new StructureBoundingBox(var02.minX() - 2, var02.minY() - 3, var02.minZ() - 3, var02.maxX() + 3, var02.maxY() + 20, var02.maxZ() + 3);
        BlockPosition.betweenClosedStream(var3).forEach(var2 -> GameTestHarnessStructures.clearBlock(var22, var2, var1));
        ((TickListServer)var1.getBlockTicks()).clearArea(var3);
        var1.clearBlockEvents(var3);
        AxisAlignedBB var4 = AxisAlignedBB.of(var3);
        List<Entity> var5 = var1.getEntitiesOfClass(Entity.class, var4, var0 -> !(var0 instanceof EntityHuman));
        var5.forEach(Entity::discard);
    }

    public static BlockPosition getTransformedFarCorner(BlockPosition var0, BaseBlockPosition var1, EnumBlockRotation var2) {
        BlockPosition var3 = var0.offset(var1).offset(-1, -1, -1);
        return DefinedStructure.transform(var3, EnumBlockMirror.NONE, var2, var0);
    }

    public static StructureBoundingBox getStructureBoundingBox(BlockPosition var0, BaseBlockPosition var1, EnumBlockRotation var2) {
        BlockPosition var3 = GameTestHarnessStructures.getTransformedFarCorner(var0, var1, var2);
        StructureBoundingBox var4 = StructureBoundingBox.fromCorners(var0, var3);
        int var5 = Math.min(var4.minX(), var4.maxX());
        int var6 = Math.min(var4.minZ(), var4.maxZ());
        return var4.move(var0.getX() - var5, 0, var0.getZ() - var6);
    }

    public static Optional<BlockPosition> findTestContainingPos(BlockPosition var0, int var1, WorldServer var22) {
        return GameTestHarnessStructures.findTestBlocks(var0, var1, var22).filter(var2 -> GameTestHarnessStructures.doesStructureContain(var2, var0, var22)).findFirst();
    }

    public static Optional<BlockPosition> findNearestTest(BlockPosition var0, int var12, WorldServer var2) {
        Comparator<BlockPosition> var3 = Comparator.comparingInt(var1 -> var1.distManhattan(var0));
        return GameTestHarnessStructures.findTestBlocks(var0, var12, var2).min(var3);
    }

    public static Stream<BlockPosition> findTestBlocks(BlockPosition var0, int var12, WorldServer var2) {
        StructureBoundingBox var3 = GameTestHarnessStructures.getBoundingBoxAtGround(var0, var12, var2);
        return BlockPosition.betweenClosedStream(var3).filter(var1 -> var2.getBlockState((BlockPosition)var1).is(Blocks.TEST_INSTANCE_BLOCK)).map(BlockPosition::immutable);
    }

    private static StructureBoundingBox getBoundingBoxAtGround(BlockPosition var0, int var1, WorldServer var2) {
        BlockPosition var3 = BlockPosition.containing(var0.getX(), var2.getHeightmapPos(HeightMap.Type.WORLD_SURFACE, var0).getY(), var0.getZ());
        return new StructureBoundingBox(var3).inflatedBy(var1, 10, var1);
    }

    public static Stream<BlockPosition> lookedAtTestPos(BlockPosition var0, Entity var12, WorldServer var22) {
        int var3 = 200;
        Vec3D var4 = var12.getEyePosition();
        Vec3D var5 = var4.add(var12.getLookAngle().scale(200.0));
        return GameTestHarnessStructures.findTestBlocks(var0, 200, var22).map(var1 -> var22.getBlockEntity((BlockPosition)var1, TileEntityTypes.TEST_INSTANCE_BLOCK)).flatMap(Optional::stream).filter(var2 -> var2.getStructureBounds().clip(var4, var5).isPresent()).map(TileEntity::getBlockPos).sorted(Comparator.comparing(var0::distSqr)).limit(1L);
    }

    private static void clearBlock(int var0, BlockPosition var1, WorldServer var2) {
        IBlockData var3 = var1.getY() < var0 ? Blocks.STONE.defaultBlockState() : Blocks.AIR.defaultBlockState();
        ArgumentTileLocation var4 = new ArgumentTileLocation(var3, Collections.emptySet(), null);
        var4.place(var2, var1, 818);
        var2.updateNeighborsAt(var1, var3.getBlock());
    }

    private static boolean doesStructureContain(BlockPosition var0, BlockPosition var1, WorldServer var2) {
        TileEntity tileEntity = var2.getBlockEntity(var0);
        if (tileEntity instanceof TestInstanceBlockEntity) {
            TestInstanceBlockEntity var3 = (TestInstanceBlockEntity)tileEntity;
            return var3.getStructureBoundingBox().isInside(var1);
        }
        return false;
    }
}

