/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.gametest.framework.GameTestBatchFactory;
import net.minecraft.gametest.framework.GameTestBatchListener;
import net.minecraft.gametest.framework.GameTestHarnessBatch;
import net.minecraft.gametest.framework.GameTestHarnessCollector;
import net.minecraft.gametest.framework.GameTestHarnessInfo;
import net.minecraft.gametest.framework.GameTestHarnessListener;
import net.minecraft.gametest.framework.GameTestHarnessTicker;
import net.minecraft.gametest.framework.ReportGameListener;
import net.minecraft.gametest.framework.StructureGridSpawner;
import net.minecraft.gametest.framework.TestEnvironmentDefinition;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.ChunkCoordIntPair;
import org.slf4j.Logger;

public class GameTestHarnessRunner {
    public static final int DEFAULT_TESTS_PER_ROW = 8;
    private static final Logger LOGGER = LogUtils.getLogger();
    final WorldServer level;
    private final GameTestHarnessTicker testTicker;
    private final List<GameTestHarnessInfo> allTestInfos;
    private ImmutableList<GameTestHarnessBatch> batches;
    final List<GameTestBatchListener> batchListeners = Lists.newArrayList();
    private final List<GameTestHarnessInfo> scheduledForRerun = Lists.newArrayList();
    private final b testBatcher;
    private boolean stopped = true;
    @Nullable
    private Holder<TestEnvironmentDefinition> currentEnvironment;
    private final c existingStructureSpawner;
    private final c newStructureSpawner;
    final boolean haltOnError;

    protected GameTestHarnessRunner(b var02, Collection<GameTestHarnessBatch> var1, WorldServer var2, GameTestHarnessTicker var3, c var4, c var5, boolean var6) {
        this.level = var2;
        this.testTicker = var3;
        this.testBatcher = var02;
        this.existingStructureSpawner = var4;
        this.newStructureSpawner = var5;
        this.batches = ImmutableList.copyOf(var1);
        this.haltOnError = var6;
        this.allTestInfos = this.batches.stream().flatMap(var0 -> var0.gameTestInfos().stream()).collect(SystemUtils.toMutableList());
        var3.setRunner(this);
        this.allTestInfos.forEach(var0 -> var0.addListener(new ReportGameListener()));
    }

    public List<GameTestHarnessInfo> getTestInfos() {
        return this.allTestInfos;
    }

    public void start() {
        this.stopped = false;
        this.runBatch(0);
    }

    public void stop() {
        this.stopped = true;
        if (this.currentEnvironment != null) {
            this.endCurrentEnvironment();
        }
    }

    public void rerunTest(GameTestHarnessInfo var0) {
        GameTestHarnessInfo var1 = var0.copyReset();
        var0.getListeners().forEach(var2 -> var2.testAddedForRerun(var0, var1, this));
        this.allTestInfos.add(var1);
        this.scheduledForRerun.add(var1);
        if (this.stopped) {
            this.runScheduledRerunTests();
        }
    }

    void runBatch(final int var0) {
        if (var0 >= this.batches.size()) {
            this.endCurrentEnvironment();
            this.runScheduledRerunTests();
            return;
        }
        final GameTestHarnessBatch var12 = (GameTestHarnessBatch)this.batches.get(var0);
        this.existingStructureSpawner.onBatchStart(this.level);
        this.newStructureSpawner.onBatchStart(this.level);
        Collection<GameTestHarnessInfo> var2 = this.createStructuresForBatch(var12.gameTestInfos());
        LOGGER.info("Running test environment '{}' batch {} ({} tests)...", new Object[]{var12.environment().getRegisteredName(), var12.index(), var2.size()});
        if (this.currentEnvironment != var12.environment()) {
            this.endCurrentEnvironment();
            this.currentEnvironment = var12.environment();
            this.currentEnvironment.value().setup(this.level);
        }
        this.batchListeners.forEach(var1 -> var1.testBatchStarting(var12));
        final GameTestHarnessCollector var3 = new GameTestHarnessCollector();
        var2.forEach(var3::addTestToTrack);
        var3.addListener(new GameTestHarnessListener(){

            private void testCompleted() {
                if (var3.isDone()) {
                    GameTestHarnessRunner.this.batchListeners.forEach(var1 -> var1.testBatchFinished(var12));
                    LongArraySet var02 = new LongArraySet(GameTestHarnessRunner.this.level.getForceLoadedChunks());
                    var02.forEach(var0 -> GameTestHarnessRunner.this.level.setChunkForced(ChunkCoordIntPair.getX(var0), ChunkCoordIntPair.getZ(var0), false));
                    GameTestHarnessRunner.this.runBatch(var0 + 1);
                }
            }

            @Override
            public void testStructureLoaded(GameTestHarnessInfo var02) {
            }

            @Override
            public void testPassed(GameTestHarnessInfo var02, GameTestHarnessRunner var1) {
                this.testCompleted();
            }

            @Override
            public void testFailed(GameTestHarnessInfo var02, GameTestHarnessRunner var1) {
                if (GameTestHarnessRunner.this.haltOnError) {
                    GameTestHarnessRunner.this.endCurrentEnvironment();
                    LongArraySet var2 = new LongArraySet(GameTestHarnessRunner.this.level.getForceLoadedChunks());
                    var2.forEach(var0 -> GameTestHarnessRunner.this.level.setChunkForced(ChunkCoordIntPair.getX(var0), ChunkCoordIntPair.getZ(var0), false));
                    GameTestHarnessTicker.SINGLETON.clear();
                } else {
                    this.testCompleted();
                }
            }

            @Override
            public void testAddedForRerun(GameTestHarnessInfo var02, GameTestHarnessInfo var1, GameTestHarnessRunner var2) {
            }
        });
        var2.forEach(this.testTicker::add);
    }

    void endCurrentEnvironment() {
        if (this.currentEnvironment != null) {
            this.currentEnvironment.value().teardown(this.level);
            this.currentEnvironment = null;
        }
    }

    private void runScheduledRerunTests() {
        if (!this.scheduledForRerun.isEmpty()) {
            LOGGER.info("Starting re-run of tests: {}", (Object)this.scheduledForRerun.stream().map(var0 -> var0.id().toString()).collect(Collectors.joining(", ")));
            this.batches = ImmutableList.copyOf(this.testBatcher.batch(this.scheduledForRerun));
            this.scheduledForRerun.clear();
            this.stopped = false;
            this.runBatch(0);
        } else {
            this.batches = ImmutableList.of();
            this.stopped = true;
        }
    }

    public void addListener(GameTestBatchListener var0) {
        this.batchListeners.add(var0);
    }

    private Collection<GameTestHarnessInfo> createStructuresForBatch(Collection<GameTestHarnessInfo> var0) {
        return var0.stream().map(this::spawn).flatMap(Optional::stream).toList();
    }

    private Optional<GameTestHarnessInfo> spawn(GameTestHarnessInfo var0) {
        if (var0.getTestBlockPos() == null) {
            return this.newStructureSpawner.spawnStructure(var0);
        }
        return this.existingStructureSpawner.spawnStructure(var0);
    }

    public static void clearMarkers(WorldServer var0) {
        PacketDebug.sendGameTestClearPacket(var0);
    }

    public static interface b {
        public Collection<GameTestHarnessBatch> batch(Collection<GameTestHarnessInfo> var1);
    }

    public static interface c {
        public static final c IN_PLACE = var0 -> Optional.of(var0.prepareTestStructure().startExecution(1));
        public static final c NOT_SET = var0 -> Optional.empty();

        public Optional<GameTestHarnessInfo> spawnStructure(GameTestHarnessInfo var1);

        default public void onBatchStart(WorldServer var0) {
        }
    }

    public static class a {
        private final WorldServer level;
        private final GameTestHarnessTicker testTicker = GameTestHarnessTicker.SINGLETON;
        private b batcher = GameTestBatchFactory.fromGameTestInfo();
        private c existingStructureSpawner = c.IN_PLACE;
        private c newStructureSpawner = c.NOT_SET;
        private final Collection<GameTestHarnessBatch> batches;
        private boolean haltOnError = false;

        private a(Collection<GameTestHarnessBatch> var0, WorldServer var1) {
            this.batches = var0;
            this.level = var1;
        }

        public static a fromBatches(Collection<GameTestHarnessBatch> var0, WorldServer var1) {
            return new a(var0, var1);
        }

        public static a fromInfo(Collection<GameTestHarnessInfo> var0, WorldServer var1) {
            return a.fromBatches(GameTestBatchFactory.fromGameTestInfo().batch(var0), var1);
        }

        public a haltOnError(boolean var0) {
            this.haltOnError = var0;
            return this;
        }

        public a newStructureSpawner(c var0) {
            this.newStructureSpawner = var0;
            return this;
        }

        public a existingStructureSpawner(StructureGridSpawner var0) {
            this.existingStructureSpawner = var0;
            return this;
        }

        public a batcher(b var0) {
            this.batcher = var0;
            return this;
        }

        public GameTestHarnessRunner build() {
            return new GameTestHarnessRunner(this.batcher, this.batches, this.level, this.testTicker, this.existingStructureSpawner, this.newStructureSpawner, this.haltOnError);
        }
    }
}

