/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class ResourceOrIdArgument<T>
implements ArgumentType<Holder<T>> {
    private static final Collection<String> EXAMPLES = List.of("foo", "foo:bar", "012", "{}", "true");
    public static final DynamicCommandExceptionType ERROR_FAILED_TO_PARSE = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatableEscape("argument.resource_or_id.failed_to_parse", var0));
    private static final SimpleCommandExceptionType ERROR_INVALID = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("argument.resource_or_id.invalid"));
    private static final MojangsonParser<?> VALUE_PARSER = MojangsonParser.create(DynamicOpsNBT.INSTANCE);
    private final HolderLookup.a registryLookup;
    private final boolean hasRegistry;
    private final Codec<Holder<T>> codec;

    protected ResourceOrIdArgument(CommandBuildContext var0, ResourceKey<IRegistry<T>> var1, Codec<Holder<T>> var2) {
        this.registryLookup = var0;
        this.hasRegistry = var0.lookup(var1).isPresent();
        this.codec = var2;
    }

    public static c lootTable(CommandBuildContext var0) {
        return new c(var0);
    }

    public static Holder<LootTable> getLootTable(CommandContext<CommandListenerWrapper> var0, String var1) throws CommandSyntaxException {
        return ResourceOrIdArgument.getResource(var0, var1);
    }

    public static a lootModifier(CommandBuildContext var0) {
        return new a(var0);
    }

    public static Holder<LootItemFunction> getLootModifier(CommandContext<CommandListenerWrapper> var0, String var1) {
        return ResourceOrIdArgument.getResource(var0, var1);
    }

    public static b lootPredicate(CommandBuildContext var0) {
        return new b(var0);
    }

    public static Holder<LootItemCondition> getLootPredicate(CommandContext<CommandListenerWrapper> var0, String var1) {
        return ResourceOrIdArgument.getResource(var0, var1);
    }

    private static <T> Holder<T> getResource(CommandContext<CommandListenerWrapper> var0, String var1) {
        return (Holder)var0.getArgument(var1, Holder.class);
    }

    @Nullable
    public Holder<T> parse(StringReader var0) throws CommandSyntaxException {
        return this.parse(var0, VALUE_PARSER);
    }

    @Nullable
    private <O> Holder<T> parse(StringReader var0, MojangsonParser<O> var12) throws CommandSyntaxException {
        RegistryOps<O> var2 = this.registryLookup.createSerializationContext(var12.getOps());
        Dynamic<O> var3 = ResourceOrIdArgument.parseInlineOrId(var2, var12, var0);
        if (!this.hasRegistry) {
            return null;
        }
        return (Holder)this.codec.parse(var3).getOrThrow(var1 -> ERROR_FAILED_TO_PARSE.createWithContext((ImmutableStringReader)var0, var1));
    }

    @VisibleForTesting
    static <T> Dynamic<T> parseInlineOrId(DynamicOps<T> var0, MojangsonParser<T> var1, StringReader var2) throws CommandSyntaxException {
        int var3 = var2.getCursor();
        T var4 = var1.parseAsArgument(var2);
        if (ResourceOrIdArgument.hasConsumedWholeArg(var2)) {
            return new Dynamic(var0, var4);
        }
        var2.setCursor(var3);
        MinecraftKey var5 = MinecraftKey.read(var2);
        if (ResourceOrIdArgument.hasConsumedWholeArg(var2)) {
            return new Dynamic(var0, var0.createString(var5.toString()));
        }
        var2.setCursor(var3);
        throw ERROR_INVALID.createWithContext((ImmutableStringReader)var2);
    }

    private static boolean hasConsumedWholeArg(StringReader var0) {
        return !var0.canRead() || var0.peek() == ' ';
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    @Nullable
    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }

    public static class c
    extends ResourceOrIdArgument<LootTable> {
        protected c(CommandBuildContext var0) {
            super(var0, Registries.LOOT_TABLE, LootTable.CODEC);
        }

        @Override
        @Nullable
        public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
            return super.parse(stringReader);
        }
    }

    public static class a
    extends ResourceOrIdArgument<LootItemFunction> {
        protected a(CommandBuildContext var0) {
            super(var0, Registries.ITEM_MODIFIER, LootItemFunctions.CODEC);
        }

        @Override
        @Nullable
        public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
            return super.parse(stringReader);
        }
    }

    public static class b
    extends ResourceOrIdArgument<LootItemCondition> {
        protected b(CommandBuildContext var0) {
            super(var0, Registries.PREDICATE, LootItemCondition.CODEC);
        }

        @Override
        @Nullable
        public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
            return super.parse(stringReader);
        }
    }
}

