/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;

public class ResourceKeyArgument<T>
implements ArgumentType<ResourceKey<T>> {
    private static final Collection<String> EXAMPLES = Arrays.asList("foo", "foo:bar", "012");
    private static final DynamicCommandExceptionType ERROR_INVALID_FEATURE = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatableEscape("commands.place.feature.invalid", var0));
    private static final DynamicCommandExceptionType ERROR_INVALID_STRUCTURE = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatableEscape("commands.place.structure.invalid", var0));
    private static final DynamicCommandExceptionType ERROR_INVALID_TEMPLATE_POOL = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatableEscape("commands.place.jigsaw.invalid", var0));
    private static final DynamicCommandExceptionType ERROR_INVALID_RECIPE = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatableEscape("recipe.notFound", var0));
    private static final DynamicCommandExceptionType ERROR_INVALID_ADVANCEMENT = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatableEscape("advancement.advancementNotFound", var0));
    final ResourceKey<? extends IRegistry<T>> registryKey;

    public ResourceKeyArgument(ResourceKey<? extends IRegistry<T>> var0) {
        this.registryKey = var0;
    }

    public static <T> ResourceKeyArgument<T> key(ResourceKey<? extends IRegistry<T>> var0) {
        return new ResourceKeyArgument<T>(var0);
    }

    public static <T> ResourceKey<T> getRegistryKey(CommandContext<CommandListenerWrapper> var0, String var1, ResourceKey<IRegistry<T>> var2, DynamicCommandExceptionType var3) throws CommandSyntaxException {
        ResourceKey var4 = (ResourceKey)var0.getArgument(var1, ResourceKey.class);
        Optional<ResourceKey<T>> var5 = var4.cast(var2);
        return var5.orElseThrow(() -> var3.create((Object)var4.location()));
    }

    private static <T> IRegistry<T> getRegistry(CommandContext<CommandListenerWrapper> var0, ResourceKey<? extends IRegistry<T>> var1) {
        return ((CommandListenerWrapper)var0.getSource()).getServer().registryAccess().lookupOrThrow(var1);
    }

    private static <T> Holder.c<T> resolveKey(CommandContext<CommandListenerWrapper> var0, String var1, ResourceKey<IRegistry<T>> var2, DynamicCommandExceptionType var3) throws CommandSyntaxException {
        ResourceKey var4 = ResourceKeyArgument.getRegistryKey(var0, var1, var2, var3);
        return (Holder.c)ResourceKeyArgument.getRegistry(var0, var2).get(var4).orElseThrow(() -> var3.create((Object)var4.location()));
    }

    public static Holder.c<WorldGenFeatureConfigured<?, ?>> getConfiguredFeature(CommandContext<CommandListenerWrapper> var0, String var1) throws CommandSyntaxException {
        return ResourceKeyArgument.resolveKey(var0, var1, Registries.CONFIGURED_FEATURE, ERROR_INVALID_FEATURE);
    }

    public static Holder.c<Structure> getStructure(CommandContext<CommandListenerWrapper> var0, String var1) throws CommandSyntaxException {
        return ResourceKeyArgument.resolveKey(var0, var1, Registries.STRUCTURE, ERROR_INVALID_STRUCTURE);
    }

    public static Holder.c<WorldGenFeatureDefinedStructurePoolTemplate> getStructureTemplatePool(CommandContext<CommandListenerWrapper> var0, String var1) throws CommandSyntaxException {
        return ResourceKeyArgument.resolveKey(var0, var1, Registries.TEMPLATE_POOL, ERROR_INVALID_TEMPLATE_POOL);
    }

    public static RecipeHolder<?> getRecipe(CommandContext<CommandListenerWrapper> var0, String var1) throws CommandSyntaxException {
        CraftingManager var2 = ((CommandListenerWrapper)var0.getSource()).getServer().getRecipeManager();
        ResourceKey<IRecipe<?>> var3 = ResourceKeyArgument.getRegistryKey(var0, var1, Registries.RECIPE, ERROR_INVALID_RECIPE);
        return var2.byKey(var3).orElseThrow(() -> ERROR_INVALID_RECIPE.create((Object)var3.location()));
    }

    public static AdvancementHolder getAdvancement(CommandContext<CommandListenerWrapper> var0, String var1) throws CommandSyntaxException {
        ResourceKey var2 = ResourceKeyArgument.getRegistryKey(var0, var1, Registries.ADVANCEMENT, ERROR_INVALID_ADVANCEMENT);
        AdvancementHolder var3 = ((CommandListenerWrapper)var0.getSource()).getServer().getAdvancements().get(var2.location());
        if (var3 == null) {
            throw ERROR_INVALID_ADVANCEMENT.create((Object)var2.location());
        }
        return var3;
    }

    public ResourceKey<T> parse(StringReader var0) throws CommandSyntaxException {
        MinecraftKey var1 = MinecraftKey.read(var0);
        return ResourceKey.create(this.registryKey, var1);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> var0, SuggestionsBuilder var1) {
        Object object = var0.getSource();
        if (object instanceof ICompletionProvider) {
            ICompletionProvider var2 = (ICompletionProvider)object;
            return var2.suggestRegistryElements(this.registryKey, ICompletionProvider.a.ELEMENTS, var1, var0);
        }
        return var1.buildFuture();
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }

    public static class net.minecraft.commands.arguments.ResourceKeyArgument$a<T>
    implements ArgumentTypeInfo<ResourceKeyArgument<T>, a> {
        @Override
        public void serializeToNetwork(a var0, PacketDataSerializer var1) {
            var1.writeResourceKey(var0.registryKey);
        }

        @Override
        public a deserializeFromNetwork(PacketDataSerializer var0) {
            return new a(var0.readRegistryKey());
        }

        @Override
        public void serializeToJson(a var0, JsonObject var1) {
            var1.addProperty("registry", var0.registryKey.location().toString());
        }

        @Override
        public a unpack(ResourceKeyArgument<T> var0) {
            return new a(var0.registryKey);
        }

        @Override
        public /* synthetic */ ArgumentTypeInfo.a deserializeFromNetwork(PacketDataSerializer packetDataSerializer) {
            return this.deserializeFromNetwork(packetDataSerializer);
        }

        public final class a
        implements ArgumentTypeInfo.a<ResourceKeyArgument<T>> {
            final ResourceKey<? extends IRegistry<T>> registryKey;

            a(ResourceKey var1) {
                this.registryKey = var1;
            }

            @Override
            public ResourceKeyArgument<T> instantiate(CommandBuildContext var0) {
                return new ResourceKeyArgument(this.registryKey);
            }

            @Override
            public ArgumentTypeInfo<ResourceKeyArgument<T>, ?> type() {
                return a.this;
            }

            @Override
            public /* synthetic */ ArgumentType instantiate(CommandBuildContext commandBuildContext) {
                return this.instantiate(commandBuildContext);
            }
        }
    }
}

