/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.gson.JsonObject;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.IChatBaseComponent;

public class ArgumentTime
implements ArgumentType<Integer> {
    private static final Collection<String> EXAMPLES = Arrays.asList("0d", "0s", "0t", "0");
    private static final SimpleCommandExceptionType ERROR_INVALID_UNIT = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("argument.time.invalid_unit"));
    private static final Dynamic2CommandExceptionType ERROR_TICK_COUNT_TOO_LOW = new Dynamic2CommandExceptionType((var0, var1) -> IChatBaseComponent.translatableEscape("argument.time.tick_count_too_low", var1, var0));
    private static final Object2IntMap<String> UNITS = new Object2IntOpenHashMap();
    final int minimum;

    private ArgumentTime(int var0) {
        this.minimum = var0;
    }

    public static ArgumentTime time() {
        return new ArgumentTime(0);
    }

    public static ArgumentTime time(int var0) {
        return new ArgumentTime(var0);
    }

    public Integer parse(StringReader var0) throws CommandSyntaxException {
        float var1 = var0.readFloat();
        String var2 = var0.readUnquotedString();
        int var3 = UNITS.getOrDefault((Object)var2, 0);
        if (var3 == 0) {
            throw ERROR_INVALID_UNIT.createWithContext((ImmutableStringReader)var0);
        }
        int var4 = Math.round(var1 * (float)var3);
        if (var4 < this.minimum) {
            throw ERROR_TICK_COUNT_TOO_LOW.createWithContext((ImmutableStringReader)var0, (Object)var4, (Object)this.minimum);
        }
        return var4;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> var0, SuggestionsBuilder var1) {
        StringReader var2 = new StringReader(var1.getRemaining());
        try {
            var2.readFloat();
        }
        catch (CommandSyntaxException var3) {
            return var1.buildFuture();
        }
        return ICompletionProvider.suggest((Iterable<String>)UNITS.keySet(), var1.createOffset(var1.getStart() + var2.getCursor()));
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }

    static {
        UNITS.put((Object)"d", 24000);
        UNITS.put((Object)"s", 20);
        UNITS.put((Object)"t", 1);
        UNITS.put((Object)"", 1);
    }

    public static class net.minecraft.commands.arguments.ArgumentTime$a
    implements ArgumentTypeInfo<ArgumentTime, a> {
        @Override
        public void serializeToNetwork(a var0, PacketDataSerializer var1) {
            var1.writeInt(var0.min);
        }

        @Override
        public a deserializeFromNetwork(PacketDataSerializer var0) {
            int var1 = var0.readInt();
            return new a(var1);
        }

        @Override
        public void serializeToJson(a var0, JsonObject var1) {
            var1.addProperty("min", (Number)var0.min);
        }

        @Override
        public a unpack(ArgumentTime var0) {
            return new a(var0.minimum);
        }

        @Override
        public /* synthetic */ ArgumentTypeInfo.a deserializeFromNetwork(PacketDataSerializer packetDataSerializer) {
            return this.deserializeFromNetwork(packetDataSerializer);
        }

        public final class a
        implements ArgumentTypeInfo.a<ArgumentTime> {
            final int min;

            a(int var1) {
                this.min = var1;
            }

            @Override
            public ArgumentTime instantiate(CommandBuildContext var0) {
                return ArgumentTime.time(this.min);
            }

            @Override
            public ArgumentTypeInfo<ArgumentTime, ?> type() {
                return a.this;
            }

            @Override
            public /* synthetic */ ArgumentType instantiate(CommandBuildContext commandBuildContext) {
                return this.instantiate(commandBuildContext);
            }
        }
    }
}

