/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.entries;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.entries.LootEntries;
import net.minecraft.world.level.storage.loot.entries.LootEntryType;
import net.minecraft.world.level.storage.loot.entries.LootSelectorEntry;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class NestedLootTable
extends LootSelectorEntry {
    public static final MapCodec<NestedLootTable> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)Codec.either(ResourceKey.codec(Registries.LOOT_TABLE), LootTable.DIRECT_CODEC).fieldOf("value").forGetter(var0 -> var0.contents)).and(NestedLootTable.singletonFields(var02)).apply((Applicative)var02, NestedLootTable::new));
    private final Either<ResourceKey<LootTable>, LootTable> contents;

    private NestedLootTable(Either<ResourceKey<LootTable>, LootTable> var0, int var1, int var2, List<LootItemCondition> var3, List<LootItemFunction> var4) {
        super(var1, var2, var3, var4);
        this.contents = var0;
    }

    @Override
    public LootEntryType getType() {
        return LootEntries.LOOT_TABLE;
    }

    @Override
    public void createItemStack(Consumer<ItemStack> var02, LootTableInfo var12) {
        ((LootTable)this.contents.map(var1 -> var12.getResolver().get(var1).map(Holder::value).orElse(LootTable.EMPTY), var0 -> var0)).getRandomItemsRaw(var12, var02);
    }

    @Override
    public void validate(LootCollector var0) {
        Optional var12 = this.contents.left();
        if (var12.isPresent()) {
            ResourceKey var2 = (ResourceKey)var12.get();
            if (!var0.allowsReferences()) {
                var0.reportProblem("Uses reference to " + String.valueOf(var2.location()) + ", but references are not allowed");
                return;
            }
            if (var0.hasVisitedElement(var2)) {
                var0.reportProblem("Table " + String.valueOf(var2.location()) + " is recursively called");
                return;
            }
        }
        super.validate(var0);
        this.contents.ifLeft(var1 -> var0.resolver().get(var1).ifPresentOrElse(var2 -> ((LootTable)var2.value()).validate(var0.enterElement("->{" + String.valueOf(var1.location()) + "}", (ResourceKey<?>)var1)), () -> var0.reportProblem("Unknown loot table called " + String.valueOf(var1.location())))).ifRight(var1 -> var1.validate(var0.forChild("->{inline}")));
    }

    public static LootSelectorEntry.a<?> lootTableReference(ResourceKey<LootTable> var0) {
        return NestedLootTable.simpleBuilder((var1, var2, var3, var4) -> new NestedLootTable((Either<ResourceKey<LootTable>, LootTable>)Either.left((Object)var0), var1, var2, var3, var4));
    }

    public static LootSelectorEntry.a<?> inlineLootTable(LootTable var0) {
        return NestedLootTable.simpleBuilder((var1, var2, var3, var4) -> new NestedLootTable((Either<ResourceKey<LootTable>, LootTable>)Either.right((Object)var0), var1, var2, var3, var4));
    }
}

