/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.SystemUtils;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.level.storage.loot.LootTable;

public class LootTables {
    private static final Set<ResourceKey<LootTable>> LOCATIONS = new HashSet<ResourceKey<LootTable>>();
    private static final Set<ResourceKey<LootTable>> IMMUTABLE_LOCATIONS = Collections.unmodifiableSet(LOCATIONS);
    public static final ResourceKey<LootTable> SPAWN_BONUS_CHEST = LootTables.register("chests/spawn_bonus_chest");
    public static final ResourceKey<LootTable> END_CITY_TREASURE = LootTables.register("chests/end_city_treasure");
    public static final ResourceKey<LootTable> SIMPLE_DUNGEON = LootTables.register("chests/simple_dungeon");
    public static final ResourceKey<LootTable> VILLAGE_WEAPONSMITH = LootTables.register("chests/village/village_weaponsmith");
    public static final ResourceKey<LootTable> VILLAGE_TOOLSMITH = LootTables.register("chests/village/village_toolsmith");
    public static final ResourceKey<LootTable> VILLAGE_ARMORER = LootTables.register("chests/village/village_armorer");
    public static final ResourceKey<LootTable> VILLAGE_CARTOGRAPHER = LootTables.register("chests/village/village_cartographer");
    public static final ResourceKey<LootTable> VILLAGE_MASON = LootTables.register("chests/village/village_mason");
    public static final ResourceKey<LootTable> VILLAGE_SHEPHERD = LootTables.register("chests/village/village_shepherd");
    public static final ResourceKey<LootTable> VILLAGE_BUTCHER = LootTables.register("chests/village/village_butcher");
    public static final ResourceKey<LootTable> VILLAGE_FLETCHER = LootTables.register("chests/village/village_fletcher");
    public static final ResourceKey<LootTable> VILLAGE_FISHER = LootTables.register("chests/village/village_fisher");
    public static final ResourceKey<LootTable> VILLAGE_TANNERY = LootTables.register("chests/village/village_tannery");
    public static final ResourceKey<LootTable> VILLAGE_TEMPLE = LootTables.register("chests/village/village_temple");
    public static final ResourceKey<LootTable> VILLAGE_DESERT_HOUSE = LootTables.register("chests/village/village_desert_house");
    public static final ResourceKey<LootTable> VILLAGE_PLAINS_HOUSE = LootTables.register("chests/village/village_plains_house");
    public static final ResourceKey<LootTable> VILLAGE_TAIGA_HOUSE = LootTables.register("chests/village/village_taiga_house");
    public static final ResourceKey<LootTable> VILLAGE_SNOWY_HOUSE = LootTables.register("chests/village/village_snowy_house");
    public static final ResourceKey<LootTable> VILLAGE_SAVANNA_HOUSE = LootTables.register("chests/village/village_savanna_house");
    public static final ResourceKey<LootTable> ABANDONED_MINESHAFT = LootTables.register("chests/abandoned_mineshaft");
    public static final ResourceKey<LootTable> NETHER_BRIDGE = LootTables.register("chests/nether_bridge");
    public static final ResourceKey<LootTable> STRONGHOLD_LIBRARY = LootTables.register("chests/stronghold_library");
    public static final ResourceKey<LootTable> STRONGHOLD_CROSSING = LootTables.register("chests/stronghold_crossing");
    public static final ResourceKey<LootTable> STRONGHOLD_CORRIDOR = LootTables.register("chests/stronghold_corridor");
    public static final ResourceKey<LootTable> DESERT_PYRAMID = LootTables.register("chests/desert_pyramid");
    public static final ResourceKey<LootTable> JUNGLE_TEMPLE = LootTables.register("chests/jungle_temple");
    public static final ResourceKey<LootTable> JUNGLE_TEMPLE_DISPENSER = LootTables.register("chests/jungle_temple_dispenser");
    public static final ResourceKey<LootTable> IGLOO_CHEST = LootTables.register("chests/igloo_chest");
    public static final ResourceKey<LootTable> WOODLAND_MANSION = LootTables.register("chests/woodland_mansion");
    public static final ResourceKey<LootTable> UNDERWATER_RUIN_SMALL = LootTables.register("chests/underwater_ruin_small");
    public static final ResourceKey<LootTable> UNDERWATER_RUIN_BIG = LootTables.register("chests/underwater_ruin_big");
    public static final ResourceKey<LootTable> BURIED_TREASURE = LootTables.register("chests/buried_treasure");
    public static final ResourceKey<LootTable> SHIPWRECK_MAP = LootTables.register("chests/shipwreck_map");
    public static final ResourceKey<LootTable> SHIPWRECK_SUPPLY = LootTables.register("chests/shipwreck_supply");
    public static final ResourceKey<LootTable> SHIPWRECK_TREASURE = LootTables.register("chests/shipwreck_treasure");
    public static final ResourceKey<LootTable> PILLAGER_OUTPOST = LootTables.register("chests/pillager_outpost");
    public static final ResourceKey<LootTable> BASTION_TREASURE = LootTables.register("chests/bastion_treasure");
    public static final ResourceKey<LootTable> BASTION_OTHER = LootTables.register("chests/bastion_other");
    public static final ResourceKey<LootTable> BASTION_BRIDGE = LootTables.register("chests/bastion_bridge");
    public static final ResourceKey<LootTable> BASTION_HOGLIN_STABLE = LootTables.register("chests/bastion_hoglin_stable");
    public static final ResourceKey<LootTable> ANCIENT_CITY = LootTables.register("chests/ancient_city");
    public static final ResourceKey<LootTable> ANCIENT_CITY_ICE_BOX = LootTables.register("chests/ancient_city_ice_box");
    public static final ResourceKey<LootTable> RUINED_PORTAL = LootTables.register("chests/ruined_portal");
    public static final ResourceKey<LootTable> TRIAL_CHAMBERS_REWARD = LootTables.register("chests/trial_chambers/reward");
    public static final ResourceKey<LootTable> TRIAL_CHAMBERS_REWARD_COMMON = LootTables.register("chests/trial_chambers/reward_common");
    public static final ResourceKey<LootTable> TRIAL_CHAMBERS_REWARD_RARE = LootTables.register("chests/trial_chambers/reward_rare");
    public static final ResourceKey<LootTable> TRIAL_CHAMBERS_REWARD_UNIQUE = LootTables.register("chests/trial_chambers/reward_unique");
    public static final ResourceKey<LootTable> TRIAL_CHAMBERS_REWARD_OMINOUS = LootTables.register("chests/trial_chambers/reward_ominous");
    public static final ResourceKey<LootTable> TRIAL_CHAMBERS_REWARD_OMINOUS_COMMON = LootTables.register("chests/trial_chambers/reward_ominous_common");
    public static final ResourceKey<LootTable> TRIAL_CHAMBERS_REWARD_OMINOUS_RARE = LootTables.register("chests/trial_chambers/reward_ominous_rare");
    public static final ResourceKey<LootTable> TRIAL_CHAMBERS_REWARD_OMINOUS_UNIQUE = LootTables.register("chests/trial_chambers/reward_ominous_unique");
    public static final ResourceKey<LootTable> TRIAL_CHAMBERS_SUPPLY = LootTables.register("chests/trial_chambers/supply");
    public static final ResourceKey<LootTable> TRIAL_CHAMBERS_CORRIDOR = LootTables.register("chests/trial_chambers/corridor");
    public static final ResourceKey<LootTable> TRIAL_CHAMBERS_INTERSECTION = LootTables.register("chests/trial_chambers/intersection");
    public static final ResourceKey<LootTable> TRIAL_CHAMBERS_INTERSECTION_BARREL = LootTables.register("chests/trial_chambers/intersection_barrel");
    public static final ResourceKey<LootTable> TRIAL_CHAMBERS_ENTRANCE = LootTables.register("chests/trial_chambers/entrance");
    public static final ResourceKey<LootTable> TRIAL_CHAMBERS_CORRIDOR_DISPENSER = LootTables.register("dispensers/trial_chambers/corridor");
    public static final ResourceKey<LootTable> TRIAL_CHAMBERS_CHAMBER_DISPENSER = LootTables.register("dispensers/trial_chambers/chamber");
    public static final ResourceKey<LootTable> TRIAL_CHAMBERS_WATER_DISPENSER = LootTables.register("dispensers/trial_chambers/water");
    public static final ResourceKey<LootTable> TRIAL_CHAMBERS_CORRIDOR_POT = LootTables.register("pots/trial_chambers/corridor");
    public static final ResourceKey<LootTable> EQUIPMENT_TRIAL_CHAMBER = LootTables.register("equipment/trial_chamber");
    public static final ResourceKey<LootTable> EQUIPMENT_TRIAL_CHAMBER_RANGED = LootTables.register("equipment/trial_chamber_ranged");
    public static final ResourceKey<LootTable> EQUIPMENT_TRIAL_CHAMBER_MELEE = LootTables.register("equipment/trial_chamber_melee");
    public static final Map<EnumColor, ResourceKey<LootTable>> SHEEP_BY_DYE = SystemUtils.make(new EnumMap(EnumColor.class), var0 -> LootTables.makeDyeKeyMap(var0, "entities/sheep"));
    public static final ResourceKey<LootTable> FISHING = LootTables.register("gameplay/fishing");
    public static final ResourceKey<LootTable> FISHING_JUNK = LootTables.register("gameplay/fishing/junk");
    public static final ResourceKey<LootTable> FISHING_TREASURE = LootTables.register("gameplay/fishing/treasure");
    public static final ResourceKey<LootTable> FISHING_FISH = LootTables.register("gameplay/fishing/fish");
    public static final ResourceKey<LootTable> CAT_MORNING_GIFT = LootTables.register("gameplay/cat_morning_gift");
    public static final ResourceKey<LootTable> ARMORER_GIFT = LootTables.register("gameplay/hero_of_the_village/armorer_gift");
    public static final ResourceKey<LootTable> BUTCHER_GIFT = LootTables.register("gameplay/hero_of_the_village/butcher_gift");
    public static final ResourceKey<LootTable> CARTOGRAPHER_GIFT = LootTables.register("gameplay/hero_of_the_village/cartographer_gift");
    public static final ResourceKey<LootTable> CLERIC_GIFT = LootTables.register("gameplay/hero_of_the_village/cleric_gift");
    public static final ResourceKey<LootTable> FARMER_GIFT = LootTables.register("gameplay/hero_of_the_village/farmer_gift");
    public static final ResourceKey<LootTable> FISHERMAN_GIFT = LootTables.register("gameplay/hero_of_the_village/fisherman_gift");
    public static final ResourceKey<LootTable> FLETCHER_GIFT = LootTables.register("gameplay/hero_of_the_village/fletcher_gift");
    public static final ResourceKey<LootTable> LEATHERWORKER_GIFT = LootTables.register("gameplay/hero_of_the_village/leatherworker_gift");
    public static final ResourceKey<LootTable> LIBRARIAN_GIFT = LootTables.register("gameplay/hero_of_the_village/librarian_gift");
    public static final ResourceKey<LootTable> MASON_GIFT = LootTables.register("gameplay/hero_of_the_village/mason_gift");
    public static final ResourceKey<LootTable> SHEPHERD_GIFT = LootTables.register("gameplay/hero_of_the_village/shepherd_gift");
    public static final ResourceKey<LootTable> TOOLSMITH_GIFT = LootTables.register("gameplay/hero_of_the_village/toolsmith_gift");
    public static final ResourceKey<LootTable> WEAPONSMITH_GIFT = LootTables.register("gameplay/hero_of_the_village/weaponsmith_gift");
    public static final ResourceKey<LootTable> UNEMPLOYED_GIFT = LootTables.register("gameplay/hero_of_the_village/unemployed_gift");
    public static final ResourceKey<LootTable> BABY_VILLAGER_GIFT = LootTables.register("gameplay/hero_of_the_village/baby_gift");
    public static final ResourceKey<LootTable> SNIFFER_DIGGING = LootTables.register("gameplay/sniffer_digging");
    public static final ResourceKey<LootTable> PANDA_SNEEZE = LootTables.register("gameplay/panda_sneeze");
    public static final ResourceKey<LootTable> CHICKEN_LAY = LootTables.register("gameplay/chicken_lay");
    public static final ResourceKey<LootTable> ARMADILLO_SHED = LootTables.register("gameplay/armadillo_shed");
    public static final ResourceKey<LootTable> PIGLIN_BARTERING = LootTables.register("gameplay/piglin_bartering");
    public static final ResourceKey<LootTable> SPAWNER_TRIAL_CHAMBER_KEY = LootTables.register("spawners/trial_chamber/key");
    public static final ResourceKey<LootTable> SPAWNER_TRIAL_CHAMBER_CONSUMABLES = LootTables.register("spawners/trial_chamber/consumables");
    public static final ResourceKey<LootTable> SPAWNER_OMINOUS_TRIAL_CHAMBER_KEY = LootTables.register("spawners/ominous/trial_chamber/key");
    public static final ResourceKey<LootTable> SPAWNER_OMINOUS_TRIAL_CHAMBER_CONSUMABLES = LootTables.register("spawners/ominous/trial_chamber/consumables");
    public static final ResourceKey<LootTable> SPAWNER_TRIAL_ITEMS_TO_DROP_WHEN_OMINOUS = LootTables.register("spawners/trial_chamber/items_to_drop_when_ominous");
    public static final ResourceKey<LootTable> BOGGED_SHEAR = LootTables.register("shearing/bogged");
    public static final ResourceKey<LootTable> SHEAR_MOOSHROOM = LootTables.register("shearing/mooshroom");
    public static final ResourceKey<LootTable> SHEAR_RED_MOOSHROOM = LootTables.register("shearing/mooshroom/red");
    public static final ResourceKey<LootTable> SHEAR_BROWN_MOOSHROOM = LootTables.register("shearing/mooshroom/brown");
    public static final ResourceKey<LootTable> SHEAR_SNOW_GOLEM = LootTables.register("shearing/snow_golem");
    public static final ResourceKey<LootTable> SHEAR_SHEEP = LootTables.register("shearing/sheep");
    public static final Map<EnumColor, ResourceKey<LootTable>> SHEAR_SHEEP_BY_DYE = SystemUtils.make(new EnumMap(EnumColor.class), var0 -> LootTables.makeDyeKeyMap(var0, "shearing/sheep"));
    public static final ResourceKey<LootTable> DESERT_WELL_ARCHAEOLOGY = LootTables.register("archaeology/desert_well");
    public static final ResourceKey<LootTable> DESERT_PYRAMID_ARCHAEOLOGY = LootTables.register("archaeology/desert_pyramid");
    public static final ResourceKey<LootTable> TRAIL_RUINS_ARCHAEOLOGY_COMMON = LootTables.register("archaeology/trail_ruins_common");
    public static final ResourceKey<LootTable> TRAIL_RUINS_ARCHAEOLOGY_RARE = LootTables.register("archaeology/trail_ruins_rare");
    public static final ResourceKey<LootTable> OCEAN_RUIN_WARM_ARCHAEOLOGY = LootTables.register("archaeology/ocean_ruin_warm");
    public static final ResourceKey<LootTable> OCEAN_RUIN_COLD_ARCHAEOLOGY = LootTables.register("archaeology/ocean_ruin_cold");

    private static void makeDyeKeyMap(EnumMap<EnumColor, ResourceKey<LootTable>> var0, String var1) {
        for (EnumColor var5 : EnumColor.values()) {
            var0.put(var5, LootTables.register(var1 + "/" + var5.getName()));
        }
    }

    private static ResourceKey<LootTable> register(String var0) {
        return LootTables.register(ResourceKey.create(Registries.LOOT_TABLE, MinecraftKey.withDefaultNamespace(var0)));
    }

    private static ResourceKey<LootTable> register(ResourceKey<LootTable> var0) {
        if (LOCATIONS.add(var0)) {
            return var0;
        }
        throw new IllegalArgumentException(String.valueOf(var0.location()) + " is already a registered built-in loot table");
    }

    public static Set<ResourceKey<LootTable>> all() {
        return IMMUTABLE_LOCATIONS;
    }
}

