/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.saveddata.maps;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityBanner;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import net.minecraft.world.level.saveddata.maps.MapDecorationTypes;

public record MapIconBanner(BlockPosition pos, EnumColor color, Optional<IChatBaseComponent> name) {
    public static final Codec<MapIconBanner> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)BlockPosition.CODEC.fieldOf("pos").forGetter(MapIconBanner::pos), (App)EnumColor.CODEC.lenientOptionalFieldOf("color", EnumColor.WHITE).forGetter(MapIconBanner::color), (App)ComponentSerialization.FLAT_CODEC.lenientOptionalFieldOf("name").forGetter(MapIconBanner::name)).apply((Applicative)var0, MapIconBanner::new));
    public static final Codec<List<MapIconBanner>> LIST_CODEC = CODEC.listOf();

    @Nullable
    public static MapIconBanner fromWorld(IBlockAccess var0, BlockPosition var1) {
        TileEntity var2 = var0.getBlockEntity(var1);
        if (var2 instanceof TileEntityBanner) {
            TileEntityBanner var3 = (TileEntityBanner)var2;
            EnumColor var4 = var3.getBaseColor();
            Optional<IChatBaseComponent> var5 = Optional.ofNullable(var3.getCustomName());
            return new MapIconBanner(var1, var4, var5);
        }
        return null;
    }

    public Holder<MapDecorationType> getDecoration() {
        return switch (this.color) {
            default -> throw new MatchException(null, null);
            case EnumColor.WHITE -> MapDecorationTypes.WHITE_BANNER;
            case EnumColor.ORANGE -> MapDecorationTypes.ORANGE_BANNER;
            case EnumColor.MAGENTA -> MapDecorationTypes.MAGENTA_BANNER;
            case EnumColor.LIGHT_BLUE -> MapDecorationTypes.LIGHT_BLUE_BANNER;
            case EnumColor.YELLOW -> MapDecorationTypes.YELLOW_BANNER;
            case EnumColor.LIME -> MapDecorationTypes.LIME_BANNER;
            case EnumColor.PINK -> MapDecorationTypes.PINK_BANNER;
            case EnumColor.GRAY -> MapDecorationTypes.GRAY_BANNER;
            case EnumColor.LIGHT_GRAY -> MapDecorationTypes.LIGHT_GRAY_BANNER;
            case EnumColor.CYAN -> MapDecorationTypes.CYAN_BANNER;
            case EnumColor.PURPLE -> MapDecorationTypes.PURPLE_BANNER;
            case EnumColor.BLUE -> MapDecorationTypes.BLUE_BANNER;
            case EnumColor.BROWN -> MapDecorationTypes.BROWN_BANNER;
            case EnumColor.GREEN -> MapDecorationTypes.GREEN_BANNER;
            case EnumColor.RED -> MapDecorationTypes.RED_BANNER;
            case EnumColor.BLACK -> MapDecorationTypes.BLACK_BANNER;
        };
    }

    public String getId() {
        return "banner-" + this.pos.getX() + "," + this.pos.getY() + "," + this.pos.getZ();
    }
}

