/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.Optionull;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NbtException;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.LightEngineThreaded;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkConverter;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.DataPaletteBlock;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.IChunkProvider;
import net.minecraft.world.level.chunk.NibbleArray;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.ProtoChunkExtension;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.status.ChunkType;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.ticks.LevelChunkTicks;
import net.minecraft.world.ticks.ProtoChunkTickList;
import net.minecraft.world.ticks.TickListChunk;
import org.slf4j.Logger;

public record SerializableChunkData(IRegistry<BiomeBase> biomeRegistry, ChunkCoordIntPair chunkPos, int minSectionY, long lastUpdateTime, long inhabitedTime, ChunkStatus chunkStatus, @Nullable BlendingData.d blendingData, @Nullable BelowZeroRetrogen belowZeroRetrogen, ChunkConverter upgradeData, @Nullable long[] carvingMask, Map<HeightMap.Type, long[]> heightmaps, IChunkAccess.a packedTicks, ShortList[] postProcessingSections, boolean lightCorrect, List<b> sectionData, List<NBTTagCompound> entities, List<NBTTagCompound> blockEntities, NBTTagCompound structureData) {
    public static final Codec<DataPaletteBlock<IBlockData>> BLOCK_STATE_CODEC = DataPaletteBlock.codecRW(Block.BLOCK_STATE_REGISTRY, IBlockData.CODEC, DataPaletteBlock.d.SECTION_STATES, Blocks.AIR.defaultBlockState());
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String TAG_UPGRADE_DATA = "UpgradeData";
    private static final String BLOCK_TICKS_TAG = "block_ticks";
    private static final String FLUID_TICKS_TAG = "fluid_ticks";
    public static final String X_POS_TAG = "xPos";
    public static final String Z_POS_TAG = "zPos";
    public static final String HEIGHTMAPS_TAG = "Heightmaps";
    public static final String IS_LIGHT_ON_TAG = "isLightOn";
    public static final String SECTIONS_TAG = "sections";
    public static final String BLOCK_LIGHT_TAG = "BlockLight";
    public static final String SKY_LIGHT_TAG = "SkyLight";

    @Nullable
    public static SerializableChunkData parse(LevelHeightAccessor var02, IRegistryCustom var1, NBTTagCompound var22) {
        Object var23;
        Object var18;
        if (!var22.contains("Status", 8)) {
            return null;
        }
        ChunkCoordIntPair var3 = new ChunkCoordIntPair(var22.getInt(X_POS_TAG), var22.getInt(Z_POS_TAG));
        long var4 = var22.getLong("LastUpdate");
        long var6 = var22.getLong("InhabitedTime");
        ChunkStatus var8 = ChunkStatus.byName(var22.getString("Status"));
        ChunkConverter var9 = var22.contains(TAG_UPGRADE_DATA, 10) ? new ChunkConverter(var22.getCompound(TAG_UPGRADE_DATA), var02) : ChunkConverter.EMPTY;
        boolean var10 = var22.getBoolean(IS_LIGHT_ON_TAG);
        BlendingData.d var11 = var22.contains("blending_data", 10) ? (BlendingData.d)BlendingData.d.CODEC.parse((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var22.getCompound("blending_data")).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElse(null) : null;
        BelowZeroRetrogen var12 = var22.contains("below_zero_retrogen", 10) ? (BelowZeroRetrogen)BelowZeroRetrogen.CODEC.parse((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var22.getCompound("below_zero_retrogen")).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElse(null) : null;
        long[] var13 = var22.contains("carving_mask", 12) ? var22.getLongArray("carving_mask") : null;
        NBTTagCompound var14 = var22.getCompound(HEIGHTMAPS_TAG);
        EnumMap<HeightMap.Type, long[]> var15 = new EnumMap<HeightMap.Type, long[]>(HeightMap.Type.class);
        for (HeightMap.Type type : var8.heightmapsAfter()) {
            var18 = type.getSerializationKey();
            if (!var14.contains((String)var18, 12)) continue;
            var15.put(type, var14.getLongArray((String)var18));
        }
        List<TickListChunk<Block>> var16 = TickListChunk.loadTickList(var22.getList(BLOCK_TICKS_TAG, 10), var0 -> BuiltInRegistries.BLOCK.getOptional(MinecraftKey.tryParse(var0)), var3);
        List<TickListChunk<FluidType>> list = TickListChunk.loadTickList(var22.getList(FLUID_TICKS_TAG, 10), var0 -> BuiltInRegistries.FLUID.getOptional(MinecraftKey.tryParse(var0)), var3);
        var18 = new IChunkAccess.a(var16, list);
        NBTTagList var19 = var22.getList("PostProcessing", 9);
        ShortList[] var20 = new ShortList[var19.size()];
        for (int var21 = 0; var21 < var19.size(); ++var21) {
            NBTTagList var222 = var19.getList(var21);
            var23 = new ShortArrayList(var222.size());
            for (int var24 = 0; var24 < var222.size(); ++var24) {
                var23.add(var222.getShort(var24));
            }
            var20[var21] = var23;
        }
        List var21 = Lists.transform((List)var22.getList("entities", 10), var0 -> (NBTTagCompound)var0);
        List var222 = Lists.transform((List)var22.getList("block_entities", 10), var0 -> (NBTTagCompound)var0);
        var23 = var22.getCompound("structures");
        NBTTagList var24 = var22.getList(SECTIONS_TAG, 10);
        ArrayList<b> var25 = new ArrayList<b>(var24.size());
        HolderLookup.b var26 = var1.lookupOrThrow(Registries.BIOME);
        Codec<PalettedContainerRO<Holder<BiomeBase>>> var27 = SerializableChunkData.makeBiomeCodec((IRegistry<BiomeBase>)var26);
        for (int var28 = 0; var28 < var24.size(); ++var28) {
            ChunkSection var31;
            PalettedContainerRO<Object> var33;
            DataPaletteBlock<Object> var32;
            NBTTagCompound var29 = var24.getCompound(var28);
            byte var30 = var29.getByte("Y");
            if (var30 >= var02.getMinSectionY() && var30 <= var02.getMaxSectionY()) {
                var32 = var29.contains("block_states", 10) ? (DataPaletteBlock)BLOCK_STATE_CODEC.parse((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var29.getCompound("block_states")).promotePartial(var2 -> SerializableChunkData.logErrors(var3, var30, var2)).getOrThrow(a::new) : new DataPaletteBlock<IBlockData>(Block.BLOCK_STATE_REGISTRY, Blocks.AIR.defaultBlockState(), DataPaletteBlock.d.SECTION_STATES);
                var33 = var29.contains("biomes", 10) ? (PalettedContainerRO)var27.parse((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var29.getCompound("biomes")).promotePartial(var2 -> SerializableChunkData.logErrors(var3, var30, var2)).getOrThrow(a::new) : new DataPaletteBlock<Holder.c>(var26.asHolderIdMap(), var26.getOrThrow(Biomes.PLAINS), DataPaletteBlock.d.SECTION_BIOMES);
                var31 = new ChunkSection((DataPaletteBlock<IBlockData>)var32, (PalettedContainerRO<Holder<BiomeBase>>)var33);
            } else {
                var31 = null;
            }
            var32 = var29.contains(BLOCK_LIGHT_TAG, 7) ? new NibbleArray(var29.getByteArray(BLOCK_LIGHT_TAG)) : null;
            var33 = var29.contains(SKY_LIGHT_TAG, 7) ? new NibbleArray(var29.getByteArray(SKY_LIGHT_TAG)) : null;
            var25.add(new b(var30, var31, (NibbleArray)((Object)var32), (NibbleArray)((Object)var33)));
        }
        return new SerializableChunkData((IRegistry<BiomeBase>)var26, var3, var02.getMinSectionY(), var4, var6, var8, var11, var12, var9, var13, var15, (IChunkAccess.a)var18, var20, var10, var25, var21, var222, (NBTTagCompound)var23);
    }

    /*
     * WARNING - void declaration
     */
    public ProtoChunk read(WorldServer var0, VillagePlace var1, RegionStorageInfo var2, ChunkCoordIntPair var3) {
        void var13_16;
        Object var13;
        if (!Objects.equals(var3, this.chunkPos)) {
            LOGGER.error("Chunk file at {} is in the wrong location; relocating. (Expected {}, got {})", new Object[]{var3, var3, this.chunkPos});
            var0.getServer().reportMisplacedChunk(this.chunkPos, var3, var2);
        }
        int var4 = var0.getSectionsCount();
        ChunkSection[] var5 = new ChunkSection[var4];
        boolean var6 = var0.dimensionType().hasSkyLight();
        ChunkProviderServer var7 = var0.getChunkSource();
        LevelLightEngine var8 = ((IChunkProvider)var7).getLightEngine();
        HolderLookup.b var9 = var0.registryAccess().lookupOrThrow(Registries.BIOME);
        boolean var10 = false;
        for (b b2 : this.sectionData) {
            boolean var15;
            var13 = SectionPosition.of(var3, b2.y);
            if (b2.chunkSection != null) {
                var5[var0.getSectionIndexFromSectionY((int)b2.y)] = b2.chunkSection;
                var1.checkConsistencyWithBlocks((SectionPosition)var13, b2.chunkSection);
            }
            boolean var14 = b2.blockLight != null;
            boolean bl = var15 = var6 && b2.skyLight != null;
            if (!var14 && !var15) continue;
            if (!var10) {
                var8.retainData(var3, true);
                var10 = true;
            }
            if (var14) {
                var8.queueSectionData(EnumSkyBlock.BLOCK, (SectionPosition)var13, b2.blockLight);
            }
            if (!var15) continue;
            var8.queueSectionData(EnumSkyBlock.SKY, (SectionPosition)var13, b2.skyLight);
        }
        ChunkType var11 = this.chunkStatus.getChunkType();
        if (var11 == ChunkType.LEVELCHUNK) {
            var13 = new LevelChunkTicks<Block>(this.packedTicks.blocks());
            var14 = new LevelChunkTicks(this.packedTicks.fluids());
            Chunk chunk = new Chunk(var0.getLevel(), var3, this.upgradeData, (LevelChunkTicks<Block>)var13, (LevelChunkTicks<FluidType>)var14, this.inhabitedTime, var5, SerializableChunkData.postLoadChunk(var0, this.entities, this.blockEntities), BlendingData.unpack(this.blendingData));
        } else {
            ProtoChunk var15;
            var13 = ProtoChunkTickList.load(this.packedTicks.blocks());
            var14 = ProtoChunkTickList.load(this.packedTicks.fluids());
            ProtoChunk protoChunk = var15 = new ProtoChunk(var3, this.upgradeData, var5, (ProtoChunkTickList<Block>)var13, (ProtoChunkTickList<FluidType>)var14, var0, (IRegistry<BiomeBase>)var9, BlendingData.unpack(this.blendingData));
            protoChunk.setInhabitedTime(this.inhabitedTime);
            if (this.belowZeroRetrogen != null) {
                var15.setBelowZeroRetrogen(this.belowZeroRetrogen);
            }
            var15.setPersistedStatus(this.chunkStatus);
            if (this.chunkStatus.isOrAfter(ChunkStatus.INITIALIZE_LIGHT)) {
                var15.setLightEngine(var8);
            }
        }
        var13_16.setLightCorrect(this.lightCorrect);
        var13 = EnumSet.noneOf(HeightMap.Type.class);
        for (HeightMap.Type var15 : var13_16.getPersistedStatus().heightmapsAfter()) {
            long[] lArray = this.heightmaps.get(var15);
            if (lArray != null) {
                var13_16.setHeightmap(var15, lArray);
                continue;
            }
            ((AbstractCollection)var13).add(var15);
        }
        HeightMap.primeHeightmaps((IChunkAccess)var13_16, (Set<HeightMap.Type>)var13);
        var13_16.setAllStarts(SerializableChunkData.unpackStructureStart(StructurePieceSerializationContext.fromLevel(var0), this.structureData, var0.getSeed()));
        var13_16.setAllReferences(SerializableChunkData.unpackStructureReferences(var0.registryAccess(), var3, this.structureData));
        for (int var14 = 0; var14 < this.postProcessingSections.length; ++var14) {
            var13_16.addPackedPostProcess(this.postProcessingSections[var14], var14);
        }
        if (var11 == ChunkType.LEVELCHUNK) {
            return new ProtoChunkExtension((Chunk)var13_16, false);
        }
        ProtoChunk var14 = (ProtoChunk)var13_16;
        for (NBTTagCompound nBTTagCompound : this.entities) {
            var14.addEntity(nBTTagCompound);
        }
        for (NBTTagCompound nBTTagCompound : this.blockEntities) {
            var14.setBlockEntityNbt(nBTTagCompound);
        }
        if (this.carvingMask != null) {
            var14.setCarvingMask(new CarvingMask(this.carvingMask, var13_16.getMinY()));
        }
        return var14;
    }

    private static void logErrors(ChunkCoordIntPair var0, int var1, String var2) {
        LOGGER.error("Recoverable errors when loading section [{}, {}, {}]: {}", new Object[]{var0.x, var1, var0.z, var2});
    }

    private static Codec<PalettedContainerRO<Holder<BiomeBase>>> makeBiomeCodec(IRegistry<BiomeBase> var0) {
        return DataPaletteBlock.codecRO(var0.asHolderIdMap(), var0.holderByNameCodec(), DataPaletteBlock.d.SECTION_BIOMES, var0.getOrThrow(Biomes.PLAINS));
    }

    public static SerializableChunkData copyOf(WorldServer var02, IChunkAccess var1) {
        Object var12;
        Object var10;
        Object var9;
        if (!var1.canBeSerialized()) {
            throw new IllegalArgumentException("Chunk can't be serialized: " + String.valueOf(var1));
        }
        ChunkCoordIntPair var2 = var1.getPos();
        ArrayList<b> var3 = new ArrayList<b>();
        ChunkSection[] var4 = var1.getSections();
        LightEngineThreaded var5 = var02.getChunkSource().getLightEngine();
        for (int var6 = var5.getMinLightSection(); var6 < var5.getMaxLightSection(); ++var6) {
            int var7 = var1.getSectionIndexFromSectionY(var6);
            boolean var8 = var7 >= 0 && var7 < var4.length;
            var9 = var5.getLayerListener(EnumSkyBlock.BLOCK).getDataLayerData(SectionPosition.of(var2, var6));
            var10 = var5.getLayerListener(EnumSkyBlock.SKY).getDataLayerData(SectionPosition.of(var2, var6));
            NibbleArray nibbleArray = var9 != null && !((NibbleArray)var9).isEmpty() ? ((NibbleArray)var9).copy() : null;
            Object object = var12 = var10 != null && !((NibbleArray)var10).isEmpty() ? ((NibbleArray)var10).copy() : null;
            if (!var8 && nibbleArray == null && var12 == null) continue;
            ChunkSection var13 = var8 ? var4[var7].copy() : null;
            var3.add(new b(var6, var13, nibbleArray, (NibbleArray)var12));
        }
        ArrayList<NBTTagCompound> var6 = new ArrayList<NBTTagCompound>(var1.getBlockEntitiesPos().size());
        for (BlockPosition var8 : var1.getBlockEntitiesPos()) {
            var9 = var1.getBlockEntityNbtForSaving(var8, var02.registryAccess());
            if (var9 == null) continue;
            var6.add((NBTTagCompound)var9);
        }
        ArrayList var7 = new ArrayList();
        long[] var8 = null;
        if (var1.getPersistedStatus().getChunkType() == ChunkType.PROTOCHUNK) {
            var9 = (ProtoChunk)var1;
            var7.addAll(((ProtoChunk)var9).getEntities());
            var10 = ((ProtoChunk)var9).getCarvingMask();
            if (var10 != null) {
                var8 = ((CarvingMask)var10).toArray();
            }
        }
        var9 = new EnumMap<HeightMap.Type, long[]>(HeightMap.Type.class);
        for (Map.Entry entry : var1.getHeightmaps()) {
            if (!var1.getPersistedStatus().heightmapsAfter().contains(entry.getKey())) continue;
            var12 = ((HeightMap)entry.getValue()).getRawData();
            var9.put((HeightMap.Type)((HeightMap.Type)entry.getKey()), (long[])var12.clone());
        }
        var10 = var1.getTicksForSerialization(var02.getGameTime());
        ShortList[] shortListArray = (ShortList[])Arrays.stream(var1.getPostProcessing()).map(var0 -> var0 != null ? new ShortArrayList(var0) : null).toArray(ShortList[]::new);
        var12 = SerializableChunkData.packStructureData(StructurePieceSerializationContext.fromLevel(var02), var2, var1.getAllStarts(), var1.getAllReferences());
        return new SerializableChunkData((IRegistry<BiomeBase>)var02.registryAccess().lookupOrThrow(Registries.BIOME), var2, var1.getMinSectionY(), var02.getGameTime(), var1.getInhabitedTime(), var1.getPersistedStatus(), Optionull.map(var1.getBlendingData(), BlendingData::pack), var1.getBelowZeroRetrogen(), var1.getUpgradeData().copy(), var8, (Map<HeightMap.Type, long[]>)var9, (IChunkAccess.a)var10, shortListArray, var1.isLightCorrect(), (List<b>)var3, var7, (List<NBTTagCompound>)var6, (NBTTagCompound)var12);
    }

    public NBTTagCompound write() {
        NBTTagCompound var0 = GameProfileSerializer.addCurrentDataVersion(new NBTTagCompound());
        var0.putInt(X_POS_TAG, this.chunkPos.x);
        var0.putInt("yPos", this.minSectionY);
        var0.putInt(Z_POS_TAG, this.chunkPos.z);
        var0.putLong("LastUpdate", this.lastUpdateTime);
        var0.putLong("InhabitedTime", this.inhabitedTime);
        var0.putString("Status", BuiltInRegistries.CHUNK_STATUS.getKey(this.chunkStatus).toString());
        if (this.blendingData != null) {
            BlendingData.d.CODEC.encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)this.blendingData).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(var1 -> var0.put("blending_data", (NBTBase)var1));
        }
        if (this.belowZeroRetrogen != null) {
            BelowZeroRetrogen.CODEC.encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)this.belowZeroRetrogen).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(var1 -> var0.put("below_zero_retrogen", (NBTBase)var1));
        }
        if (!this.upgradeData.isEmpty()) {
            var0.put(TAG_UPGRADE_DATA, this.upgradeData.write());
        }
        NBTTagList var12 = new NBTTagList();
        Codec<PalettedContainerRO<Holder<BiomeBase>>> var22 = SerializableChunkData.makeBiomeCodec(this.biomeRegistry);
        for (b b2 : this.sectionData) {
            NBTTagCompound var5 = new NBTTagCompound();
            ChunkSection var6 = b2.chunkSection;
            if (var6 != null) {
                var5.put("block_states", (NBTBase)BLOCK_STATE_CODEC.encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, var6.getStates()).getOrThrow());
                var5.put("biomes", (NBTBase)var22.encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, var6.getBiomes()).getOrThrow());
            }
            if (b2.blockLight != null) {
                var5.putByteArray(BLOCK_LIGHT_TAG, b2.blockLight.getData());
            }
            if (b2.skyLight != null) {
                var5.putByteArray(SKY_LIGHT_TAG, b2.skyLight.getData());
            }
            if (var5.isEmpty()) continue;
            var5.putByte("Y", (byte)b2.y);
            var12.add(var5);
        }
        var0.put(SECTIONS_TAG, var12);
        if (this.lightCorrect) {
            var0.putBoolean(IS_LIGHT_ON_TAG, true);
        }
        NBTTagList var3 = new NBTTagList();
        var3.addAll(this.blockEntities);
        var0.put("block_entities", var3);
        if (this.chunkStatus.getChunkType() == ChunkType.PROTOCHUNK) {
            NBTTagList nBTTagList = new NBTTagList();
            nBTTagList.addAll(this.entities);
            var0.put("entities", nBTTagList);
            if (this.carvingMask != null) {
                var0.putLongArray("carving_mask", this.carvingMask);
            }
        }
        SerializableChunkData.saveTicks(var0, this.packedTicks);
        var0.put("PostProcessing", SerializableChunkData.packOffsets(this.postProcessingSections));
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        this.heightmaps.forEach((var1, var2) -> nBTTagCompound.put(var1.getSerializationKey(), new NBTTagLongArray((long[])var2)));
        var0.put(HEIGHTMAPS_TAG, nBTTagCompound);
        var0.put("structures", this.structureData);
        return var0;
    }

    private static void saveTicks(NBTTagCompound var02, IChunkAccess.a var1) {
        NBTTagList var2 = new NBTTagList();
        for (TickListChunk<Block> var4 : var1.blocks()) {
            var2.add(var4.save(var0 -> BuiltInRegistries.BLOCK.getKey((Block)var0).toString()));
        }
        var02.put(BLOCK_TICKS_TAG, var2);
        NBTTagList var3 = new NBTTagList();
        for (TickListChunk<FluidType> var5 : var1.fluids()) {
            var3.add(var5.save(var0 -> BuiltInRegistries.FLUID.getKey((FluidType)var0).toString()));
        }
        var02.put(FLUID_TICKS_TAG, var3);
    }

    public static ChunkType getChunkTypeFromTag(@Nullable NBTTagCompound var0) {
        if (var0 != null) {
            return ChunkStatus.byName(var0.getString("Status")).getChunkType();
        }
        return ChunkType.PROTOCHUNK;
    }

    @Nullable
    private static Chunk.c postLoadChunk(WorldServer var0, List<NBTTagCompound> var1, List<NBTTagCompound> var2) {
        if (var1.isEmpty() && var2.isEmpty()) {
            return null;
        }
        return var3 -> {
            if (!var1.isEmpty()) {
                var0.addLegacyChunkEntities(EntityTypes.loadEntitiesRecursive(var1, var0, EntitySpawnReason.LOAD));
            }
            for (NBTTagCompound var5 : var2) {
                boolean var6 = var5.getBoolean("keepPacked");
                if (var6) {
                    var3.setBlockEntityNbt(var5);
                    continue;
                }
                BlockPosition var7 = TileEntity.getPosFromTag(var5);
                TileEntity var8 = TileEntity.loadStatic(var7, var3.getBlockState(var7), var5, var0.registryAccess());
                if (var8 == null) continue;
                var3.setBlockEntity(var8);
            }
        };
    }

    private static NBTTagCompound packStructureData(StructurePieceSerializationContext var0, ChunkCoordIntPair var1, Map<Structure, StructureStart> var2, Map<Structure, LongSet> var3) {
        NBTTagCompound var4 = new NBTTagCompound();
        NBTTagCompound var5 = new NBTTagCompound();
        HolderLookup.b var6 = var0.registryAccess().lookupOrThrow(Registries.STRUCTURE);
        for (Map.Entry<Structure, StructureStart> var8 : var2.entrySet()) {
            Map.Entry<Structure, LongSet> var9 = var6.getKey(var8.getKey());
            var5.put(((MinecraftKey)((Object)var9)).toString(), var8.getValue().createTag(var0, var1));
        }
        var4.put("starts", var5);
        NBTTagCompound var7 = new NBTTagCompound();
        for (Map.Entry<Structure, LongSet> var9 : var3.entrySet()) {
            if (((LongSet)var9.getValue()).isEmpty()) continue;
            MinecraftKey var10 = var6.getKey((Structure)var9.getKey());
            var7.put(var10.toString(), new NBTTagLongArray((LongSet)var9.getValue()));
        }
        var4.put("References", var7);
        return var4;
    }

    private static Map<Structure, StructureStart> unpackStructureStart(StructurePieceSerializationContext var0, NBTTagCompound var1, long var2) {
        HashMap var4 = Maps.newHashMap();
        HolderLookup.b var5 = var0.registryAccess().lookupOrThrow(Registries.STRUCTURE);
        NBTTagCompound var6 = var1.getCompound("starts");
        for (String var8 : var6.getAllKeys()) {
            MinecraftKey var9 = MinecraftKey.tryParse(var8);
            Structure var10 = (Structure)var5.getValue(var9);
            if (var10 == null) {
                LOGGER.error("Unknown structure start: {}", (Object)var9);
                continue;
            }
            StructureStart var11 = StructureStart.loadStaticStart(var0, var6.getCompound(var8), var2);
            if (var11 == null) continue;
            var4.put(var10, var11);
        }
        return var4;
    }

    private static Map<Structure, LongSet> unpackStructureReferences(IRegistryCustom var0, ChunkCoordIntPair var1, NBTTagCompound var22) {
        HashMap var3 = Maps.newHashMap();
        HolderLookup.b var4 = var0.lookupOrThrow(Registries.STRUCTURE);
        NBTTagCompound var5 = var22.getCompound("References");
        for (String var7 : var5.getAllKeys()) {
            MinecraftKey var8 = MinecraftKey.tryParse(var7);
            Structure var9 = (Structure)var4.getValue(var8);
            if (var9 == null) {
                LOGGER.warn("Found reference to unknown structure '{}' in chunk {}, discarding", (Object)var8, (Object)var1);
                continue;
            }
            long[] var10 = var5.getLongArray(var7);
            if (var10.length == 0) continue;
            var3.put(var9, new LongOpenHashSet(Arrays.stream(var10).filter(var2 -> {
                ChunkCoordIntPair var4 = new ChunkCoordIntPair(var2);
                if (var4.getChessboardDistance(var1) > 8) {
                    LOGGER.warn("Found invalid structure reference [ {} @ {} ] for chunk {}.", new Object[]{var8, var4, var1});
                    return false;
                }
                return true;
            }).toArray()));
        }
        return var3;
    }

    private static NBTTagList packOffsets(ShortList[] var0) {
        NBTTagList var1 = new NBTTagList();
        for (ShortList var5 : var0) {
            NBTTagList var6 = new NBTTagList();
            if (var5 != null) {
                for (int var7 = 0; var7 < var5.size(); ++var7) {
                    var6.add(NBTTagShort.valueOf(var5.getShort(var7)));
                }
            }
            var1.add(var6);
        }
        return var1;
    }

    public static final class b
    extends Record {
        final int y;
        @Nullable
        final ChunkSection chunkSection;
        @Nullable
        final NibbleArray blockLight;
        @Nullable
        final NibbleArray skyLight;

        public b(int var0, @Nullable ChunkSection var1, @Nullable NibbleArray var2, @Nullable NibbleArray var3) {
            this.y = var0;
            this.chunkSection = var1;
            this.blockLight = var2;
            this.skyLight = var3;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "y;chunkSection;blockLight;skyLight", "y", "chunkSection", "blockLight", "skyLight"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "y;chunkSection;blockLight;skyLight", "y", "chunkSection", "blockLight", "skyLight"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "y;chunkSection;blockLight;skyLight", "y", "chunkSection", "blockLight", "skyLight"}, this, var0);
        }

        public int y() {
            return this.y;
        }

        @Nullable
        public ChunkSection chunkSection() {
            return this.chunkSection;
        }

        @Nullable
        public NibbleArray blockLight() {
            return this.blockLight;
        }

        @Nullable
        public NibbleArray skyLight() {
            return this.skyLight;
        }
    }

    public static class a
    extends NbtException {
        public a(String var0) {
            super(var0);
        }
    }
}

