/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.status;

import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.server.level.GenerationChunkHolder;
import net.minecraft.util.StaticCache2D;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import net.minecraft.util.profiling.jfr.callback.ProfiledDuration;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.status.ChunkDependencies;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.status.ChunkStatusTask;
import net.minecraft.world.level.chunk.status.ChunkStatusTasks;
import net.minecraft.world.level.chunk.status.WorldGenContext;

public final class ChunkStep
extends Record {
    final ChunkStatus targetStatus;
    private final ChunkDependencies directDependencies;
    final ChunkDependencies accumulatedDependencies;
    private final int blockStateWriteRadius;
    private final ChunkStatusTask task;

    public ChunkStep(ChunkStatus var0, ChunkDependencies var1, ChunkDependencies var2, int var3, ChunkStatusTask var4) {
        this.targetStatus = var0;
        this.directDependencies = var1;
        this.accumulatedDependencies = var2;
        this.blockStateWriteRadius = var3;
        this.task = var4;
    }

    public int getAccumulatedRadiusOf(ChunkStatus var0) {
        if (var0 == this.targetStatus) {
            return 0;
        }
        return this.accumulatedDependencies.getRadiusOf(var0);
    }

    public CompletableFuture<IChunkAccess> apply(WorldGenContext var0, StaticCache2D<GenerationChunkHolder> var12, IChunkAccess var2) {
        if (var2.getPersistedStatus().isBefore(this.targetStatus)) {
            ProfiledDuration var3 = JvmProfiler.INSTANCE.onChunkGenerate(var2.getPos(), var0.level().dimension(), this.targetStatus.getName());
            return this.task.doWork(var0, this, var12, var2).thenApply(var1 -> this.completeChunkGeneration((IChunkAccess)var1, var3));
        }
        return this.task.doWork(var0, this, var12, var2);
    }

    private IChunkAccess completeChunkGeneration(IChunkAccess var0, @Nullable ProfiledDuration var1) {
        ProtoChunk var2;
        if (var0 instanceof ProtoChunk && (var2 = (ProtoChunk)var0).getPersistedStatus().isBefore(this.targetStatus)) {
            var2.setPersistedStatus(this.targetStatus);
        }
        if (var1 != null) {
            var1.finish(true);
        }
        return var0;
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{ChunkStep.class, "targetStatus;directDependencies;accumulatedDependencies;blockStateWriteRadius;task", "targetStatus", "directDependencies", "accumulatedDependencies", "blockStateWriteRadius", "task"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ChunkStep.class, "targetStatus;directDependencies;accumulatedDependencies;blockStateWriteRadius;task", "targetStatus", "directDependencies", "accumulatedDependencies", "blockStateWriteRadius", "task"}, this);
    }

    @Override
    public final boolean equals(Object var0) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ChunkStep.class, "targetStatus;directDependencies;accumulatedDependencies;blockStateWriteRadius;task", "targetStatus", "directDependencies", "accumulatedDependencies", "blockStateWriteRadius", "task"}, this, var0);
    }

    public ChunkStatus targetStatus() {
        return this.targetStatus;
    }

    public ChunkDependencies directDependencies() {
        return this.directDependencies;
    }

    public ChunkDependencies accumulatedDependencies() {
        return this.accumulatedDependencies;
    }

    public int blockStateWriteRadius() {
        return this.blockStateWriteRadius;
    }

    public ChunkStatusTask task() {
        return this.task;
    }

    public static class a {
        private final ChunkStatus status;
        @Nullable
        private final ChunkStep parent;
        private ChunkStatus[] directDependenciesByRadius;
        private int blockStateWriteRadius = -1;
        private ChunkStatusTask task = ChunkStatusTasks::passThrough;

        protected a(ChunkStatus var0) {
            if (var0.getParent() != var0) {
                throw new IllegalArgumentException("Not starting with the first status: " + String.valueOf(var0));
            }
            this.status = var0;
            this.parent = null;
            this.directDependenciesByRadius = new ChunkStatus[0];
        }

        protected a(ChunkStatus var0, ChunkStep var1) {
            if (var1.targetStatus.getIndex() != var0.getIndex() - 1) {
                throw new IllegalArgumentException("Out of order status: " + String.valueOf(var0));
            }
            this.status = var0;
            this.parent = var1;
            this.directDependenciesByRadius = new ChunkStatus[]{var1.targetStatus};
        }

        public a addRequirement(ChunkStatus var0, int var1) {
            if (var0.isOrAfter(this.status)) {
                throw new IllegalArgumentException("Status " + String.valueOf(var0) + " can not be required by " + String.valueOf(this.status));
            }
            int var3 = var1 + 1;
            ChunkStatus[] var2 = this.directDependenciesByRadius;
            if (var3 > var2.length) {
                this.directDependenciesByRadius = new ChunkStatus[var3];
                Arrays.fill(this.directDependenciesByRadius, var0);
            }
            for (int var4 = 0; var4 < Math.min(var3, var2.length); ++var4) {
                this.directDependenciesByRadius[var4] = ChunkStatus.max(var2[var4], var0);
            }
            return this;
        }

        public a blockStateWriteRadius(int var0) {
            this.blockStateWriteRadius = var0;
            return this;
        }

        public a setTask(ChunkStatusTask var0) {
            this.task = var0;
            return this;
        }

        public ChunkStep build() {
            return new ChunkStep(this.status, new ChunkDependencies((ImmutableList<ChunkStatus>)ImmutableList.copyOf((Object[])this.directDependenciesByRadius)), new ChunkDependencies((ImmutableList<ChunkStatus>)ImmutableList.copyOf((Object[])this.buildAccumulatedDependencies())), this.blockStateWriteRadius, this.task);
        }

        private ChunkStatus[] buildAccumulatedDependencies() {
            if (this.parent == null) {
                return this.directDependenciesByRadius;
            }
            int var0 = this.getRadiusOfParent(this.parent.targetStatus);
            ChunkDependencies var1 = this.parent.accumulatedDependencies;
            ChunkStatus[] var2 = new ChunkStatus[Math.max(var0 + var1.size(), this.directDependenciesByRadius.length)];
            for (int var3 = 0; var3 < var2.length; ++var3) {
                int var4 = var3 - var0;
                var2[var3] = var4 < 0 || var4 >= var1.size() ? this.directDependenciesByRadius[var3] : (var3 >= this.directDependenciesByRadius.length ? var1.get(var4) : ChunkStatus.max(this.directDependenciesByRadius[var3], var1.get(var4)));
            }
            return var2;
        }

        private int getRadiusOfParent(ChunkStatus var0) {
            for (int var1 = this.directDependenciesByRadius.length - 1; var1 >= 0; --var1) {
                if (!this.directDependenciesByRadius[var1].isOrAfter(var0)) continue;
                return var1;
            }
            return 0;
        }
    }
}

