/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.EnumDirection8;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.level.BlockAccessAir;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockChest;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockStem;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityChest;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyChestType;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.DataPaletteBlock;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.ticks.TickListChunk;
import org.slf4j.Logger;

public class ChunkConverter {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final ChunkConverter EMPTY = new ChunkConverter(BlockAccessAir.INSTANCE);
    private static final String TAG_INDICES = "Indices";
    private static final EnumDirection8[] DIRECTIONS = EnumDirection8.values();
    private final EnumSet<EnumDirection8> sides = EnumSet.noneOf(EnumDirection8.class);
    private final List<TickListChunk<Block>> neighborBlockTicks = Lists.newArrayList();
    private final List<TickListChunk<FluidType>> neighborFluidTicks = Lists.newArrayList();
    private final int[][] index;
    static final Map<Block, a> MAP = new IdentityHashMap<Block, a>();
    static final Set<a> CHUNKY_FIXERS = Sets.newHashSet();

    private ChunkConverter(LevelHeightAccessor var0) {
        this.index = new int[var0.getSectionsCount()][];
    }

    public ChunkConverter(NBTTagCompound var02, LevelHeightAccessor var1) {
        this(var1);
        if (var02.contains(TAG_INDICES, 10)) {
            NBTTagCompound var2 = var02.getCompound(TAG_INDICES);
            for (int var3 = 0; var3 < this.index.length; ++var3) {
                String var4 = String.valueOf(var3);
                if (!var2.contains(var4, 11)) continue;
                this.index[var3] = var2.getIntArray(var4);
            }
        }
        int var2 = var02.getInt("Sides");
        for (EnumDirection8 var6 : EnumDirection8.values()) {
            if ((var2 & 1 << var6.ordinal()) == 0) continue;
            this.sides.add(var6);
        }
        ChunkConverter.loadTicks(var02, "neighbor_block_ticks", var0 -> BuiltInRegistries.BLOCK.getOptional(MinecraftKey.tryParse(var0)).or(() -> Optional.of(Blocks.AIR)), this.neighborBlockTicks);
        ChunkConverter.loadTicks(var02, "neighbor_fluid_ticks", var0 -> BuiltInRegistries.FLUID.getOptional(MinecraftKey.tryParse(var0)).or(() -> Optional.of(FluidTypes.EMPTY)), this.neighborFluidTicks);
    }

    private ChunkConverter(ChunkConverter var0) {
        this.sides.addAll(var0.sides);
        this.neighborBlockTicks.addAll(var0.neighborBlockTicks);
        this.neighborFluidTicks.addAll(var0.neighborFluidTicks);
        this.index = new int[var0.index.length][];
        for (int var1 = 0; var1 < var0.index.length; ++var1) {
            int[] var2 = var0.index[var1];
            this.index[var1] = var2 != null ? IntArrays.copy((int[])var2) : null;
        }
    }

    private static <T> void loadTicks(NBTTagCompound var0, String var1, Function<String, Optional<T>> var2, List<TickListChunk<T>> var3) {
        if (var0.contains(var1, 9)) {
            NBTTagList var4 = var0.getList(var1, 10);
            for (NBTBase var6 : var4) {
                TickListChunk.loadTick((NBTTagCompound)var6, var2).ifPresent(var3::add);
            }
        }
    }

    public void upgrade(Chunk var0) {
        this.upgradeInside(var0);
        for (EnumDirection8 var4 : DIRECTIONS) {
            ChunkConverter.upgradeSides(var0, var4);
        }
        World var12 = var0.getLevel();
        this.neighborBlockTicks.forEach(var1 -> {
            Block var2 = var1.type() == Blocks.AIR ? var12.getBlockState(var1.pos()).getBlock() : (Block)var1.type();
            var12.scheduleTick(var1.pos(), var2, var1.delay(), var1.priority());
        });
        this.neighborFluidTicks.forEach(var1 -> {
            FluidType var2 = var1.type() == FluidTypes.EMPTY ? var12.getFluidState(var1.pos()).getType() : (FluidType)var1.type();
            var12.scheduleTick(var1.pos(), var2, var1.delay(), var1.priority());
        });
        CHUNKY_FIXERS.forEach(var1 -> var1.processChunk(var12));
    }

    private static void upgradeSides(Chunk var0, EnumDirection8 var1) {
        World var2 = var0.getLevel();
        if (!var0.getUpgradeData().sides.remove((Object)var1)) {
            return;
        }
        Set<EnumDirection> var3 = var1.getDirections();
        boolean var4 = false;
        int var5 = 15;
        boolean var6 = var3.contains(EnumDirection.EAST);
        boolean var7 = var3.contains(EnumDirection.WEST);
        boolean var8 = var3.contains(EnumDirection.SOUTH);
        boolean var9 = var3.contains(EnumDirection.NORTH);
        boolean var10 = var3.size() == 1;
        ChunkCoordIntPair var11 = var0.getPos();
        int var12 = var11.getMinBlockX() + (var10 && (var9 || var8) ? 1 : (var7 ? 0 : 15));
        int var13 = var11.getMinBlockX() + (var10 && (var9 || var8) ? 14 : (var7 ? 0 : 15));
        int var14 = var11.getMinBlockZ() + (var10 && (var6 || var7) ? 1 : (var9 ? 0 : 15));
        int var15 = var11.getMinBlockZ() + (var10 && (var6 || var7) ? 14 : (var9 ? 0 : 15));
        EnumDirection[] var16 = EnumDirection.values();
        BlockPosition.MutableBlockPosition var17 = new BlockPosition.MutableBlockPosition();
        for (BlockPosition var19 : BlockPosition.betweenClosed(var12, var2.getMinY(), var14, var13, var2.getMaxY(), var15)) {
            IBlockData var20;
            IBlockData var21 = var20 = var2.getBlockState(var19);
            for (EnumDirection var25 : var16) {
                var17.setWithOffset((BaseBlockPosition)var19, var25);
                var21 = ChunkConverter.updateState(var21, var25, var2, var19, var17);
            }
            Block.updateOrDestroy(var20, var21, var2, var19, 18);
        }
    }

    private static IBlockData updateState(IBlockData var0, EnumDirection var1, GeneratorAccess var2, BlockPosition var3, BlockPosition var4) {
        return MAP.getOrDefault(var0.getBlock(), Type.DEFAULT).updateShape(var0, var1, var2.getBlockState(var4), var2, var3, var4);
    }

    private void upgradeInside(Chunk var0) {
        int var5;
        BlockPosition.MutableBlockPosition var1 = new BlockPosition.MutableBlockPosition();
        BlockPosition.MutableBlockPosition var2 = new BlockPosition.MutableBlockPosition();
        ChunkCoordIntPair var3 = var0.getPos();
        World var4 = var0.getLevel();
        for (var5 = 0; var5 < this.index.length; ++var5) {
            ChunkSection var6 = var0.getSection(var5);
            int[] var7 = this.index[var5];
            this.index[var5] = null;
            if (var7 == null || var7.length <= 0) continue;
            EnumDirection[] var8 = EnumDirection.values();
            DataPaletteBlock<IBlockData> var9 = var6.getStates();
            int var10 = var0.getSectionYFromSectionIndex(var5);
            int var11 = SectionPosition.sectionToBlockCoord(var10);
            for (int var15 : var7) {
                IBlockData var19;
                int var16 = var15 & 0xF;
                int var17 = var15 >> 8 & 0xF;
                int var18 = var15 >> 4 & 0xF;
                var1.set(var3.getMinBlockX() + var16, var11 + var17, var3.getMinBlockZ() + var18);
                IBlockData var20 = var19 = var9.get(var15);
                for (EnumDirection var24 : var8) {
                    var2.setWithOffset((BaseBlockPosition)var1, var24);
                    if (SectionPosition.blockToSectionCoord(var1.getX()) != var3.x || SectionPosition.blockToSectionCoord(var1.getZ()) != var3.z) continue;
                    var20 = ChunkConverter.updateState(var20, var24, var4, var1, var2);
                }
                Block.updateOrDestroy(var19, var20, var4, var1, 18);
            }
        }
        for (var5 = 0; var5 < this.index.length; ++var5) {
            if (this.index[var5] != null) {
                LOGGER.warn("Discarding update data for section {} for chunk ({} {})", new Object[]{var4.getSectionYFromSectionIndex(var5), var3.x, var3.z});
            }
            this.index[var5] = null;
        }
    }

    public boolean isEmpty() {
        for (int[] var3 : this.index) {
            if (var3 == null) continue;
            return false;
        }
        return this.sides.isEmpty();
    }

    public NBTTagCompound write() {
        Object var3;
        int var2;
        NBTTagCompound var0 = new NBTTagCompound();
        NBTTagCompound var1 = new NBTTagCompound();
        for (var2 = 0; var2 < this.index.length; ++var2) {
            var3 = String.valueOf(var2);
            if (this.index[var2] == null || this.index[var2].length == 0) continue;
            var1.putIntArray((String)var3, this.index[var2]);
        }
        if (!var1.isEmpty()) {
            var0.put(TAG_INDICES, var1);
        }
        var2 = 0;
        for (EnumDirection8 var4 : this.sides) {
            var2 |= 1 << var4.ordinal();
        }
        var0.putByte("Sides", (byte)var2);
        if (!this.neighborBlockTicks.isEmpty()) {
            var3 = new NBTTagList();
            this.neighborBlockTicks.forEach(arg_0 -> ChunkConverter.b((NBTTagList)var3, arg_0));
            var0.put("neighbor_block_ticks", (NBTBase)var3);
        }
        if (!this.neighborFluidTicks.isEmpty()) {
            var3 = new NBTTagList();
            this.neighborFluidTicks.forEach(arg_0 -> ChunkConverter.a((NBTTagList)var3, arg_0));
            var0.put("neighbor_fluid_ticks", (NBTBase)var3);
        }
        return var0;
    }

    public ChunkConverter copy() {
        if (this == EMPTY) {
            return EMPTY;
        }
        return new ChunkConverter(this);
    }

    private static /* synthetic */ void a(NBTTagList var02, TickListChunk var1) {
        var02.add(var1.save(var0 -> BuiltInRegistries.FLUID.getKey((FluidType)var0).toString()));
    }

    private static /* synthetic */ void b(NBTTagList var02, TickListChunk var1) {
        var02.add(var1.save(var0 -> BuiltInRegistries.BLOCK.getKey((Block)var0).toString()));
    }

    static abstract sealed class Type
    extends Enum<Type>
    implements a {
        public static final /* enum */ Type BLACKLIST = new Type(new Block[]{Blocks.OBSERVER, Blocks.NETHER_PORTAL, Blocks.WHITE_CONCRETE_POWDER, Blocks.ORANGE_CONCRETE_POWDER, Blocks.MAGENTA_CONCRETE_POWDER, Blocks.LIGHT_BLUE_CONCRETE_POWDER, Blocks.YELLOW_CONCRETE_POWDER, Blocks.LIME_CONCRETE_POWDER, Blocks.PINK_CONCRETE_POWDER, Blocks.GRAY_CONCRETE_POWDER, Blocks.LIGHT_GRAY_CONCRETE_POWDER, Blocks.CYAN_CONCRETE_POWDER, Blocks.PURPLE_CONCRETE_POWDER, Blocks.BLUE_CONCRETE_POWDER, Blocks.BROWN_CONCRETE_POWDER, Blocks.GREEN_CONCRETE_POWDER, Blocks.RED_CONCRETE_POWDER, Blocks.BLACK_CONCRETE_POWDER, Blocks.ANVIL, Blocks.CHIPPED_ANVIL, Blocks.DAMAGED_ANVIL, Blocks.DRAGON_EGG, Blocks.GRAVEL, Blocks.SAND, Blocks.RED_SAND, Blocks.OAK_SIGN, Blocks.SPRUCE_SIGN, Blocks.BIRCH_SIGN, Blocks.ACACIA_SIGN, Blocks.CHERRY_SIGN, Blocks.JUNGLE_SIGN, Blocks.DARK_OAK_SIGN, Blocks.PALE_OAK_SIGN, Blocks.OAK_WALL_SIGN, Blocks.SPRUCE_WALL_SIGN, Blocks.BIRCH_WALL_SIGN, Blocks.ACACIA_WALL_SIGN, Blocks.JUNGLE_WALL_SIGN, Blocks.DARK_OAK_WALL_SIGN, Blocks.PALE_OAK_WALL_SIGN, Blocks.OAK_HANGING_SIGN, Blocks.SPRUCE_HANGING_SIGN, Blocks.BIRCH_HANGING_SIGN, Blocks.ACACIA_HANGING_SIGN, Blocks.JUNGLE_HANGING_SIGN, Blocks.DARK_OAK_HANGING_SIGN, Blocks.PALE_OAK_HANGING_SIGN, Blocks.OAK_WALL_HANGING_SIGN, Blocks.SPRUCE_WALL_HANGING_SIGN, Blocks.BIRCH_WALL_HANGING_SIGN, Blocks.ACACIA_WALL_HANGING_SIGN, Blocks.JUNGLE_WALL_HANGING_SIGN, Blocks.DARK_OAK_WALL_HANGING_SIGN, Blocks.PALE_OAK_WALL_HANGING_SIGN}){

            @Override
            public IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
                return var0;
            }
        };
        public static final /* enum */ Type DEFAULT = new Type(new Block[0]){

            @Override
            public IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
                return var0.updateShape(var3, var3, var4, var1, var5, var3.getBlockState(var5), var3.getRandom());
            }
        };
        public static final /* enum */ Type CHEST = new Type(new Block[]{Blocks.CHEST, Blocks.TRAPPED_CHEST}){

            @Override
            public IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
                if (var2.is(var0.getBlock()) && var1.getAxis().isHorizontal() && var0.getValue(BlockChest.TYPE) == BlockPropertyChestType.SINGLE && var2.getValue(BlockChest.TYPE) == BlockPropertyChestType.SINGLE) {
                    EnumDirection var6 = var0.getValue(BlockChest.FACING);
                    if (var1.getAxis() != var6.getAxis() && var6 == var2.getValue(BlockChest.FACING)) {
                        BlockPropertyChestType var7 = var1 == var6.getClockWise() ? BlockPropertyChestType.LEFT : BlockPropertyChestType.RIGHT;
                        var3.setBlock(var5, (IBlockData)var2.setValue(BlockChest.TYPE, var7.getOpposite()), 18);
                        if (var6 == EnumDirection.NORTH || var6 == EnumDirection.EAST) {
                            TileEntity var8 = var3.getBlockEntity(var4);
                            TileEntity var9 = var3.getBlockEntity(var5);
                            if (var8 instanceof TileEntityChest && var9 instanceof TileEntityChest) {
                                TileEntityChest.swapContents((TileEntityChest)var8, (TileEntityChest)var9);
                            }
                        }
                        return (IBlockData)var0.setValue(BlockChest.TYPE, var7);
                    }
                }
                return var0;
            }
        };
        public static final /* enum */ Type LEAVES = new Type(true, new Block[]{Blocks.ACACIA_LEAVES, Blocks.CHERRY_LEAVES, Blocks.BIRCH_LEAVES, Blocks.PALE_OAK_LEAVES, Blocks.DARK_OAK_LEAVES, Blocks.JUNGLE_LEAVES, Blocks.OAK_LEAVES, Blocks.SPRUCE_LEAVES}){
            private final ThreadLocal<List<ObjectSet<BlockPosition>>> queue = ThreadLocal.withInitial(() -> Lists.newArrayListWithCapacity((int)7));

            @Override
            public IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
                IBlockData var6 = var0.updateShape(var3, var3, var4, var1, var5, var3.getBlockState(var5), var3.getRandom());
                if (var0 != var6) {
                    int var7 = var6.getValue(BlockProperties.DISTANCE);
                    List<ObjectSet<BlockPosition>> var8 = this.queue.get();
                    if (var8.isEmpty()) {
                        for (int var9 = 0; var9 < 7; ++var9) {
                            var8.add((ObjectSet<BlockPosition>)new ObjectOpenHashSet());
                        }
                    }
                    var8.get(var7).add((Object)var4.immutable());
                }
                return var0;
            }

            @Override
            public void processChunk(GeneratorAccess var0) {
                BlockPosition.MutableBlockPosition var1 = new BlockPosition.MutableBlockPosition();
                List<ObjectSet<BlockPosition>> var2 = this.queue.get();
                for (int var3 = 2; var3 < var2.size(); ++var3) {
                    int var4 = var3 - 1;
                    ObjectSet<BlockPosition> var5 = var2.get(var4);
                    ObjectSet<BlockPosition> var6 = var2.get(var3);
                    for (BlockPosition var8 : var5) {
                        IBlockData var9 = var0.getBlockState(var8);
                        if (var9.getValue(BlockProperties.DISTANCE) < var4) continue;
                        var0.setBlock(var8, (IBlockData)var9.setValue(BlockProperties.DISTANCE, var4), 18);
                        if (var3 == 7) continue;
                        for (EnumDirection var13 : DIRECTIONS) {
                            var1.setWithOffset((BaseBlockPosition)var8, var13);
                            IBlockData var14 = var0.getBlockState(var1);
                            if (!var14.hasProperty(BlockProperties.DISTANCE) || var9.getValue(BlockProperties.DISTANCE) <= var3) continue;
                            var6.add((Object)var1.immutable());
                        }
                    }
                }
                var2.clear();
            }
        };
        public static final /* enum */ Type STEM_BLOCK = new Type(new Block[]{Blocks.MELON_STEM, Blocks.PUMPKIN_STEM}){

            @Override
            public IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
                if (var0.getValue(BlockStem.AGE) == 7) {
                    Block var6;
                    Block block = var6 = var0.is(Blocks.PUMPKIN_STEM) ? Blocks.PUMPKIN : Blocks.MELON;
                    if (var2.is(var6)) {
                        return (IBlockData)(var0.is(Blocks.PUMPKIN_STEM) ? Blocks.ATTACHED_PUMPKIN_STEM : Blocks.ATTACHED_MELON_STEM).defaultBlockState().setValue(BlockFacingHorizontal.FACING, var1);
                    }
                }
                return var0;
            }
        };
        public static final EnumDirection[] DIRECTIONS;
        private static final /* synthetic */ Type[] g;

        public static Type[] values() {
            return (Type[])g.clone();
        }

        public static Type valueOf(String var0) {
            return Enum.valueOf(Type.class, var0);
        }

        Type(Block ... var2) {
            this(false, var2);
        }

        Type(boolean var2, Block ... var3) {
            for (Block var7 : var3) {
                MAP.put(var7, this);
            }
            if (var2) {
                CHUNKY_FIXERS.add(this);
            }
        }

        private static /* synthetic */ Type[] a() {
            return new Type[]{BLACKLIST, DEFAULT, CHEST, LEAVES, STEM_BLOCK};
        }

        static {
            g = Type.a();
            DIRECTIONS = EnumDirection.values();
        }
    }

    public static interface a {
        public IBlockData updateShape(IBlockData var1, EnumDirection var2, IBlockData var3, GeneratorAccess var4, BlockPosition var5, BlockPosition var6);

        default public void processChunk(GeneratorAccess var0) {
        }
    }
}

