/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.piston;

import com.mojang.serialization.MapCodec;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.piston.BlockPiston;
import net.minecraft.world.level.block.piston.BlockPistonExtension;
import net.minecraft.world.level.block.piston.TileEntityPiston;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyPistonType;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class BlockPistonMoving
extends BlockTileEntity {
    public static final MapCodec<BlockPistonMoving> CODEC = BlockPistonMoving.simpleCodec(BlockPistonMoving::new);
    public static final BlockStateEnum<EnumDirection> FACING = BlockPistonExtension.FACING;
    public static final BlockStateEnum<BlockPropertyPistonType> TYPE = BlockPistonExtension.TYPE;

    public MapCodec<BlockPistonMoving> codec() {
        return CODEC;
    }

    public BlockPistonMoving(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(FACING, EnumDirection.NORTH)).setValue(TYPE, BlockPropertyPistonType.DEFAULT));
    }

    @Override
    @Nullable
    public TileEntity newBlockEntity(BlockPosition var0, IBlockData var1) {
        return null;
    }

    public static TileEntity newMovingBlockEntity(BlockPosition var0, IBlockData var1, IBlockData var2, EnumDirection var3, boolean var4, boolean var5) {
        return new TileEntityPiston(var0, var1, var2, var3, var4, var5);
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> getTicker(World var0, IBlockData var1, TileEntityTypes<T> var2) {
        return BlockPistonMoving.createTickerHelper(var2, TileEntityTypes.PISTON, TileEntityPiston::tick);
    }

    @Override
    protected void onRemove(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        if (var0.is(var3.getBlock())) {
            return;
        }
        TileEntity var5 = var1.getBlockEntity(var2);
        if (var5 instanceof TileEntityPiston) {
            ((TileEntityPiston)var5).finalTick();
        }
    }

    @Override
    public void destroy(GeneratorAccess var0, BlockPosition var1, IBlockData var2) {
        BlockPosition var3 = var1.relative(var2.getValue(FACING).getOpposite());
        IBlockData var4 = var0.getBlockState(var3);
        if (var4.getBlock() instanceof BlockPiston && var4.getValue(BlockPiston.EXTENDED).booleanValue()) {
            var0.removeBlock(var3, false);
        }
    }

    @Override
    protected EnumInteractionResult useWithoutItem(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3, MovingObjectPositionBlock var4) {
        if (!var1.isClientSide && var1.getBlockEntity(var2) == null) {
            var1.removeBlock(var2, false);
            return EnumInteractionResult.CONSUME;
        }
        return EnumInteractionResult.PASS;
    }

    @Override
    protected List<ItemStack> getDrops(IBlockData var0, LootParams.a var1) {
        TileEntityPiston var2 = this.getBlockEntity(var1.getLevel(), BlockPosition.containing(var1.getParameter(LootContextParameters.ORIGIN)));
        if (var2 == null) {
            return Collections.emptyList();
        }
        return var2.getMovedState().getDrops(var1);
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return VoxelShapes.empty();
    }

    @Override
    protected VoxelShape getCollisionShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        TileEntityPiston var4 = this.getBlockEntity(var1, var2);
        if (var4 != null) {
            return var4.getCollisionShape(var1, var2);
        }
        return VoxelShapes.empty();
    }

    @Nullable
    private TileEntityPiston getBlockEntity(IBlockAccess var0, BlockPosition var1) {
        TileEntity var2 = var0.getBlockEntity(var1);
        if (var2 instanceof TileEntityPiston) {
            return (TileEntityPiston)var2;
        }
        return null;
    }

    @Override
    protected EnumRenderType getRenderShape(IBlockData var0) {
        return EnumRenderType.INVISIBLE;
    }

    @Override
    protected ItemStack getCloneItemStack(IWorldReader var0, BlockPosition var1, IBlockData var2, boolean var3) {
        return ItemStack.EMPTY;
    }

    @Override
    protected IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        return (IBlockData)var0.setValue(FACING, var1.rotate(var0.getValue(FACING)));
    }

    @Override
    protected IBlockData mirror(IBlockData var0, EnumBlockMirror var1) {
        return var0.rotate(var1.getRotation(var0.getValue(FACING)));
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(FACING, TYPE);
    }

    @Override
    protected boolean isPathfindable(IBlockData var0, PathMode var1) {
        return false;
    }
}

